/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.search.biz.util;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.search.api.dto.response.AddressVO;
import com.dtyunxi.cis.search.api.dto.response.OrderStepVO;
import com.dtyunxi.cis.search.api.dto.response.SaleOrderRespEsVo;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.huieryun.opensearch.api.RowMapper;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.util.JacksonUtil;
import com.google.common.collect.Lists;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SaleOrderRowMapper
implements RowMapper<SaleOrderRespEsVo> {
    public SaleOrderRespEsVo mapRow(Map<String, Object> docValue) {
        List orderStepVOS = Lists.newArrayList();
        if (docValue.containsKey("orderSteps") && Objects.nonNull(docValue.get("orderSteps"))) {
            Object orderSteps = docValue.get("orderSteps");
            orderStepVOS = JSON.parseArray((String)orderSteps.toString(), OrderStepVO.class);
            docValue.put("orderSteps", null);
        }
        SaleOrderRespEsVo saleOrderRespEsVo = (SaleOrderRespEsVo)JacksonUtil.readValue((String)JacksonUtil.toJson(docValue), SaleOrderRespEsVo.class);
        saleOrderRespEsVo.setPlatformCreateTime(this.builderFormatTime(docValue, "platformCreateTime"));
        saleOrderRespEsVo.setSaleOrderCreateTime(this.builderFormatTime(docValue, "saleOrderCreateTime"));
        saleOrderRespEsVo.setConfirmReceiveTime(this.builderFormatTime(docValue, "confirmReceiveTime"));
        saleOrderRespEsVo.setPreDeliveryTime(this.builderFormatTime(docValue, "preDeliveryTime"));
        saleOrderRespEsVo.setPreArriveTime(this.builderFormatTime(docValue, "preArriveTime"));
        saleOrderRespEsVo.setPushOrderTime(this.builderFormatTime(docValue, "pushOrderTime"));
        saleOrderRespEsVo.setDeliveryTime(this.builderFormatTime(docValue, "deliveryTime"));
        saleOrderRespEsVo.setCreateTime(this.builderFormatTime(docValue, "createTime"));
        saleOrderRespEsVo.setUpdateTime(this.builderFormatTime(docValue, "updateTime"));
        AddressVO orderAddress = new AddressVO();
        orderAddress.setDetailAddress(this.builderFormatStr(docValue, "detailAddress"));
        orderAddress.setProvince(this.builderFormatStr(docValue, "province"));
        orderAddress.setProvinceCode(this.builderFormatStr(docValue, "provinceCode"));
        orderAddress.setCity(this.builderFormatStr(docValue, "city"));
        orderAddress.setCityCode(this.builderFormatStr(docValue, "cityCode"));
        orderAddress.setDistrict(this.builderFormatStr(docValue, "county"));
        orderAddress.setDistrictCode(this.builderFormatStr(docValue, "countyCode"));
        saleOrderRespEsVo.setOrderAddress(orderAddress);
        saleOrderRespEsVo.setOrderSteps(orderStepVOS);
        return saleOrderRespEsVo;
    }

    private String builderFormatTime(Map<String, Object> docValue, String timeLong) {
        if (docValue.get(timeLong) != null) {
            long deliveryTimeLong = Long.parseLong(docValue.get(timeLong).toString());
            if (deliveryTimeLong != 0L) {
                return DateUtil.format((Date)new Date(deliveryTimeLong), (String)DatePattern.DATETIME_PATTERN.getPattern());
            }
            return null;
        }
        return null;
    }

    private String builderFormatStr(Map<String, Object> docValue, String reqParam) {
        if (docValue.get(reqParam) != null) {
            return docValue.get(reqParam).toString();
        }
        return null;
    }
}

