/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.bitem.biz.impl;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.ICombinedPackageActivityApi;
import com.dtyunxi.tcbj.api.dto.request.CombinedPackageActivityReqDto;
import com.dtyunxi.tcbj.api.dto.response.CombinedPackageActivityRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuRespDto;
import com.dtyunxi.yundt.module.bitem.api.IBcombinedPackageActivityService;
import com.dtyunxi.yundt.module.bitem.api.IBitemService;
import com.dtyunxi.yundt.module.bitem.api.dto.request.ItemDepthQueryReqDto;
import com.dtyunxi.yundt.module.bitem.api.dto.response.ItemInfoRespDto;
import com.dtyunxi.yundt.module.bitem.biz.price.PriceRuleHelper;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BcombinedPackageActivityImpl
implements IBcombinedPackageActivityService {
    private static final Logger logger = LoggerFactory.getLogger(BcombinedPackageActivityImpl.class);
    @Resource
    private ICombinedPackageActivityApi combinedPackageActivityApi;
    @Resource
    private IBitemService bitemService;
    @Autowired
    private PriceRuleHelper priceRuleHelper;

    public PageInfo<CombinedPackageActivityRespDto> queryCombinedPackageActivity(CombinedPackageActivityReqDto combinedPackageActivityReqDto) {
        PageInfo pageInfoRestResponse = (PageInfo)RestResponseHelper.extractData((RestResponse)this.combinedPackageActivityApi.queryCombinedPackageActivity(combinedPackageActivityReqDto));
        if (this.priceRuleHelper.isUseCenterPrice(combinedPackageActivityReqDto.getShopId())) {
            List combinedPackageActivityList = pageInfoRestResponse.getList();
            if (CollectionUtils.isNotEmpty((Collection)combinedPackageActivityList)) {
                for (CombinedPackageActivityRespDto dto : combinedPackageActivityList) {
                    ArrayList itemIdList = new ArrayList();
                    HashMap itemNumMap = new HashMap();
                    List activityItemRespDtos = dto.getActivityItemRespDtos();
                    activityItemRespDtos.forEach(e -> {
                        itemIdList.add(e.getItemId());
                        itemNumMap.put(e.getItemId(), e.getNum());
                    });
                    String itemIds = itemIdList.stream().map(e -> e.toString()).collect(Collectors.joining(","));
                    ItemDepthQueryReqDto itemDepthReqDto = new ItemDepthQueryReqDto();
                    itemDepthReqDto.setShopId(((CombinedPackageActivityRespDto)combinedPackageActivityList.get(0)).getShopId());
                    itemDepthReqDto.setItemIds(itemIds);
                    PageInfo itemInfoRespDtoPageInfo = this.bitemService.queryItemPageDepth(itemDepthReqDto, Integer.valueOf(1), Integer.valueOf(itemIdList.size()));
                    List itemInfoRespList = itemInfoRespDtoPageInfo.getList();
                    itemInfoRespList.forEach(itemInfo -> ((ItemSkuRespDto)itemInfo.getItemSkuList().get(0)).setShoppingCartItemNum((Integer)itemNumMap.get(itemInfo.getItemId())));
                    logger.info("\u8bbe\u7f6e\u5546\u54c1\u5217\u8868\u7684\u4ef7\u683c\u524d,{}", (Object)JSONObject.toJSONString((Object)itemInfoRespList));
                    HashMap<Long, BigDecimal> priceMap = new HashMap<Long, BigDecimal>();
                    if (!CollectionUtils.isNotEmpty((Collection)itemInfoRespList)) continue;
                    this.bitemService.setItemPolicyPriceInfo(itemInfoRespList);
                    for (ItemInfoRespDto itemInfoRespDto : itemInfoRespList) {
                        if (null != ((ItemSkuRespDto)itemInfoRespDto.getItemSkuList().get(0)).getPrice()) {
                            priceMap.put(itemInfoRespDto.getItemId(), ((ItemSkuRespDto)itemInfoRespDto.getItemSkuList().get(0)).getPrice());
                            continue;
                        }
                        if (null == itemInfoRespDto.getSellPrice()) continue;
                        priceMap.put(itemInfoRespDto.getItemId(), itemInfoRespDto.getSellPrice());
                    }
                    HashMap<Long, BigDecimal> finalPriceMap = priceMap;
                    activityItemRespDtos.forEach(e -> e.setPrice((BigDecimal)finalPriceMap.get(e.getItemId())));
                    logger.info("\u8bbe\u7f6e\u5546\u54c1\u5217\u8868\u7684\u4ef7\u683c\u540e,{}", (Object)JSONObject.toJSONString((Object)itemInfoRespList));
                }
            }
            logger.info("\u67e5\u8be2\u4ef7\u683c\u4e2d\u5fc3\u83b7\u53d6\u5957\u88c5\u5546\u54c1\u4ef7\u683c,{}", (Object)JSONObject.toJSONString((Object)combinedPackageActivityList));
        }
        return pageInfoRestResponse;
    }
}

