/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.bitem.biz.inventory;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.WarehouseSupplyConfigReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.WarehouseSupplyConfigRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.query.IWarehouseSupplyConfigQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.constant.ItemInventoryStrategyEnum;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.inventory.CsLogicInventoryTotalRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.ShopBaseDto;
import com.dtyunxi.yundt.module.bitem.biz.inventory.ItemInventoryStrategyService;
import com.github.pagehelper.PageInfo;
import com.yx.tcbj.center.customer.api.dto.response.CustomerExtV2DetailRespDto;
import com.yx.tcbj.center.customer.api.query.ICustomerExtThreeQueryApi;
import com.yx.tcbj.center.customer.api.query.ICustomerQueryApi;
import com.yx.tcbj.center.shop.api.dto.request.ShopQueryV3Dto;
import com.yx.tcbj.center.shop.api.query.IShopQueryV3Api;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
public class ItemInventoryStrategyHelper {
    private static final Logger log = LoggerFactory.getLogger(ItemInventoryStrategyHelper.class);
    @Resource
    private IWarehouseSupplyConfigQueryApi warehouseSupplyConfigQueryApi;
    @Resource
    private List<ItemInventoryStrategyService> itemInventoryStrategyServiceList;
    @Resource
    private ICustomerQueryApi iCustomerQueryApi2;
    @Resource
    private IShopQueryV3Api shopQueryV3Api;
    @Resource
    private ICustomerExtThreeQueryApi customerExtThreeQueryApi;
    public static Map<String, ItemInventoryStrategyService> STRATEGY_SERVICE_TABLE = null;

    @PostConstruct
    public void init() {
        STRATEGY_SERVICE_TABLE = this.itemInventoryStrategyServiceList.stream().collect(Collectors.toMap(v -> v.getStrategy().getCode(), service -> service));
    }

    public ItemInventoryStrategyEnum strategyOfCustomerFlag(Long customerId, Long shopId, String organizationId) {
        log.info("strategyOfCustomerFlag customerId is {} , shopId is {} , organizationId is {} .", new Object[]{customerId, shopId, organizationId});
        if (null == customerId) {
            return ItemInventoryStrategyEnum.DEFAULT;
        }
        if (null == shopId && null == organizationId) {
            return ItemInventoryStrategyEnum.DEFAULT;
        }
        CustomerExtV2DetailRespDto customer = (CustomerExtV2DetailRespDto)RestResponseHelper.extractData((RestResponse)this.customerExtThreeQueryApi.queryById(customerId));
        if (customer.getIsWarehouseEnable() == null || customer.getIsWarehouseEnable() == 0) {
            log.info("customer.getIsWarehouseEnable() == {} , return DEFAULT .", (Object)customer.getIsWarehouseEnable());
            return ItemInventoryStrategyEnum.DEFAULT;
        }
        WarehouseSupplyConfigReqDto warehouseSupplyConfigReqDto = new WarehouseSupplyConfigReqDto();
        warehouseSupplyConfigReqDto.setCustomerId(customerId);
        warehouseSupplyConfigReqDto.setShopId(shopId);
        warehouseSupplyConfigReqDto.setOrganizationId(organizationId == null ? null : Long.valueOf(organizationId));
        PageInfo warehouseSupplyConfigRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.warehouseSupplyConfigQueryApi.queryByPage(JSON.toJSONString((Object)warehouseSupplyConfigReqDto), Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE)));
        List configRespDtos = warehouseSupplyConfigRespDtoPageInfo.getList();
        if (CollectionUtils.isEmpty((Collection)configRespDtos)) {
            return ItemInventoryStrategyEnum.DEFAULT;
        }
        WarehouseSupplyConfigRespDto warehouseSupplyConfigRespDto = (WarehouseSupplyConfigRespDto)configRespDtos.stream().findFirst().get();
        return ItemInventoryStrategyEnum.getByCode((Integer)warehouseSupplyConfigRespDto.getSupplyType());
    }

    public ItemInventoryStrategyEnum strategyOfCustomerFlag(Long customerId) {
        Long orgId = this.getJxsCustomerInfo().getOrgInfoId();
        Long shopId = this.getShopIdByOrgId(orgId);
        return this.strategyOfCustomerFlag(customerId, shopId, orgId.toString());
    }

    public static ItemInventoryStrategyService getStrategyService(String code) {
        log.info(" get inventory strategy code is {} .", (Object)code);
        if (StringUtils.isEmpty((Object)code)) {
            log.info(" code is empty string , choose default strategy . ");
            return STRATEGY_SERVICE_TABLE.get(ItemInventoryStrategyEnum.DEFAULT.getCode());
        }
        ItemInventoryStrategyService itemInventoryStrategyService = STRATEGY_SERVICE_TABLE.get(code);
        if (null == itemInventoryStrategyService) {
            return STRATEGY_SERVICE_TABLE.get(ItemInventoryStrategyEnum.DEFAULT.getCode());
        }
        return itemInventoryStrategyService;
    }

    public CustomerRespDto getJxsCustomerInfo() {
        String orgId = ServiceContext.getContext().getAttachment("yes.req.cus.b2b.organizationid");
        log.info("\u83b7\u53d6 yes.req.cus.b2b.organizationid={}", (Object)orgId);
        if (orgId != null) {
            CustomerRespDto customerRespDto = (CustomerRespDto)this.iCustomerQueryApi2.queryByOrgInfoId(Long.valueOf(orgId)).getData();
            log.info("\u4ece yes.req.cus.b2b.organizationid \u83b7\u53d6\u6210\u529f customerRespDto={}", (Object)JSONObject.toJSONString((Object)customerRespDto));
            if (customerRespDto == null) {
                throw new RuntimeException("\u67e5\u8be2\u5f53\u524d\u767b\u5f55\u4eba\u79df\u6237\u4fe1\u606f\u5931\u8d25 \u5ba2\u6237\u67e5\u8be2\u5f02\u5e38");
            }
            return customerRespDto;
        }
        log.info("\u4ece yes.req.cus.b2b.organizationid \u83b7\u53d6\u5931\u8d25");
        String customerid = ServiceContext.getContext().getAttachment("yes.req.cus.b2b.customerid");
        log.info("\u83b7\u53d6 yes.req.cus.b2b.customerid={}", (Object)customerid);
        if (customerid == null) {
            throw new RuntimeException("\u67e5\u8be2\u5f53\u524d\u767b\u5f55\u4eba\u79df\u6237\u4fe1\u606f\u5931\u8d25 \u8bf7\u6c42\u5934\u83b7\u53d6customerid\u5f02\u5e38");
        }
        List customerLssList = (List)this.iCustomerQueryApi2.queryCustomerListByIds(Collections.singletonList(Long.valueOf(customerid))).getData();
        if (customerLssList == null || customerLssList.isEmpty()) {
            throw new RuntimeException("\u67e5\u8be2\u5f53\u524d\u767b\u5f55\u4eba\u79df\u6237\u4fe1\u606f\u5931\u8d25 \u5c0fb\u5ba2\u6237\u67e5\u8be2\u5f02\u5e38");
        }
        List customerJxsList = (List)this.iCustomerQueryApi2.queryCustomerByOrgId(Collections.singletonList(((CustomerRespDto)customerLssList.get(0)).getMerchantId())).getData();
        if (customerJxsList != null && !customerJxsList.isEmpty()) {
            log.info("\u4ece yes.req.cus.b2b.customerid \u83b7\u53d6\u6210\u529f customerRespDtoList={}", (Object)JSONObject.toJSONString((Object)customerJxsList));
            return (CustomerRespDto)customerJxsList.get(0);
        }
        log.info("\u4ece yes.req.cus.b2b.customerid \u83b7\u53d6\u5931\u8d25");
        throw new RuntimeException("\u67e5\u8be2\u5f53\u524d\u767b\u5f55\u4eba\u79df\u6237\u4fe1\u606f\u5931\u8d25");
    }

    public Long getShopIdByOrgId(Long orgId) {
        ShopQueryV3Dto shopQueryParam = new ShopQueryV3Dto();
        shopQueryParam.setOrganizationId(orgId);
        PageInfo shopBaseDtoList = (PageInfo)RestResponseHelper.extractData((RestResponse)this.shopQueryV3Api.queryBaseShopPage2(shopQueryParam, Integer.valueOf(1), Integer.valueOf(1)));
        if (shopBaseDtoList == null || shopBaseDtoList.getList() == null || shopBaseDtoList.getList().isEmpty()) {
            throw new BizException("\u5e97\u94fa\u67e5\u8be2\u5f02\u5e38 orgId=" + orgId);
        }
        log.info("getShopIdByOrgId shopBaseDtoList={}", (Object)JSONObject.toJSONString((Object)shopBaseDtoList));
        return ((ShopBaseDto)shopBaseDtoList.getList().get(0)).getId();
    }

    public List<CsLogicInventoryTotalRespDto> getInventoryList(List<String> cargoCodeList, Long customerId) {
        log.info("getInventoryList start , cargoCodeList : {} , customerId : {} .", cargoCodeList, (Object)customerId);
        Long orgId = this.getJxsCustomerInfo().getOrgInfoId();
        Long shopId = this.getShopIdByOrgId(orgId);
        ItemInventoryStrategyEnum itemInventoryStrategyEnum = this.strategyOfCustomerFlag(customerId, shopId, orgId.toString());
        ItemInventoryStrategyService strategyService = ItemInventoryStrategyHelper.getStrategyService(itemInventoryStrategyEnum.getCode());
        List<CsLogicInventoryTotalRespDto> inventoryList = strategyService.getInventoryList(cargoCodeList, shopId, customerId);
        log.info("getInventoryList end , inventoryList : {}.", (Object)JSONObject.toJSONString(inventoryList));
        return inventoryList;
    }

    public static Long getSmallBCustomerId() {
        String customerid = ServiceContext.getContext().getAttachment("yes.req.cus.b2b.customerid");
        log.info("\u83b7\u53d6 yes.req.cus.b2b.customerid={}", (Object)customerid);
        if (customerid == null) {
            throw new RuntimeException("\u67e5\u8be2\u5f53\u524d\u767b\u5f55\u4eba\u79df\u6237\u4fe1\u606f\u5931\u8d25 \u8bf7\u6c42\u5934\u83b7\u53d6customerid\u5f02\u5e38");
        }
        return Long.valueOf(customerid);
    }
}

