/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.bitem.biz.inventory;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.WarehouseSupplyConfigReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.WarehouseSupplyConfigRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.query.IWarehouseSupplyConfigQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.constant.ItemInventoryStrategyEnum;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.inventory.CsLogicInventoryTotalRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsWarehouseTypeEnum;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.ShopBaseDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.dtyunxi.yundt.module.bitem.biz.inventory.ItemInventoryStrategyService;
import com.github.pagehelper.PageInfo;
import com.yx.tcbj.center.customer.api.dto.response.CustomerExtRespDto;
import com.yx.tcbj.center.customer.api.query.ICustomerExtThreeQueryApi;
import com.yx.tcbj.center.customer.api.query.ICustomerQueryApi;
import com.yx.tcbj.center.shop.api.dto.request.ShopQueryV3Dto;
import com.yx.tcbj.center.shop.api.query.IShopQueryV3Api;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
public class ItemInventoryStrategyHelper {
    private static final Logger log = LoggerFactory.getLogger(ItemInventoryStrategyHelper.class);
    @Resource
    private IWarehouseSupplyConfigQueryApi warehouseSupplyConfigQueryApi;
    @Resource
    private List<ItemInventoryStrategyService> itemInventoryStrategyServiceList;
    @Resource
    private ICustomerQueryApi iCustomerQueryApi2;
    @Resource
    private IShopQueryV3Api shopQueryV3Api;
    @Resource
    private ICustomerExtThreeQueryApi customerExtThreeQueryApi;
    public static Map<String, ItemInventoryStrategyService> STRATEGY_SERVICE_TABLE = null;
    @Resource
    private IShopQueryApi shopQueryApi;

    @PostConstruct
    public void init() {
        STRATEGY_SERVICE_TABLE = this.itemInventoryStrategyServiceList.stream().collect(Collectors.toMap(v -> v.getStrategy().getCode(), service -> service));
    }

    public ItemInventoryStrategyEnum strategyOfCustomerFlag(Long customerId, Long shopId, String organizationId, String warehouseType) {
        log.info("strategyOfCustomerFlag customerId is {} , shopId is {} , organizationId is {} .", new Object[]{customerId, shopId, organizationId});
        this.logStackTrace();
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        StringBuilder stackTrace = new StringBuilder();
        for (StackTraceElement element : stackTraceElements) {
            stackTrace.append(element.toString()).append("\n");
        }
        log.info("\u8c03\u7528\u5806\u6808: \n{}", (Object)stackTrace.toString());
        if (null == customerId) {
            log.info("customerId is null , return DEFAULT .");
            return ItemInventoryStrategyEnum.DEFAULT;
        }
        if (null == shopId && null == organizationId) {
            throw new BizException("shopId and organizationId is null");
        }
        CustomerExtRespDto jxsCustomerInfo = this.getJxsCustomerInfoByShopId(shopId);
        log.info("jxsCustomerInfo is {} .", (Object)JSONObject.toJSONString((Object)jxsCustomerInfo));
        if (jxsCustomerInfo.getIsWarehouseEnable() == null || jxsCustomerInfo.getIsWarehouseEnable() == 0) {
            log.info("customer.getIsWarehouseEnable() == {} , return DEFAULT .", (Object)jxsCustomerInfo.getIsWarehouseEnable());
            return ItemInventoryStrategyEnum.DEFAULT;
        }
        WarehouseSupplyConfigReqDto warehouseSupplyConfigReqDto = new WarehouseSupplyConfigReqDto();
        warehouseSupplyConfigReqDto.setCustomerId(customerId);
        warehouseSupplyConfigReqDto.setShopId(shopId);
        warehouseSupplyConfigReqDto.setOrganizationId(organizationId == null ? null : Long.valueOf(organizationId));
        warehouseSupplyConfigReqDto.setWarehouseType(warehouseType);
        PageInfo warehouseSupplyConfigRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.warehouseSupplyConfigQueryApi.queryByPage(JSON.toJSONString((Object)warehouseSupplyConfigReqDto), Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE)));
        List<WarehouseSupplyConfigRespDto> configRespDtos = warehouseSupplyConfigRespDtoPageInfo.getList();
        if (CollectionUtils.isEmpty((Collection)warehouseSupplyConfigRespDtoPageInfo.getList())) {
            configRespDtos = this.reQueryWarehouseSupplyConfig(customerId, shopId, organizationId);
        }
        if (CollectionUtils.isEmpty((Collection)configRespDtos)) {
            return ItemInventoryStrategyEnum.DEFAULT;
        }
        WarehouseSupplyConfigRespDto warehouseSupplyConfigRespDto = (WarehouseSupplyConfigRespDto)configRespDtos.stream().findFirst().get();
        return ItemInventoryStrategyEnum.getByCode((Integer)warehouseSupplyConfigRespDto.getSupplyType());
    }

    private List<WarehouseSupplyConfigRespDto> reQueryWarehouseSupplyConfig(Long customerId, Long shopId, String organizationId) {
        log.info("\u5ba2\u6237\u77ed\u7f16\u7801\u67e5\u8be2\u5206\u4ed3 \u517c\u5bb9\u4e00\u4e2a\u95e8\u5e97\u8981\u8de8\u79df\u6237\u67e5\u8be2\u5206\u4ed3\u914d\u7f6e\u7684\u60c5\u51b5 customerId={},shopId={},organizationId={},", new Object[]{customerId, shopId, organizationId});
        WarehouseSupplyConfigReqDto warehouseSupplyConfigReQueryParam = new WarehouseSupplyConfigReqDto();
        warehouseSupplyConfigReQueryParam.setShopId(shopId);
        warehouseSupplyConfigReQueryParam.setOrganizationId(organizationId == null ? null : Long.valueOf(organizationId));
        warehouseSupplyConfigReQueryParam.setWarehouseType(CsWarehouseTypeEnum.PRODUCT_WAREHOUSE.getCode());
        PageInfo warehouseSupplyConfigReQuery = (PageInfo)RestResponseHelper.extractData((RestResponse)this.warehouseSupplyConfigQueryApi.queryByPage(JSON.toJSONString((Object)warehouseSupplyConfigReQueryParam), Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE)));
        List configRespDtos = warehouseSupplyConfigReQuery.getList();
        log.info("\u5ba2\u6237\u77ed\u7f16\u7801\u67e5\u8be2\u5206\u4ed3\u7ed3\u679c configRespDtos={}", (Object)JSONObject.toJSONString((Object)configRespDtos));
        if (configRespDtos == null || configRespDtos.isEmpty()) {
            return null;
        }
        String customerShortCode = this.getCustomerSmallBShortCode(String.valueOf(customerId));
        for (WarehouseSupplyConfigRespDto configRespDto : configRespDtos) {
            if (!customerShortCode.equals(configRespDto.getCustomerCode().split("_")[0])) continue;
            log.info("\u5339\u914d\u5230\u5ba2\u6237\u7f16\u7801\u524d\u7f00 customerShortCode={} configRespDto={}", (Object)customerShortCode, (Object)JSONObject.toJSONString((Object)configRespDto));
            return Collections.singletonList(configRespDto);
        }
        return null;
    }

    public String getCustomerSmallBShortCode(String customerId) {
        CustomerExtRespDto customerLss = (CustomerExtRespDto)this.customerExtThreeQueryApi.queryById(String.valueOf(customerId)).getData();
        if (customerLss == null) {
            throw new RuntimeException("\u67e5\u8be2\u5f53\u524d\u767b\u5f55\u4eba\u79df\u6237\u4fe1\u606f\u5931\u8d25 \u5c0fb\u5ba2\u6237\u67e5\u8be2\u5f02\u5e38");
        }
        String customerYDCode = customerLss.getCode().split("_")[0];
        log.info("customerYDCode={}", (Object)customerYDCode);
        return customerYDCode;
    }

    public ItemInventoryStrategyEnum strategyOfCustomerFlag(Long customerId, String warehouseType) {
        Long orgId = this.getJxsCustomerInfoByLogin(String.valueOf(customerId)).getOrgInfoId();
        Long shopId = this.getShopIdByOrgId(orgId);
        return this.strategyOfCustomerFlag(customerId, shopId, orgId.toString(), warehouseType);
    }

    public static ItemInventoryStrategyService getStrategyService(String code) {
        log.info("get inventory strategy code is {} .", (Object)code);
        if (StringUtils.isEmpty((Object)code)) {
            log.info(" code is empty string , choose default strategy . ");
            return STRATEGY_SERVICE_TABLE.get(ItemInventoryStrategyEnum.DEFAULT.getCode());
        }
        ItemInventoryStrategyService itemInventoryStrategyService = STRATEGY_SERVICE_TABLE.get(code);
        if (null == itemInventoryStrategyService) {
            return STRATEGY_SERVICE_TABLE.get(ItemInventoryStrategyEnum.DEFAULT.getCode());
        }
        return itemInventoryStrategyService;
    }

    public CustomerExtRespDto getJxsCustomerInfoByLogin(String yesReqCusB2bCustomerid) {
        String customerid = ServiceContext.getContext().getAttachment("yes.req.cus.b2b.customerid");
        log.info("\u83b7\u53d6 yes.req.cus.b2b.customerid={}", (Object)customerid);
        if (customerid == null) {
            customerid = yesReqCusB2bCustomerid;
        }
        if (customerid != null) {
            log.info("\u67e5\u5c0fb customerid={}", (Object)customerid);
            CustomerExtRespDto customerLss = (CustomerExtRespDto)this.customerExtThreeQueryApi.queryById(customerid).getData();
            log.info("\u67e5\u5c0fb customerLss={}", (Object)JSONObject.toJSONString((Object)customerLss));
            if (customerLss == null) {
                throw new RuntimeException("\u67e5\u8be2\u5f53\u524d\u767b\u5f55\u4eba\u79df\u6237\u4fe1\u606f\u5931\u8d25 \u5c0fb\u5ba2\u6237\u67e5\u8be2\u5f02\u5e38");
            }
            List<Long> orgIdList = Collections.singletonList(customerLss.getMerchantId());
            log.info("\u67e5\u5927b orgIdList={}", (Object)JSONObject.toJSONString(orgIdList));
            CustomerExtRespDto customerJxs = (CustomerExtRespDto)((List)this.customerExtThreeQueryApi.queryByOrgIdList(orgIdList).getData()).get(0);
            log.info("\u67e5\u5927b customerJxs={}", (Object)JSONObject.toJSONString((Object)customerJxs));
            if (customerJxs != null) {
                log.info("\u4ece yes.req.cus.b2b.customerid \u83b7\u53d6\u6210\u529f customerRespDtoList={}", (Object)JSONObject.toJSONString((Object)customerJxs));
                return customerJxs;
            }
            log.info("\u4ece yes.req.cus.b2b.customerid \u83b7\u53d6\u5931\u8d25");
        } else {
            log.info("\u7528yes.req.cus.b2b.customerid\u67e5\u8be2\u5f53\u524d\u767b\u5f55\u4eba\u79df\u6237\u4fe1\u606f\u5931\u8d25 customerid={}", (Object)customerid);
        }
        String orgId = ServiceContext.getContext().getAttachment("yes.req.cus.b2b.organizationid");
        log.info("\u83b7\u53d6 yes.req.cus.b2b.organizationid={}", (Object)orgId);
        if (orgId != null) {
            CustomerExtRespDto customerRespDto = (CustomerExtRespDto)((List)this.customerExtThreeQueryApi.queryByOrgIdList(Collections.singletonList(Long.valueOf(orgId))).getData()).get(0);
            log.info("\u4ece yes.req.cus.b2b.organizationid \u83b7\u53d6\u6210\u529f customerRespDto={}", (Object)JSONObject.toJSONString((Object)customerRespDto));
            if (customerRespDto == null) {
                throw new RuntimeException("\u67e5\u8be2\u5f53\u524d\u767b\u5f55\u4eba\u79df\u6237\u4fe1\u606f\u5931\u8d25 \u5ba2\u6237\u67e5\u8be2\u5f02\u5e38");
            }
            return customerRespDto;
        }
        log.info("\u4ece yes.req.cus.b2b.organizationid \u83b7\u53d6\u5931\u8d25");
        throw new RuntimeException("\u67e5\u8be2\u5f53\u524d\u767b\u5f55\u4eba\u79df\u6237\u4fe1\u606f\u5931\u8d25");
    }

    public CustomerExtRespDto getJxsCustomerInfoByShopId(Long shopId) {
        log.info("getJxsCustomerInfoByShopId shopQueryApi.queryById shopId={}", (Object)shopId);
        ShopDto shopDto = (ShopDto)this.shopQueryApi.queryById(shopId.longValue(), new String[0]).getData();
        log.info("getJxsCustomerInfoByShopId  shopQueryApi.queryById shopDto={}", (Object)JSONObject.toJSONString((Object)shopDto));
        Long orgId = shopDto.getOrganizationId();
        log.info("getJxsCustomerInfoByShopId customerExtThreeQueryApi.queryByOrgIdList orgId={}", (Object)orgId);
        CustomerExtRespDto customerRespDto = (CustomerExtRespDto)((List)this.customerExtThreeQueryApi.queryByOrgIdList(Collections.singletonList(orgId)).getData()).get(0);
        log.info("getJxsCustomerInfoByShopId customerExtThreeQueryApi.queryByOrgIdList customerRespDto={}", (Object)JSONObject.toJSONString((Object)customerRespDto));
        if (customerRespDto == null) {
            throw new RuntimeException("\u901a\u8fc7shopId\u83b7\u53d6\u7ecf\u9500\u5546\u4fe1\u606f\u6210\u529f\u5931\u8d25 \u5ba2\u6237\u67e5\u8be2\u5f02\u5e38");
        }
        log.info("\u901a\u8fc7shopId\u83b7\u53d6\u7ecf\u9500\u5546\u4fe1\u606f\u6210\u529f customerRespDto={}", (Object)JSONObject.toJSONString((Object)customerRespDto));
        return customerRespDto;
    }

    public Long getShopIdByOrgId(Long orgId) {
        ShopQueryV3Dto shopQueryParam = new ShopQueryV3Dto();
        shopQueryParam.setOrganizationId(orgId);
        PageInfo shopBaseDtoList = (PageInfo)RestResponseHelper.extractData((RestResponse)this.shopQueryV3Api.queryBaseShopPage2(shopQueryParam, Integer.valueOf(1), Integer.valueOf(1)));
        if (shopBaseDtoList == null || shopBaseDtoList.getList() == null || shopBaseDtoList.getList().isEmpty()) {
            throw new BizException("\u5e97\u94fa\u67e5\u8be2\u5f02\u5e38 orgId=" + orgId);
        }
        log.info("getShopIdByOrgId shopBaseDtoList={}", (Object)JSONObject.toJSONString((Object)shopBaseDtoList));
        return ((ShopBaseDto)shopBaseDtoList.getList().get(0)).getId();
    }

    public List<CsLogicInventoryTotalRespDto> getInventoryList(List<String> cargoCodeList, Long customerId, String warehouseType) {
        log.info("getInventoryList start , cargoCodeList : {} , customerId : {} .", cargoCodeList, (Object)customerId);
        Long orgId = this.getJxsCustomerInfoByLogin(String.valueOf(customerId)).getOrgInfoId();
        Long shopId = this.getShopIdByOrgId(orgId);
        ItemInventoryStrategyEnum itemInventoryStrategyEnum = this.strategyOfCustomerFlag(customerId, shopId, orgId.toString(), warehouseType);
        ItemInventoryStrategyService strategyService = ItemInventoryStrategyHelper.getStrategyService(itemInventoryStrategyEnum.getCode());
        List<CsLogicInventoryTotalRespDto> inventoryList = strategyService.getInventoryList(cargoCodeList, shopId, customerId);
        log.info("getInventoryList end , inventoryList : {}.", (Object)JSONObject.toJSONString(inventoryList));
        return inventoryList;
    }

    public static Long getSmallBCustomerId() {
        String customerid = ServiceContext.getContext().getAttachment("yes.req.cus.b2b.customerid");
        log.info("\u83b7\u53d6 yes.req.cus.b2b.customerid={}", (Object)customerid);
        if (customerid == null) {
            log.info("\u67e5\u8be2\u5f53\u524d\u767b\u5f55\u4eba\u79df\u6237\u4fe1\u606f\u5931\u8d25 \u8bf7\u6c42\u5934\u83b7\u53d6customerid\u5f02\u5e38");
            return null;
        }
        return Long.valueOf(customerid);
    }

    public void logStackTrace() {
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        StringBuilder stackTrace = new StringBuilder();
        for (StackTraceElement element : stackTraceElements) {
            stackTrace.append(element.toString()).append("\n");
        }
        log.info("\u8c03\u7528\u5806\u6808: \n{}", (Object)stackTrace.toString());
    }
}

