/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.bitem.biz.inventory.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.inventory.ICsLogicInventoryTotalQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.WarehouseSupplyRelReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.WarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.WarehouseSupplyRelRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.query.IWarehouseSupplyRelQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.constant.ItemInventoryStrategyEnum;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsLogicInventoryTotalBatchQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.inventory.CsLogicInventoryTotalRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsWarehouseTypeEnum;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.dtyunxi.yundt.module.bitem.biz.inventory.ItemInventoryStrategyHelper;
import com.dtyunxi.yundt.module.bitem.biz.inventory.ItemInventoryStrategyService;
import com.dtyunxi.yundt.module.bitem.biz.service.IBInventoryService;
import com.github.pagehelper.PageInfo;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ItemInventorySeparateStrategyServiceImpl
implements ItemInventoryStrategyService {
    private static final Logger log = LoggerFactory.getLogger(ItemInventorySeparateStrategyServiceImpl.class);
    @Resource
    private IWarehouseSupplyRelQueryApi warehouseSupplyRelQueryApi;
    @Resource
    private ICsLogicInventoryTotalQueryApi csLogicInventoryTotalQueryApi;
    @Resource
    private IShopQueryApi shopQueryApi;
    @Resource
    private ItemInventoryStrategyHelper itemInventoryStrategyHelper;
    @Resource
    private IBInventoryService inventoryService;

    @Override
    public ItemInventoryStrategyEnum getStrategy() {
        return ItemInventoryStrategyEnum.SEPARATE;
    }

    @Override
    public List<CsLogicInventoryTotalRespDto> getInventoryList(List<String> cargoCodeList, Long shopId, Long customerId) {
        log.info("\u5206\u4ed3\u5e93\u5b58\u67e5\u8be2\u7b56\u7565 req params , cargoCodeList : {} ,shopId : {} ,customerId : {} .", new Object[]{cargoCodeList, shopId, customerId});
        List warehouseSupplyRelRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.warehouseSupplyRelQueryApi.queryByCustomerId(String.valueOf(customerId)));
        log.info("warehouseSupplyRelRespDtos : {} .", (Object)JSONObject.toJSONString((Object)warehouseSupplyRelRespDtos));
        WarehouseSupplyRelRespDto warehouseSupplyRelRespDto = warehouseSupplyRelRespDtos.stream().filter(e -> CsWarehouseTypeEnum.PRODUCT_WAREHOUSE.getCode().equals(e.getWarehouseType())).findFirst().orElse(null);
        if (warehouseSupplyRelRespDto == null) {
            List<CsLogicInventoryTotalRespDto> csLogicInventoryTotalRespDto = this.getDefaultInventoryList(cargoCodeList, shopId, customerId);
            log.info("\u5206\u4ed3\u914d\u7f6e\u4e3a\u7a7a\uff0c\u4f7f\u7528\u9ed8\u8ba4\u4ed3\u5e93\u67e5\u8be2 csLogicInventoryTotalRespDto={}", csLogicInventoryTotalRespDto);
            return csLogicInventoryTotalRespDto;
        }
        CsLogicInventoryTotalBatchQueryDto tcbjAvailableReqDto = new CsLogicInventoryTotalBatchQueryDto();
        tcbjAvailableReqDto.setWarehouseCode(warehouseSupplyRelRespDto.getWarehouseCode());
        tcbjAvailableReqDto.setCargoCodeList(cargoCodeList);
        List csLogicInventoryTotalRespDtoList = (List)this.csLogicInventoryTotalQueryApi.queryWarehouseInventory(tcbjAvailableReqDto).getData();
        log.info("csLogicInventoryTotalRespDtoList : {} .", (Object)JSONObject.toJSONString((Object)csLogicInventoryTotalRespDtoList));
        return csLogicInventoryTotalRespDtoList;
    }

    @Override
    public List<String> getWarehouseList(Long shopId, Long customerId) {
        if (customerId == null) {
            throw new BizException("customerId is null .");
        }
        Object warehouseSupplyRelRespDtos = null;
        log.info("2 \u8865\u507f\u914d\u7f6e\u7684\u5206\u4ed3\u4ed3\u5e93 customerId={}, shopId={} .", (Object)customerId, (Object)shopId);
        ShopDto shopDto = (ShopDto)this.shopQueryApi.queryById(shopId.longValue(), new String[0]).getData();
        Long orgId = shopDto.getOrganizationId();
        String customerShortCode = this.itemInventoryStrategyHelper.getCustomerSmallBShortCode(String.valueOf(customerId));
        WarehouseSupplyRelReqDto warehouseReqDto = new WarehouseSupplyRelReqDto();
        warehouseReqDto.setOrganizationId(orgId);
        warehouseReqDto.setCustomerShortCode(customerShortCode);
        warehouseReqDto.setWarehouseType(CsWarehouseTypeEnum.PRODUCT_WAREHOUSE.getCode());
        List result2 = ((PageInfo)this.warehouseSupplyRelQueryApi.queryWarehousePage(JSON.toJSONString((Object)warehouseReqDto), Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE)).getData()).getList();
        if (!CollectionUtils.isEmpty((Collection)result2)) {
            log.info("\u7b2c\u4e8c\u6b65\u67e5\u8be2\u6210\u529f warehouseSupplyRelRespDtos : {} .", (Object)JSONObject.toJSONString(warehouseSupplyRelRespDtos));
            return result2.stream().map(WarehouseSupplyRelRespDto::getWarehouseCode).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public List<CsLogicInventoryTotalRespDto> getDefaultInventoryList(List<String> cargoCodeList, Long shopId, Long customerId) {
        log.info("\u9ed8\u8ba4\u5e93\u5b58\u67e5\u8be2\u7b56\u7565 req params , cargoCodeList : {} ,shopId : {} ,customerId : {} .", new Object[]{cargoCodeList, shopId, customerId});
        WarehouseRespDto warehouseRespDto = this.inventoryService.queryWarehouseByShopId(shopId);
        CsLogicInventoryTotalBatchQueryDto tcbjAvilableReqDto = new CsLogicInventoryTotalBatchQueryDto();
        tcbjAvilableReqDto.setWarehouseCode(warehouseRespDto.getCode());
        tcbjAvilableReqDto.setCargoCodeList(cargoCodeList);
        return (List)this.csLogicInventoryTotalQueryApi.queryWarehouseInventory(tcbjAvilableReqDto).getData();
    }
}

