/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.bitem.biz.service.impl;

import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request.CustomerAuthItemPageReqDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.response.CustomerAuthItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.query.ICustomerAuthItemQueryApi;
import com.dtyunxi.yundt.module.bitem.api.dto.request.CustomerAuthItemPageExtReqDto;
import com.dtyunxi.yundt.module.bitem.api.dto.response.CustomerAuthItemExtRespDto;
import com.dtyunxi.yundt.module.bitem.api.service.ICustomerAuthItemExtService;
import com.dtyunxi.yundt.module.bitem.biz.service.ICustomerAuthItemService;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CustomerAuthItemExtServiceImpl
implements ICustomerAuthItemExtService {
    private static final Logger logger = LoggerFactory.getLogger(CustomerAuthItemExtServiceImpl.class);
    @Autowired
    private ICustomerAuthItemService customerAuthItemService;
    @Autowired
    private ICustomerAuthItemQueryApi customerAuthItemQueryApi;

    public RestResponse<PageInfo<CustomerAuthItemExtRespDto>> queryAuthItemPageExt(CustomerAuthItemPageExtReqDto reqDto) {
        RestResponse<PageInfo<CustomerAuthItemRespDto>> baseResponse = this.customerAuthItemService.queryAuthItemPage((CustomerAuthItemPageReqDto)reqDto);
        PageInfo basePageInfo = (PageInfo)RestResponseHelper.extractData(baseResponse);
        PageInfo extPageInfo = new PageInfo();
        BeanUtils.copyProperties((Object)basePageInfo, (Object)extPageInfo, (String[])new String[]{"list"});
        if (basePageInfo != null && CollectionUtils.isNotEmpty((Collection)basePageInfo.getList())) {
            List extList = basePageInfo.getList().stream().map(this::convertToExtRespDto).collect(Collectors.toList());
            extPageInfo.setList(extList);
        }
        return new RestResponse((Object)extPageInfo);
    }

    public RestResponse<List<CustomerAuthItemExtRespDto>> queryAuthItemBySkuIdsExt(List<Long> skuIds) {
        if (CollectionUtils.isEmpty(skuIds)) {
            return new RestResponse(new ArrayList());
        }
        try {
            RestResponse<List<CustomerAuthItemRespDto>> baseResponse = this.customerAuthItemService.queryAuthItemBySkuIds(skuIds);
            List baseList = (List)RestResponseHelper.extractData(baseResponse);
            if (CollectionUtils.isEmpty((Collection)baseList)) {
                return new RestResponse(new ArrayList());
            }
            List extList = baseList.stream().map(this::convertToExtRespDto).collect(Collectors.toList());
            return new RestResponse(extList);
        }
        catch (Exception e) {
            logger.error("Error querying auth items by skuIds: {}", skuIds, (Object)e);
            return new RestResponse(new ArrayList());
        }
    }

    private CustomerAuthItemExtRespDto convertToExtRespDto(CustomerAuthItemRespDto baseDto) {
        CustomerAuthItemExtRespDto extDto = new CustomerAuthItemExtRespDto();
        BeanUtils.copyProperties((Object)baseDto, (Object)extDto);
        return extDto;
    }
}

