/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.marketing.biz.impl.serializa;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.icommerce.utils.BizExceptionHelper;
import com.dtyunxi.icommerce.utils.IExceptionCode;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.enums.CouponValidityTypeEnum;
import com.dtyunxi.yundt.module.marketing.api.ISerializeCouPonUseTimeValue;
import com.dtyunxi.yundt.module.marketing.api.common.CouponTemplateTobDto;
import com.dtyunxi.yundt.module.marketing.api.common.CouponUseTimeTobDto;
import com.dtyunxi.yundt.module.marketing.api.common.DynamicDate;
import com.dtyunxi.yundt.module.marketing.biz.enums.MarketingModuleExcpCode;
import org.springframework.stereotype.Component;

@Component
public class SerializeCouPonUseTimeValueByDays
implements ISerializeCouPonUseTimeValue {
    private static final Integer TYPE = 4;

    public Integer getType() {
        return TYPE;
    }

    public void serialize(CouponTemplateTobDto couponTemplateTobDto) {
        CouponUseTimeTobDto couponUseTimeTobDto = couponTemplateTobDto.getCouponUseTimeReqDto();
        if (couponUseTimeTobDto.getValue() == null) {
            BizExceptionHelper.throwBizException((IExceptionCode)MarketingModuleExcpCode.COUPON_TP_USE_TIME_RANGE_UNDEFINED);
        }
        if (couponUseTimeTobDto.getValue() instanceof Integer || couponUseTimeTobDto.getValue() instanceof Byte) {
            DynamicDate dynamicDate = new DynamicDate();
            dynamicDate.setAfterDate(Integer.valueOf(couponUseTimeTobDto.getUpDays() + 1));
            dynamicDate.setDay(Integer.valueOf(Integer.parseInt(couponUseTimeTobDto.getValue().toString())));
            couponTemplateTobDto.setValidityType(CouponValidityTypeEnum.DYNAMIC_DATE.getType());
            couponTemplateTobDto.setDynamicDate(JSONObject.toJSONString((Object)dynamicDate));
        } else {
            BizExceptionHelper.throwBizException((IExceptionCode)MarketingModuleExcpCode.COUPON_TP_USE_TIME_RANGE_UNDEFINED);
        }
    }
}

