/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.marketing.biz.condition.coupon;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.SpringBeanUtil;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ConditionReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ConditionRespDto;
import com.dtyunxi.yundt.module.marketing.api.common.BaseActivityTobDto;
import com.dtyunxi.yundt.module.marketing.api.dto.ConditionItem;
import com.dtyunxi.yundt.module.marketing.api.dto.response.CouponItemRespDto;
import com.dtyunxi.yundt.module.marketing.api.dto.response.CouponTemplateDetailRespDto;
import com.dtyunxi.yundt.module.marketing.biz.condition.AbstractBaseTemplate;
import com.dtyunxi.yundt.module.marketing.biz.constant.MarketingConstant;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

public class CouponItemSkusCondition
extends AbstractBaseTemplate {
    @Override
    protected <T extends BaseActivityTobDto> void parse(ConditionRespDto conditionRespDto, T t) {
        IItemQueryApi itemQueryApi = (IItemQueryApi)SpringBeanUtil.getBean(IItemQueryApi.class);
        CouponTemplateDetailRespDto couponDetail = (CouponTemplateDetailRespDto)t;
        JSONObject jsonObject = JSON.parseObject((String)conditionRespDto.getConditionParams());
        List items = JSON.parseArray((String)jsonObject.getString("CouponItemSkusCondition.items"), ConditionItem.class);
        ArrayList itemList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)items)) {
            List itemIdList = items.stream().map(ConditionItem::getItemCode).distinct().collect(Collectors.toList());
            List skuIdList = items.stream().map(ConditionItem::getSkuId).collect(Collectors.toList());
            List itemRespDtos = (List)RestResponseHelper.extractData((RestResponse)itemQueryApi.queryByItemIdsOnPost(itemIdList));
            List skuRespDtos = (List)itemQueryApi.queryItemSkus(skuIdList).getData();
            Map<Long, ItemRespDto> itemMap = itemRespDtos.stream().collect(Collectors.toMap(ItemRespDto::getId, item -> item, (e1, e2) -> e1));
            Map<Long, ItemSkuRespDto> skuMap = skuRespDtos.stream().collect(Collectors.toMap(ItemSkuRespDto::getId, sku -> sku, (e1, e2) -> e1));
            items.forEach(couponItem -> {
                ItemRespDto itemRespDto = (ItemRespDto)itemMap.get(Long.valueOf(couponItem.getItemCode()));
                ItemSkuRespDto skuRespDto = (ItemSkuRespDto)skuMap.get(couponItem.getSkuId());
                if (Objects.nonNull(itemRespDto) && Objects.nonNull(skuRespDto)) {
                    CouponItemRespDto couponItemRespDto = new CouponItemRespDto();
                    couponItemRespDto.setItemId(Long.valueOf(couponItem.getItemCode()));
                    couponItemRespDto.setItemCode(itemRespDto.getCode());
                    couponItemRespDto.setItemName(itemRespDto.getName());
                    couponItemRespDto.setSkuId(couponItem.getSkuId());
                    couponItemRespDto.setAttr(skuRespDto.getAttr());
                    couponItemRespDto.setShopId(couponItem.getShopId());
                    couponItemRespDto.setSubType(itemRespDto.getSubType());
                    itemList.add(couponItemRespDto);
                }
            });
        }
        couponDetail.setItemList((List)itemList);
    }

    @Override
    public long getConditionTemplateId() {
        return MarketingConstant.CONDITION_ITEM_TP_ID;
    }

    @Override
    public long getRuleId() {
        return 0L;
    }

    @Override
    public boolean support(ActivityType type) {
        return ActivityType.COUPON_TOB_ACTIVITY.equals((Object)type);
    }

    @Override
    public <T extends BaseActivityTobDto> ConditionReqDto convertToCondition(T t) {
        return null;
    }
}

