/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.marketing.biz.condition.exchange;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.SpringBeanUtil;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ItemBusTypeEnum;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.item.ItemSkuPriceConditionQueryReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.item.ItemSkuPriceQueryReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.item.ItemSkuPriceQueryRespDto;
import com.dtyunxi.yundt.cube.center.price.api.query.IBasePriceItemQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.ShopBaseDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.ItemSkuDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityItemQueryReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ConditionReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.ActivityItemRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.query.IActivityItemQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ConditionRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.fullreduction.model.FullDecActItem;
import com.dtyunxi.yundt.module.bitem.api.IBitemService;
import com.dtyunxi.yundt.module.bitem.api.dto.ItemChangeApplyDetailDto;
import com.dtyunxi.yundt.module.marketing.api.common.BaseActivityTobDto;
import com.dtyunxi.yundt.module.marketing.api.dto.BlackItemSkuDto;
import com.dtyunxi.yundt.module.marketing.api.dto.request.ApplicableActivityItemDto;
import com.dtyunxi.yundt.module.marketing.api.dto.request.PromotionActivitySkuDto;
import com.dtyunxi.yundt.module.marketing.api.dto.request.exchange.ExchangeActivityDto;
import com.dtyunxi.yundt.module.marketing.api.enums.SelectTypeEnum;
import com.dtyunxi.yundt.module.marketing.biz.condition.AbstractBaseTemplate;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExchangeItemsCondition
extends AbstractBaseTemplate {
    private static Logger logger = LoggerFactory.getLogger(ExchangeItemsCondition.class);

    @Override
    protected <T extends BaseActivityTobDto> void parse(ConditionRespDto conditionRespDto, T t) {
        JSONObject jsonObject = JSON.parseObject((String)conditionRespDto.getConditionParams());
        IBitemService itemService = (IBitemService)SpringBeanUtil.getBean(IBitemService.class);
        Integer selectType = jsonObject.getInteger("ItemTimeLimitCondition.type");
        if (SelectTypeEnum.ALL.getCode().equals(selectType) || SelectTypeEnum.CATEGORY.getCode().equals(selectType)) {
            List brandIds = JSON.parseArray((String)jsonObject.getString("ItemTimeLimitCondition.brandIds"), Long.class);
            List dirIds = JSON.parseArray((String)jsonObject.getString("ItemTimeLimitCondition.dirIds"), Long.class);
            List blackItems = JSON.parseArray((String)jsonObject.getString("ItemTimeLimitCondition.blackItems"), ItemSkuDto.class);
            ArrayList<BlackItemSkuDto> blackActivityItems = new ArrayList<BlackItemSkuDto>();
            if (CollectionUtils.isNotEmpty((Collection)blackItems)) {
                for (ItemSkuDto blackItem : blackItems) {
                    ItemChangeApplyDetailDto itemDetail = itemService.getDetailByItemId(blackItem.getShopId(), blackItem.getItemId(), ItemBusTypeEnum.ORDINARY.getType());
                    BlackItemSkuDto blackItemSkuDto = new BlackItemSkuDto();
                    blackItemSkuDto.setItemId(blackItem.getItemId());
                    blackItemSkuDto.setItemCode(itemDetail.getItemCode());
                    blackItemSkuDto.setItemName(itemDetail.getItemName());
                    blackItemSkuDto.setShopId(blackItem.getShopId());
                    blackItemSkuDto.setSkuId(blackItem.getSkuId());
                    itemDetail.getSkuList().stream().filter(skuRespDto -> skuRespDto.getId().equals(blackItem.getSkuId())).findFirst().ifPresent(itemSku -> {
                        if (null != itemSku.getAttrMap()) {
                            String skuName = StringUtils.join(itemSku.getAttrMap().values(), (String)" ");
                            blackItemSkuDto.setSkuDesc(skuName);
                            blackItemSkuDto.setAttr(skuName);
                        }
                    });
                    blackActivityItems.add(blackItemSkuDto);
                }
            }
            ExchangeActivityDto exchangeActivityDto = (ExchangeActivityDto)t;
            exchangeActivityDto.setBrandIds(brandIds);
            exchangeActivityDto.setDirIds(dirIds);
            exchangeActivityDto.setBlackItems(blackActivityItems);
            return;
        }
        IActivityItemQueryApi activityItemQueryApi = (IActivityItemQueryApi)SpringBeanUtil.getBean(IActivityItemQueryApi.class);
        IShopQueryApi shopQueryApi = (IShopQueryApi)SpringBeanUtil.getBean(IShopQueryApi.class);
        ActivityItemQueryReqDto activityItemQueryReqDto = new ActivityItemQueryReqDto();
        activityItemQueryReqDto.setActivityId(conditionRespDto.getActivityId());
        List items = (List)activityItemQueryApi.queryAll(activityItemQueryReqDto).getData();
        Map<String, List<ActivityItemRespDto>> group = items.stream().collect(Collectors.groupingBy(activityItem -> activityItem.getShopId() + activityItem.getItemId().toString() + activityItem.getSkuId()));
        ArrayList groupActivityItemDtos = Lists.newArrayList();
        ArrayList<ItemSkuPriceConditionQueryReqDto> shopConditionList = new ArrayList<ItemSkuPriceConditionQueryReqDto>();
        for (ActivityItemRespDto item : items) {
            ItemSkuPriceConditionQueryReqDto skuPriceConditionReqDto = new ItemSkuPriceConditionQueryReqDto();
            skuPriceConditionReqDto.setSkuId(item.getSkuId());
            skuPriceConditionReqDto.setShopId(item.getShopId());
            shopConditionList.add(skuPriceConditionReqDto);
        }
        ItemSkuPriceQueryReqDto itemSkuPriceQueryReqDto = new ItemSkuPriceQueryReqDto();
        itemSkuPriceQueryReqDto.setShopConditionList(shopConditionList);
        RestResponse listRestResponse = ((IBasePriceItemQueryApi)SpringBeanUtil.getBean(IBasePriceItemQueryApi.class)).queryRetailSkuPrice(itemSkuPriceQueryReqDto);
        List skuPriceQueryRespList = (List)RestResponseHelper.extractData((RestResponse)listRestResponse);
        Map<String, BigDecimal> costRetailPriceMap = skuPriceQueryRespList.stream().filter(Objects::nonNull).filter(e -> e.getCostRetailPrice() != null).collect(Collectors.toMap(e -> "" + e.getShopId() + e.getSkuId(), ItemSkuPriceQueryRespDto::getCostRetailPrice, (o1, o2) -> o1));
        group.forEach((shopItemKey, itemDtos) -> {
            Long itemId = ((ActivityItemRespDto)itemDtos.get(0)).getItemId();
            Long shopId = ((ActivityItemRespDto)itemDtos.get(0)).getShopId();
            ItemChangeApplyDetailDto itemDetail = itemService.getDetailByItemId(shopId, itemId, ItemBusTypeEnum.ORDINARY.getType());
            if (null == itemDetail) {
                return;
            }
            ApplicableActivityItemDto applicableActivityItemDto = new ApplicableActivityItemDto();
            applicableActivityItemDto.setItemId(itemId);
            applicableActivityItemDto.setItemCode(itemDetail.getItemCode());
            applicableActivityItemDto.setItemName(itemDetail.getItemName());
            applicableActivityItemDto.setShopId(shopId);
            applicableActivityItemDto.setSkuId(((ActivityItemRespDto)itemDtos.get(0)).getSkuId());
            applicableActivityItemDto.setDirName(itemDetail.getDirName());
            if (null != shopId) {
                ShopBaseDto shopDto = (ShopBaseDto)shopQueryApi.queryBaseById(shopId).getData();
                applicableActivityItemDto.setShopName(shopDto == null ? null : shopDto.getName());
            }
            Long totalStock = 0L;
            ArrayList skus = Lists.newArrayList();
            BigDecimal minPrice = BigDecimal.ZERO;
            for (ActivityItemRespDto skuDto : itemDtos) {
                PromotionActivitySkuDto sku = new PromotionActivitySkuDto();
                sku.setActivityStock(skuDto.getOriginalStock());
                applicableActivityItemDto.setActivityStock(skuDto.getOriginalStock());
                sku.setPromotionPrice(skuDto.getActivityPrice());
                sku.setItemId(skuDto.getItemId());
                sku.setSkuId(skuDto.getSkuId());
                itemDetail.getSkuList().stream().filter(skuRespDto -> skuRespDto.getId().equals(skuDto.getSkuId())).findFirst().ifPresent(itemSku -> {
                    if (null != itemSku.getAttrMap()) {
                        String skuName = StringUtils.join(itemSku.getAttrMap().values(), (String)" ");
                        sku.setSkuName(skuName);
                        applicableActivityItemDto.setSkuDesc(skuName);
                        applicableActivityItemDto.setAttr(skuName);
                        applicableActivityItemDto.setSkuCode(itemSku.getCode());
                        applicableActivityItemDto.setBrand(itemDetail.getBrand());
                    }
                });
                String key = "" + shopId + skuDto.getSkuId();
                BigDecimal price = (BigDecimal)costRetailPriceMap.get(key);
                logger.info("\u83b7\u53d6\u91d1\u989d:{},{}", (Object)key, costRetailPriceMap.get(key));
                if (null != price && price.compareTo(minPrice) == -1) {
                    minPrice = price;
                }
                sku.setSellPrice(price);
                Long stock = itemService.queryVirStorage(shopId, null, skuDto.getSkuId());
                sku.setStock(stock);
                totalStock = totalStock + stock;
                skus.add(sku);
            }
            applicableActivityItemDto.setSkus((List)skus);
            applicableActivityItemDto.setTotalStock(totalStock);
            applicableActivityItemDto.setSellPrice(minPrice);
            applicableActivityItemDto.setSubType(itemDetail.getSubType());
            groupActivityItemDtos.add(applicableActivityItemDto);
            ExchangeActivityDto exchangeActivityDto = (ExchangeActivityDto)t;
            exchangeActivityDto.setActivityItems(groupActivityItemDtos);
        });
    }

    @Override
    public long getConditionTemplateId() {
        return 1196944771412880281L;
    }

    @Override
    public long getRuleId() {
        return 0L;
    }

    @Override
    public boolean support(ActivityType type) {
        return ActivityType.EXCHANGE_ACTIVITY.equals((Object)type);
    }

    @Override
    public <T extends BaseActivityTobDto> ConditionReqDto convertToCondition(T t) {
        ConditionReqDto condition = this.getConditionReqDto();
        HashMap conditionParam = Maps.newHashMap();
        ExchangeActivityDto exchangeActivityDto = (ExchangeActivityDto)t;
        List promotionActivityItemDtos = exchangeActivityDto.getActivityItems();
        conditionParam.put("ItemTimeLimitCondition.type", exchangeActivityDto.getSelectType());
        List fullDecActItems = promotionActivityItemDtos.stream().map(itemDto -> {
            FullDecActItem fullDecActItem = new FullDecActItem();
            fullDecActItem.setItemId(itemDto.getItemId());
            fullDecActItem.setItemCode(itemDto.getItemCode());
            fullDecActItem.setItemName(itemDto.getItemName());
            fullDecActItem.setPrice(itemDto.getSellPrice());
            fullDecActItem.setShopId(itemDto.getShopId());
            fullDecActItem.setSkuId(itemDto.getSkuId());
            return fullDecActItem;
        }).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty((Collection)exchangeActivityDto.getBlackItems())) {
            List blackItems = exchangeActivityDto.getBlackItems().stream().map(itemDto -> {
                ItemSkuDto itemSkuDto = new ItemSkuDto();
                itemSkuDto.setItemId(itemDto.getItemId());
                itemSkuDto.setShopId(itemDto.getShopId());
                itemSkuDto.setSkuId(itemDto.getSkuId());
                return itemSkuDto;
            }).collect(Collectors.toList());
            conditionParam.put("ItemTimeLimitCondition.blackItems", blackItems);
        }
        conditionParam.put("ItemTimeLimitCondition.items", fullDecActItems);
        conditionParam.put("ItemTimeLimitCondition.sellerIds", Lists.newArrayList());
        conditionParam.put("ItemTimeLimitCondition.brandIds", t.getBrandIds());
        conditionParam.put("ItemTimeLimitCondition.dirIds", t.getDirIds());
        logger.info("\u52a0\u4ef7\u8d2d\u6d3b\u52a8\u9002\u7528\u5546\u54c1\u6761\u4ef6\u53c2\u6570={}", (Object)JSON.toJSONString((Object)conditionParam));
        condition.setConditionParams(JSON.toJSONString((Object)conditionParam));
        return condition;
    }
}

