/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.trade.biz.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.bean.ObjectHelper;
import com.dtyunxi.icommerce.utils.BizExceptionHelper;
import com.dtyunxi.icommerce.utils.IExceptionCode;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.ITcbjInventoryApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.TcbjInventoryActReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ItemBusTypeEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemDetailReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemSearchQueryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ShelfReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemDetailRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemMediasRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemPriceRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSearchRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemShelfRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemSkuQueryApi;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.CommunalPriceQueryReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.ItemPolicyPriceRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.ITrolleyApi;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.TrolleyItemReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.TrolleyItemRepDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.TrolleyRepDto;
import com.dtyunxi.yundt.cube.center.trade.api.query.ITrolleyQueryApi;
import com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.api.IItemActivityStockApi;
import com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.api.dto.ExchangeActivityTargetDto;
import com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.api.dto.ItemSkuActivityPriceDto;
import com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.api.dto.request.ActivityPriceBranchQueryReqDto;
import com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.api.dto.response.ExchangeActivityTargetRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.ItemSkuDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityItemQueryReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivitySimpleInfoDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ItemActivityTagDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ItemActivityTagQueryReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.ActivityItemRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.ActivityRuleItemRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityDimensionEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.BizActivityType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.query.IActivityItemQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.query.IActivityQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.query.IActivityRuleItemQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.query.IConditionQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.query.IItemActivityTagQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ActivityRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ConditionRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.combination.model.ComRuleContentDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.combination.model.CombinationRule;
import com.dtyunxi.yundt.module.bitem.api.IBItemPriceService;
import com.dtyunxi.yundt.module.bitem.api.IBitemService;
import com.dtyunxi.yundt.module.bitem.api.IBshopService;
import com.dtyunxi.yundt.module.bitem.api.dto.request.ItemStorageQueryDto;
import com.dtyunxi.yundt.module.bitem.api.dto.request.StorageBranchQueryReqDto;
import com.dtyunxi.yundt.module.bitem.api.dto.response.ItemActivityPriceRespDto;
import com.dtyunxi.yundt.module.bitem.api.dto.response.ItemInfoRespDto;
import com.dtyunxi.yundt.module.bitem.biz.util.PageInfoUtil;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.marketing.api.dto.response.ItemActivityInfoRespDto;
import com.dtyunxi.yundt.module.trade.api.dto.ShoppingCartGroupDto;
import com.dtyunxi.yundt.module.trade.api.dto.ShoppingCartItemExtDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.ShoppingCartItemReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.TrolleyQueryReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.ItemOrderActivityTagDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.ShoppingCartItemRespDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.ShoppingCartRespDto;
import com.dtyunxi.yundt.module.trade.api.enums.TradeModuleExcpCode;
import com.dtyunxi.yundt.module.trade.biz.util.DeliveryRuleUtils;
import com.dtyunxi.yundt.module.trade.biz.vo.BatchAddItemVo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.yx.tcbj.center.api.dto.request.SellerSkuPriceReqDto;
import com.yx.tcbj.center.api.query.ISellerSkuPriceQueryApi;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.AsyncResult;
import org.springframework.stereotype.Service;

@Service
public class ShoppingCartCommonImpl {
    private static Logger logger = LoggerFactory.getLogger(ShoppingCartCommonImpl.class);
    @Resource
    private ITrolleyApi trolleyApi;
    @Resource
    private ITrolleyQueryApi trolleyQueryApi;
    @Resource
    private IItemQueryApi itemQueryApi;
    @Resource
    private IShopQueryApi shopQueryApi;
    @Resource
    private IContext context;
    @Resource
    private IBitemService bitemService;
    @Resource
    private IItemActivityTagQueryApi itemActivityTagQueryApi;
    @Resource
    private IActivityItemQueryApi activityItemQueryApi;
    @Resource
    private IActivityQueryApi activityQueryApi;
    @Resource
    private IItemSkuQueryApi itemSkuQueryApi;
    @Autowired
    private IBItemPriceService ibItemPriceService;
    @Resource
    private IBshopService bshopService;
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;
    @Autowired
    private IItemActivityStockApi itemActivityStockApi;
    @Resource
    private ICustomerQueryApi customerQueryApi;
    @Resource
    private IActivityRuleItemQueryApi activityRuleItemQueryApi;
    @Resource
    private IConditionQueryApi conditionQueryApi;
    @Resource
    private ISellerSkuPriceQueryApi sellerSkuPriceQueryApi;
    @Resource
    private ITcbjInventoryApi tcbjInventoryApi;
    @Autowired
    private DeliveryRuleUtils deliveryRuleUtils;

    @Async(value="taskExecutor")
    public Future<Long> asycAddItem(ShoppingCartItemReqDto cartItemReqDto, Long tenantId, Long instanceId, Long userId, String userType, String requestId) {
        try {
            logger.info("\u5f02\u6b65\u52a0\u8d2d\u7269\u8f66 userId={}, itemId={}", (Object)cartItemReqDto.getUserId(), (Object)cartItemReqDto.getItemId());
            ServiceContext.getContext().set("yes.req.tenantId", (Object)tenantId);
            ServiceContext.getContext().set("yes.req.instanceId", (Object)instanceId);
            ServiceContext.getContext().set("yes.req.userId", (Object)userId);
            ServiceContext.getContext().set("yes.req.userType", (Object)userType);
            ServiceContext.getContext().set("yes.req.requestId", (Object)requestId);
            Long id = this.addItem(cartItemReqDto, tenantId, instanceId, userId);
            logger.info("\u5f02\u6b65\u52a0\u8d2d\u7269\u8f66\u6210\u529f\uff0cid={}", (Object)id);
            return new AsyncResult((Object)id);
        }
        catch (BizException e) {
            if (TradeModuleExcpCode.ITEM_STORAGAE_NOT_ENOUGH.getCode().equals(e.getCode())) {
                logger.error("{}, {}", (Object)TradeModuleExcpCode.ITEM_STORAGAE_NOT_ENOUGH.getMsg(), (Object)e);
            } else {
                logger.error("\u52a0\u8d2d\u7269\u8f66\u5931\u8d25{}", (Throwable)e);
            }
            return new AsyncResult((Object)0L);
        }
    }

    public Long addItem(ShoppingCartItemReqDto shoppingCartItemReqDto, Long tenantId, Long instanceId, Long userId) {
        ShopDto shopDto;
        TrolleyRepDto substationCart;
        Boolean enough;
        ItemDetailRespDto itemDetailRespDto;
        if (Objects.nonNull(shoppingCartItemReqDto.getUserId())) {
            userId = shoppingCartItemReqDto.getUserId();
        }
        if (null == (itemDetailRespDto = (ItemDetailRespDto)this.itemQueryApi.queryItemDetail(shoppingCartItemReqDto.getItemId(), "sku,medias", null).getData())) {
            BizExceptionHelper.throwBizException((IExceptionCode)TradeModuleExcpCode.ITEM_NOT_EXIST);
        }
        if (this.deliveryRuleUtils.isSellerDelivery(shoppingCartItemReqDto.getCustomerId()) && !(enough = this.validateStorage(shoppingCartItemReqDto.getShopId(), shoppingCartItemReqDto.getItemId(), shoppingCartItemReqDto.getSkuId(), shoppingCartItemReqDto.getItemNum(), shoppingCartItemReqDto.getCustomerId())).booleanValue()) {
            BizExceptionHelper.throwBizException((IExceptionCode)TradeModuleExcpCode.ITEM_STORAGAE_NOT_ENOUGH);
        }
        if (null == (substationCart = this.getUserShoppingCart(userId, shoppingCartItemReqDto.getSubstationId()))) {
            BizExceptionHelper.throwBizException((IExceptionCode)TradeModuleExcpCode.SHOPPING_CART_NOT_EXIST);
        }
        if (null == (shopDto = (ShopDto)this.shopQueryApi.queryById(shoppingCartItemReqDto.getShopId().longValue(), new String[0]).getData())) {
            BizExceptionHelper.throwBizException((IExceptionCode)TradeModuleExcpCode.SHOP_NOT_EXIST);
        }
        TrolleyItemReqDto trolleyItemReqDto = new TrolleyItemReqDto();
        trolleyItemReqDto.setTenantId(tenantId);
        trolleyItemReqDto.setInstanceId(instanceId);
        trolleyItemReqDto.setItemNum(shoppingCartItemReqDto.getItemNum());
        trolleyItemReqDto.setItemName(shoppingCartItemReqDto.getItemName());
        trolleyItemReqDto.setTrolleyId(substationCart.getId());
        trolleyItemReqDto.setItemSrc("icommerceb");
        trolleyItemReqDto.setGroupKey(shoppingCartItemReqDto.getShopId().toString());
        trolleyItemReqDto.setItemSerial(String.valueOf(shoppingCartItemReqDto.getItemId()));
        trolleyItemReqDto.setSkuSerial(String.valueOf(shoppingCartItemReqDto.getSkuId()));
        trolleyItemReqDto.setAddChannel(shoppingCartItemReqDto.getAddChannel());
        trolleyItemReqDto.setType(shopDto.getType() == null ? null : Integer.valueOf(shopDto.getType().intValue()));
        ShoppingCartItemExtDto extension = this.getShoppingCartItemExtDto(itemDetailRespDto, shoppingCartItemReqDto, shopDto.getName());
        trolleyItemReqDto.setExtension(ObjectHelper.bean2Json((Object)extension));
        RestResponse trolleyItemRepDtoRestResponse = this.trolleyApi.addTrolleyItem(trolleyItemReqDto);
        logger.info("\u65b0\u589e\u8d2d\u7269\u8f66\u9879\u63a5\u53e3\u8fd4\u56de\u53c2\u6570, {}", (Object)trolleyItemRepDtoRestResponse.toString());
        return ((TrolleyItemRepDto)trolleyItemRepDtoRestResponse.getData()).getId();
    }

    private Boolean validateStorage(Long shopId, Long itemId, Long skuId, Integer itemNum, Long customerId) {
        Boolean enough = false;
        RestResponse listRestResponse = this.itemSkuQueryApi.queryBySkuId((List)Lists.newArrayList((Object[])new Long[]{skuId}));
        List itemSkuRespDtos = (List)RestResponseHelper.extractData((RestResponse)listRestResponse);
        StorageBranchQueryReqDto storageBranchQueryReqDto = new StorageBranchQueryReqDto();
        ArrayList<ItemStorageQueryDto> itemStorageList = new ArrayList<ItemStorageQueryDto>(1);
        ItemStorageQueryDto itemStorageQueryDto = new ItemStorageQueryDto();
        itemStorageQueryDto.setSkuId(skuId);
        itemStorageQueryDto.setShopId(shopId);
        itemStorageQueryDto.setCargoCode(((ItemSkuRespDto)itemSkuRespDtos.get(0)).getCargoCode());
        itemStorageList.add(itemStorageQueryDto);
        storageBranchQueryReqDto.setItemStorageList(itemStorageList);
        storageBranchQueryReqDto.setCustomerId(customerId);
        List itemStorageQueryDtos = this.bitemService.queryBranchItemStorage(storageBranchQueryReqDto);
        Long storage = ((ItemStorageQueryDto)itemStorageQueryDtos.get(0)).getAvaNum();
        if (storage >= (long)itemNum.intValue()) {
            enough = true;
        }
        return enough;
    }

    private ShoppingCartItemExtDto getShoppingCartItemExtDto(ItemDetailRespDto itemDetailRespDto, ShoppingCartItemReqDto shoppingCartItemReqDto, String shopName) {
        List skus;
        ShoppingCartItemExtDto shoppingCartItemExtDto = new ShoppingCartItemExtDto();
        String imgPath = null;
        BigDecimal sellPrice = null;
        String attrs = null;
        List medias = itemDetailRespDto.getItemMediasList();
        if (CollectionUtils.isNotEmpty((Collection)medias)) {
            imgPath = medias.stream().findFirst().map(ItemMediasRespDto::getPath1).orElse(null);
        }
        if (CollectionUtils.isNotEmpty((Collection)(skus = itemDetailRespDto.getItemSkuList()))) {
            for (ItemSkuRespDto sku : skus) {
                if (!shoppingCartItemReqDto.getSkuId().equals(sku.getId())) continue;
                List priceList = sku.getItemPriceList();
                if (CollectionUtils.isNotEmpty((Collection)priceList)) {
                    sellPrice = priceList.stream().filter(price -> "\u552e\u4ef7".equals(price.getName())).map(ItemPriceRespDto::getPrice).findFirst().orElse(null);
                }
                attrs = sku.getAttr();
            }
        }
        shoppingCartItemExtDto.setImgPath(imgPath);
        shoppingCartItemExtDto.setAttrs(attrs);
        shoppingCartItemExtDto.setSellPrice(sellPrice);
        shoppingCartItemExtDto.setShopName(shopName);
        shoppingCartItemExtDto.setBusType(itemDetailRespDto.getItem().getBusType());
        return shoppingCartItemExtDto;
    }

    private TrolleyRepDto getUserShoppingCart(Long userId, String substationId) {
        TrolleyRepDto trolleyRepDto = (TrolleyRepDto)this.trolleyQueryApi.getTrolley(this.context.tenantId(), this.context.instanceId(), "icommerceb", String.valueOf(userId), StringUtils.isBlank((CharSequence)substationId) ? "0" : substationId, Integer.valueOf(1)).getData();
        return trolleyRepDto;
    }

    private void setExchangeActivityId(List<ShoppingCartItemRespDto> normalCartItemList) {
        if (CollectionUtils.isEmpty(normalCartItemList)) {
            return;
        }
        HashMap shopDtoMap = Maps.newHashMap();
        List customerRespDtos = Lists.newArrayList();
        Set shopIds = normalCartItemList.stream().map(ShoppingCartItemRespDto::getShopId).collect(Collectors.toSet());
        List shopDtos = (List)RestResponseHelper.extractData((RestResponse)this.shopQueryApi.queryByIds(shopIds));
        ArrayList merchantIds = Lists.newArrayList();
        for (ShopDto shopDto : shopDtos) {
            merchantIds.add(shopDto.getOrganizationId());
            shopDtoMap.put(shopDto.getId(), shopDto);
        }
        String customerId = ServiceContext.getContext().getAttachment("yes.req.cus.b2b.customerid");
        if (StringUtils.isNumeric((CharSequence)customerId)) {
            logger.info("\u4e1a\u52a1\u5458\u7aef\uff1a{}", (Object)customerId);
            customerRespDtos.add(RestResponseHelper.extractData((RestResponse)this.customerQueryApi.queryById(Long.valueOf(customerId))));
        } else {
            logger.info("h5\u7aef");
            String orgId = ServiceContext.getContext().getAttachment("yes.req.cus.b2b.organizationid");
            customerRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryListByOrgIdAndMerchantIds((List)merchantIds, Long.valueOf(orgId)));
        }
        logger.info("\u5ba2\u6237\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)customerRespDtos));
        ExchangeActivityTargetDto exchangeActivityTargetDto = new ExchangeActivityTargetDto();
        exchangeActivityTargetDto.setCustomerRespDtos(customerRespDtos);
        exchangeActivityTargetDto.setActivityTemplateId(Long.valueOf(BizActivityType.EXCHANGE_ACTIVITY.getId()));
        HashMap map = Maps.newHashMap();
        for (ShoppingCartItemRespDto normalCartItem : normalCartItemList) {
            ItemSkuDto itemSkuDto = new ItemSkuDto();
            itemSkuDto.setShopId(normalCartItem.getShopId());
            itemSkuDto.setItemId(normalCartItem.getItemId());
            itemSkuDto.setSkuId(normalCartItem.getSkuId());
            if (shopDtoMap.containsKey(normalCartItem.getShopId())) {
                ShopDto shopDto = (ShopDto)shopDtoMap.get(normalCartItem.getShopId());
                itemSkuDto.setShopOrgId(shopDto.getOrganizationId());
            }
            if (map.containsKey(normalCartItem.getShopId())) {
                ((List)map.get(normalCartItem.getShopId())).add(itemSkuDto);
                continue;
            }
            map.put(normalCartItem.getShopId(), Lists.newArrayList((Object[])new ItemSkuDto[]{itemSkuDto}));
        }
        exchangeActivityTargetDto.setShopSkuIds((Map)map);
        logger.info("\u67e5\u8be2\u6362\u8d2d\u6d3b\u52a8\u5206\u7ec4\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)exchangeActivityTargetDto));
        List exchangeTargetRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.itemActivityStockApi.validateExchangeActivityTarget(exchangeActivityTargetDto));
        logger.info("\u6362\u8d2d\u6d3b\u52a8\u5206\u7ec4\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)exchangeTargetRespDtos));
        Map<String, ExchangeActivityTargetRespDto> exchangeMap = exchangeTargetRespDtos.stream().collect(Collectors.toMap(e -> e.getShopId() + "#" + e.getSkuId(), e -> e, (e1, e2) -> e1));
        for (ShoppingCartItemRespDto shoppingCartItemRespDto : normalCartItemList) {
            String key = shoppingCartItemRespDto.getShopId() + "#" + shoppingCartItemRespDto.getSkuId();
            if (!exchangeMap.containsKey(key)) continue;
            ExchangeActivityTargetRespDto exchangeRespDto = exchangeMap.get(key);
            shoppingCartItemRespDto.setActivityId(exchangeRespDto.getActivityId());
            shoppingCartItemRespDto.setActivityName(exchangeRespDto.getActivityName());
            shoppingCartItemRespDto.setActivityTag(exchangeRespDto.getActivityTag());
        }
    }

    public void groupByExchangeActivityId(List<ShoppingCartItemRespDto> normalCartItemList, List<ShoppingCartGroupDto> shoppingCartGroupDtos) {
        if (CollectionUtils.isEmpty(normalCartItemList) || CollectionUtils.isEmpty(shoppingCartGroupDtos)) {
            return;
        }
        HashMap shopDtoMap = Maps.newHashMap();
        List customerRespDtos = Lists.newArrayList();
        Set shopIds = normalCartItemList.stream().map(ShoppingCartItemRespDto::getShopId).collect(Collectors.toSet());
        List shopDtos = (List)RestResponseHelper.extractData((RestResponse)this.shopQueryApi.queryByIds(shopIds));
        ArrayList merchantIds = Lists.newArrayList();
        for (ShopDto shopDto : shopDtos) {
            merchantIds.add(shopDto.getOrganizationId());
            shopDtoMap.put(shopDto.getId(), shopDto);
        }
        String customerId = ServiceContext.getContext().getAttachment("yes.req.cus.b2b.customerid");
        if (StringUtils.isNumeric((CharSequence)customerId)) {
            logger.info("\u4e1a\u52a1\u5458\u7aef\uff1a{}", (Object)customerId);
            customerRespDtos.add(RestResponseHelper.extractData((RestResponse)this.customerQueryApi.queryById(Long.valueOf(customerId))));
        } else {
            logger.info("h5\u7aef");
            String orgId = ServiceContext.getContext().getAttachment("yes.req.cus.b2b.organizationid");
            customerRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryListByOrgIdAndMerchantIds((List)merchantIds, Long.valueOf(orgId)));
        }
        logger.info("\u5ba2\u6237\u4fe1\u606f\uff1a{}", (Object)customerRespDtos);
        ExchangeActivityTargetDto exchangeActivityTargetDto = new ExchangeActivityTargetDto();
        exchangeActivityTargetDto.setCustomerRespDtos(customerRespDtos);
        exchangeActivityTargetDto.setActivityTemplateId(Long.valueOf(BizActivityType.EXCHANGE_ACTIVITY.getId()));
        HashMap map = Maps.newHashMap();
        for (ShoppingCartItemRespDto normalCartItem : normalCartItemList) {
            ItemSkuDto itemSkuDto = new ItemSkuDto();
            itemSkuDto.setShopId(normalCartItem.getShopId());
            itemSkuDto.setItemId(normalCartItem.getItemId());
            itemSkuDto.setSkuId(normalCartItem.getSkuId());
            if (shopDtoMap.containsKey(normalCartItem.getShopId())) {
                ShopDto shopDto = (ShopDto)shopDtoMap.get(normalCartItem.getShopId());
                itemSkuDto.setShopOrgId(shopDto.getOrganizationId());
            }
            if (map.containsKey(normalCartItem.getShopId())) {
                ((List)map.get(normalCartItem.getShopId())).add(itemSkuDto);
                continue;
            }
            map.put(normalCartItem.getShopId(), Lists.newArrayList((Object[])new ItemSkuDto[]{itemSkuDto}));
        }
        exchangeActivityTargetDto.setShopSkuIds((Map)map);
        logger.info("\u67e5\u8be2\u6362\u8d2d\u6d3b\u52a8\u5206\u7ec4\u5165\u53c2\uff1a{}", (Object)exchangeActivityTargetDto);
        List exchangeTargetRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.itemActivityStockApi.validateExchangeActivityList(exchangeActivityTargetDto));
        logger.info("\u6362\u8d2d\u6d3b\u52a8\u5206\u7ec4\u4fe1\u606f\uff1a{}", (Object)exchangeTargetRespDtos);
        Map<String, ExchangeActivityTargetRespDto> exchangeMap = exchangeTargetRespDtos.stream().collect(Collectors.toMap(e -> e.getShopId() + "#" + e.getSkuId() + "#" + e.getActivityId(), e -> e, (e1, e2) -> e1));
        Map<Long, ShoppingCartGroupDto> groupMap = shoppingCartGroupDtos.stream().collect(Collectors.toMap(ShoppingCartGroupDto::getShopId, e -> e, (e1, e2) -> e1));
        for (ShoppingCartItemRespDto shoppingCartItemRespDto : normalCartItemList) {
            ShoppingCartGroupDto cartGroupDto = groupMap.get(shoppingCartItemRespDto.getShopId());
            if (cartGroupDto == null || !CollectionUtils.isNotEmpty((Collection)cartGroupDto.getActivityIds())) continue;
            ExchangeActivityTargetRespDto exchangeRespDto = null;
            for (Long activityId : cartGroupDto.getActivityIds()) {
                String key = shoppingCartItemRespDto.getShopId() + "#" + shoppingCartItemRespDto.getSkuId() + "#" + activityId;
                if (!exchangeMap.containsKey(key)) continue;
                exchangeRespDto = exchangeMap.get(key);
                break;
            }
            if (exchangeRespDto == null) continue;
            shoppingCartItemRespDto.setActivityId(exchangeRespDto.getActivityId());
            shoppingCartItemRespDto.setActivityName(exchangeRespDto.getActivityName());
            shoppingCartItemRespDto.setActivityTag(exchangeRespDto.getActivityTag());
        }
    }

    public ShoppingCartRespDto queryShoppingCarItemList(TrolleyQueryReqDto trolleyQueryReqDto) {
        TrolleyRepDto userTrolley;
        ShoppingCartRespDto result = new ShoppingCartRespDto();
        String substationId = null;
        if (null == trolleyQueryReqDto || null == trolleyQueryReqDto.getSubstationId()) {
            substationId = "0";
        }
        ArrayList itemList = Lists.newArrayList();
        Long userId = Objects.nonNull(trolleyQueryReqDto.getCustomerId()) ? trolleyQueryReqDto.getCustomerId() : (Long)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryOrgIdByUserId(this.context.userId()));
        if (Objects.isNull(userId)) {
            BizExceptionHelper.throwBizException((IExceptionCode)TradeModuleExcpCode.CUSTOMER_NOT_EXIST);
        }
        if (null == (userTrolley = this.getUserShoppingCart(userId, substationId))) {
            return result;
        }
        ArrayList allTrolleyItems = Lists.newArrayList();
        TrolleyItemReqDto trolleyItemReqDto = new TrolleyItemReqDto();
        trolleyItemReqDto.setType(trolleyQueryReqDto.getType());
        trolleyItemReqDto.setTrolleyId(userTrolley.getId());
        List list = (List)this.trolleyQueryApi.queryTrolleyItems(trolleyItemReqDto).getData();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return result;
        }
        List trolleyItemRepDtoList = Collections.emptyList();
        HashSet<Long> itemIdList = new HashSet<Long>();
        HashSet<Long> shopIdList = new HashSet<Long>();
        for (TrolleyItemRepDto trolleyItem : list) {
            if (Integer.valueOf(1).equals(trolleyItem.getActivityType())) {
                trolleyItemRepDtoList.add(trolleyItem);
            }
            itemIdList.add(Long.valueOf(trolleyItem.getItemSerial()));
            shopIdList.add(Long.valueOf(trolleyItem.getGroupKey()));
        }
        if (CollectionUtils.isNotEmpty(trolleyItemRepDtoList)) {
            result.setTrolleyItemRepDtoList(trolleyItemRepDtoList);
        }
        logger.info("\u7ec4\u5408\u5957\u88c5\u4fe1\u606f\uff0c{}", trolleyItemRepDtoList);
        ItemSearchRespDto itemSearchRespDto = this.queryItemESByItemIdsAndShopIds(itemIdList, shopIdList);
        if (null == itemSearchRespDto || !PageInfoUtil.isNotEmpty((PageInfo)itemSearchRespDto.getPageInfo())) {
            return result;
        }
        List itemRespDtos = itemSearchRespDto.getPageInfo().getList();
        Map itemMap = itemRespDtos.stream().collect(Collectors.toMap(ItemRespDto::getItemId, Function.identity(), (o1, o2) -> o2));
        ArrayList itemShelfRespDtos = Lists.newArrayList();
        ArrayList itemSkuRespDtos = Lists.newArrayList();
        HashSet itemIds = Sets.newHashSet();
        HashMap<Long, Integer> subTypeMap = new HashMap<Long, Integer>();
        for (ItemRespDto itemRespDto : itemRespDtos) {
            if (CollectionUtils.isNotEmpty((Collection)itemRespDto.getItemShelfInfoList())) {
                itemShelfRespDtos.addAll(itemRespDto.getItemShelfInfoList());
            }
            if (!itemIds.add(itemRespDto.getItemId())) continue;
            itemSkuRespDtos.addAll(itemRespDto.getItemSkuList());
            subTypeMap.put(itemRespDto.getItemId(), itemRespDto.getSubType());
        }
        Map<String, ItemShelfRespDto> itemShelfMap = itemShelfRespDtos.stream().collect(Collectors.toMap(item -> item.getShopId() + item.getSkuId().toString(), item -> item, (e1, e2) -> e1));
        Map<Long, ItemSkuRespDto> skuMap = itemSkuRespDtos.stream().collect(Collectors.toMap(ItemSkuRespDto::getId, sku -> sku, (e1, e2) -> e1));
        StorageBranchQueryReqDto storageBranchQueryReqDto = new StorageBranchQueryReqDto();
        ArrayList<ItemStorageQueryDto> itemStorageList = new ArrayList<ItemStorageQueryDto>();
        for (TrolleyItemRepDto trolleyItemRepDto : list) {
            if (trolleyItemRepDto.getActivityType() != 0) continue;
            Long skuId = Long.valueOf(trolleyItemRepDto.getSkuSerial());
            Long shopId = Long.valueOf(trolleyItemRepDto.getGroupKey());
            ItemSkuRespDto skuRespDto = skuMap.get(skuId);
            ItemStorageQueryDto itemStorageQueryDto = new ItemStorageQueryDto();
            itemStorageQueryDto.setSkuId(skuId);
            itemStorageQueryDto.setShopId(shopId);
            itemStorageQueryDto.setCargoCode(skuRespDto.getCargoCode());
            itemStorageList.add(itemStorageQueryDto);
        }
        storageBranchQueryReqDto.setItemStorageList(itemStorageList);
        List itemStorageQueryDtos = this.bitemService.queryBranchItemStorage(storageBranchQueryReqDto);
        Map<String, Long> avaNumMap = itemStorageQueryDtos.stream().collect(Collectors.toMap(e -> e.getShopId() + "_" + e.getSkuId() + "_" + e.getCargoCode(), e -> Optional.of(e).map(ItemStorageQueryDto::getAvaNum).orElse(0L), (o1, o2) -> o1));
        for (TrolleyItemRepDto trolleyItemRepDto : list) {
            if (trolleyItemRepDto.getActivityType() != 0) continue;
            ShoppingCartItemRespDto shoppingCartItemRespDto = this.convertToShoppingCartItemRespDto(trolleyItemRepDto, itemShelfMap, skuMap, avaNumMap);
            shoppingCartItemRespDto.setSubType((Integer)subTypeMap.get(Long.valueOf(trolleyItemRepDto.getItemSerial())));
            if (itemMap.containsKey(shoppingCartItemRespDto.getItemId())) {
                shoppingCartItemRespDto.setItemCode(((ItemRespDto)itemMap.get(shoppingCartItemRespDto.getItemId())).getCode());
            }
            itemList.add(shoppingCartItemRespDto);
        }
        this.setCartItemList(itemList, result);
        return result;
    }

    public ShoppingCartRespDto filterShoppingCarItemByShop(ShoppingCartRespDto shoppingCartRespDto) {
        ArrayList itemList;
        if (shoppingCartRespDto == null) {
            return null;
        }
        List<Object> shopIds = new ArrayList();
        List shopDtos = this.bshopService.customerShop();
        if (CollectionUtils.isNotEmpty((Collection)shopDtos)) {
            shopIds = shopDtos.stream().map(ShopDto::getId).collect(Collectors.toList());
        }
        if (!CollectionUtils.isEmpty((Collection)shoppingCartRespDto.getNormalCartItemList())) {
            itemList = Lists.newArrayList();
            for (ShoppingCartItemRespDto shoppingCartItemRespDto : shoppingCartRespDto.getNormalCartItemList()) {
                if (!shopIds.contains(shoppingCartItemRespDto.getShopId())) continue;
                itemList.add(shoppingCartItemRespDto);
            }
            shoppingCartRespDto.setNormalCartItemList((List)itemList);
        }
        if (!CollectionUtils.isEmpty((Collection)shoppingCartRespDto.getLoseCartItemList())) {
            itemList = Lists.newArrayList();
            for (ShoppingCartItemRespDto shoppingCartItemRespDto : shoppingCartRespDto.getLoseCartItemList()) {
                if (!shopIds.contains(shoppingCartItemRespDto.getShopId())) continue;
                itemList.add(shoppingCartItemRespDto);
            }
            shoppingCartRespDto.setLoseCartItemList((List)itemList);
        }
        if (!CollectionUtils.isEmpty((Collection)shoppingCartRespDto.getTrolleyItemRepDtoList())) {
            ArrayList trolleyItemList = Lists.newArrayList();
            for (TrolleyItemRepDto trolleyItemRepDto : shoppingCartRespDto.getTrolleyItemRepDtoList()) {
                if (!shopIds.contains(Long.valueOf(trolleyItemRepDto.getGroupKey()))) continue;
                trolleyItemList.add(trolleyItemRepDto);
            }
            logger.info("\u7ec4\u5408\u5957\u88c5setCombinedPackageItemSize,{}", (Object)trolleyItemList.size());
            if (CollectionUtils.isNotEmpty((Collection)trolleyItemList)) {
                this.setCombinedPackageItem(trolleyItemList, shoppingCartRespDto);
            }
        }
        return shoppingCartRespDto;
    }

    private Map<String, ItemShelfRespDto> queryItemEsShelf(Map<Long, ShoppingCartItemRespDto> map) {
        Map<String, ItemShelfRespDto> shelfItemMap = new HashMap<String, ItemShelfRespDto>();
        HashSet<Long> itemIdList = new HashSet<Long>();
        HashSet<Long> shopIdList = new HashSet<Long>();
        for (Map.Entry<Long, ShoppingCartItemRespDto> entry : map.entrySet()) {
            List list = entry.getValue().getCombinedPackageItemList();
            list.forEach(e -> {
                itemIdList.add(e.getItemId());
                shopIdList.add(e.getShopId());
            });
        }
        ItemSearchRespDto itemSearchRespDto = this.queryItemESByItemIdsAndShopIds(itemIdList, shopIdList);
        logger.info("ES\u67e5\u8be2\u7ec4\u5408\u5957\u88c5\u5546\u54c1\u4e0a\u67b6\u4fe1\u606f\uff0c{}", (Object)JSONObject.toJSONString((Object)itemSearchRespDto));
        ArrayList itemShelfRespDtos = new ArrayList();
        if (null != itemSearchRespDto || CollectionUtils.isNotEmpty((Collection)itemSearchRespDto.getPageInfo().getList())) {
            for (ItemRespDto itemRespDto : itemSearchRespDto.getPageInfo().getList()) {
                if (!CollectionUtils.isNotEmpty((Collection)itemRespDto.getItemShelfInfoList())) continue;
                itemShelfRespDtos.addAll(itemRespDto.getItemShelfInfoList());
            }
            logger.info("\u7ec4\u5408\u5957\u88c5\u5546\u54c1\u5df2\u4e0a\u67b6\u4fe1\u606f\uff0c{}", (Object)JSONObject.toJSONString(itemShelfRespDtos));
            if (CollectionUtils.isNotEmpty(itemShelfRespDtos)) {
                shelfItemMap = itemShelfRespDtos.stream().filter(e -> e.getStatus() == 1).collect(Collectors.toMap(e -> e.getShopId() + "-" + e.getItemId(), e -> e, (o1, o2) -> o1));
            }
        }
        return shelfItemMap;
    }

    private void setCombinedPackageItem(List<TrolleyItemRepDto> trolleyItemRepDtos, ShoppingCartRespDto shoppingCartRespDto) {
        ArrayList itemList;
        logger.info("\u7ec4\u5408\u5957\u88c5");
        ActivityDto activityDto = new ActivityDto();
        activityDto.setActivityIds(trolleyItemRepDtos.stream().map(e -> Long.valueOf(e.getSkuSerial())).collect(Collectors.toList()));
        List activityRespDtos = (List)this.activityQueryApi.queryActivityList(activityDto).getData();
        if (CollectionUtils.isEmpty((Collection)activityRespDtos)) {
            return;
        }
        Map<Long, ShoppingCartItemRespDto> map = this.combinedPackageInfo(activityRespDtos, trolleyItemRepDtos);
        Map<String, ItemShelfRespDto> shelfItemMap = this.queryItemEsShelf(map);
        ArrayList normalCartItemList = Lists.newArrayList();
        ArrayList loseCartItemList = Lists.newArrayList();
        for (ActivityRespDto activityRespDto : activityRespDtos) {
            ShoppingCartItemRespDto shoppingCartItemRespDto = map.get(activityRespDto.getId());
            if (ActivityStatusEnum.ACTIVATE.getKey().equals(activityRespDto.getActivityStatus()) && shoppingCartItemRespDto.getStorage() > 0L) {
                boolean isVaild = true;
                for (ShoppingCartItemRespDto cartItemRespDto : shoppingCartItemRespDto.getCombinedPackageItemList()) {
                    if (!shelfItemMap.containsKey(cartItemRespDto.getShopId() + "-" + cartItemRespDto.getItemId())) {
                        isVaild = false;
                        continue;
                    }
                    if (null != cartItemRespDto.getSellPrice()) continue;
                    isVaild = false;
                }
                if (isVaild) {
                    normalCartItemList.add(shoppingCartItemRespDto);
                    continue;
                }
                loseCartItemList.add(shoppingCartItemRespDto);
                continue;
            }
            loseCartItemList.add(shoppingCartItemRespDto);
        }
        if (CollectionUtils.isNotEmpty((Collection)normalCartItemList)) {
            logger.info("\u6709\u6548\u7ec4\u5408\u5957\u88c5,{}", (Object)normalCartItemList);
            if (CollectionUtils.isNotEmpty((Collection)shoppingCartRespDto.getNormalCartItemList())) {
                shoppingCartRespDto.getNormalCartItemList().addAll(normalCartItemList);
            } else {
                itemList = Lists.newArrayList();
                itemList.addAll(normalCartItemList);
                shoppingCartRespDto.setNormalCartItemList((List)itemList);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)loseCartItemList)) {
            logger.info("\u5931\u6548\u7ec4\u5408\u5957\u88c5,{}", (Object)loseCartItemList);
            if (CollectionUtils.isNotEmpty((Collection)shoppingCartRespDto.getLoseCartItemList())) {
                shoppingCartRespDto.getLoseCartItemList().addAll(loseCartItemList);
            } else {
                itemList = Lists.newArrayList();
                itemList.addAll(loseCartItemList);
                shoppingCartRespDto.setLoseCartItemList((List)itemList);
            }
        }
    }

    public Map<Long, ShoppingCartItemRespDto> combinedPackageInfo(List<ActivityRespDto> activityRespDtos, List<TrolleyItemRepDto> trolleyItemRepDtos) {
        Map<String, TrolleyItemRepDto> trolleyItemMap = trolleyItemRepDtos.stream().collect(Collectors.toMap(e -> e.getSkuSerial(), e -> e, (e1, e2) -> e1));
        HashMap<Long, ShoppingCartItemRespDto> map = new HashMap<Long, ShoppingCartItemRespDto>();
        List activityIds = activityRespDtos.stream().map(e -> e.getId()).collect(Collectors.toList());
        List conditionRespDtos = this.conditionQueryApi.queryConditions(activityIds, 1196944223312880296L);
        HashMap conditionParamsMap = CollectionUtils.isNotEmpty((Collection)conditionRespDtos) ? conditionRespDtos.stream().collect(Collectors.toMap(e -> e.getActivityId(), e -> e.getConditionParams(), (e1, e2) -> e1)) : new HashMap();
        ShoppingCartItemRespDto shoppingCartItemRespDto = null;
        for (ActivityRespDto activityRespDto : activityRespDtos) {
            TrolleyItemRepDto trolleyItemRepDto = trolleyItemMap.get(activityRespDto.getId().toString());
            shoppingCartItemRespDto = new ShoppingCartItemRespDto();
            shoppingCartItemRespDto.setId(trolleyItemRepDto.getId());
            shoppingCartItemRespDto.setItemName(activityRespDto.getActivityName());
            shoppingCartItemRespDto.setActivityName(activityRespDto.getActivityName());
            shoppingCartItemRespDto.setItemNum(trolleyItemRepDto.getItemNum());
            shoppingCartItemRespDto.setShopId(Long.valueOf(trolleyItemRepDto.getGroupKey()));
            shoppingCartItemRespDto.setImgPath(activityRespDto.getActivityLogo());
            shoppingCartItemRespDto.setItemCode(activityRespDto.getRemark());
            shoppingCartItemRespDto.setSellPrice(this.getPackagePrice((String)conditionParamsMap.get(activityRespDto.getId())));
            shoppingCartItemRespDto.setThresholdType(this.getThresholdType((String)conditionParamsMap.get(activityRespDto.getId())));
            shoppingCartItemRespDto.setActivityTag("\u7ec4\u5408\u5957\u88c5");
            shoppingCartItemRespDto.setAddChannel(trolleyItemRepDto.getAddChannel());
            shoppingCartItemRespDto.setIsCombinedPackage(Integer.valueOf(1));
            map.put(activityRespDto.getId(), shoppingCartItemRespDto);
        }
        if (MapUtils.isNotEmpty(map)) {
            this.combinedPackageItemInfo(map);
        }
        return map;
    }

    private void combinedPackageItemInfo(Map<Long, ShoppingCartItemRespDto> map) {
        logger.info("\u7ec4\u88c5\u7ec4\u5408\u5957\u88c5\u5546\u54c1\u4fe1\u606f");
        ArrayList<Long> activityIds = new ArrayList<Long>();
        for (Map.Entry<Long, ShoppingCartItemRespDto> entry : map.entrySet()) {
            activityIds.add(entry.getKey());
        }
        TcbjInventoryActReqDto tcbjInventoryActReqDto = new TcbjInventoryActReqDto();
        tcbjInventoryActReqDto.setActivityIdList(activityIds);
        List tcbjInventoryActRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.tcbjInventoryApi.inventoryActQuery(tcbjInventoryActReqDto));
        HashMap inventoryActMap = CollectionUtils.isNotEmpty((Collection)tcbjInventoryActRespDtos) ? tcbjInventoryActRespDtos.stream().collect(Collectors.toMap(e -> e.getActivityId(), e -> e.getDetailRespDtoList())) : new HashMap();
        List activityRuleItemRespDtoList = (List)this.activityRuleItemQueryApi.queryActivityRuleItemByActivityIds(activityIds).getData();
        if (CollectionUtils.isNotEmpty((Collection)activityRuleItemRespDtoList)) {
            Map<Long, List<ActivityRuleItemRespDto>> itemMap = activityRuleItemRespDtoList.stream().collect(Collectors.groupingBy(e -> e.getActivityId()));
            for (Map.Entry<Long, ShoppingCartItemRespDto> entry : map.entrySet()) {
                ShoppingCartItemRespDto shoppingCartItemRespDto = entry.getValue();
                List<ActivityRuleItemRespDto> activityRuleItemRespDtos = itemMap.get(entry.getKey());
                List tcbjInventoryActDetailRespDtos = null;
                if (inventoryActMap.get(entry.getKey()) != null) {
                    tcbjInventoryActDetailRespDtos = (List)inventoryActMap.get(entry.getKey());
                }
                Long stock = 0L;
                this.activityRuleItemInfo(activityRuleItemRespDtos);
                ArrayList combinedPackageItemList = Lists.newArrayList();
                ShoppingCartItemRespDto combinedPackageItem = null;
                for (ActivityRuleItemRespDto dto : activityRuleItemRespDtos) {
                    BigDecimal activitySurplus;
                    combinedPackageItem = new ShoppingCartItemRespDto();
                    combinedPackageItem.setItemId(dto.getItemId());
                    combinedPackageItem.setItemName(dto.getItemName());
                    combinedPackageItem.setItemCode(dto.getItemCode());
                    combinedPackageItem.setItemNum(Integer.valueOf(Math.toIntExact(dto.getNum())));
                    combinedPackageItem.setSkuId(dto.getSkuId());
                    combinedPackageItem.setSkuCode(dto.getSkuCode());
                    combinedPackageItem.setCargoCode(dto.getSkuCode());
                    combinedPackageItem.setShopId(dto.getShopId());
                    combinedPackageItem.setActivityId(dto.getActivityId());
                    combinedPackageItem.setImgPath(dto.getImgPath());
                    combinedPackageItem.setStorage(null);
                    combinedPackageItem.setSellPrice(dto.getSellPrice());
                    combinedPackageItem.setPackageUnitPrice(dto.getPrice());
                    combinedPackageItem.setAddChannel(shoppingCartItemRespDto.getAddChannel());
                    combinedPackageItem.setStatus(Integer.valueOf(1));
                    combinedPackageItem.setBusType(Integer.valueOf(0));
                    combinedPackageItem.setSubType(dto.getSubType());
                    combinedPackageItem.setIsCombinedPackage(Integer.valueOf(1));
                    combinedPackageItem.setId(shoppingCartItemRespDto.getId());
                    combinedPackageItem.setAttrs((Map)JSON.parseObject((String)dto.getAttr()));
                    combinedPackageItemList.add(combinedPackageItem);
                    if (!CollectionUtils.isNotEmpty((Collection)tcbjInventoryActDetailRespDtos) || (activitySurplus = tcbjInventoryActDetailRespDtos.stream().filter(e -> e.getCargoCode().equals(dto.getSkuCode())).map(e -> e.getActivitySurplus()).reduce(BigDecimal.ZERO, BigDecimal::add)).intValue() <= 0) continue;
                    stock = activitySurplus.divide(new BigDecimal(dto.getNum())).longValue();
                }
                shoppingCartItemRespDto.setStorage(stock);
                shoppingCartItemRespDto.setAttrs(this.setCombinedPackageAttrs(activityRuleItemRespDtos));
                shoppingCartItemRespDto.setShopName(activityRuleItemRespDtos.get(0).getShopName());
                shoppingCartItemRespDto.setCombinedPackageItemList((List)combinedPackageItemList);
            }
        }
        logger.info("\u6700\u7ec8\u7ec4\u88c5\u7ec4\u5408\u5957\u88c5\u5546\u54c1\u4fe1\u606f\uff0c{}", map);
    }

    private void activityRuleItemInfo(List<ActivityRuleItemRespDto> list) {
        List itemIds = list.stream().map(e -> e.getItemId()).collect(Collectors.toList());
        HashSet<Long> shopIds = new HashSet<Long>();
        shopIds.add(list.get(0).getShopId());
        List shopDtos = (List)RestResponseHelper.extractData((RestResponse)this.shopQueryApi.queryByIds(shopIds));
        ArrayList merchantIds = Lists.newArrayList();
        for (ShopDto shopDto : shopDtos) {
            merchantIds.add(shopDto.getOrganizationId());
        }
        List customerRespDtos = Lists.newArrayList();
        String customerId = ServiceContext.getContext().getAttachment("yes.req.cus.b2b.customerid");
        if (StringUtils.isNumeric((CharSequence)customerId)) {
            logger.info("\u4e1a\u52a1\u5458\u7aef\uff1a{}", (Object)customerId);
            customerRespDtos.add(RestResponseHelper.extractData((RestResponse)this.customerQueryApi.queryById(Long.valueOf(customerId))));
        } else {
            logger.info("h5\u7aef");
            String orgId = ServiceContext.getContext().getAttachment("yes.req.cus.b2b.organizationid");
            logger.info("yes.req.cus.b2b.organizationid,{}", (Object)orgId);
            customerRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryListByOrgIdAndMerchantIds((List)merchantIds, Long.valueOf(orgId)));
        }
        SellerSkuPriceReqDto sellerSkuPriceReqDto = new SellerSkuPriceReqDto();
        sellerSkuPriceReqDto.setItemIdList(itemIds);
        sellerSkuPriceReqDto.setShopId(list.get(0).getShopId());
        sellerSkuPriceReqDto.setCustomerId(((CustomerRespDto)customerRespDtos.get(0)).getId());
        List sellerSkuPriceRespDtos = (List)this.sellerSkuPriceQueryApi.queryList(sellerSkuPriceReqDto).getData();
        HashMap priceMap = CollectionUtils.isNotEmpty((Collection)sellerSkuPriceRespDtos) ? sellerSkuPriceRespDtos.stream().collect(Collectors.toMap(e -> e.getItemId(), e -> e.getSupplyPrice(), (o1, o2) -> o1)) : new HashMap();
        Map itemMediasMap = (Map)this.itemQueryApi.queryItemMediasByItemIds(itemIds).getData();
        for (ActivityRuleItemRespDto dto : list) {
            dto.setSellPrice((BigDecimal)priceMap.get(dto.getItemId()));
            dto.setImgPath((String)itemMediasMap.get(dto.getItemId()));
        }
    }

    private Map<String, Object> setCombinedPackageAttrs(List<ActivityRuleItemRespDto> dtoList) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        int num = 0;
        for (ActivityRuleItemRespDto dto : dtoList) {
            num = (int)((long)num + dto.getNum());
        }
        map.put(dtoList.size() + "\u79cd," + num + "\u4ef6", "\u5957");
        return map;
    }

    public ShoppingCartRespDto buildTags(ShoppingCartRespDto result, Long customerId) {
        if (result == null || CollectionUtils.isEmpty((Collection)result.getNormalCartItemList())) {
            return result;
        }
        List collectItemInfoRespDto = result.getNormalCartItemList().stream().map(data -> {
            ItemInfoRespDto newData = new ItemInfoRespDto();
            BeanUtil.copyProperties((Object)data, (Object)newData, (String[])new String[0]);
            return newData;
        }).collect(Collectors.toList());
        List itemTags = this.bitemService.getItemTags(collectItemInfoRespDto, customerId);
        Map itemTagGroup = itemTags.stream().collect(Collectors.groupingBy(itemInfoRespDto -> itemInfoRespDto.getItemId() + "-" + itemInfoRespDto.getShopId(), Collectors.toList()));
        Iterator iterator = result.getNormalCartItemList().iterator();
        while (iterator.hasNext()) {
            ShoppingCartItemRespDto shoppingCartItemRespDto;
            List itemInfoRespDtos = itemTagGroup.get((shoppingCartItemRespDto = (ShoppingCartItemRespDto)iterator.next()).getItemId() + "-" + shoppingCartItemRespDto.getShopId());
            shoppingCartItemRespDto.setTags(!CollectionUtils.isEmpty(itemInfoRespDtos) ? ((ItemInfoRespDto)itemInfoRespDtos.get(0)).getTags() : null);
        }
        return result;
    }

    public void setItemPolicyPrice(List<ShoppingCartItemRespDto> normalCartItemList, Long customerId) {
        if (CollectionUtils.isEmpty(normalCartItemList)) {
            return;
        }
        List customerIdList = Objects.isNull(customerId) ? this.bitemService.getCustomerIdListByUserId(this.context.userId()) : Lists.newArrayList((Object[])new Long[]{customerId});
        try {
            CommunalPriceQueryReqDto reqDto = new CommunalPriceQueryReqDto();
            reqDto.setCustomerIds(customerIdList);
            reqDto.setPolicyDate(new Date());
            ArrayList skuPriceReqDtoList = new ArrayList();
            normalCartItemList.forEach(cartItemInfo -> {
                CommunalPriceQueryReqDto.ItemSkuPriceReqDto skuPriceReqDto = new CommunalPriceQueryReqDto.ItemSkuPriceReqDto();
                skuPriceReqDto.setSkuId(cartItemInfo.getSkuId());
                skuPriceReqDto.setItemId(cartItemInfo.getItemId());
                skuPriceReqDto.setShopId(cartItemInfo.getShopId());
                skuPriceReqDto.setSkuSellPrice(cartItemInfo.getSellPrice());
                skuPriceReqDtoList.add(skuPriceReqDto);
            });
            reqDto.setSkuList(skuPriceReqDtoList);
            List itemSkuPolicyPriceRespDtos = (List)this.ibItemPriceService.getItemPrice(reqDto).getData();
            if (!CollectionUtils.isEmpty((Collection)itemSkuPolicyPriceRespDtos)) {
                normalCartItemList.forEach(cartItemInfo -> {
                    ItemPolicyPriceRespDto skuPolicyPrice = itemSkuPolicyPriceRespDtos.stream().filter(e -> Objects.equals(cartItemInfo.getShopId(), e.getShopId()) && e.getSkuId().equals(cartItemInfo.getSkuId())).findFirst().orElse(null);
                    cartItemInfo.setItemSkuPolicyPrice(skuPolicyPrice);
                    if (Objects.nonNull(skuPolicyPrice)) {
                        cartItemInfo.setSellPrice(skuPolicyPrice.getPrice());
                    }
                });
            }
        }
        catch (Exception e) {
            logger.error("\u5ba2\u6237{}\u67e5\u8be2\u4ef7\u683c\u4e2d\u5fc3\u653f\u7b56\u4ef7\u5f02\u5e38\uff1a{}", (Object)customerId, (Object)e.getMessage());
        }
    }

    public void setCartItemList(List<ShoppingCartItemRespDto> cartItems, ShoppingCartRespDto shoppingCartRespDto) {
        ArrayList normalCartItemList = Lists.newArrayList();
        ArrayList loseCartItemList = Lists.newArrayList();
        for (ShoppingCartItemRespDto cartItem : cartItems) {
            if (cartItem.getStatus() == null || cartItem.getStatus() == 0) {
                cartItem.setLoseType(Integer.valueOf(1));
                loseCartItemList.add(cartItem);
                continue;
            }
            if (cartItem.getStorage() == null || cartItem.getStorage() <= 0L) {
                cartItem.setLoseType(Integer.valueOf(2));
                loseCartItemList.add(cartItem);
                continue;
            }
            normalCartItemList.add(cartItem);
        }
        shoppingCartRespDto.setNormalCartItemList((List)normalCartItemList);
        shoppingCartRespDto.setLoseCartItemList((List)loseCartItemList);
    }

    public ItemSearchRespDto queryItemESByItemIdsAndShopIds(Set<Long> itemIdList, Set<Long> shopIdList) {
        ItemSearchQueryReqDto itemSearchQueryReqDto = new ItemSearchQueryReqDto();
        itemSearchQueryReqDto.setInstanceId(this.context.instanceId());
        itemSearchQueryReqDto.setTenantId(this.context.tenantId());
        itemSearchQueryReqDto.setBusType(ItemBusTypeEnum.ORDINARY.getType());
        itemSearchQueryReqDto.setItemIds((List)Lists.newArrayList(itemIdList));
        itemSearchQueryReqDto.setShopIds((List)Lists.newArrayList(shopIdList));
        itemSearchQueryReqDto.setIsOffShelf(Boolean.valueOf(false));
        ItemSearchRespDto itemSearchRespDto = (ItemSearchRespDto)RestResponseHelper.extractData((RestResponse)this.itemQueryApi.queryItemByDirIdDepth(itemSearchQueryReqDto, Integer.valueOf(1), Integer.valueOf(itemIdList.size() * shopIdList.size())));
        return itemSearchRespDto;
    }

    private void setItemActivityPrice(List<ShoppingCartItemRespDto> cartItems) {
        if (CollectionUtils.isEmpty(cartItems)) {
            return;
        }
        Set shopIds = cartItems.stream().map(ShoppingCartItemRespDto::getShopId).collect(Collectors.toSet());
        HashMap<Long, Object> customerIdMap = new HashMap<Long, Object>();
        for (Long shopId : shopIds) {
            Long customerId = this.bshopService.queryCustomerIdByShopId(shopId);
            customerIdMap.put(shopId, customerId);
        }
        ArrayList skuActivityPriceDtos = Lists.newArrayList();
        for (ShoppingCartItemRespDto cartItem : cartItems) {
            ItemSkuActivityPriceDto skuActivityPriceDto = new ItemSkuActivityPriceDto();
            skuActivityPriceDto.setItemId(cartItem.getItemId());
            skuActivityPriceDto.setSkuId(cartItem.getSkuId());
            skuActivityPriceDto.setShopId(cartItem.getShopId());
            skuActivityPriceDto.setCustomerId((Long)customerIdMap.get(cartItem.getShopId()));
            skuActivityPriceDto.setSellPrice(cartItem.getSellPrice());
            skuActivityPriceDtos.add(skuActivityPriceDto);
        }
        ActivityPriceBranchQueryReqDto branchQueryReqDto = new ActivityPriceBranchQueryReqDto();
        branchQueryReqDto.setItemSkuActivityPriceList((List)skuActivityPriceDtos);
        branchQueryReqDto.setFilterSecKill(Boolean.valueOf(true));
        branchQueryReqDto.setFilterNotBegin(Boolean.valueOf(true));
        List itemSkuActivityPriceDtos = (List)RestResponseHelper.extractData((RestResponse)this.itemActivityStockApi.queryBranchItemSkuActivityPrice(branchQueryReqDto));
        Map<String, List<ItemSkuActivityPriceDto>> priceMaps = itemSkuActivityPriceDtos.stream().collect(Collectors.groupingBy(priceDto -> priceDto.getShopId() + priceDto.getSkuId().toString()));
        for (ShoppingCartItemRespDto cartItemRespDto : cartItems) {
            ItemSkuActivityPriceDto priceDto2;
            String key = cartItemRespDto.getShopId() + cartItemRespDto.getSkuId().toString();
            if (!priceMaps.containsKey(key) || Objects.isNull((priceDto2 = priceMaps.get(key).get(0)).getActivityId())) continue;
            ActivitySimpleInfoDto simpleInfoDto = new ActivitySimpleInfoDto();
            simpleInfoDto.setActivityId(priceDto2.getActivityId());
            simpleInfoDto.setActivityTag(priceDto2.getActivityTag());
            simpleInfoDto.setActivityTemplateId(priceDto2.getActivityTemplateId());
            ActivityType type = ActivityType.getByType((Long)simpleInfoDto.getActivityTemplateId());
            ItemActivityPriceRespDto priceRespDto = new ItemActivityPriceRespDto();
            priceRespDto.setActivityId(simpleInfoDto.getActivityId());
            priceRespDto.setActivityName(simpleInfoDto.getActivityTag());
            priceRespDto.setActivityType(type);
            priceRespDto.setSkuId(priceDto2.getSkuId());
            priceRespDto.setItemId(priceDto2.getItemId());
            priceRespDto.setActivityPrice(priceDto2.getActivityPrice());
            priceRespDto.setShopId(priceDto2.getShopId());
            priceRespDto.setPromotionMethod(priceDto2.getPromotionMethod());
            priceRespDto.setDiscount(priceDto2.getDiscount());
            cartItemRespDto.setActivityPrice(priceRespDto);
        }
    }

    private Map<Long, List<ItemActivityTagDto>> queryTags(List<Long> itemIds) {
        Map<Object, Object> itemTagsMap = Maps.newHashMap();
        ItemActivityTagQueryReqDto queryReqDto = new ItemActivityTagQueryReqDto();
        queryReqDto.setDimensionList((List)Lists.newArrayList((Object[])new Integer[]{ActivityDimensionEnum.ITEM.getKey()}));
        queryReqDto.setInstanceId(this.context.instanceId());
        queryReqDto.setTenantId(this.context.tenantId());
        queryReqDto.setItemIdList(itemIds);
        queryReqDto.setPreheatStartTime(new Date());
        List tags = (List)this.itemActivityTagQueryApi.queryList(queryReqDto).getData();
        if (CollectionUtils.isEmpty((Collection)tags)) {
            return itemTagsMap;
        }
        itemTagsMap = tags.stream().collect(Collectors.groupingBy(ItemActivityTagDto::getItemId));
        return itemTagsMap;
    }

    private ItemActivityPriceRespDto getItemActivityPriceRespDto(Long skuId, ItemActivityTagDto tagDto) {
        ActivityItemQueryReqDto itemQueryReqDto = new ActivityItemQueryReqDto();
        Long activityId = tagDto.getActivityId();
        itemQueryReqDto.setActivityId(activityId);
        itemQueryReqDto.setSkuId(skuId);
        List activityItems = (List)this.activityItemQueryApi.queryAll(itemQueryReqDto).getData();
        if (CollectionUtils.isEmpty((Collection)activityItems)) {
            return null;
        }
        try {
            ActivityRespDto activityRespDto = (ActivityRespDto)this.activityQueryApi.queryActivityDetail(activityId.longValue()).getData();
            if (activityRespDto.getActivityTemplateId().equals(ActivityType.GROUP_ACTIVITY.getId())) {
                return null;
            }
            ActivityItemRespDto activityItemRespDto = (ActivityItemRespDto)activityItems.get(0);
            ItemActivityPriceRespDto itemActivityPriceRespDto = new ItemActivityPriceRespDto();
            itemActivityPriceRespDto.setSkuId(skuId);
            itemActivityPriceRespDto.setActivityPrice(activityItemRespDto.getActivityPrice());
            itemActivityPriceRespDto.setActivityType(ActivityType.getByType((Long)activityRespDto.getActivityTemplateId()));
            itemActivityPriceRespDto.setActivityId(activityRespDto.getId());
            return itemActivityPriceRespDto;
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            return null;
        }
    }

    private ShoppingCartItemRespDto convertToShoppingCartItemRespDto(TrolleyItemRepDto trolleyItemRepDto, Map<String, ItemShelfRespDto> itemShelfMap, Map<Long, ItemSkuRespDto> skuMap, Map<String, Long> avaNumMap) {
        ShoppingCartItemExtDto shoppingCartItemExtDto = (ShoppingCartItemExtDto)ObjectHelper.Json2Bean((String)trolleyItemRepDto.getExtension(), ShoppingCartItemExtDto.class);
        Long itemId = Long.valueOf(trolleyItemRepDto.getItemSerial());
        Long skuId = Long.valueOf(trolleyItemRepDto.getSkuSerial());
        Long shopId = Long.valueOf(trolleyItemRepDto.getGroupKey());
        ItemSkuRespDto skuRespDto = skuMap.get(skuId);
        Long storage = avaNumMap.get(shopId + "_" + skuId + "_" + skuRespDto.getCargoCode());
        ShoppingCartItemRespDto shoppingCartItemRespDto = new ShoppingCartItemRespDto();
        shoppingCartItemRespDto.setId(trolleyItemRepDto.getId());
        shoppingCartItemRespDto.setItemId(itemId);
        shoppingCartItemRespDto.setSkuId(skuId);
        shoppingCartItemRespDto.setShopId(shopId);
        shoppingCartItemRespDto.setItemNum(trolleyItemRepDto.getItemNum());
        shoppingCartItemRespDto.setAddChannel(trolleyItemRepDto.getAddChannel());
        shoppingCartItemRespDto.setItemName(trolleyItemRepDto.getItemName());
        shoppingCartItemRespDto.setStorage(storage);
        shoppingCartItemRespDto.setType(trolleyItemRepDto.getType());
        if (Objects.nonNull(skuRespDto)) {
            shoppingCartItemRespDto.setMinPackage(skuRespDto.getMinPackage());
            shoppingCartItemRespDto.setUnit(skuRespDto.getUnit());
            shoppingCartItemRespDto.setSkuCode(skuRespDto.getCode());
            shoppingCartItemRespDto.setCargoCode(skuRespDto.getCargoCode());
        }
        ItemShelfRespDto itemShelfRespDto = itemShelfMap.get(shopId + skuId.toString());
        this.newSetSellePriceAndStatus(shoppingCartItemRespDto, itemShelfRespDto);
        ShopDto shopDto = (ShopDto)this.shopQueryApi.queryById(shopId.longValue(), new String[0]).getData();
        if (null != shopDto) {
            shoppingCartItemRespDto.setShopName(shoppingCartItemExtDto.getShopName());
            shoppingCartItemRespDto.setShopId(shopDto.getId());
        }
        if (null != shoppingCartItemExtDto) {
            Map attrs = (Map)JSONObject.parseObject((String)shoppingCartItemExtDto.getAttrs(), Map.class);
            shoppingCartItemRespDto.setAttrs(attrs);
            shoppingCartItemRespDto.setBusType(shoppingCartItemExtDto.getBusType());
            shoppingCartItemRespDto.setImgPath(shoppingCartItemExtDto.getImgPath());
            if (null == shoppingCartItemRespDto.getSellPrice()) {
                shoppingCartItemRespDto.setSellPrice(shoppingCartItemExtDto.getSellPrice());
            }
        }
        return shoppingCartItemRespDto;
    }

    private void setSellePriceAndStatus(ShoppingCartItemRespDto shoppingCartItemRespDto, Long skuId, Long shopId) {
        ShelfReqDto shelfReqDto = new ShelfReqDto();
        shelfReqDto.setSkuId(skuId);
        shelfReqDto.setShopId(shopId);
        PageInfo pageInfo = (PageInfo)this.itemQueryApi.queryItemShelf(JSON.toJSONString((Object)shelfReqDto), Integer.valueOf(1), Integer.valueOf(1)).getData();
        if (null != pageInfo && CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
            shoppingCartItemRespDto.setSellPrice(((ItemShelfRespDto)pageInfo.getList().get(0)).getPrice());
            if (((ItemShelfRespDto)pageInfo.getList().get(0)).getStatus() == 1) {
                shoppingCartItemRespDto.setStatus(Integer.valueOf(1));
            } else {
                shoppingCartItemRespDto.setStatus(Integer.valueOf(0));
            }
        }
    }

    private void newSetSellePriceAndStatus(ShoppingCartItemRespDto shoppingCartItemRespDto, ItemShelfRespDto itemShelfRespDto) {
        if (Objects.nonNull(itemShelfRespDto)) {
            shoppingCartItemRespDto.setSellPrice(itemShelfRespDto.getPrice());
            shoppingCartItemRespDto.setStatus(Optional.ofNullable(itemShelfRespDto.getStatus()).filter(i -> i == 1).orElse(0));
            shoppingCartItemRespDto.setStockDisplay(itemShelfRespDto.getStockDisplay());
            shoppingCartItemRespDto.setLimitMin(itemShelfRespDto.getLimitMin());
            shoppingCartItemRespDto.setLimitMinMode(itemShelfRespDto.getLimitMinMode());
            shoppingCartItemRespDto.setMultipleStatus(itemShelfRespDto.getMultipleStatus());
        }
    }

    private Integer getStatus(Long shopId, Long skuId, Long itemId) {
        boolean isOnShelf = this.bitemService.isOnshelf(shopId, itemId, skuId);
        if (!isOnShelf) {
            return 0;
        }
        return 1;
    }

    public void setItemOrderActivity(List<ShoppingCartItemRespDto> cartItems) {
        Map<Object, Object> itemTags = Maps.newHashMap();
        List itemIts = cartItems.stream().map(ShoppingCartItemRespDto::getItemId).collect(Collectors.toList());
        List shopIds = cartItems.stream().map(ShoppingCartItemRespDto::getShopId).collect(Collectors.toList());
        ItemActivityTagQueryReqDto queryReqDto = new ItemActivityTagQueryReqDto();
        queryReqDto.setItemIdList(itemIts);
        queryReqDto.setShopIdList(shopIds);
        queryReqDto.setInstanceId(this.context.instanceId());
        queryReqDto.setTenantId(this.context.tenantId());
        queryReqDto.setDimension(ActivityDimensionEnum.ORDER.getKey());
        List tags = (List)RestResponseHelper.extractData((RestResponse)this.itemActivityTagQueryApi.queryList(queryReqDto));
        itemTags = tags.stream().collect(Collectors.groupingBy(tagDto -> tagDto.getShopId().toString() + tagDto.getItemId().toString()));
        for (ShoppingCartItemRespDto cartItem : cartItems) {
            ItemOrderActivityTagDto itemOrderActivityTagDto = new ItemOrderActivityTagDto();
            List tagDtos = (List)itemTags.get(cartItem.getShopId().toString() + cartItem.getItemId().toString());
            if (CollectionUtils.isEmpty((Collection)tagDtos)) continue;
            ItemActivityTagDto itemActivityTagDto = tagDtos.stream().findFirst().orElse(null);
            CubeBeanUtils.copyProperties((Object)itemOrderActivityTagDto, (Object)itemActivityTagDto, (String[])new String[0]);
            ItemActivityInfoRespDto itemActivityInfoRespDto = this.convertToItemActivityInfoRespDto(itemActivityTagDto);
            ActivityType activityType = itemActivityInfoRespDto.getActivityType();
            itemOrderActivityTagDto.setActivityType(activityType.name());
            Integer promotionMethod = itemActivityInfoRespDto.getPromotionMethod();
            if (promotionMethod == null || promotionMethod != 1) continue;
            itemOrderActivityTagDto.setPromotionMethod(itemActivityInfoRespDto.getPromotionMethod());
            cartItem.setItemOrderActivityTagDto(itemOrderActivityTagDto);
        }
    }

    private ItemActivityInfoRespDto convertToItemActivityInfoRespDto(ItemActivityTagDto itemActivityTagDto) {
        ItemActivityInfoRespDto activityInfo = new ItemActivityInfoRespDto();
        try {
            ActivityRespDto activityRespDto = (ActivityRespDto)this.activityQueryApi.queryActivityDetail(itemActivityTagDto.getActivityId().longValue()).getData();
            CubeBeanUtils.copyProperties((Object)activityInfo, (Object)activityRespDto, (String[])new String[0]);
            if (null == activityRespDto.getPreheatStartTime()) {
                activityInfo.setPreheatStartTime(activityRespDto.getBeginTime());
            }
            activityInfo.setDimension(activityRespDto.getActivityTemplate().getDimension());
            activityInfo.setActivityType(ActivityType.getByType((Long)activityRespDto.getActivityTemplateId()));
            activityInfo.setPromotionMethod(activityRespDto.getPromotionMethod());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return activityInfo;
    }

    public ShoppingCartItemExtDto getShoppingCombinedPackage(ActivityRespDto activityRespDto, Long shopId) {
        ShoppingCartItemExtDto shoppingCartItemExtDto = new ShoppingCartItemExtDto();
        Object imgPath = null;
        Object sellPrice = null;
        Object attrs = null;
        String shopName = null;
        ShopDto shopDto = (ShopDto)this.shopQueryApi.queryById(shopId.longValue(), new String[0]).getData();
        if (shopDto != null) {
            shopName = shopDto.getName();
        }
        ArrayList activityIds = Lists.newArrayList();
        activityIds.add(activityRespDto.getId());
        List activityRuleItemRespDtoList = (List)this.activityRuleItemQueryApi.queryActivityRuleItemByActivityIds((List)activityIds).getData();
        List conditionRespDtos = this.conditionQueryApi.queryConditions((List)activityIds, 1196944223312880296L);
        shoppingCartItemExtDto.setImgPath(activityRespDto.getActivityLogo());
        shoppingCartItemExtDto.setAttrs(this.setCombinedPackageAttrs(activityRuleItemRespDtoList).toString());
        shoppingCartItemExtDto.setSellPrice(this.getPackagePrice(((ConditionRespDto)conditionRespDtos.get(0)).getConditionParams()));
        shoppingCartItemExtDto.setShopName(shopName);
        shoppingCartItemExtDto.setBusType(Integer.valueOf(0));
        return shoppingCartItemExtDto;
    }

    public BigDecimal getPackagePrice(String conditionParams) {
        JSONObject jsonObject;
        CombinationRule combinationRule;
        ComRuleContentDto contents;
        BigDecimal totalPrice = null;
        if (conditionParams != null && Objects.nonNull(contents = (combinationRule = (CombinationRule)JSON.parseObject((String)(jsonObject = JSON.parseObject((String)conditionParams)).getString("CombinationCondition.rule"), CombinationRule.class)).getComRuleContent())) {
            totalPrice = contents.getTotalPrice();
        }
        return totalPrice;
    }

    public Integer getThresholdType(String conditionParams) {
        Integer thresholdType = 0;
        if (conditionParams != null) {
            JSONObject jsonObject = JSON.parseObject((String)conditionParams);
            CombinationRule combinationRule = (CombinationRule)JSON.parseObject((String)jsonObject.getString("CombinationCondition.rule"), CombinationRule.class);
            thresholdType = combinationRule.getThresholdType();
        }
        return thresholdType;
    }

    @Async(value="taskExecutor")
    public Future<BatchAddItemVo> asycAddItemBatch(List<ShoppingCartItemReqDto> cartItemList, Long tenantId, Long instanceId, Long userId, String userType, String requestId, Long shopId) {
        BatchAddItemVo vo = new BatchAddItemVo();
        try {
            logger.info("\u5f02\u6b65\u52a0\u8d2d\u7269\u8f66 userId={}, cartItemList={}", (Object)userId, cartItemList);
            ServiceContext.getContext().set("yes.req.tenantId", (Object)tenantId);
            ServiceContext.getContext().set("yes.req.instanceId", (Object)instanceId);
            ServiceContext.getContext().set("yes.req.userId", (Object)userId);
            ServiceContext.getContext().set("yes.req.userType", (Object)userType);
            ServiceContext.getContext().set("yes.req.requestId", (Object)requestId);
            vo = this.addItemBatch(cartItemList, tenantId, instanceId, userId, shopId);
            logger.info("\u5f02\u6b65\u52a0\u8d2d\u7269\u8f66 userId={}, cartItemList={}, BatchAddItemVo={}", new Object[]{userId, cartItemList, vo});
            return new AsyncResult((Object)vo);
        }
        catch (BizException e) {
            if (TradeModuleExcpCode.ITEM_STORAGAE_NOT_ENOUGH.getCode().equals(e.getCode())) {
                logger.error("{}, {}", (Object)TradeModuleExcpCode.ITEM_STORAGAE_NOT_ENOUGH.getMsg(), (Object)e);
            } else {
                logger.error("\u52a0\u8d2d\u7269\u8f66\u6821\u9a8c\u5931\u8d25{}", (Throwable)e);
            }
            vo.setError(true);
            vo.setErrorMsg(TradeModuleExcpCode.VALIDATION_FAIL);
            return new AsyncResult((Object)vo);
        }
    }

    public BatchAddItemVo addItemBatch(List<ShoppingCartItemReqDto> cartItemList, Long tenantId, Long instanceId, Long userId, Long shopId) {
        ShopDto shopDto;
        BatchAddItemVo vo = new BatchAddItemVo();
        vo.setError(false);
        if (Objects.nonNull(cartItemList.get(0).getUserId())) {
            userId = cartItemList.get(0).getUserId();
        }
        List<Long> itemIds = cartItemList.stream().map(s -> s.getItemId()).collect(Collectors.toList());
        List<ItemDetailRespDto> itemDetailList = this.listItemDetail(cartItemList, itemIds);
        boolean isExist = true;
        for (ItemDetailRespDto itemDetailDto : itemDetailList) {
            if (itemIds.contains(itemDetailDto.getItem().getId())) continue;
            isExist = false;
        }
        if (CollectionUtils.isEmpty(itemDetailList) || !isExist) {
            vo.setError(true);
            vo.setErrorMsg(TradeModuleExcpCode.ITEM_NOT_EXIST);
            return vo;
        }
        TrolleyRepDto trolley = this.getUserShoppingCart(userId, cartItemList.get(0).getSubstationId());
        if (null == trolley) {
            vo.setError(true);
            vo.setErrorMsg(TradeModuleExcpCode.SHOPPING_CART_NOT_EXIST);
        }
        if (null == (shopDto = (ShopDto)this.shopQueryApi.queryById(shopId.longValue(), new String[0]).getData())) {
            vo.setError(true);
            vo.setErrorMsg(TradeModuleExcpCode.SHOP_NOT_EXIST);
        }
        List<TrolleyItemReqDto> trolleyItemList = this.listTrolleyItem(cartItemList, itemDetailList, trolley.getId(), tenantId, instanceId, userId, shopDto);
        vo.setTrolleyItemList(trolleyItemList);
        return vo;
    }

    private List<ItemDetailRespDto> listItemDetail(List<ShoppingCartItemReqDto> cartItemList, List<Long> itemIds) {
        ItemDetailReqDto itemDetail = new ItemDetailReqDto();
        itemDetail.setItemIds(itemIds);
        itemDetail.setFields(Arrays.asList("sku", "medias"));
        return (List)this.itemQueryApi.listItemDetail(itemDetail).getData();
    }

    private List<TrolleyItemReqDto> listTrolleyItem(List<ShoppingCartItemReqDto> cartItemList, List<ItemDetailRespDto> itemDetailList, Long trolleyId, Long tenantId, Long instanceId, Long userId, ShopDto shopDto) {
        TrolleyItemReqDto trolleyItemReqDto = null;
        ArrayList list = Lists.newArrayList();
        for (ShoppingCartItemReqDto shoppingCartItemReqDto : cartItemList) {
            trolleyItemReqDto = new TrolleyItemReqDto();
            trolleyItemReqDto.setTenantId(tenantId);
            trolleyItemReqDto.setInstanceId(instanceId);
            trolleyItemReqDto.setItemNum(shoppingCartItemReqDto.getItemNum());
            trolleyItemReqDto.setItemName(shoppingCartItemReqDto.getItemName());
            trolleyItemReqDto.setTrolleyId(trolleyId);
            trolleyItemReqDto.setItemSrc("icommerceb");
            trolleyItemReqDto.setGroupKey(shopDto.getId().toString());
            trolleyItemReqDto.setItemSerial(String.valueOf(shoppingCartItemReqDto.getItemId()));
            trolleyItemReqDto.setSkuSerial(String.valueOf(shoppingCartItemReqDto.getSkuId()));
            trolleyItemReqDto.setAddChannel(shoppingCartItemReqDto.getAddChannel());
            trolleyItemReqDto.setType(shopDto.getType() == null ? null : Integer.valueOf(shopDto.getType().intValue()));
            trolleyItemReqDto.setExtension(this.getShoppingAttr(itemDetailList, shoppingCartItemReqDto, shopDto.getName()));
            list.add(trolleyItemReqDto);
        }
        return list;
    }

    private String getShoppingAttr(List<ItemDetailRespDto> itemDetailList, ShoppingCartItemReqDto shoppingCartItemReqDto, String shopName) {
        for (ItemDetailRespDto itemDetailRespDto : itemDetailList) {
            if (!Objects.equals(itemDetailRespDto.getItem().getId(), shoppingCartItemReqDto.getItemId())) continue;
            ShoppingCartItemExtDto extension = this.getShoppingCartItemExtDto(itemDetailRespDto, shoppingCartItemReqDto, shopName);
            return ObjectHelper.bean2Json((Object)extension);
        }
        return null;
    }

    private Boolean batchValidateStorage(List<ShoppingCartItemReqDto> cartItemList) {
        logger.info("\u6279\u91cf\u9a8c\u8bc1\u5e93\u5b58 cartItemList: {}", cartItemList);
        List skuIds = cartItemList.stream().map(s -> s.getSkuId()).collect(Collectors.toList());
        List itemSkuRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.itemSkuQueryApi.queryBySkuId(skuIds));
        List<ItemStorageQueryDto> itemStorageList = this.listItemStorage(cartItemList, itemSkuRespDtos);
        for (ShoppingCartItemReqDto shoppingCartItem : cartItemList) {
            Integer itemNum = shoppingCartItem.getItemNum();
            for (ItemStorageQueryDto itemStorage : itemStorageList) {
                Long storage;
                if (!Objects.equals(shoppingCartItem.getSkuId(), itemStorage.getSkuId()) || (storage = itemStorage.getAvaNum()) >= (long)itemNum.intValue()) continue;
                return false;
            }
        }
        return true;
    }

    private List<ItemStorageQueryDto> listItemStorage(List<ShoppingCartItemReqDto> cartItemList, List<ItemSkuRespDto> itemSkuRespDtos) {
        logger.info("\u67e5\u8be2\u5e93\u5b58 cartItemList: {}, itemSkuRespDtos: {}", cartItemList, itemSkuRespDtos);
        StorageBranchQueryReqDto storageBranchQueryReqDto = new StorageBranchQueryReqDto();
        ArrayList itemStorageList = Lists.newArrayList();
        for (ShoppingCartItemReqDto shoppingCartItem : cartItemList) {
            Long shopId = shoppingCartItem.getShopId();
            Long skuId = shoppingCartItem.getSkuId();
            ItemStorageQueryDto itemStorageQueryDto = new ItemStorageQueryDto();
            itemStorageQueryDto.setSkuId(skuId);
            itemStorageQueryDto.setShopId(shopId);
            for (ItemSkuRespDto itemSku : itemSkuRespDtos) {
                if (!Objects.equals(itemSku.getId(), skuId)) continue;
                itemStorageQueryDto.setCargoCode(itemSkuRespDtos.get(0).getCargoCode());
            }
            itemStorageList.add(itemStorageQueryDto);
        }
        storageBranchQueryReqDto.setItemStorageList((List)itemStorageList);
        return this.bitemService.queryBranchItemStorage(storageBranchQueryReqDto);
    }
}

