/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.trade.biz.impl;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.BeanCopierUtils;
import com.dtyunxi.icommerce.utils.BizExceptionHelper;
import com.dtyunxi.icommerce.utils.IExceptionCode;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.response.CompanySimpleInfoDto;
import com.dtyunxi.tcbj.api.query.IUserExtV2QueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.CargoStorageDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.WarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.ITcbjInventoryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.query.IWarehouseQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.UnitRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IUnitQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.SellerQueryReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.ISellerQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.IAfterSalesApi;
import com.dtyunxi.yundt.cube.center.trade.api.IAfterSalesTobApi;
import com.dtyunxi.yundt.cube.center.trade.api.constants.DeliveryCancelTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.OptTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.RefundStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.ReturnStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.tob.OptBizTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.AfterSalesItemReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.CancelReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.ReturnQueryReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.ReturnReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.TradeItemReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob.OptLogReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob.ReturnModTobReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.ApplyReturnItemRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.AuditRecordRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.DeliveryItemRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderDeliveryRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.RefundRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.ReturnDetailRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.ReturnOmniItemRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.ReturnRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.tob.ApplyReturnItemBatchRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.tob.ReturnCountTobRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.query.IAfterSalesQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.query.IAfterSalesQueryTobApi;
import com.dtyunxi.yundt.cube.center.trade.api.query.IOrderDeliveryQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.query.IOrderQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.query.IRefundQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.tob.IOptLogApi;
import com.dtyunxi.yundt.cube.center.trade.api.tob.query.IAttachementQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryApi;
import com.dtyunxi.yundt.module.bitem.api.IBitemService;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.trade.api.IOrderAfterSales;
import com.dtyunxi.yundt.module.trade.api.IOrderService;
import com.dtyunxi.yundt.module.trade.api.constant.TradeConstant;
import com.dtyunxi.yundt.module.trade.api.dto.AfterSalesItemAppDto;
import com.dtyunxi.yundt.module.trade.api.dto.AfterSalesItemsDto;
import com.dtyunxi.yundt.module.trade.api.dto.CustomAddressDto;
import com.dtyunxi.yundt.module.trade.api.dto.OrderItemExtDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.order.AfterSalesUpdateReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.order.CancelAfterSalesReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.order.ReturnLogisticsAddReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.order.ReturnOrderItemSaveReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.order.ReturnOrderPageSearchReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.order.ReturnOrderSaveReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.order.AfterSalesDetailRespDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.order.AfterSalesItemBeanRespDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.order.AfterSalesQueryReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.order.AfterSalesRespDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.order.OrderReceiveDetailRespDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.order.ReFundOrderDetailRespDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.order.ReturnOrderRespDto;
import com.dtyunxi.yundt.module.trade.api.enums.OrderReturnBizTypeEnum;
import com.dtyunxi.yundt.module.trade.api.enums.PlaceTypeEnum;
import com.dtyunxi.yundt.module.trade.api.enums.RefundOrderStatusToBEnum;
import com.dtyunxi.yundt.module.trade.api.enums.ReturnStatusToBEnum;
import com.dtyunxi.yundt.module.trade.api.enums.ReturnWayEnum;
import com.dtyunxi.yundt.module.trade.api.enums.TradeModuleExcpCode;
import com.dtyunxi.yundt.module.trade.biz.ICommonService;
import com.dtyunxi.yundt.module.trade.biz.util.ReturnOrderUtil;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrderAfterSalesImpl
implements IOrderAfterSales {
    private static Logger logger = LoggerFactory.getLogger(OrderAfterSalesImpl.class);
    @Resource
    private IContext context;
    @Resource
    private IOrderQueryApi iOrderQueryApi;
    @Autowired
    private IAfterSalesQueryApi afterSalesQueryApi;
    @Resource
    private IWarehouseQueryApi warehouseQueryApi;
    @Resource
    private IOrderService orderService;
    @Resource
    private IUnitQueryApi unitQueryApi;
    @Resource
    private IAttachementQueryApi attachementQueryApi;
    @Resource
    private IAfterSalesApi afterSalesApi;
    @Resource
    private IOrderDeliveryQueryApi orderDeliveryQueryApi;
    @Resource
    private IRefundQueryApi refundQueryApi;
    @Resource
    private ICustomerQueryApi customerQueryApi;
    @Resource
    private IAfterSalesTobApi afterSalesTobApi;
    @Resource
    private IAfterSalesQueryTobApi afterSalesQueryTobApi;
    @Resource
    private ICommonService commonService;
    @Resource
    private IShopQueryApi shopQueryApi;
    @Resource
    private ISellerQueryApi sellerQueryApi;
    @Resource
    private IBitemService bitemService;
    @Resource
    private IOptLogApi optLogApi;
    @Autowired
    private ITcbjInventoryApi tcbjInventoryApi;
    @Resource
    private IOrganizationQueryApi organizationQueryApi;
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;
    @Resource
    private IUserExtV2QueryApi userExtV2QueryApi;

    public PageInfo<AfterSalesRespDto> pageQuery(AfterSalesQueryReqDto afterSalesQueryReqDto, Integer pageNum, Integer pageSize) {
        if (null == afterSalesQueryReqDto || StringUtils.isBlank((CharSequence)afterSalesQueryReqDto.getSearchType())) {
            BizExceptionHelper.throwBizException((IExceptionCode)TradeModuleExcpCode.INVALID_PARAM);
        }
        RestResponse restResponse = null;
        afterSalesQueryReqDto.setTenantId(this.context.tenantId());
        afterSalesQueryReqDto.setInstanceId(this.context.instanceId());
        if ("H5".equals(afterSalesQueryReqDto.getSearchType())) {
            afterSalesQueryReqDto.setUserId(String.valueOf(this.context.userId()));
            restResponse = this.afterSalesQueryApi.queryReturnByPage(JSON.toJSONString((Object)afterSalesQueryReqDto), pageNum, pageSize);
        } else if ("admin".equals(afterSalesQueryReqDto.getSearchType())) {
            afterSalesQueryReqDto.setSellerId(null);
            afterSalesQueryReqDto.setTenantId(this.context.tenantId());
            afterSalesQueryReqDto.setInstanceId(this.context.instanceId());
            try {
                SimpleDateFormat formatter;
                if (StringUtils.isNotEmpty((CharSequence)afterSalesQueryReqDto.getReturnTimeEndStr())) {
                    formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSX");
                    afterSalesQueryReqDto.setReturnTimeEnd(formatter.parse(afterSalesQueryReqDto.getReturnTimeEndStr()));
                }
                if (StringUtils.isNotEmpty((CharSequence)afterSalesQueryReqDto.getReturnTimeStartStr())) {
                    formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSX");
                    afterSalesQueryReqDto.setReturnTimeStart(formatter.parse(afterSalesQueryReqDto.getReturnTimeStartStr()));
                }
            }
            catch (ParseException e) {
                BizExceptionHelper.throwBizException((IExceptionCode)TradeModuleExcpCode.INVALID_PARAM, (Throwable)e);
            }
            logger.debug("\u63a5\u53e3\u8c03\u7528\u53c2\u6570" + JSON.toJSONString((Object)afterSalesQueryReqDto));
            restResponse = this.afterSalesQueryApi.queryReturnByPage(JSON.toJSONString((Object)afterSalesQueryReqDto), pageNum, pageSize);
        } else {
            BizExceptionHelper.throwBizException((IExceptionCode)TradeModuleExcpCode.INVALID_PARAM);
        }
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData(restResponse);
        return this.convertAfterSalesRespDtoPageInfo(pageNum, pageSize, (PageInfo<ReturnRespDto>)pageInfo);
    }

    public List<AfterSalesItemAppDto> getWaitServiceList(String deliveryNo, Integer refundType, Long customerId) {
        List<String> customerIds = Lists.newArrayList();
        if (PlaceTypeEnum.SALESMAN.getCode().equals(refundType)) {
            customerIds = this.orderService.getCustomerIdsBySalesmanId(this.context.userId());
        } else if (PlaceTypeEnum.CUSTOMER.getCode().equals(refundType)) {
            Long tempCustomerId = this.orderService.getCustomerIdByUserId(this.context.userId());
            if (Objects.nonNull(tempCustomerId)) {
                customerIds.add(tempCustomerId.toString());
                customerId = tempCustomerId;
            }
        } else if (Objects.nonNull(customerId)) {
            customerIds.add(customerId.toString());
        }
        if (Objects.isNull(customerId) || CollectionUtils.isEmpty(customerIds)) {
            return new ArrayList<AfterSalesItemAppDto>();
        }
        ArrayList list = Lists.newArrayList();
        RestResponse deliveryItemRestResp = this.orderDeliveryQueryApi.queryDeliveryItemForCanService(deliveryNo, customerId.toString());
        List deliveryItemRespDtos = (List)RestResponseHelper.extractData((RestResponse)deliveryItemRestResp);
        if (CollectionUtils.isNotEmpty((Collection)deliveryItemRespDtos)) {
            HashSet<Long> unitIds = new HashSet<Long>(deliveryItemRespDtos.size());
            for (DeliveryItemRespDto deliveryItemRespDto : deliveryItemRespDtos) {
                AfterSalesItemAppDto itemAppDto = new AfterSalesItemAppDto();
                BeanUtils.copyProperties((Object)deliveryItemRespDto, (Object)itemAppDto);
                itemAppDto.setPath(deliveryItemRespDto.getItemImgPath());
                if (StringUtils.isNotEmpty((CharSequence)deliveryItemRespDto.getSkuSerial())) {
                    itemAppDto.setSkuId(Long.valueOf(deliveryItemRespDto.getSkuSerial()));
                }
                itemAppDto.setSkuName(deliveryItemRespDto.getSkuDesc());
                itemAppDto.setPayAmount(deliveryItemRespDto.getItemPrice().multiply(new BigDecimal(itemAppDto.getCanReturnedNum())));
                itemAppDto.setSubTotalReturnAmount(deliveryItemRespDto.getItemPrice().multiply(new BigDecimal(itemAppDto.getCanReturnedNum())));
                itemAppDto.setTradeItemNo(deliveryItemRespDto.getTrOrderItemNo());
                itemAppDto.setItemId(StringUtils.isNotEmpty((CharSequence)deliveryItemRespDto.getItemSerial()) ? Long.valueOf(deliveryItemRespDto.getItemSerial()) : null);
                itemAppDto.setGift(deliveryItemRespDto.getGift());
                if (StringUtils.isNotEmpty((CharSequence)itemAppDto.getUnit())) {
                    try {
                        Long unitId = Long.parseLong(itemAppDto.getUnit());
                        unitIds.add(unitId);
                    }
                    catch (NumberFormatException e) {
                        logger.info("\u67e5\u8be2\u5f85\u552e\u540e\u6e05\u5355\u5217\u8868\u8fd4\u56de\u5355\u4f4d\u8f6c\u6362\u51fa\u9519>>>{}", (Object)(itemAppDto.getUnit() + itemAppDto.getSkuId()));
                    }
                }
                list.add(itemAppDto);
            }
            if (CollectionUtils.isNotEmpty(unitIds)) {
                List unitRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.unitQueryApi.queryByIds(StringUtils.join(unitIds, (String)",")));
                Map<String, String> unitNameMap = unitRespDtos.stream().collect(Collectors.toMap(unitResp -> unitResp.getId().toString(), UnitRespDto::getName, (e1, e2) -> e1));
                for (AfterSalesItemAppDto salesItemAppDto : list) {
                    if (!StringUtils.isNotEmpty((CharSequence)salesItemAppDto.getUnit())) continue;
                    String unitName = unitNameMap.get(salesItemAppDto.getUnit());
                    salesItemAppDto.setUnitName(unitName);
                }
            }
        }
        return list;
    }

    public AfterSalesItemsDto getWaitServiceListWithGift(String deliveryNo, Integer refundType, Long customerId) {
        AfterSalesItemsDto afterSalesItemsDto = new AfterSalesItemsDto();
        List<AfterSalesItemAppDto> waitServiceList = this.getWaitServiceList(deliveryNo, refundType, customerId);
        ArrayList<AfterSalesItemAppDto> itemList = new ArrayList<AfterSalesItemAppDto>();
        ArrayList<AfterSalesItemAppDto> giftItems = new ArrayList<AfterSalesItemAppDto>();
        for (AfterSalesItemAppDto afterSalesItemAppDto : waitServiceList) {
            if (afterSalesItemAppDto.getGift() != null && afterSalesItemAppDto.getGift() == 1) {
                giftItems.add(afterSalesItemAppDto);
                continue;
            }
            itemList.add(afterSalesItemAppDto);
        }
        afterSalesItemsDto.setItemList(itemList);
        afterSalesItemsDto.setGiftItems(giftItems);
        return afterSalesItemsDto;
    }

    public PageInfo<ReturnOrderRespDto> queryAfterSalesByPage(ReturnOrderPageSearchReqDto searchReqDto, Integer pageNum, Integer pageSize) {
        ReturnQueryReqDto returnQueryReqDto = new ReturnQueryReqDto();
        ArrayList customerIds = Lists.newArrayList();
        HashMap<String, String> nameMap = new HashMap<String, String>();
        HashMap<String, String> selllerNameMap = new HashMap<String, String>();
        HashMap<String, ShopDto> shopDtoMap = new HashMap<String, ShopDto>();
        ServiceContext serviceContext = ServiceContext.getContext();
        String headerCustomerId = serviceContext.getAttachment("yes.req.cus.b2b.customerid");
        if (StringUtils.isNotEmpty((CharSequence)headerCustomerId)) {
            if (searchReqDto.getCustomerId() == null) {
                customerIds.addAll(this.orderService.getCustomerIdsBySalesmanIdAndName(this.context.userId(), searchReqDto.getCustomerInfo(), nameMap));
            } else {
                customerIds.add(searchReqDto.getCustomerId());
                nameMap.put(headerCustomerId, searchReqDto.getCustomerName());
            }
        } else {
            List<Long> customerIdList = this.commonService.getCustomerIdListByUserId(this.context.userId(), nameMap);
            for (Long custId : customerIdList) {
                customerIds.add(custId.toString());
            }
        }
        if (CollectionUtils.isEmpty((Collection)customerIds)) {
            return new PageInfo();
        }
        returnQueryReqDto.setCustomerIds(StringUtils.join((Iterable)customerIds, (String)","));
        returnQueryReqDto.setInstanceId(this.context.instanceId());
        returnQueryReqDto.setTenantId(this.context.tenantId());
        returnQueryReqDto.setReturnNo(searchReqDto.getReturnNo());
        if (StringUtils.isNotBlank((CharSequence)searchReqDto.getItemName())) {
            returnQueryReqDto.setKeyword(searchReqDto.getItemName());
        } else {
            returnQueryReqDto.setKeyword(searchReqDto.getKeyword());
        }
        StringBuilder statusSb = new StringBuilder();
        if (ReturnStatusToBEnum.RETURN_REFUND_ING.getCode().equals(searchReqDto.getReFundOrderTradeStatus())) {
            statusSb.append(ReturnStatusToBEnum.WAIT_IN_STORAGE.getCode()).append(",");
            statusSb.append(ReturnStatusToBEnum.PART_IN_STORAGE.getCode()).append(",");
            statusSb.append(ReturnStatusToBEnum.ALL_IN_STORAGE.getCode()).append(",");
            statusSb.append(ReturnStatusToBEnum.WAIT_REFUND.getCode()).append(",");
            statusSb.append(ReturnStatusToBEnum.PART_REFUND.getCode()).append(",");
            statusSb.deleteCharAt(statusSb.length() - 1);
            returnQueryReqDto.setReturnStatusList(statusSb.toString());
        } else {
            returnQueryReqDto.setReturnStatus(searchReqDto.getReFundOrderTradeStatus());
        }
        if (ObjectUtil.isNotEmpty((Object)searchReqDto.getStartDay()) && ObjectUtil.isNotEmpty((Object)searchReqDto.getEndDay())) {
            returnQueryReqDto.setReturnTimeStart(searchReqDto.getStartDay());
            returnQueryReqDto.setReturnTimeEnd(searchReqDto.getEndDay());
        }
        returnQueryReqDto.setPageNum(pageNum);
        returnQueryReqDto.setPageSize(pageSize);
        RestResponse pageInfoRestResponse = this.afterSalesQueryApi.queryPostReturnByPage(JSON.toJSONString((Object)returnQueryReqDto));
        PageInfo pageInfoRestResponse1 = (PageInfo)RestResponseHelper.extractData((RestResponse)pageInfoRestResponse);
        PageInfo page = new PageInfo();
        if (pageInfoRestResponse1 != null && pageInfoRestResponse1.getList() != null && pageInfoRestResponse1.getList().size() > 0) {
            List list = pageInfoRestResponse1.getList();
            List refundRecordRespDto = list.stream().map(this::buildRefundRecordRespDto).collect(Collectors.toList());
            this.initSellerNameMap(selllerNameMap, list.stream().map(e -> e.getSellerId()).collect(Collectors.toList()));
            this.initShopNameMap(shopDtoMap, list.stream().map(e -> e.getShopId()).collect(Collectors.toList()));
            for (ReturnOrderRespDto returnOrderRespDto : refundRecordRespDto) {
                String customerName = (String)nameMap.get(returnOrderRespDto.getCustomerId());
                returnOrderRespDto.setCustomerName(customerName);
                returnOrderRespDto.setSellerName((String)selllerNameMap.get(returnOrderRespDto.getSellerId()));
                ShopDto shopDto = (ShopDto)shopDtoMap.get(returnOrderRespDto.getShopId());
                returnOrderRespDto.setShopName(shopDto.getName());
                returnOrderRespDto.setShopType(String.valueOf(shopDto.getType()));
            }
            page.setList(refundRecordRespDto);
            Map companyMap = (Map)RestResponseHelper.extractData((RestResponse)this.userExtV2QueryApi.queryCompanyNameByCusId(refundRecordRespDto.stream().map(e -> Long.parseLong(e.getCustomerId())).collect(Collectors.toList())));
            if (MapUtil.isNotEmpty((Map)companyMap) && CollectionUtils.isNotEmpty(refundRecordRespDto)) {
                CompanySimpleInfoDto simpleInfoDto = null;
                for (ReturnOrderRespDto orderListRespDto : refundRecordRespDto) {
                    simpleInfoDto = (CompanySimpleInfoDto)companyMap.get(Long.parseLong(orderListRespDto.getCustomerId()));
                    if (orderListRespDto.getCustomerId() == null || simpleInfoDto == null) continue;
                    orderListRespDto.setOrganizationName(simpleInfoDto.getOrgName());
                    orderListRespDto.setCustomerOrgName(simpleInfoDto.getOrgName());
                }
            }
            CubeBeanUtils.copyProperties((Object)page, (Object)pageInfoRestResponse1, (String[])new String[]{"list", "navigatepageNums"});
        }
        return page;
    }

    private void initShopNameMap(Map<String, ShopDto> shopDtoMap, List<String> shopIds) {
        if (CollectionUtils.isEmpty(shopIds)) {
            return;
        }
        HashSet shopIdSet = new HashSet(shopIds.stream().map(e -> Long.valueOf(e)).collect(Collectors.toList()));
        List res = (List)this.shopQueryApi.queryByIds(shopIdSet).getData();
        res.forEach(e -> shopDtoMap.put(String.valueOf(e.getId()), (ShopDto)e));
    }

    private void initSellerNameMap(Map<String, String> selllerNameMap, List<String> sellerIds) {
        if (CollectionUtils.isEmpty(sellerIds)) {
            return;
        }
        SellerQueryReqDto sellerQueryReqDto = new SellerQueryReqDto();
        HashSet sellerIdSet = new HashSet(sellerIds.stream().map(e -> Long.valueOf(e)).collect(Collectors.toList()));
        sellerQueryReqDto.setIdList(new ArrayList(sellerIdSet));
        List sellerList = (List)this.sellerQueryApi.queryList(sellerQueryReqDto).getData();
        sellerList.forEach(e -> selllerNameMap.put(String.valueOf(e.getId()), e.getName()));
    }

    public ReFundOrderDetailRespDto getAfterSalesDetail(String returnNo) {
        PageInfo refundPageInfo;
        RestResponse returnDetailRespDtoRestResponse = this.afterSalesQueryApi.queryReturnDetail(returnNo, "{}");
        ReturnDetailRespDto returnDetailRespDto = (ReturnDetailRespDto)RestResponseHelper.extractData((RestResponse)returnDetailRespDtoRestResponse);
        String refundType = "1";
        String tradeNo = null;
        if (StringUtils.isNotEmpty((CharSequence)returnDetailRespDto.getDeliveryNo())) {
            refundType = "2";
            tradeNo = returnDetailRespDto.getDeliveryNo();
        } else {
            refundType = "APP".equals(returnDetailRespDto.getDeviceType()) ? "3" : "1";
            tradeNo = returnDetailRespDto.getOrderTradeNo();
        }
        ArrayList itemDetails = Lists.newArrayList();
        Integer totalItemNum = 0;
        for (ReturnOmniItemRespDto returnOmniItemRespDto : returnDetailRespDto.getReturnOmniItemRespDtoList()) {
            AfterSalesItemAppDto itemAppDto = this.buildItemDetail(returnOmniItemRespDto, refundType);
            totalItemNum = totalItemNum + itemAppDto.getNum();
            itemDetails.add(itemAppDto);
        }
        this.buildUtilMessageByIds(itemDetails);
        ReFundOrderDetailRespDto reFundOrderDetailRespDto = new ReFundOrderDetailRespDto();
        if ("3".equals(refundType)) {
            ArrayList newItemList = Lists.newArrayList();
            Map<Long, List<AfterSalesItemAppDto>> itemMap = itemDetails.stream().collect(Collectors.groupingBy(AfterSalesItemAppDto::getSkuId));
            for (Map.Entry<Long, List<AfterSalesItemAppDto>> entry : itemMap.entrySet()) {
                Long skuSerial = entry.getKey();
                List<AfterSalesItemAppDto> itemRespDtos = entry.getValue();
                Integer canReturnedNum = 0;
                Integer num = 0;
                Integer itemNum = 0;
                Integer thisStorageNum = 0;
                Integer returnedNum = 0;
                BigDecimal payAmount = new BigDecimal("0");
                BigDecimal subTotalReturnAmount = new BigDecimal("0");
                for (AfterSalesItemAppDto itemRespDto : itemRespDtos) {
                    canReturnedNum = canReturnedNum + itemRespDto.getCanReturnedNum();
                    num = num + itemRespDto.getNum();
                    itemNum = itemNum + itemRespDto.getItemNum();
                    thisStorageNum = thisStorageNum + itemRespDto.getThisStorageNum();
                    returnedNum = returnedNum + itemRespDto.getReturnedNum();
                    if (Objects.nonNull(itemRespDto.getPayAmount())) {
                        payAmount = payAmount.add(itemRespDto.getPayAmount());
                    }
                    if (!Objects.nonNull(itemRespDto.getSubTotalReturnAmount())) continue;
                    subTotalReturnAmount = subTotalReturnAmount.add(itemRespDto.getSubTotalReturnAmount());
                }
                AfterSalesItemAppDto itemAppDto = itemRespDtos.get(0);
                itemAppDto.setCanReturnedNum(canReturnedNum);
                itemAppDto.setNum(num);
                itemAppDto.setItemNum(itemNum);
                itemAppDto.setThisStorageNum(thisStorageNum);
                itemAppDto.setReturnedNum(returnedNum);
                itemAppDto.setPayAmount(payAmount);
                itemAppDto.setSubTotalReturnAmount(subTotalReturnAmount);
                newItemList.add(itemAppDto);
            }
            reFundOrderDetailRespDto.setItemList((List)newItemList);
        } else {
            reFundOrderDetailRespDto.setItemList((List)itemDetails);
        }
        Map extFields = returnDetailRespDto.getExtFields();
        String returnDesc = extFields.get("returnDesc") + "";
        if (!(OrderReturnBizTypeEnum.ONLY_REFUND.getCode().equals(returnDetailRespDto.getReturnType()) || ReturnStatusToBEnum.AUDITING.getCode().equals(returnDetailRespDto.getReturnStatus()) || ReturnStatusToBEnum.CANCEL.getCode().equals(returnDetailRespDto.getReturnStatus()))) {
            this.buildAddress(reFundOrderDetailRespDto, returnDesc);
        }
        String refundStatus = extFields.get("refundStatus") + "";
        String placeUserId = extFields.get("placeUserId") + "";
        String remark = extFields.get("remark") + "";
        String warehouseCode = extFields.get("warehouseCode") + "";
        reFundOrderDetailRespDto.setTotalItemNum(totalItemNum);
        RefundOrderStatusToBEnum refundOrderStatusToBEnum = ReturnOrderUtil.convertRefundStatus(refundStatus);
        reFundOrderDetailRespDto.setOrderRefundStatus(refundOrderStatusToBEnum.getCode());
        reFundOrderDetailRespDto.setOrderRefundStatusName(refundOrderStatusToBEnum.getName());
        reFundOrderDetailRespDto.setOrderId(null);
        reFundOrderDetailRespDto.setOrderNo(returnDetailRespDto.getOrderTradeNo());
        reFundOrderDetailRespDto.setPayAmount(returnDetailRespDto.getPayAmount());
        reFundOrderDetailRespDto.setApplyAmount(returnDetailRespDto.getRefundAmount());
        reFundOrderDetailRespDto.setOrganizationId(returnDetailRespDto.getOrganizationId());
        reFundOrderDetailRespDto.setPlaceType("1");
        reFundOrderDetailRespDto.setRefundId(null);
        reFundOrderDetailRespDto.setReturnedAmount(null);
        reFundOrderDetailRespDto.setWarehouseCode(warehouseCode);
        JSONObject jsonObjectReturnRespDto = new JSONObject();
        jsonObjectReturnRespDto.put("returnNo", (Object)returnNo);
        jsonObjectReturnRespDto.put("instanceId", (Object)this.context.instanceId());
        jsonObjectReturnRespDto.put("tenantId", (Object)this.context.tenantId());
        RestResponse pageInfoRestResponse1 = this.refundQueryApi.queryByPage(jsonObjectReturnRespDto.toJSONString(), Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE));
        BigDecimal returnedPayAmount = new BigDecimal("0");
        if (pageInfoRestResponse1 != null && ((PageInfo)pageInfoRestResponse1.getData()).getList() != null && ((PageInfo)pageInfoRestResponse1.getData()).getList().size() > 0) {
            List list = ((PageInfo)pageInfoRestResponse1.getData()).getList();
            returnedPayAmount = this.countAlreadyPayAmount(list);
        }
        reFundOrderDetailRespDto.setAmount(null == returnedPayAmount ? BigDecimal.ZERO : returnedPayAmount);
        reFundOrderDetailRespDto.setReturnNo(returnDetailRespDto.getReturnNo());
        reFundOrderDetailRespDto.setReturnOrderRemark(remark);
        reFundOrderDetailRespDto.setReturnReason(returnDetailRespDto.getReturnReason());
        reFundOrderDetailRespDto.setApplyTime(returnDetailRespDto.getCreateTime());
        reFundOrderDetailRespDto.setBizType(returnDetailRespDto.getReturnType());
        reFundOrderDetailRespDto.setBizTypeName(OrderReturnBizTypeEnum.toName((String)returnDetailRespDto.getReturnType()));
        reFundOrderDetailRespDto.setDeliveryNo(returnDetailRespDto.getDeliveryNo());
        reFundOrderDetailRespDto.setOrderTradeStatus(returnDetailRespDto.getReturnStatus());
        reFundOrderDetailRespDto.setOrderTradeStatusName(ReturnStatusToBEnum.toName((String)returnDetailRespDto.getReturnStatus()));
        if (StringUtils.isNotBlank((CharSequence)returnDetailRespDto.getExtension())) {
            ReturnLogisticsAddReqDto jsonObject = (ReturnLogisticsAddReqDto)JSONObject.parseObject((String)returnDetailRespDto.getExtension(), ReturnLogisticsAddReqDto.class);
            reFundOrderDetailRespDto.setReturnWay(jsonObject.getReturnWay());
        }
        if (Objects.nonNull(refundPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)pageInfoRestResponse1)) && CollectionUtils.isNotEmpty((Collection)refundPageInfo.getList())) {
            HashSet<String> refundWaySet = new HashSet<String>(refundPageInfo.getList().size());
            Date refundTime = null;
            for (RefundRespDto refundRespDto : refundPageInfo.getList()) {
                refundWaySet.add(refundRespDto.getPayMethod());
                if (Objects.nonNull(refundTime)) {
                    boolean before = refundTime.before(refundRespDto.getRefundTime());
                    if (!before) continue;
                    refundTime = refundRespDto.getRefundTime();
                    continue;
                }
                refundTime = refundRespDto.getRefundTime();
            }
            reFundOrderDetailRespDto.setRefundWayList((List)Lists.newArrayList(refundWaySet));
            reFundOrderDetailRespDto.setRefundTime(refundTime);
        }
        reFundOrderDetailRespDto.setCustomerId(extFields.get("customerId") + "");
        if (Objects.nonNull(reFundOrderDetailRespDto.getCustomerId())) {
            RestResponse customerRestResp = this.customerQueryApi.queryById(Long.valueOf(reFundOrderDetailRespDto.getCustomerId()));
            CustomerRespDto customerRespDto = (CustomerRespDto)RestResponseHelper.extractData((RestResponse)customerRestResp);
            reFundOrderDetailRespDto.setCustomerName(customerRespDto.getName());
        }
        if (CollectionUtils.isNotEmpty((Collection)returnDetailRespDto.getApplyReturnItemRespDtoList())) {
            this.setApplyReturnItemBatchNoInfo(returnDetailRespDto.getApplyReturnItemRespDtoList(), returnDetailRespDto.getWarehouseCode());
        }
        if (CollectionUtils.isNotEmpty((Collection)reFundOrderDetailRespDto.getItemList())) {
            this.setReturnItemBatchNoInfo(reFundOrderDetailRespDto.getItemList(), returnDetailRespDto.getWarehouseCode());
        }
        RestResponse attachementRestResp = this.attachementQueryApi.queryByNoAndType(reFundOrderDetailRespDto.getReturnNo(), "RETURN");
        List attachementReqDtoList = (List)RestResponseHelper.extractData((RestResponse)attachementRestResp);
        reFundOrderDetailRespDto.setAttachmentList(attachementReqDtoList);
        reFundOrderDetailRespDto.setApplyReturnItemRespDtoList(returnDetailRespDto.getApplyReturnItemRespDtoList());
        reFundOrderDetailRespDto.setApplyReturnQty(returnDetailRespDto.getApplyReturnQty());
        reFundOrderDetailRespDto.setCreateMode(returnDetailRespDto.getCreateMode());
        CustomAddressDto customAddressDto = (CustomAddressDto)JSON.parseObject((String)returnDetailRespDto.getBuyerAddrInfo(), CustomAddressDto.class);
        reFundOrderDetailRespDto.setBuyerAddrInfo(customAddressDto);
        reFundOrderDetailRespDto.setSellerId(returnDetailRespDto.getSellerId());
        reFundOrderDetailRespDto.setShopId(returnDetailRespDto.getShopId());
        ShopDto shopBaseDto = (ShopDto)this.shopQueryApi.queryById(Long.valueOf(returnDetailRespDto.getShopId()).longValue(), new String[0]).getData();
        reFundOrderDetailRespDto.setShopName(shopBaseDto.getName());
        reFundOrderDetailRespDto.setSellerName(shopBaseDto.getSellerName());
        try {
            Long customerId = Long.parseLong(reFundOrderDetailRespDto.getCustomerId());
            ArrayList<Long> customerIdList = new ArrayList<Long>(Arrays.asList(customerId));
            Map companyMap = (Map)RestResponseHelper.extractData((RestResponse)this.userExtV2QueryApi.queryCompanyNameByCusId(customerIdList));
            if (MapUtil.isNotEmpty((Map)companyMap) && returnDetailRespDto.getCustomerId() != null && companyMap.get(customerId) != null) {
                reFundOrderDetailRespDto.setOrganizationName(((CompanySimpleInfoDto)companyMap.get(customerId)).getOrgName());
                reFundOrderDetailRespDto.setCustomerOrgName(((CompanySimpleInfoDto)companyMap.get(customerId)).getOrgName());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setReturnOrderWarehouseName(reFundOrderDetailRespDto);
        return reFundOrderDetailRespDto;
    }

    private void setReturnOrderWarehouseName(ReFundOrderDetailRespDto reFundOrderDetailRespDto) {
        logger.info("setReturnOrderWarehouseName start. reFundOrderDetailRespDto={}", (Object)JSON.toJSONString((Object)reFundOrderDetailRespDto));
        if (StringUtils.isEmpty((CharSequence)reFundOrderDetailRespDto.getWarehouseCode())) {
            return;
        }
        WarehouseRespDto warehouseRespDto = (WarehouseRespDto)this.warehouseQueryApi.queryWarehouseByCode(reFundOrderDetailRespDto.getWarehouseCode(), "{}").getData();
        reFundOrderDetailRespDto.setWarehouseName(warehouseRespDto.getName());
        logger.info("setReturnOrderWarehouseName end. \uff1areFundOrderDetailRespDto={}", (Object)JSON.toJSONString((Object)reFundOrderDetailRespDto));
    }

    private void setReturnItemBatchNoInfo(List<AfterSalesItemAppDto> itemList, String warehouseCode) {
        HashSet batchNoSet = Sets.newHashSet();
        ArrayList all = Lists.newArrayList();
        for (AfterSalesItemAppDto afterSalesItemAppDto : itemList) {
            String[] split;
            if (!StringUtils.isNotBlank((CharSequence)afterSalesItemAppDto.getBatchNo())) continue;
            ArrayList itemBatchNoList = Lists.newArrayList();
            for (String batchNo : split = afterSalesItemAppDto.getBatchNo().split(",")) {
                String[] batchNumArr = batchNo.split("#");
                ApplyReturnItemBatchRespDto applyBatchNo = new ApplyReturnItemBatchRespDto();
                applyBatchNo.setBatchNo(batchNumArr[0]);
                applyBatchNo.setNum(Integer.valueOf(batchNumArr[1]));
                batchNoSet.add(batchNumArr[0]);
                itemBatchNoList.add(applyBatchNo);
                all.add(applyBatchNo);
            }
            afterSalesItemAppDto.setReturnItemBatchRespDtos((List)itemBatchNoList);
        }
        if (CollectionUtils.isNotEmpty((Collection)batchNoSet)) {
            logger.info("\u67e5\u8be2\u6279\u6b21\u53f7\u4fe1\u606f\u5165\u53c2\uff1a{},\u4ed3\u5e93\u7f16\u7801\uff1a{}", (Object)JSON.toJSONString((Object)batchNoSet), (Object)warehouseCode);
            List cargoStorageDtos = (List)RestResponseHelper.extractData((RestResponse)this.tcbjInventoryApi.queryCargoStorageByBatchesAndWarehouseCode(new ArrayList(batchNoSet), warehouseCode));
            logger.info("\u67e5\u8be2\u6279\u6b21\u53f7\u4fe1\u606f\u8fd4\u56de\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)cargoStorageDtos));
            Map<String, CargoStorageDto> batchDataMap = cargoStorageDtos.stream().collect(Collectors.toMap(CargoStorageDto::getBatch, e -> e, (e1, e2) -> e1));
            logger.info("\u67e5\u8be2\u6279\u6b21\u53f7\u5206\u7ec4\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString(batchDataMap));
            for (ApplyReturnItemBatchRespDto applyReturnItemBatchDto : all) {
                if (!batchDataMap.containsKey(applyReturnItemBatchDto.getBatchNo())) continue;
                CargoStorageDto cargoStorageDto = batchDataMap.get(applyReturnItemBatchDto.getBatchNo());
                applyReturnItemBatchDto.setProductionDate(cargoStorageDto.getProduceTime());
                applyReturnItemBatchDto.setExpiredDate(cargoStorageDto.getExpireTime());
            }
        }
    }

    private void setApplyReturnItemBatchNoInfo(List<ApplyReturnItemRespDto> applyReturnItemRespDtoList, String warehouseCode) {
        HashSet batchNoSet = Sets.newHashSet();
        ArrayList all = Lists.newArrayList();
        for (ApplyReturnItemRespDto applyReturnItemRespDto : applyReturnItemRespDtoList) {
            String[] batchNumArr;
            String[] split;
            if (StringUtils.isNotBlank((CharSequence)applyReturnItemRespDto.getSrcBatchNo())) {
                ArrayList srcTradeItemBatchDtos = Lists.newArrayList();
                for (String batchNo : split = applyReturnItemRespDto.getSrcBatchNo().split(",")) {
                    batchNumArr = batchNo.split("#");
                    ApplyReturnItemBatchRespDto srcBatchNo = new ApplyReturnItemBatchRespDto();
                    srcBatchNo.setBatchNo(batchNumArr[0]);
                    srcBatchNo.setNum(Integer.valueOf(batchNumArr[1]));
                    batchNoSet.add(batchNumArr[0]);
                    srcTradeItemBatchDtos.add(srcBatchNo);
                    all.add(srcBatchNo);
                }
                applyReturnItemRespDto.setSrcTradeItemBatchNoDtos((List)srcTradeItemBatchDtos);
            }
            if (!StringUtils.isNotBlank((CharSequence)applyReturnItemRespDto.getBatchNo())) continue;
            ArrayList itemBatchNoList = Lists.newArrayList();
            for (String batchNo : split = applyReturnItemRespDto.getBatchNo().split(",")) {
                batchNumArr = batchNo.split("#");
                ApplyReturnItemBatchRespDto applyBatchNo = new ApplyReturnItemBatchRespDto();
                applyBatchNo.setBatchNo(batchNumArr[0]);
                applyBatchNo.setNum(Integer.valueOf(batchNumArr[1]));
                batchNoSet.add(batchNumArr[0]);
                itemBatchNoList.add(applyBatchNo);
                all.add(applyBatchNo);
            }
            applyReturnItemRespDto.setApplyItemBatchNoDtos((List)itemBatchNoList);
        }
        if (CollectionUtils.isNotEmpty((Collection)batchNoSet)) {
            logger.info("\u67e5\u8be2\u6279\u6b21\u53f7\u4fe1\u606f\u5165\u53c2\uff1a{},\u4ed3\u5e93\u7f16\u7801\uff1a{}", (Object)JSON.toJSONString((Object)batchNoSet), (Object)warehouseCode);
            List cargoStorageDtos = (List)RestResponseHelper.extractData((RestResponse)this.tcbjInventoryApi.queryCargoStorageByBatchesAndWarehouseCode(new ArrayList(batchNoSet), warehouseCode));
            logger.info("\u67e5\u8be2\u6279\u6b21\u53f7\u4fe1\u606f\u8fd4\u56de\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)cargoStorageDtos));
            Map<String, CargoStorageDto> batchDataMap = cargoStorageDtos.stream().collect(Collectors.toMap(CargoStorageDto::getBatch, e -> e, (e1, e2) -> e1));
            logger.info("\u67e5\u8be2\u6279\u6b21\u53f7\u5206\u7ec4\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString(batchDataMap));
            for (ApplyReturnItemBatchRespDto applyReturnItemBatchDto : all) {
                if (!batchDataMap.containsKey(applyReturnItemBatchDto.getBatchNo())) continue;
                CargoStorageDto cargoStorageDto = batchDataMap.get(applyReturnItemBatchDto.getBatchNo());
                applyReturnItemBatchDto.setProductionDate(cargoStorageDto.getProduceTime());
                applyReturnItemBatchDto.setExpiredDate(cargoStorageDto.getExpireTime());
            }
        }
    }

    private List<AfterSalesItemAppDto> getGift(String orderNo) {
        RestResponse listRestResponse = this.iOrderQueryApi.queryOrderItemsByTradeNo(orderNo);
        List data = (List)listRestResponse.getData();
        List collect = data.stream().filter(o -> o != null && o.getGift() == 1).collect(Collectors.toList());
        List<AfterSalesItemAppDto> supplierReturnList = collect.stream().map(this::buildAfterSalesItemAppDto).collect(Collectors.toList());
        return supplierReturnList;
    }

    private AfterSalesItemAppDto buildAfterSalesItemAppDto(TradeItemReqDto tradeItemReqDto) {
        AfterSalesItemAppDto afterSalesItemAppDto = new AfterSalesItemAppDto();
        BeanUtils.copyProperties((Object)tradeItemReqDto, (Object)afterSalesItemAppDto);
        afterSalesItemAppDto.setSkuName(tradeItemReqDto.getSkuDesc());
        return afterSalesItemAppDto;
    }

    private void buildAddress(ReFundOrderDetailRespDto reFundOrderDetailRespDto, String returnDesc) {
        try {
            OrderReceiveDetailRespDto orderReceiveDetailRespDto = (OrderReceiveDetailRespDto)JSONObject.parseObject((String)returnDesc, OrderReceiveDetailRespDto.class);
            OrderReceiveDetailRespDto receiveDetail = new OrderReceiveDetailRespDto();
            receiveDetail.setCustomerName(orderReceiveDetailRespDto.getCustomerName());
            receiveDetail.setDeliveryAddress(orderReceiveDetailRespDto.getDeliveryAddress());
            receiveDetail.setDeliveryMobile(orderReceiveDetailRespDto.getDeliveryMobile());
            receiveDetail.setDeliveryName(orderReceiveDetailRespDto.getDeliveryName());
            reFundOrderDetailRespDto.setReceiveDetail(receiveDetail);
        }
        catch (Exception e) {
            logger.info("\u5730\u5740\u89e3\u6790\u5f02\u5e38,data----:" + JSONObject.toJSONString((Object)returnDesc));
            logger.info("\u5931\u8d25\u539f\u56e0" + e.getMessage());
        }
    }

    private BigDecimal countAlreadyPayAmount(List<RefundRespDto> list) {
        BigDecimal alreadyPayAmount = null;
        try {
            alreadyPayAmount = list.stream().map(RefundRespDto::getRefundTotalAmount).reduce(BigDecimal::add).get();
            alreadyPayAmount = alreadyPayAmount.setScale(1, 1);
        }
        catch (Exception e) {
            logger.info("\u7d2f\u52a0\u5df2\u652f\u4ed8\u91d1\u989d\u5931\u8d25,data----:" + JSONObject.toJSONString(list));
            logger.info("\u5931\u8d25\u539f\u56e0" + e.getMessage());
        }
        return alreadyPayAmount;
    }

    public void updateAfterSales(AfterSalesUpdateReqDto reqDto) {
        if (!ReturnStatusToBEnum.WAIT_AUDIT.getCode().equals(reqDto.getOrderTradeStatus())) {
            BizExceptionHelper.throwBizException((IExceptionCode)TradeModuleExcpCode.RETURN_NOT_ALLOW_MODIFY);
        }
        List itemList = reqDto.getItemList();
        List supplierReturnList = itemList.stream().map(this::buildSupplierAfterSalesItem).collect(Collectors.toList());
        ReturnModTobReqDto returnReqDto = new ReturnModTobReqDto();
        returnReqDto.setAfterSalesItems(supplierReturnList);
        returnReqDto.setRefundAmount(reqDto.getApplyAmount());
        returnReqDto.setReqReason(reqDto.getRemark());
        returnReqDto.setTradeNo(reqDto.getReturnNo());
        returnReqDto.setReturnNo(reqDto.getReturnNo());
        returnReqDto.setTotalAmount(reqDto.getApplyAmount());
        returnReqDto.setRemark(reqDto.getRemark());
        returnReqDto.setAttachements(reqDto.getAttachmentList());
        returnReqDto.setUpdateFlag(TradeConstant.YES);
        RestResponse voidRestResponse = this.afterSalesTobApi.modifyReturnInfo(returnReqDto);
        RestResponseHelper.checkOrThrow((RestResponse)voidRestResponse);
    }

    public void cancelAfterSales(CancelAfterSalesReqDto reqDto) {
        CancelReqDto cancelOrderReqDto = new CancelReqDto();
        cancelOrderReqDto.setTradeNo(cancelOrderReqDto.getTradeNo());
        cancelOrderReqDto.setCancelDesc(reqDto.getCancelDesc());
        cancelOrderReqDto.setCancelType(reqDto.getCancelType());
        String returnNo = reqDto.getReturnNo();
        RestResponse voidRestResponse = this.afterSalesApi.cancelByReturn(returnNo, cancelOrderReqDto);
        RestResponseHelper.checkOrThrow((RestResponse)voidRestResponse);
    }

    public void addLogistics(ReturnLogisticsAddReqDto reqDto) {
        if (StringUtils.isEmpty((CharSequence)reqDto.getReturnNo()) || StringUtils.isEmpty((CharSequence)reqDto.getReturnWay())) {
            BizExceptionHelper.throwBizException((IExceptionCode)TradeModuleExcpCode.RETURN_NO_WAY_NOT_EMPTY);
        }
        ReturnModTobReqDto returnReqDto = new ReturnModTobReqDto();
        returnReqDto.setReturnNo(reqDto.getReturnNo());
        returnReqDto.setExtension(JSON.toJSONString((Object)reqDto));
        returnReqDto.setUpdateFlag(TradeConstant.NO);
        RestResponse voidRestResponse = this.afterSalesTobApi.modifyReturnInfo(returnReqDto);
        OptLogReqDto optLogDto = new OptLogReqDto();
        optLogDto.setBizType(OptBizTypeEnum.RETURN.getType());
        optLogDto.setBizNo(reqDto.getReturnNo());
        optLogDto.setOptTime(new Date());
        optLogDto.setOptPerson(this.context.userName());
        optLogDto.setOptType(OptTypeEnum.RETURN_LOGISTICS_CREATE.getType());
        StringBuilder description = new StringBuilder();
        description.append("\u9000\u8d27\u7269\u6d41\u4fe1\u606f\u63d0\u4ea4\u6210\u529f\uff0c\u5f85\u590d\u6838\u3002 ");
        description.append("\u9000\u8d27\u65b9\u5f0f:" + ReturnWayEnum.fromCode((Integer)Integer.valueOf(reqDto.getReturnWay())).getName() + "\uff0c");
        if (String.valueOf(ReturnWayEnum.EXPRESS.getCode()).equalsIgnoreCase(reqDto.getReturnWay())) {
            description.append("\u5feb\u9012\u516c\u53f8:" + reqDto.getExpressCompany() + "\uff0c");
            description.append("\u5feb\u9012\u5355\u53f7:" + reqDto.getExpressCode() + "\u3002");
        } else if (String.valueOf(ReturnWayEnum.LOGISTICS.getCode()).equalsIgnoreCase(reqDto.getReturnWay())) {
            description.append("\u7269\u6d41\u516c\u53f8:" + reqDto.getLogisticsCompany() + "\uff0c");
            description.append("\u7269\u6d41\u5355\u53f7:" + reqDto.getLogisticsCode() + "\u3002");
        } else if (String.valueOf(ReturnWayEnum.FACTORY_CAR.getCode()).equalsIgnoreCase(reqDto.getReturnWay())) {
            description.append("\u914d\u9001\u5458\u59d3\u540d:" + reqDto.getDeliveryName() + "\uff0c");
            description.append("\u624b\u673a\u53f7:" + reqDto.getDeliveryPhone() + "\uff0c");
            description.append("\u8f66\u724c\u53f7:" + reqDto.getDeliveryCar() + "\u3002");
        }
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getRemark())) {
            description.append("\u5907\u6ce8\u4fe1\u606f\uff1a" + reqDto.getRemark() + "\u3002");
        }
        optLogDto.setDescription(description.toString());
        RestResponse response = this.optLogApi.addBoOptLog(optLogDto);
        RestResponseHelper.extractData((RestResponse)response);
        RestResponseHelper.checkOrThrow((RestResponse)voidRestResponse);
    }

    public void addAfterSales(ReturnOrderSaveReqDto reqDto) {
        RestResponse orderDeliveryRestResp;
        OrderDeliveryRespDto orderDeliveryRespDto;
        ReturnReqDto returnReqDto = new ReturnReqDto();
        List<String> customerIds = Lists.newArrayList();
        if (PlaceTypeEnum.SALESMAN.getCode().equals(reqDto.getSrcType())) {
            returnReqDto.setDeviceType("SALESMAN");
            customerIds = this.orderService.getCustomerIdsBySalesmanId(this.context.userId());
        } else {
            returnReqDto.setDeviceType("APP");
            Long customerId = this.orderService.getCustomerIdByUserId(this.context.userId());
            if (Objects.nonNull(customerId)) {
                customerIds.add(customerId.toString());
                reqDto.setCustomerId(customerId.toString());
            }
        }
        if (StringUtils.isEmpty((CharSequence)reqDto.getCustomerId()) || CollectionUtils.isEmpty((Collection)customerIds)) {
            logger.error("\u8be5\u8d26\u53f7\u4e0d\u662f\u7ecf\u9500\u5546\u6216\u4e1a\u52a1\u5458\u8d26\u53f7\uff0c\u4e0d\u5141\u8bb8\u7533\u8bf7\u552e\u540e\uff01");
            return;
        }
        List itemList = reqDto.getItemList();
        ArrayList<ReturnOrderItemSaveReqDto> newList = new ArrayList<ReturnOrderItemSaveReqDto>();
        for (ReturnOrderItemSaveReqDto returnOrderItemSaveReqDto : itemList) {
            if (returnOrderItemSaveReqDto.getNum() == null) continue;
            newList.add(returnOrderItemSaveReqDto);
        }
        List supplierReturnList = newList.stream().map(this::buildSupplierReturnItem).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getGiftItems())) {
            for (AfterSalesItemAppDto giftItem : reqDto.getGiftItems()) {
                AfterSalesItemReqDto afterSalesItemReqDto = new AfterSalesItemReqDto();
                HashMap<String, Object> extFields = new HashMap<String, Object>();
                extFields.put("returnedNum", giftItem.getReturnedNum() + giftItem.getCanReturnedNum());
                extFields.put("returnNum", giftItem.getCanReturnedNum());
                extFields.put("unit", giftItem.getUnit());
                extFields.put("remark", giftItem.getRemark());
                afterSalesItemReqDto.setId(giftItem.getId());
                afterSalesItemReqDto.setTradeItemNo(giftItem.getTradeItemNo());
                afterSalesItemReqDto.setExtFields(extFields);
                afterSalesItemReqDto.setSkuSerial(Objects.nonNull(giftItem.getSkuId()) ? giftItem.getSkuId().toString() : null);
                afterSalesItemReqDto.setItemCode(giftItem.getItemCode());
                afterSalesItemReqDto.setGift(giftItem.getGift());
                OrderItemExtDto orderItemExtDto = new OrderItemExtDto();
                orderItemExtDto.setImgPath(giftItem.getPath());
                orderItemExtDto.setShelfType(giftItem.getShelfType());
                afterSalesItemReqDto.setExtension(JSONObject.toJSONString((Object)orderItemExtDto));
                afterSalesItemReqDto.setItemSerial(Objects.nonNull(giftItem.getItemId()) ? giftItem.getItemId().toString() : null);
                supplierReturnList.add(afterSalesItemReqDto);
            }
        }
        returnReqDto.setAfterSalesItems(supplierReturnList);
        returnReqDto.setCancelType(DeliveryCancelTypeEnum.NOT_CANCLE.getType());
        returnReqDto.setOrderTradeNo(reqDto.getOrderNo());
        returnReqDto.setRefundAmount(reqDto.getRefundAmount());
        returnReqDto.setReqReason(reqDto.getRemark());
        returnReqDto.setReturnType(StringUtils.isBlank((CharSequence)reqDto.getOrderReturnBizType()) ? OrderReturnBizTypeEnum.REFUND_AND_RETURN.getCode() : reqDto.getOrderReturnBizType());
        returnReqDto.setTradeNo(reqDto.getOrderNo());
        HashMap<String, Object> addrExtFields = new HashMap<String, Object>();
        addrExtFields.put("refundStatus", RefundStatusEnum.INIT.getName());
        addrExtFields.put("totalAmount", reqDto.getRefundAmount());
        addrExtFields.put("placeUserId", this.context.userId());
        addrExtFields.put("placeTime", reqDto.getPlaceTime());
        addrExtFields.put("remark", reqDto.getRemark());
        addrExtFields.put("customerId", Long.valueOf(reqDto.getCustomerId()));
        addrExtFields.put("attachements", reqDto.getAttachmentList());
        RestResponse customerRestResp = this.customerQueryApi.queryById(Long.valueOf(reqDto.getCustomerId()));
        CustomerRespDto customerRespDto = (CustomerRespDto)RestResponseHelper.extractData((RestResponse)customerRestResp);
        OrderReceiveDetailRespDto orderReceiveDetailRespDto = new OrderReceiveDetailRespDto();
        orderReceiveDetailRespDto.setCustomerName(customerRespDto.getName());
        addrExtFields.put("returnDesc", JSONObject.toJSONString((Object)orderReceiveDetailRespDto));
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getDeliveryNo()) && Objects.nonNull(orderDeliveryRespDto = (OrderDeliveryRespDto)RestResponseHelper.extractData((RestResponse)(orderDeliveryRestResp = this.orderDeliveryQueryApi.queryOrderByDeliveryNo(reqDto.getDeliveryNo()))))) {
            addrExtFields.put("warehouseCode", orderDeliveryRespDto.getWarehouseCode());
            returnReqDto.setWarehouseCode(orderDeliveryRespDto.getWarehouseCode());
        }
        returnReqDto.setExtFields(addrExtFields);
        returnReqDto.setDeliveryNo(reqDto.getDeliveryNo());
        returnReqDto.setCustomerId(reqDto.getCustomerId());
        RestResponse mapRestResponse = this.afterSalesApi.addAfterSale(returnReqDto);
        RestResponseHelper.extractData((RestResponse)mapRestResponse);
    }

    public ReturnCountTobRespDto queryAfterSalesCount(Integer srcType) {
        ReturnCountTobRespDto returnCountTobRespDto = new ReturnCountTobRespDto();
        Long userId = this.context.userId();
        List<Object> customerIds = Lists.newArrayList();
        if (PlaceTypeEnum.SALESMAN.getCode().equals(srcType)) {
            customerIds = this.orderService.getCustomerIdsBySalesmanId(userId);
        } else {
            List customerIdList = this.bitemService.getCustomerIdListByUserId(userId);
            if (CollectionUtils.isNotEmpty((Collection)customerIdList)) {
                customerIds = customerIdList.stream().map(Object::toString).collect(Collectors.toList());
            }
        }
        if (CollectionUtils.isEmpty((Collection)customerIds)) {
            returnCountTobRespDto.setWaitAuditCount(Integer.valueOf(0));
            returnCountTobRespDto.setProcessingCount(Integer.valueOf(0));
            returnCountTobRespDto.setCompleteCount(Integer.valueOf(0));
            return returnCountTobRespDto;
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("customerIds", (Object)StringUtils.join((Iterable)customerIds, (String)","));
        jsonObject.put("instanceId", (Object)this.context.instanceId());
        jsonObject.put("tenantId", (Object)this.context.tenantId());
        RestResponse returnCountTobRestResp = this.afterSalesQueryTobApi.queryReturnCountTob(jsonObject.toJSONString());
        returnCountTobRespDto = (ReturnCountTobRespDto)RestResponseHelper.extractData((RestResponse)returnCountTobRestResp);
        return returnCountTobRespDto;
    }

    private AfterSalesItemReqDto buildSupplierAfterSalesItem(AfterSalesItemAppDto itemAppDto) {
        AfterSalesItemReqDto afterSalesItemReqDto = new AfterSalesItemReqDto();
        HashMap<String, Object> extFields = new HashMap<String, Object>();
        extFields.put("returnedNum", itemAppDto.getReturnedNum() + itemAppDto.getNum());
        extFields.put("returnNum", itemAppDto.getNum());
        extFields.put("originNum", itemAppDto.getThisStorageNum());
        extFields.put("unit", itemAppDto.getUnit());
        extFields.put("itemAmount", itemAppDto.getItemPrice());
        extFields.put("remark", itemAppDto.getRemark());
        extFields.put("refundAmount", BigDecimal.valueOf(itemAppDto.getNum().intValue()).multiply(itemAppDto.getItemPrice()) + "");
        afterSalesItemReqDto.setItemPrice(itemAppDto.getItemPrice());
        afterSalesItemReqDto.setId(itemAppDto.getId());
        afterSalesItemReqDto.setTradeItemNo(itemAppDto.getTradeItemNo());
        afterSalesItemReqDto.setExtFields(extFields);
        afterSalesItemReqDto.setSkuSerial(Objects.nonNull(itemAppDto.getSkuId()) ? itemAppDto.getSkuId().toString() : null);
        afterSalesItemReqDto.setItemCode(itemAppDto.getItemCode());
        OrderItemExtDto orderItemExtDto = new OrderItemExtDto();
        orderItemExtDto.setImgPath(itemAppDto.getPath());
        orderItemExtDto.setShelfType(itemAppDto.getShelfType());
        afterSalesItemReqDto.setExtension(JSONObject.toJSONString((Object)orderItemExtDto));
        afterSalesItemReqDto.setItemSerial(Objects.nonNull(itemAppDto.getItemId()) ? itemAppDto.getItemId().toString() : null);
        return afterSalesItemReqDto;
    }

    private AfterSalesItemReqDto buildSupplierReturnItem(ReturnOrderItemSaveReqDto returnOrderItemDto) {
        AfterSalesItemReqDto afterSalesItemReqDto = new AfterSalesItemReqDto();
        HashMap<String, Object> extFields = new HashMap<String, Object>();
        extFields.put("returnedNum", returnOrderItemDto.getReturnedNum() + returnOrderItemDto.getNum());
        extFields.put("returnNum", returnOrderItemDto.getNum());
        extFields.put("unit", returnOrderItemDto.getUnit());
        extFields.put("itemAmount", returnOrderItemDto.getItemPrice());
        extFields.put("remark", returnOrderItemDto.getRemark());
        extFields.put("refundAmount", BigDecimal.valueOf(returnOrderItemDto.getNum().intValue()).multiply(returnOrderItemDto.getItemPrice()) + "");
        afterSalesItemReqDto.setItemPrice(returnOrderItemDto.getItemPrice());
        afterSalesItemReqDto.setId(returnOrderItemDto.getId());
        afterSalesItemReqDto.setTradeItemNo(returnOrderItemDto.getTradeItemNo());
        afterSalesItemReqDto.setExtFields(extFields);
        afterSalesItemReqDto.setSkuSerial(Objects.nonNull(returnOrderItemDto.getSkuId()) ? returnOrderItemDto.getSkuId().toString() : null);
        afterSalesItemReqDto.setItemCode(returnOrderItemDto.getItemCode());
        afterSalesItemReqDto.setGift(returnOrderItemDto.getGift());
        OrderItemExtDto orderItemExtDto = new OrderItemExtDto();
        orderItemExtDto.setImgPath(returnOrderItemDto.getPath());
        orderItemExtDto.setShelfType(returnOrderItemDto.getShelfType());
        afterSalesItemReqDto.setExtension(JSONObject.toJSONString((Object)orderItemExtDto));
        afterSalesItemReqDto.setItemSerial(Objects.nonNull(returnOrderItemDto.getItemId()) ? returnOrderItemDto.getItemId().toString() : null);
        return afterSalesItemReqDto;
    }

    private AfterSalesItemAppDto buildItemDetail(ReturnOmniItemRespDto returnOmniItemRespDto, String refundType) {
        AfterSalesItemAppDto itemDetail = new AfterSalesItemAppDto();
        Map extFields = returnOmniItemRespDto.getExtFields();
        String unit = extFields.get("unit") + "";
        String returnedNum = extFields.get("returnedNum") + "";
        String returnNum = extFields.get("returnNum") + "";
        String itemAmount = extFields.get("itemAmount") + "";
        String refundAmount = extFields.get("refundAmount") + "";
        itemDetail.setItemId(Long.valueOf(returnOmniItemRespDto.getItemId()));
        itemDetail.setItemCode(returnOmniItemRespDto.getItemCode());
        itemDetail.setItemName(returnOmniItemRespDto.getItemName());
        itemDetail.setCargoSerial(returnOmniItemRespDto.getCargoSerial());
        itemDetail.setItemNum(returnOmniItemRespDto.getItemNum());
        itemDetail.setNum(Integer.valueOf(StringUtils.isBlank((CharSequence)returnNum) || "null".equals(returnNum) ? 0 : Integer.parseInt(returnNum)));
        itemDetail.setGift(returnOmniItemRespDto.getGift());
        itemDetail.setTradeItemNo(returnOmniItemRespDto.getTradeItemNo());
        if ("3".equals(refundType)) {
            itemDetail.setReturnedNum(Integer.valueOf(0));
        } else if (null != returnOmniItemRespDto.getItemNum()) {
            itemDetail.setReturnedNum(returnOmniItemRespDto.getItemNum());
        } else {
            itemDetail.setReturnedNum(Integer.valueOf(0));
        }
        if (itemDetail.getGift() == 0) {
            itemDetail.setCanReturnedNum(Integer.valueOf(itemDetail.getItemNum() - itemDetail.getReturnedNum()));
        } else {
            itemDetail.setCanReturnedNum(Integer.valueOf(returnOmniItemRespDto.getDeliveredNum() - itemDetail.getReturnedNum()));
        }
        itemDetail.setThisStorageNum(Integer.valueOf(StringUtils.isEmpty((CharSequence)returnNum) ? 0 : Integer.parseInt(returnNum)));
        BigDecimal adjustNum = Optional.ofNullable(returnOmniItemRespDto.getAdjustNum()).orElse(BigDecimal.ZERO);
        itemDetail.setItemPrice(returnOmniItemRespDto.getItemPrice().add(adjustNum));
        itemDetail.setId(returnOmniItemRespDto.getId());
        itemDetail.setPayAmount(returnOmniItemRespDto.getPayTotalAmount());
        itemDetail.setSubTotalReturnAmount(itemDetail.getItemPrice().multiply(BigDecimal.valueOf(itemDetail.getNum().intValue())));
        itemDetail.setRemark(returnOmniItemRespDto.getRemark());
        itemDetail.setSkuName(returnOmniItemRespDto.getSkuDesc());
        itemDetail.setSkuId(Long.valueOf(returnOmniItemRespDto.getSkuSerial()));
        itemDetail.setItemId(Long.valueOf(returnOmniItemRespDto.getItemId()));
        itemDetail.setUnit(unit);
        itemDetail.setCargoSerial(returnOmniItemRespDto.getCargoSerial());
        if (StringUtils.isNotBlank((CharSequence)returnOmniItemRespDto.getExtension())) {
            OrderItemExtDto jsonObject = (OrderItemExtDto)JSONObject.parseObject((String)returnOmniItemRespDto.getExtension(), OrderItemExtDto.class);
            itemDetail.setPath(jsonObject.getImgPath());
            itemDetail.setShelfType(jsonObject.getShelfType());
        }
        itemDetail.setBatchNo(returnOmniItemRespDto.getBatchNo());
        return itemDetail;
    }

    private void buildUtilMessageByIds(List<AfterSalesItemAppDto> itemDetails) {
        if (CollectionUtils.isNotEmpty(itemDetails)) {
            HashSet<Long> unitIds = new HashSet<Long>(itemDetails.size());
            for (AfterSalesItemAppDto itemDetail : itemDetails) {
                if (!StringUtils.isNotEmpty((CharSequence)itemDetail.getUnit())) continue;
                try {
                    Long unitId = Long.parseLong(itemDetail.getUnit());
                    unitIds.add(unitId);
                }
                catch (NumberFormatException e) {
                    logger.info("\u9000\u8ba2\u5355\u8be6\u60c5\u8fd4\u56de\u5355\u4f4d\u8f6c\u6362\u51fa\u9519>>>{}", (Object)(itemDetail.getUnit() + itemDetail.getItemId()));
                }
            }
            if (CollectionUtils.isNotEmpty(unitIds)) {
                List unitRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.unitQueryApi.queryByIds(StringUtils.join(unitIds, (String)",")));
                Map<String, String> unitNameMap = unitRespDtos.stream().collect(Collectors.toMap(unitResp -> unitResp.getId().toString(), UnitRespDto::getName, (e1, e2) -> e1));
                for (AfterSalesItemAppDto itemDetail : itemDetails) {
                    if (!StringUtils.isNotEmpty((CharSequence)itemDetail.getUnit())) continue;
                    String unitName = unitNameMap.get(itemDetail.getUnit());
                    itemDetail.setUnitName(unitName);
                }
            }
        }
    }

    private ReturnOrderRespDto buildRefundRecordRespDto(ReturnRespDto returnRespDto) {
        ReturnOrderRespDto refundRecordRespDto = new ReturnOrderRespDto();
        Map extFields = returnRespDto.getExtFields();
        String refundStatus = extFields.get("refundStatus") + "";
        refundRecordRespDto.setCustomerId(extFields.get("customerId") + "");
        refundRecordRespDto.setBizType(returnRespDto.getReturnType());
        refundRecordRespDto.setBizTypeName(OrderReturnBizTypeEnum.toName((String)returnRespDto.getReturnType()));
        refundRecordRespDto.setId(returnRespDto.getId());
        refundRecordRespDto.setReturnNo(returnRespDto.getReturnNo());
        refundRecordRespDto.setOrderNo(returnRespDto.getOrderTradeNo());
        RefundOrderStatusToBEnum refundOrderStatusToBEnum = ReturnOrderUtil.convertRefundStatus(refundStatus);
        refundRecordRespDto.setOrderRefundStatus(refundOrderStatusToBEnum.getCode());
        refundRecordRespDto.setOrderRefundStatusName(refundOrderStatusToBEnum.getName());
        refundRecordRespDto.setApplyReturnQty(returnRespDto.getApplyReturnQty());
        refundRecordRespDto.setCreateMode(returnRespDto.getCreateMode());
        refundRecordRespDto.setShopId(String.valueOf(returnRespDto.getShopId()));
        refundRecordRespDto.setSellerId(String.valueOf(returnRespDto.getSellerId()));
        refundRecordRespDto.setApplyReturnItemRespDtoList(returnRespDto.getApplyReturnItemRespDtoList());
        ArrayList<Long> customerIdList = new ArrayList<Long>(Arrays.asList(Long.parseLong(refundRecordRespDto.getCustomerId())));
        Map companyMap = (Map)RestResponseHelper.extractData((RestResponse)this.userExtV2QueryApi.queryCompanyNameByCusId(customerIdList));
        if (MapUtil.isNotEmpty((Map)companyMap) && refundRecordRespDto.getCustomerId() != null && companyMap.get(refundRecordRespDto.getCustomerId()) != null) {
            refundRecordRespDto.setOrganizationName(((CompanySimpleInfoDto)companyMap.get(refundRecordRespDto.getCustomerId())).getOrgName());
            refundRecordRespDto.setCustomerOrgName(((CompanySimpleInfoDto)companyMap.get(refundRecordRespDto.getCustomerId())).getOrgName());
        }
        refundRecordRespDto.setApplyTime(returnRespDto.getCreateTime());
        if (StringUtils.isNotBlank((CharSequence)returnRespDto.getExtension())) {
            ReturnLogisticsAddReqDto jsonObject = (ReturnLogisticsAddReqDto)JSONObject.parseObject((String)returnRespDto.getExtension(), ReturnLogisticsAddReqDto.class);
            refundRecordRespDto.setReturnWay(jsonObject.getReturnWay());
        }
        refundRecordRespDto.setOrderTradeStatus(returnRespDto.getReturnStatus());
        refundRecordRespDto.setOrderTradeStatusName(ReturnStatusToBEnum.toName((String)returnRespDto.getReturnStatus()));
        refundRecordRespDto.setRefundAmount(returnRespDto.getRefundAmount());
        List returnOmniItemRespDtoList = returnRespDto.getReturnOmniItemRespDtoList();
        ArrayList newItemList = Lists.newArrayList();
        if (StringUtils.isEmpty((CharSequence)returnRespDto.getDeliveryNo()) && "APP".equals(returnRespDto.getDeviceType())) {
            Map<String, List<ReturnOmniItemRespDto>> itemMap = returnOmniItemRespDtoList.stream().collect(Collectors.groupingBy(ReturnOmniItemRespDto::getSkuSerial));
            Integer totalItemNum = 0;
            for (Map.Entry<String, List<ReturnOmniItemRespDto>> entry : itemMap.entrySet()) {
                String skuSerial = entry.getKey();
                List<ReturnOmniItemRespDto> itemRespDtos = entry.getValue();
                Integer returnNum = 0;
                for (ReturnOmniItemRespDto itemRespDto : itemRespDtos) {
                    Map itemExtFields = itemRespDto.getExtFields();
                    String tempReturnNum = itemExtFields.get("returnNum") + "";
                    if (!StringUtils.isNotEmpty((CharSequence)tempReturnNum)) continue;
                    returnNum = returnNum + Integer.parseInt(tempReturnNum);
                }
                totalItemNum = totalItemNum + returnNum;
                ReturnOmniItemRespDto omniItemRespDto = itemRespDtos.get(0);
                AfterSalesItemAppDto itemAppDto = new AfterSalesItemAppDto();
                BeanUtils.copyProperties((Object)omniItemRespDto, (Object)itemAppDto);
                itemAppDto.setItemName(omniItemRespDto.getItemName());
                itemAppDto.setSkuName(omniItemRespDto.getSkuDesc());
                itemAppDto.setSkuId(Long.valueOf(omniItemRespDto.getSkuSerial()));
                itemAppDto.setNum(returnNum);
                if (StringUtils.isNotBlank((CharSequence)omniItemRespDto.getExtension())) {
                    OrderItemExtDto jsonObject = (OrderItemExtDto)JSONObject.parseObject((String)omniItemRespDto.getExtension(), OrderItemExtDto.class);
                    itemAppDto.setPath(jsonObject.getImgPath());
                    itemAppDto.setShelfType(jsonObject.getShelfType());
                }
                newItemList.add(itemAppDto);
            }
            refundRecordRespDto.setTotalItemNum(totalItemNum);
            refundRecordRespDto.setItemList((List)newItemList);
        } else {
            ArrayList itemList = Lists.newArrayList();
            Integer totalItemNum = 0;
            for (ReturnOmniItemRespDto returnOmniItemRespDto : returnOmniItemRespDtoList) {
                Map itemExtFields = returnOmniItemRespDto.getExtFields();
                String tempReturnNum = itemExtFields.get("returnNum") + "";
                if (StringUtils.isNotEmpty((CharSequence)tempReturnNum)) {
                    totalItemNum = totalItemNum + Integer.parseInt(tempReturnNum);
                }
                AfterSalesItemAppDto itemAppDto = new AfterSalesItemAppDto();
                BeanUtils.copyProperties((Object)returnOmniItemRespDto, (Object)itemAppDto);
                itemAppDto.setItemName(returnOmniItemRespDto.getItemName());
                itemAppDto.setSkuName(returnOmniItemRespDto.getSkuDesc());
                itemAppDto.setSkuId(Long.valueOf(returnOmniItemRespDto.getSkuSerial()));
                itemAppDto.setNum(Integer.valueOf(StringUtils.isNotEmpty((CharSequence)tempReturnNum) ? Integer.parseInt(tempReturnNum) : 0));
                if (StringUtils.isNotBlank((CharSequence)returnOmniItemRespDto.getExtension())) {
                    OrderItemExtDto jsonObject = (OrderItemExtDto)JSONObject.parseObject((String)returnOmniItemRespDto.getExtension(), OrderItemExtDto.class);
                    itemAppDto.setPath(jsonObject.getImgPath());
                    itemAppDto.setShelfType(jsonObject.getShelfType());
                }
                itemList.add(itemAppDto);
            }
            refundRecordRespDto.setTotalItemNum(totalItemNum);
            refundRecordRespDto.setItemList((List)itemList);
        }
        return refundRecordRespDto;
    }

    private PageInfo<AfterSalesRespDto> convertAfterSalesRespDtoPageInfo(Integer pageNum, Integer pageSize, PageInfo<ReturnRespDto> pageInfo) {
        PageInfo resultPageInfo = new PageInfo();
        resultPageInfo.setSize(pageSize.intValue());
        resultPageInfo.setPageNum(pageNum.intValue());
        if (null != pageInfo) {
            BeanCopierUtils.copy(pageInfo, (Object)resultPageInfo);
            List returnRespDtoList = pageInfo.getList();
            if (CollectionUtils.isNotEmpty((Collection)returnRespDtoList)) {
                ArrayList afterSalesRespDtoList = Lists.newArrayList();
                returnRespDtoList.forEach(returnRespDto -> {
                    AfterSalesRespDto afterSalesRespDto = new AfterSalesRespDto();
                    BeanCopierUtils.copy((Object)returnRespDto, (Object)afterSalesRespDto);
                    List returnOmniItemRespDtos = returnRespDto.getReturnOmniItemRespDtoList();
                    if (CollectionUtils.isNotEmpty((Collection)returnOmniItemRespDtos)) {
                        List afterSalesItemBeanRespDtos = BeanCopierUtils.copyList((List)returnOmniItemRespDtos, AfterSalesItemBeanRespDto.class);
                        this.handleAfterSalesItemBeanRespDtos(afterSalesItemBeanRespDtos, returnRespDto.getReturnReason());
                        afterSalesRespDto.setAfterSalesItemRespDtoList(afterSalesItemBeanRespDtos);
                    }
                    if (returnRespDto != null && returnRespDto.getUserId() != null) {
                        afterSalesRespDto.setUserName(null);
                        afterSalesRespDto.setNickName(null);
                    }
                    if (StringUtils.isNotBlank((CharSequence)returnRespDto.getExtension())) {
                        afterSalesRespDto.setReqReason(((Map)JSON.toJavaObject((JSON)JSON.parseObject((String)returnRespDto.getExtension()), Map.class)).get("reqReason").toString());
                    }
                    if (StringUtils.isNotBlank((CharSequence)returnRespDto.getRefundAmountDetail())) {
                        afterSalesRespDto.setApplyRefundAmount(new BigDecimal(((Map)JSON.toJavaObject((JSON)JSON.parseObject((String)returnRespDto.getRefundAmountDetail()), Map.class)).get("refundAmountDetail").toString()));
                    } else {
                        afterSalesRespDto.setApplyRefundAmount(returnRespDto.getRefundAmount());
                    }
                    if (!ReturnStatusEnum.FINISH.getName().equals(returnRespDto.getReturnStatus()) && !ReturnStatusEnum.REFUNDING.getName().equals(returnRespDto.getReturnStatus())) {
                        afterSalesRespDto.setRefundAmount(null);
                    }
                    afterSalesRespDto.setId(afterSalesRespDto.getTradeNo());
                    afterSalesRespDtoList.add(afterSalesRespDto);
                });
                resultPageInfo.setList((List)afterSalesRespDtoList);
            }
        }
        return resultPageInfo;
    }

    private AfterSalesDetailRespDto convertAfterSalesDetailRespDto(ReturnDetailRespDto returnDetailRespDto) {
        AfterSalesDetailRespDto afterSalesDetailRespDto = null;
        if (null != returnDetailRespDto) {
            AuditRecordRespDto recordRespDto;
            afterSalesDetailRespDto = new AfterSalesDetailRespDto();
            BeanCopierUtils.copy((Object)returnDetailRespDto, (Object)afterSalesDetailRespDto);
            if (CollectionUtils.isNotEmpty((Collection)returnDetailRespDto.getReturnOmniItemRespDtoList())) {
                List afterSalesItemBeanRespDtos = BeanCopierUtils.copyList((List)returnDetailRespDto.getReturnOmniItemRespDtoList(), AfterSalesItemBeanRespDto.class);
                this.handleAfterSalesItemBeanRespDtos(afterSalesItemBeanRespDtos, returnDetailRespDto.getReturnReason());
                afterSalesDetailRespDto.setAfterSalesItemRespDtoList(afterSalesItemBeanRespDtos);
            }
            if (CollectionUtils.isNotEmpty((Collection)returnDetailRespDto.getAuditRecordReps()) && null != (recordRespDto = (AuditRecordRespDto)returnDetailRespDto.getAuditRecordReps().get(0))) {
                BeanCopierUtils.copy(returnDetailRespDto.getAuditRecordReps().get(0), (Object)afterSalesDetailRespDto);
                if (StringUtils.isNotEmpty((CharSequence)recordRespDto.getReqMedia())) {
                    ArrayList reqMediaList = Lists.newArrayList((Object[])recordRespDto.getReqMedia().split(","));
                    afterSalesDetailRespDto.setReqMediaList((List)reqMediaList);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)returnDetailRespDto.getRefundAmountDetail())) {
                afterSalesDetailRespDto.setApplyRefundAmount(new BigDecimal(((Map)JSON.toJavaObject((JSON)JSON.parseObject((String)returnDetailRespDto.getRefundAmountDetail()), Map.class)).get("refundAmountDetail").toString()));
            } else {
                afterSalesDetailRespDto.setApplyRefundAmount(returnDetailRespDto.getRefundAmount());
            }
            if (StringUtils.isNotBlank((CharSequence)returnDetailRespDto.getExtension())) {
                afterSalesDetailRespDto.setUserName(((Map)JSON.toJavaObject((JSON)JSON.parseObject((String)returnDetailRespDto.getExtension()), Map.class)).get("userName").toString());
            }
            if (!ReturnStatusEnum.FINISH.getCode().equals(afterSalesDetailRespDto.getReturnStatus()) && !ReturnStatusEnum.REFUNDING.getCode().equals(afterSalesDetailRespDto.getReturnStatus())) {
                afterSalesDetailRespDto.setRefundAmount(null);
            }
        }
        return afterSalesDetailRespDto;
    }

    private void handleAfterSalesItemBeanRespDtos(List<AfterSalesItemBeanRespDto> afterSalesItemBeanRespDtos, String returnReason) {
        afterSalesItemBeanRespDtos.stream().forEach(bean -> {
            if (StringUtils.isNotBlank((CharSequence)bean.getExtension())) {
                bean.setItemImagePath(((Map)JSON.toJavaObject((JSON)JSON.parseObject((String)bean.getExtension()), Map.class)).get("imgPath").toString());
            }
            if (StringUtils.isNotBlank((CharSequence)returnReason)) {
                bean.setReason(returnReason);
            }
        });
    }
}

