/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.trade.biz.impl;

import com.alibaba.fastjson.JSONObject;
import com.aliyun.openservices.shade.com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.ICsDeliveryResultOrderQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.order.delivery.ITcbjDeliveryApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsDeliveryResultOrderDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsDeliveryResultOrderRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.SubTypeEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.UnitRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IUnitQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.IDeliveryApi;
import com.dtyunxi.yundt.cube.center.trade.api.constants.tob.OptBizTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.DeliveryItemReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob.OptLogReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.DeliveryItemRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.DeliveryLogisticRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderDeliveryDetailRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderDeliveryRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderDetailRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.TradeItemRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.query.IDeliveryQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.query.IOrderDeliveryQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.tob.IOptLogApi;
import com.dtyunxi.yundt.cube.center.trade.ext.api.enums.OrderQueryEnum;
import com.dtyunxi.yundt.cube.center.trade.ext.api.query.IOrderBizQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.trade.api.IDeliveryService;
import com.dtyunxi.yundt.module.trade.api.dto.MgmtDeliveryItemDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.order.DeliveredItemRespDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.order.OrderDeliveredDetailRespDto;
import com.dtyunxi.yundt.module.trade.api.enums.DeliveryStatusToBEnum;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DeliveryServiceImpl
implements IDeliveryService {
    private static final Logger logger = LoggerFactory.getLogger(DeliveryServiceImpl.class);
    @Autowired
    private IDeliveryQueryApi deliveryQueryApi;
    @Autowired
    private IDeliveryApi deliveryApi;
    @Resource
    private IOptLogApi optLogApi;
    @Resource
    private IContext context;
    @Resource
    private IOrderDeliveryQueryApi orderDeliveryQueryApi;
    @Resource
    private IUnitQueryApi unitQueryApi;
    @Resource
    private IOrderBizQueryApi orderBizQueryApi;
    @Autowired
    private IItemQueryApi itemQueryApi;
    @Autowired
    private ITcbjDeliveryApi tcbjDeliveryApi;
    @Autowired
    private ICsDeliveryResultOrderQueryApi csDeliveryResultOrderQueryApi;

    public List<DeliveryLogisticRespDto> listDeliveryLogistics(String shippingCompanyCode, String expressCode) {
        RestResponse response = this.deliveryQueryApi.listDeliveryLogistics(shippingCompanyCode, expressCode);
        return (List)RestResponseHelper.extractData((RestResponse)response);
    }

    public void confirm(String deliveryNo, String orderNo) {
        RestResponse response = this.deliveryApi.confirm(deliveryNo);
        RestResponseHelper.checkOrThrow((RestResponse)response);
        if (StringUtils.isEmpty((CharSequence)orderNo)) {
            RestResponse orderDeliveryRestResp = this.orderDeliveryQueryApi.queryOrderByDeliveryNo(deliveryNo);
            OrderDeliveryRespDto orderDeliveryRespDto = (OrderDeliveryRespDto)RestResponseHelper.extractData((RestResponse)orderDeliveryRestResp);
            orderNo = orderDeliveryRespDto.getOrderNo();
        }
        OptLogReqDto optLogDto = new OptLogReqDto();
        optLogDto.setBizType(OptBizTypeEnum.ORDER.getType());
        optLogDto.setBizNo(orderNo);
        optLogDto.setOptTime(new Date());
        optLogDto.setOptPerson(this.context.userName());
        optLogDto.setOptType("DELIVERY_ORDER_CONFIRM");
        optLogDto.setDescription("\u3010\u53d1\u8d27\u5355\u5df2\u7b7e\u6536\u3011\u53d1\u8d27\u5355\u53f7\uff1a" + deliveryNo + "\u5df2\u786e\u8ba4\u6536\u8d27\u3002");
        RestResponse longRestResponse = this.optLogApi.addBoOptLog(optLogDto);
        RestResponseHelper.extractData((RestResponse)longRestResponse);
    }

    public OrderDeliveredDetailRespDto getDetail(String deliveryNo) {
        JSONObject sjon = new JSONObject();
        sjon.put("deliveryNo", (Object)deliveryNo);
        sjon.put("instanceId", (Object)this.context.instanceId());
        sjon.put("tenantId", (Object)this.context.tenantId());
        RestResponse restResp = this.orderDeliveryQueryApi.queryDetailByPage(sjon.toJSONString(), Integer.valueOf(1), Integer.valueOf(1));
        PageInfo deliveryDetailPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)restResp);
        OrderDeliveryDetailRespDto deliveryDetailRespDto = (OrderDeliveryDetailRespDto)deliveryDetailPageInfo.getList().get(0);
        OrderDeliveredDetailRespDto deliveredDetailRespDto = new OrderDeliveredDetailRespDto();
        deliveredDetailRespDto.setDeliveryNo(deliveryDetailRespDto.getDeliveryNo());
        deliveredDetailRespDto.setOrderNo(deliveryDetailRespDto.getOrderNo());
        deliveredDetailRespDto.setDeliveryStatus(deliveryDetailRespDto.getDeliveryStatus() + "");
        deliveredDetailRespDto.setDeliveryStatusName(DeliveryStatusToBEnum.toName((String)deliveryDetailRespDto.getDeliveryStatus()));
        deliveredDetailRespDto.setDeliveryTime(deliveryDetailRespDto.getDeliveryTime());
        deliveredDetailRespDto.setShippingType(deliveryDetailRespDto.getShippingType());
        deliveredDetailRespDto.setShippingCompany(deliveryDetailRespDto.getShippingCompany());
        deliveredDetailRespDto.setShippingCompanyCode(deliveryDetailRespDto.getShippingCompanyCode());
        deliveredDetailRespDto.setExpressCode(deliveryDetailRespDto.getExpressCode());
        deliveredDetailRespDto.setShippingTime(deliveryDetailRespDto.getShippingTime());
        deliveredDetailRespDto.setRemark(deliveryDetailRespDto.getRemark());
        List deliveryItems = deliveryDetailRespDto.getDeliveryItems();
        ArrayList deliveredItems = Lists.newArrayList();
        Integer totalItemNum = 0;
        HashSet unitIds = Sets.newHashSet();
        for (DeliveryItemRespDto deliveryItem : deliveryItems) {
            if (deliveryItem.getItemNum() == 0) continue;
            DeliveredItemRespDto deliveredItemRespDto = new DeliveredItemRespDto();
            BeanUtils.copyProperties((Object)deliveryItem, (Object)deliveredItemRespDto);
            deliveredItemRespDto.setPath(deliveryItem.getItemImgPath());
            deliveredItemRespDto.setSkuName(deliveryItem.getSkuDesc());
            totalItemNum = totalItemNum + deliveryItem.getItemNum();
            BigDecimal payAmount = BigDecimal.ZERO;
            if (deliveryItem.getItemPrice() != null) {
                payAmount = deliveryItem.getItemPrice().multiply(new BigDecimal(deliveryItem.getItemNum()));
            }
            deliveredItemRespDto.setPayAmount(payAmount);
            deliveredItems.add(deliveredItemRespDto);
            if (!StringUtils.isNotEmpty((CharSequence)deliveryItem.getUnit())) continue;
            try {
                Long unitId = Long.parseLong(deliveryItem.getUnit());
                unitIds.add(unitId);
            }
            catch (NumberFormatException e) {
                logger.info("\u53d1\u8d27\u5355\u8be6\u60c5\u5217\u8868\u8fd4\u56de\u5355\u4f4d\u8f6c\u6362\u51fa\u9519>>>{}", (Object)(deliveryItem.getUnit() + deliveryItem.getTrOrderItemNo()));
            }
        }
        Map<Object, Object> unitNameMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)unitIds)) {
            List unitRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.unitQueryApi.queryByIds(StringUtils.join((Iterable)unitIds, (String)",")));
            unitNameMap = unitRespDtos.stream().collect(Collectors.toMap(unitResp -> unitResp.getId().toString(), UnitRespDto::getName, (e1, e2) -> e1));
        }
        ArrayList attrs = Lists.newArrayList((Object[])new OrderQueryEnum[]{OrderQueryEnum.ITEM});
        RestResponse orderDetailRestResp = this.orderBizQueryApi.getOrderDetail(deliveryDetailRespDto.getOrderNo(), StringUtils.join((Iterable)attrs, (String)","));
        OrderDetailRespDto orderDetailRespDto = (OrderDetailRespDto)RestResponseHelper.extractData((RestResponse)orderDetailRestResp);
        List orderItems = orderDetailRespDto.getOrderItems();
        Map<String, TradeItemRespDto> tradeItemMap = orderItems.stream().collect(Collectors.toMap(TradeItemRespDto::getTradeItemNo, item -> item, (e1, e2) -> e1));
        for (DeliveredItemRespDto deliveredItem : deliveredItems) {
            String unitName = (String)unitNameMap.get(deliveredItem.getUnit());
            TradeItemRespDto itemRespDto = tradeItemMap.get(deliveredItem.getTrOrderItemNo());
            Integer buyNum = itemRespDto.getItemNum();
            deliveredItem.setUnitName(unitName);
            deliveredItem.setBuyNum(buyNum);
            deliveredItem.setGift(itemRespDto.getGift());
        }
        deliveredDetailRespDto.setTotalItemNum(BigDecimal.valueOf(totalItemNum.intValue()));
        deliveredDetailRespDto.setDeliveredItems((List)deliveredItems);
        return deliveredDetailRespDto;
    }

    public RestResponse<PageInfo<MgmtDeliveryItemDto>> queryItemDetailPage(DeliveryItemReqDto deliveryItemReqDto) {
        if (StringUtils.isBlank((CharSequence)deliveryItemReqDto.getDeliveryNo())) {
            throw new BizException("\u53d1\u8d27\u8bb0\u5f55\u6d41\u6c34\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CsDeliveryResultOrderRespDto csDeliveryResultOrderRespDto = (CsDeliveryResultOrderRespDto)RestResponseHelper.extractData((RestResponse)this.csDeliveryResultOrderQueryApi.queryByDocumentNo(deliveryItemReqDto.getDeliveryNo()));
        logger.info("\u53d1\u8d27\u7ed3\u679c\u5355\u8be6\u60c5\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)csDeliveryResultOrderRespDto));
        if (csDeliveryResultOrderRespDto == null || CollectionUtils.isEmpty((Collection)csDeliveryResultOrderRespDto.getDeliveryResultOrderDetailRespDtoList())) {
            return new RestResponse();
        }
        OrderDetailRespDto orderDetailRespDto = (OrderDetailRespDto)RestResponseHelper.extractData((RestResponse)this.orderBizQueryApi.getOrderDetail(csDeliveryResultOrderRespDto.getPreOrderNo(), OrderQueryEnum.ITEM.name()));
        if (orderDetailRespDto == null) {
            return new RestResponse();
        }
        HashSet<String> itemIds = new HashSet<String>();
        HashMap tradeItemRespDtoMap = Maps.newHashMap();
        for (TradeItemRespDto orderItem : orderDetailRespDto.getOrderItems()) {
            if (StringUtils.isNotBlank((CharSequence)orderItem.getItemSerial())) {
                itemIds.add(orderItem.getItemSerial());
            }
            tradeItemRespDtoMap.put(orderItem.getCargoSerial(), orderItem);
        }
        ArrayList list = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(itemIds)) {
            List itemRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.itemQueryApi.queryByItemIds(StringUtils.join(itemIds, (String)",")));
            Map<String, ItemRespDto> itemMap = itemRespDtos.stream().collect(Collectors.toMap(e -> String.valueOf(e.getId()), e -> e, (e1, e2) -> e1));
            for (CsDeliveryResultOrderDetailRespDto resultOrderDetailRespDto : csDeliveryResultOrderRespDto.getDeliveryResultOrderDetailRespDtoList()) {
                TradeItemRespDto tradeItemRespDto = (TradeItemRespDto)tradeItemRespDtoMap.get(resultOrderDetailRespDto.getCargoCode());
                MgmtDeliveryItemDto mgmtDeliveryItemDto = new MgmtDeliveryItemDto();
                mgmtDeliveryItemDto.setItemCode(tradeItemRespDto.getItemCode());
                mgmtDeliveryItemDto.setItemName(tradeItemRespDto.getItemName());
                mgmtDeliveryItemDto.setBatchNo(tradeItemRespDto.getBatchNo());
                if (itemMap.containsKey(tradeItemRespDto.getItemSerial())) {
                    ItemRespDto itemRespDto = itemMap.get(tradeItemRespDto.getItemSerial());
                    mgmtDeliveryItemDto.setSubType(itemRespDto.getSubType());
                    mgmtDeliveryItemDto.setSubTypeName(SubTypeEnum.getSubTypeDesc((Integer)itemRespDto.getSubType()));
                    mgmtDeliveryItemDto.setItemTypeName(SubTypeEnum.getSubTypeDesc((Integer)itemRespDto.getSubType()));
                }
                mgmtDeliveryItemDto.setSkuDesc(tradeItemRespDto.getSkuDesc());
                mgmtDeliveryItemDto.setItemNum(Integer.valueOf(resultOrderDetailRespDto.getQuantity().intValue()));
                list.add(mgmtDeliveryItemDto);
            }
        }
        PageInfo pageInfo = new PageInfo();
        pageInfo.setList((List)list);
        return new RestResponse((Object)pageInfo);
    }
}

