/**
 * @(#)IItemProcess.java 1.0 2019/10/12
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.module.customer.api;

import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerSearchReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.AddressDto;
import com.dtyunxi.yundt.module.customer.api.dto.request.CustomerDetailReqDto;
import com.dtyunxi.yundt.module.customer.api.dto.request.UserAccountReqDto;
import com.dtyunxi.yundt.module.customer.api.dto.response.CustomerDetailAddRespDto;
import com.dtyunxi.yundt.module.customer.api.dto.response.CustomerDetailRespDto;
import com.dtyunxi.yundt.module.customer.api.dto.response.CustomerListRespDto;
import com.github.pagehelper.PageInfo;

import java.util.List;

/**
 * 客户信息服务
 *
 * @author xuhuaqiang
 */
public interface ICustomerService {

    /**
     * 新增客户信息
     *
     * @param reqDto
     * @return
     */
    CustomerDetailAddRespDto add(CustomerDetailReqDto reqDto);

    /**
     * 保存全部客户相关信息
     *
     * @param reqDto
     * @return
     */
    CustomerDetailAddRespDto saveAll(CustomerDetailReqDto reqDto);

    /**
     * 更新客户信息
     *
     * @param reqDto
     * @return
     */
    void update(CustomerDetailReqDto reqDto);

    /**
     * 创建客户账号信息
     * Created by sumo on 2020/10/9 0009
     */
    void addCustomerAccount(UserAccountReqDto userAccountReqDto);

    /**
     * 编辑客户账号信息
     * Created by sumo on 2020/10/9 0009
     */
    void updateCustomerAccount(UserAccountReqDto userAccountReqDto);
    /**
     * 分页查询客户信息列表
     *
     * @param filter
     * @return
     */
    PageInfo<CustomerListRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize);

    /***
     * 根据id查询客户信息详情
     * @param id
     * @return
     */
    CustomerDetailRespDto queryById(Long id);

    /***
     * 根据编码查询客户信息详情
     * @param code
     * @return
     */
    CustomerDetailRespDto queryByCode(String code);

    /***
     * 校验该区域下是否存在客户 true:是;false:否
     * @param regionCode
     * @return
     */
    Boolean isExistByRegionCode(String regionCode);

    /***
     *  迁移客户到指定区域下
     * @param sourceRegionCode
     * @param targetRegionCode
     * @return
     */
    void moveCustomerToRegion(String sourceRegionCode, String targetRegionCode);
    /***
     * 导出客户信息
     * @return
     */
    String exportCustomer(CustomerSearchReqDto customerSearchReqDto);
    /**
     * 不分页查询客户信息列表
     *
     * @param filter
     * @return
     */
    List<CustomerRespDto> queryByList(String filter);

    Boolean checkExportCustomer(String fileName);

    PageInfo<AddressDto> queryAddressByPage(String keyword,String addressType, Long customerId,Integer pageNum, Integer pageSize);
    AddressDto queryDefaultAddress(String addressType,Long customerId);

}
