/**
 * @(#)MemberInfoRespDto.java 1.0 2019/11/19
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.module.customer.api.dto.response;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 用户信息响应数据
 *
 * @author xuhuaqiang
 * @since 1.0.0
 */
@ApiModel(value = "UserInfoRespDto", description = "用户信息响应数据")
public class UserInfoRespDto {

    @ApiModelProperty(name = "userId", value = "用户id")
    private Long userId;

    @ApiModelProperty(name = "avatar", value = "头像")
    private String avatar;

    @ApiModelProperty(name = "userName", value = "用户名/登录名")
    private String userName;

    @ApiModelProperty(name = "customerTypeId", value = "客户类型ID")
    private Long customerTypeId;

    @ApiModelProperty(name = "customerTypeName", value = "客户类型名称")
    private String customerTypeName;

    @ApiModelProperty(name = "customerId", value = "客户ID")
    private Long customerId;

    @ApiModelProperty(name = "customerName", value = "客户名称")
    private String customerName;

    @ApiModelProperty(name = "salesmanName", value = "业务员姓名")
    private String salesmanName;

    @ApiModelProperty(name = "salesmanNo", value = "业务员编号")
    private String salesmanNo;

    @ApiModelProperty(name = "companyName", value = "公司名称")
    private String companyName;

    @ApiModelProperty(name = "phone", value = "手机号码, 选填")
    private String phone;

    @ApiModelProperty(name = "email", value = "邮箱号, 选填")
    private String email;

    @ApiModelProperty(name = "orgInfoId", value = "组织id")
    private Long orgInfoId;

    @ApiModelProperty(value = "组织名称(公司名称)，新增必填")
    private String orgName;

    @ApiModelProperty(value = "组织名称(全程)")
    private String organizationName;

    public String getOrganizationName() {
        return organizationName;
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getOrgInfoId() {
        return orgInfoId;
    }

    public void setOrgInfoId(Long orgInfoId) {
        this.orgInfoId = orgInfoId;
    }

    public String getSalesmanName() {
        return salesmanName;
    }

    public void setSalesmanName(String salesmanName) {
        this.salesmanName = salesmanName;
    }

    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public String getSalesmanNo() {
        return salesmanNo;
    }

    public void setSalesmanNo(String salesmanNo) {
        this.salesmanNo = salesmanNo;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Long getCustomerId() {
        return customerId;
    }

    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }

    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getAvatar() {
        return avatar;
    }

    public void setAvatar(String avatar) {
        this.avatar = avatar;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public Long getCustomerTypeId() {
        return customerTypeId;
    }

    public void setCustomerTypeId(Long customerTypeId) {
        this.customerTypeId = customerTypeId;
    }

    public String getCustomerTypeName() {
        return customerTypeName;
    }

    public void setCustomerTypeName(String customerTypeName) {
        this.customerTypeName = customerTypeName;
    }
}
