package com.dtyunxi.yundt.module.customer.api.enums;

/**
 * customer表的statusid关联的customer_status表的code编码值，用于判断用
 *
 * @author lsw
 * @date 2022/8/2
 *
 * @Deprecated 使用com.dtyunxi.yundt.cube.center.customer.api.constants.CustomerStatusEnum
 */
@Deprecated
public enum CustomerStatusEnum {

    ENABLED("enabled", "启用"),

    DISABLED("disabled", "禁用"),

    FREEZE("freeze", "冻结"),
    ;

    private final String code;
    private final String name;

    CustomerStatusEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public String getName() {
        return name;
    }


    public static CustomerStatusEnum fromCode(String status) {
        for (CustomerStatusEnum typeEnum : CustomerStatusEnum.values()) {
            if (typeEnum.getCode().equals(status)) {
                return typeEnum;
            }
        }
        return null;
    }

    public static String toCode(String status) {
        CustomerStatusEnum newEnum = fromCode(status);
        return newEnum == null ? null : newEnum.getCode();
    }

    public static String toName(String status) {
        CustomerStatusEnum newEnum = fromCode(status);
        return newEnum == null ? null : newEnum.getName();
    }
}
