package com.dtyunxi.yundt.module.customer.api.vo;

import cn.afterturn.easypoi.excel.annotation.Excel;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.EmployeeCustomerBlacklistReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.EmployeeCustomerReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.EmployeeRegionReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.EmployeeRoleReqDto;

import java.io.Serializable;
import java.util.List;

/**
 * @author jiejun
 * @Description 品牌端员工信息ExcelVo
 * @since 1.0.0
 */
public class B2bEmployeeExcelVo implements Serializable {


    @Excel(name = "*登录账号")
    private String account;

    @Excel(name = "角色")
    private String roleName;

    @Excel(name = "*姓名")
    private String userName;

    @Excel(name = "性别")
    private String sex;

    @Excel(name = "*职位")
    private String position;

    @Excel(name = "所属部门")
    private String department;

    @Excel(name = "工号")
    private String jobNumber;

    @Excel(name = "手机号码")
    private String phoneNumber;


    @Excel(name = "导入失败原因")
    private String errorMsg;

    /**
     * 账户ID
     */
    private Long userId;

    /**
     * 角色对象（根据角色名称获取）
     */
    private EmployeeRoleReqDto role;

    /**
     * 角色集合
     */
    private List<EmployeeRoleReqDto> roleList;

    /**
     * 管理区域对象
     */
    private EmployeeRegionReqDto area;

    /**
     * 管理区域集合
     */
    private List<EmployeeRegionReqDto> areaList;

    /**
     * 管理客户对象
     */
    private EmployeeCustomerReqDto customerDto;

    /**
     * 管理客户集合
     */
    private List<EmployeeCustomerReqDto> customerInfoList;

    /**
     * 管理客户黑名单对象
     */
    private EmployeeCustomerBlacklistReqDto customerBlackDto;

    /**
     * 管理客户黑名单集合
     */
    private List<EmployeeCustomerBlacklistReqDto> customerBlackList;

    /**
     * 是否主数据，登录账号进行合并角色、管理区域、管理客户、管理黑名单的数据，是为处理，否为被合并
     */
    private Integer ifMain;

    /**
     * 组织id
     */
    private Long orgId;

    public EmployeeCustomerReqDto getCustomerDto() {
        return customerDto;
    }

    public void setCustomerDto(EmployeeCustomerReqDto customerDto) {
        this.customerDto = customerDto;
    }

    public List<EmployeeCustomerReqDto> getCustomerInfoList() {
        return customerInfoList;
    }

    public void setCustomerInfoList(List<EmployeeCustomerReqDto> customerInfoList) {
        this.customerInfoList = customerInfoList;
    }

    public EmployeeCustomerBlacklistReqDto getCustomerBlackDto() {
        return customerBlackDto;
    }

    public void setCustomerBlackDto(EmployeeCustomerBlacklistReqDto customerBlackDto) {
        this.customerBlackDto = customerBlackDto;
    }

    public List<EmployeeCustomerBlacklistReqDto> getCustomerBlackList() {
        return customerBlackList;
    }

    public void setCustomerBlackList(List<EmployeeCustomerBlacklistReqDto> customerBlackList) {
        this.customerBlackList = customerBlackList;
    }

    public EmployeeRegionReqDto getArea() {
        return area;
    }

    public void setArea(EmployeeRegionReqDto area) {
        this.area = area;
    }

    public List<EmployeeRegionReqDto> getAreaList() {
        return areaList;
    }

    public void setAreaList(List<EmployeeRegionReqDto> areaList) {
        this.areaList = areaList;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public EmployeeRoleReqDto getRole() {
        return role;
    }

    public void setRole(EmployeeRoleReqDto role) {
        this.role = role;
    }

    public String getAccount() {
        return account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public String getRoleName() {
        return roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getSex() {
        return sex;
    }

    public void setSex(String sex) {
        this.sex = sex;
    }

    public String getPosition() {
        return position;
    }

    public void setPosition(String position) {
        this.position = position;
    }

    public String getDepartment() {
        return department;
    }

    public void setDepartment(String department) {
        this.department = department;
    }

    public String getJobNumber() {
        return jobNumber;
    }

    public void setJobNumber(String jobNumber) {
        this.jobNumber = jobNumber;
    }

    public String getPhoneNumber() {
        return phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }


    public String getErrorMsg() {
        return errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public List<EmployeeRoleReqDto> getRoleList() {
        return roleList;
    }

    public void setRoleList(List<EmployeeRoleReqDto> roleList) {
        this.roleList = roleList;
    }

    public Integer getIfMain() {
        return ifMain;
    }

    public void setIfMain(Integer ifMain) {
        this.ifMain = ifMain;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
}
