package com.dtyunxi.yundt.module.customer.api.enums;

/**
 * 校验信用代码状态
 */
public enum CompanyVerifyEnum {

    /**
     * 否
     */
    SUCCESS(1, "验证成功"),
    /**
     * 是
     */
    FAIL(0, "验证失败,三要素不一致"),
    FAIL_NAME(0, "企业名称与实际不符"),
    FAIL_LEGALPERSONNAME(0, "法人名称与实际不符"),

    ;

    private Integer code;
    private String name;

    CompanyVerifyEnum(Integer code, String name) {
        this.code = code;
        this.name = name;
    }

    public Integer getCode() {
        return code;
    }

    public String getName() {
        return name;
    }


    public static DefaultSettingEnum fromCode(Integer status) {
        for (DefaultSettingEnum typeEnum : DefaultSettingEnum.values()) {
            if (typeEnum.getCode().equals(status)) {
                return typeEnum;
            }
        }
        return null;
    }

    public static Integer toCode(Integer status) {
        DefaultSettingEnum newEnum = fromCode(status);
        return newEnum == null ? null : newEnum.getCode();
    }

    public static String toName(Integer status) {
        DefaultSettingEnum newEnum = fromCode(status);
        return newEnum == null ? null : newEnum.getName();
    }
}
