package com.dtyunxi.yundt.module.customer.api.dto.response.user;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.user.api.dto.RoleDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.EmployeeRoleReqDto;
import com.dtyunxi.yundt.module.customer.api.dto.request.user.RoleQueryReqDto;
import com.github.pagehelper.PageInfo;

import java.util.List;

/**
 * @author liangfa
 * @Description 人员角色管理接口
 * @date 2022-01-14 14:06
 * @since 1.0.0
 */
public interface IEmployeeRoleService {

    /**
     * 新增人员角色信息
     *
     * @param instanceId  实例ID
     * @param reqDto 请求dto
     * @return
     */
    RestResponse<Long> addEmployeeRole(Long instanceId, EmployeeRoleReqDto reqDto);

    /**
     * 修改人员角色信息
     *
     * @param instanceId  实例ID
     * @param reqDto 请求dto
     */
    RestResponse<Void> modifyEmployeeRole(Long instanceId, EmployeeRoleReqDto reqDto);

    /**
     * 设置超级管理员
     * @param instanceId 实例ID
     * @param reqDto 请求参数
     * @return 结果
     */

    RestResponse<Long> setSuperAdmin(Long instanceId, EmployeeRoleReqDto reqDto);

    /**
     * 分页查询角色列表
     * 
     * @param reqDto 查询请求参数
     * @return 角色列表
     */
    RestResponse<PageInfo<RoleDto>> queryPageRoleInfo(RoleQueryReqDto reqDto);

}
