package com.dtyunxi.yundt.module.customer.api.user;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.module.customer.api.dto.response.user.EmployeeAddImportDto;
import com.dtyunxi.yundt.module.customer.api.dto.response.user.EmployeeModifyImportDto;
import com.dtyunxi.yundt.module.customer.api.dto.response.user.SellerEmployeeImportDto;

import java.util.List;

/**
 * @Description 商家人员
 * @date 2022-01-14 14:06
 * @since 1.0.0
 */
public interface ISellerEmployeeExtService {

    /**
     * 商家人员导入-数据传输的时候已经校验必填字段
     * @param importDataList 导入数据列表
     * @return 处理结果
     */
    RestResponse<List<SellerEmployeeImportDto>> doSellerEmployeeImport(List<SellerEmployeeImportDto> importDataList);

    RestResponse<List<SellerEmployeeImportDto>> doSellerEmployeeImport(List<SellerEmployeeImportDto> importDataList, Integer module);

//    /**
//     * 商家人员新增导入-使用专用的新增DTO
//     * @param addDataList 新增数据列表
//     * @return 处理结果
//     */
//    RestResponse<List<EmployeeAddImportDto>> doSellerEmployeeAddImport(List<EmployeeAddImportDto> addDataList);
//
//    /**
//     * 商家人员修改导入-使用专用的修改DTO
//     * @param modifyDataList 修改数据列表
//     * @return 处理结果
//     */
//    RestResponse<List<EmployeeModifyImportDto>> doSellerEmployeeModifyImport(List<EmployeeModifyImportDto> modifyDataList);

}
