package com.dtyunxi.yundt.module.customer.api.user;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerAreaRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.entity.ImportBaseResponse;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.EmployeeExtReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.EmployeeExtRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.RoleExpandRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.UserOrgizationRespDto;
import com.dtyunxi.yundt.module.customer.api.dto.request.EmployeeImportExtReqDto;
import com.dtyunxi.yundt.module.customer.api.dto.request.user.EmployeeExpandQueryReqDto;
import com.dtyunxi.yundt.module.customer.api.dto.request.user.EmployeeExpandReqDto;
import com.dtyunxi.yundt.module.customer.api.dto.response.user.EmployeeExpandRespDto;
import com.dtyunxi.yundt.module.customer.api.vo.EmployeeExcelExtVo;
import com.github.pagehelper.PageInfo;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * @Description 用户中心：人员信息服务(定开)
 * @since 1.0.0
 */
public interface IEmployeeExpand2Service {

    /**
     * 新增人员信息
     *
     * @param reqDto 请求参数DTO
     * @return 数据ID
     */
    RestResponse<Long> addEmployee(Long instanceId, EmployeeExpandReqDto reqDto);

    /**
     * 修改人员信息
     *
     * @param reqDto 请求参数DTO
     * @return
     */
    RestResponse<Void> modifyEmployee(Long instanceId, EmployeeExpandReqDto reqDto);


    /**
     * 更新人员状态(支持批量)
     *
     * @param reqDto 请求参数DTO
     * @return
     */
    RestResponse<Void> updateStatus(Long instanceId,EmployeeExtReqDto reqDto);


    /**
     * 设置超管
     *
     * @param reqDto 请求参数DTO
     * @return
     */
    RestResponse<Void> setSuperAdmin( Long instanceId, EmployeeExtReqDto reqDto);

    /**
     * 导入人员信息
     *
     * @return 响应结果
     */
    RestResponse<ImportBaseResponse> importExcelEmployee(EmployeeImportExtReqDto importReqDto);


    /**
     * 分页查询人员信息
     *
     * @param reqDto 人员查询条件
     * @return 人员分页数据信息
     */
    RestResponse<PageInfo<EmployeeExpandRespDto>> queryByPage(EmployeeExpandQueryReqDto reqDto);

    /**
     * 查询人员详情
     *
     * @param reqDto 人员查询条件
     * @return 人员详情
     */
    RestResponse<EmployeeExpandRespDto> queryById( EmployeeExtReqDto reqDto);

    List<EmployeeExcelExtVo> processImportEmployeeExcelExtVos(List<EmployeeExcelExtVo> importDataList, Long orgId, boolean isModifyMode, Long instanceId, Set<Integer> successfulImportRows);

    /**
     * 根据组织查询人员分页信息
     * @param organizationId 组织ID
     * @return 人员分页信息
     */
    RestResponse<PageInfo<EmployeeExpandRespDto>> queryPageByOrg(Long organizationId,
                                                               Integer pageNum,
                                                              Integer pageSize);

    RestResponse<List<Long>> getEmployeeOrgIdByUserId(Long userId);

    /**
     * 根据角色获取人员信息
     * @param roleId 角色ID
     * @param instanceId 实例ID
     * @return 结果
     */
    RestResponse<List<EmployeeExtRespDto>> queryByRole(Long roleId,Long instanceId);


    RestResponse<List<OrganizationDto>> getOrgInfoByUserId(Long userId);

    /*导入时获取需要校验相关信息map*/
    Map<String,CustomerRespDto> getOrgCustomerMap(List<String> customerCodeList);

    Map<String, List<RoleExpandRespDto>> getRoleMap(List<String> roleNameList, Long orgId);

    Map<String, List<UserOrgizationRespDto>> getAccoutMap(List<String> accountList);

    Map<String, List<CustomerAreaRespDto>>  getCustomerAreaMap(List<String> governAreaList, Long orgId);

    Map<String,Long> getEmployeeMap(List<Long> userIdList,List<Long> orgIdList );

    Map<String,OrganizationDto> getOrgByNameMap(List<String> nameList);

}
