/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.customer.biz.mq.process;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.biz.commons.utils.EasyPoiExportUtil;
import com.dtyunxi.cube.biz.commons.utils.ExcelUtil;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.huieryun.oss.api.IObjectStorageService;
import com.dtyunxi.huieryun.oss.vo.OssRegistryVo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.ICustomerDataApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerImportSaveReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerInfoExcelReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.ImportEventReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.ImportUpdateReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.enmus.ImportStatusEnum;
import com.dtyunxi.yundt.module.customer.biz.service.ICustomerImportLogService;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Component;

@Component
@MQDesc(topic="${icomb.common.topic.customer.import:CUSTOMER_INFO_IMPORT_TOPIC}", tag="CUSTOMER_INFO_IMPORT_TAG")
public class CustomerInfoImportProcessor
implements IMessageProcessor<CustomerImportSaveReqDto> {
    @Resource
    private ICacheService cacheService;
    @Resource
    private IObjectStorageService objectStorageService;
    @Resource
    private ICustomerDataApi iCustomerDataApi;
    @Resource
    private ICustomerImportLogService customerImportLogService;
    @Resource
    private OssRegistryVo ossRegistryVo;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageResponse process(CustomerImportSaveReqDto eventDto) {
        this.logger.info("\u5ba2\u6237\u6279\u91cf\u5bfc\u5165 ---> \u6536\u5230\u6279\u91cf\u5ba2\u6237\u4fe1\u606f\u6279\u91cf\u5bfc\u5165\u7684MQ\u6d88\u606f" + eventDto.getTenantId());
        ServiceContext.getContext().setAttachment("yes.req.tenantId", String.valueOf(eventDto.getTenantId()));
        ServiceContext.getContext().setAttachment("yes.req.instanceId", String.valueOf(eventDto.getInstanceId()));
        MDC.put((String)"yes.req.requestId", (String)UUID.randomUUID().toString().replace("-", ""));
        this.logger.info("\u5ba2\u6237\u6279\u91cf\u5bfc\u5165 ---> \u6536\u5230\u6279\u91cf\u5ba2\u6237\u4fe1\u606f\u6279\u91cf\u5bfc\u5165\u7684MQ\u6d88\u606f:{}", (Object)(JSON.toJSONString((Object)eventDto) + "instanceId" + ServiceContext.getContext().getRequestInstanceId()));
        if (eventDto.getUrl() == null) {
            this.logger.error("\u6d88\u606f\u4f53\u5185\u5bb9\u4e0d\u5168\uff0c\u5ffd\u7565\u5904\u7406");
            return MessageResponse.SUCCESS;
        }
        if (StringUtils.isNotBlank((CharSequence)((CharSequence)this.cacheService.getCache("customerExcelImportKey", eventDto.getId() + "", String.class)))) {
            return MessageResponse.SUCCESS;
        }
        this.cacheService.setCache("customerExcelImportKey", eventDto.getId() + "", (Object)"{}", 10);
        ImportUpdateReqDto memberImportRespDto = new ImportUpdateReqDto();
        try {
            long currentTimeMillis = System.currentTimeMillis();
            this.logger.info("\u5ba2\u6237\u6279\u91cf\u5bfc\u5165\u8fdb\u884c\u4e2d ---> \u5f00\u59cb\u4e0b\u8f7dexcel");
            InputStream is = this.getInputStream(eventDto.getUrl());
            this.logger.info("\u5ba2\u6237\u6279\u91cf\u5bfc\u5165\u8fdb\u884c\u4e2d ---> \u5f00\u59cb\u8bfb\u53d6excel");
            ExcelImportResult objectExcelImportResult = EasyPoiExportUtil.importExcel((InputStream)is, (Integer)0, (Integer)1, CustomerInfoExcelReqDto.class);
            this.logger.info("\u5ba2\u6237\u6279\u91cf\u5bfc\u5165\u8fdb\u884c\u4e2d ---> \u8bfb\u53d6excel\u6210\u529f,\u65f6\u95f4\u82b1\u8d39{}\u6beb\u79d2", (Object)(System.currentTimeMillis() - currentTimeMillis));
            List customerInfoExcelReqDtos = objectExcelImportResult.getList();
            this.logger.info("\u5ba2\u6237\u6279\u91cf\u5bfc\u5165\u8fdb\u884c\u4e2d --->\u63d0\u53d6\u6570\u636e\u6210\u529f,\u6570\u636e\u91cf" + customerInfoExcelReqDtos.size());
            if (customerInfoExcelReqDtos.isEmpty() || customerInfoExcelReqDtos.size() > 50000) {
                this.logger.error("\u5ba2\u6237\u4fe1\u606f\u6279\u91cf\u5bfc\u5165\u6570\u636e\u4e3a\u7a7a\u6216\u8005\u8d85\u8fc7\u6700\u5927\u6570\u91cf");
                ImportUpdateReqDto eo = new ImportUpdateReqDto();
                eo.setId(eventDto.getId());
                eo.setStatus(ImportStatusEnum.EMPTY.getCode());
                eo.setTotalNum(Integer.valueOf(0));
                eo.setErrorNum(Integer.valueOf(0));
                eo.setSuccessNum(Integer.valueOf(0));
                eo.setRepeatNum(Integer.valueOf(0));
                eo.setErrorReason("\u5ba2\u6237\u4fe1\u606f\u6279\u91cf\u5bfc\u5165\u6570\u636e\u4e3a\u7a7a\u6216\u8005\u8d85\u8fc7\u6700\u5927\u6570\u91cf");
                this.iCustomerDataApi.update(eo);
                MessageResponse messageResponse = MessageResponse.SUCCESS;
                return messageResponse;
            }
            ImportEventReqDto importEventReqDto = new ImportEventReqDto();
            BeanUtils.copyProperties((Object)eventDto, (Object)importEventReqDto);
            importEventReqDto.setCustomerInfoExcelReqList(customerInfoExcelReqDtos);
            int totalSize = customerInfoExcelReqDtos.size();
            this.customerImportLogService.importCustomer(importEventReqDto, dataValidateResult -> {
                String downloadUrl = null;
                if (dataValidateResult.getErrorCustomerInfoExcelList().size() > 0) {
                    String fileName = "\u5ba2\u6237\u4fe1\u606f\u9519\u8bef\u5217\u8868" + DateUtil.getDateFormat((Date)new Date(), (String)"yyyyMMddHHmmss") + String.format("%02d", new Random().nextInt(100)) + ".xlsx";
                    InputStream inputStream = ExcelUtil.createExcel((String[])new String[]{"\u5ba2\u6237\u4fe1\u606f\u9519\u8bef\u5217\u8868"}, (Object[])new Object[]{dataValidateResult.getErrorCustomerInfoExcelList()});
                    this.objectStorageService.put(this.ossRegistryVo.getBucketName(), fileName, inputStream);
                    downloadUrl = this.objectStorageService.getFileUrl(fileName);
                    this.logger.info("\u5ba2\u6237\u6279\u91cf\u5bfc\u5165 ---> \u4e0a\u4f20\u9519\u8bef\u7684Excel\u6210\u529f\uff0c\u8fde\u63a5\u5730\u5740\uff1a{}", (Object)downloadUrl);
                }
                Integer errorNum = dataValidateResult.getErrorCustomerInfoExcelList().size();
                Integer successNum = dataValidateResult.getCustomerInfoExcelList().size();
                memberImportRespDto.setTotalNum(Integer.valueOf(totalSize));
                memberImportRespDto.setErrorNum(errorNum);
                memberImportRespDto.setSuccessNum(Integer.valueOf(totalSize - errorNum));
                memberImportRespDto.setStatus(ImportStatusEnum.LOADING.getCode());
                memberImportRespDto.setErrorReason(downloadUrl);
                this.logger.info("\u5ba2\u6237\u6279\u91cf\u5bfc\u5165 ---> \u603b\u6570\u91cf:{} \u4e0d\u5408\u683c\u7684\u6570\u636e\u91cf\uff1a{}\uff0c\u5408\u683c\u7684\u6570\u636e\u91cf\uff1a{}", new Object[]{memberImportRespDto.getTotalNum(), errorNum, successNum});
                return true;
            });
            memberImportRespDto.setStatus(ImportStatusEnum.SUCCESS.getCode());
        }
        catch (Exception e) {
            this.logger.error("", (Throwable)e);
            e.printStackTrace();
            this.logger.info("\u5ba2\u6237\u6279\u91cf\u5bfc\u5165\u5f02\u5e38 ---> \u4e0d\u4f1a\u88ab\u91cd\u65b0\u6295\u9012");
            memberImportRespDto.setStatus(ImportStatusEnum.ERROR.getCode());
            MessageResponse messageResponse = MessageResponse.SUCCESS;
            return messageResponse;
        }
        finally {
            memberImportRespDto.setId(eventDto.getId());
            this.iCustomerDataApi.update(memberImportRespDto);
        }
        return MessageResponse.SUCCESS;
    }

    private InputStream getInputStream(String fileUrl) throws IOException {
        URL url = new URL(fileUrl);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        return conn.getInputStream();
    }
}

