/**
 * @(#)LoginImpl.java 1.0 2019年7月12日
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.module.customer.biz.impl.user;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.biz.commons.utils.Assert;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.ObjectHelper;
import com.dtyunxi.dto.RequestDto;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.icommerce.module.dao.das.TenantGuideDas;
import com.dtyunxi.icommerce.module.dao.eo.TenantGuideEo;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.Base64;
import com.dtyunxi.util.JacksonUtil;
import com.dtyunxi.yundt.cube.bundle.org.center.user.api.query.IPostAssignmentQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.RCustomerSalesmanRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerSalesmanQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CustomerSearchExtReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.query.IEmployeeCustomerQueryApi;
import com.dtyunxi.yundt.cube.center.identity.api.ITokenApi;
import com.dtyunxi.yundt.cube.center.identity.api.IVerifyCodeApi;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.UserLoginReqDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.response.TokenRespDto;
import com.dtyunxi.yundt.cube.center.user.api.IAuthorizeApi;
import com.dtyunxi.yundt.cube.center.user.api.ISecurityApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.UserDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.UserModifyPasswordDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryExtApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IUserQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.customer.api.dto.request.ResetPasswordReqDto;
import com.dtyunxi.yundt.module.customer.api.dto.response.TenantGuideRespDto;
import com.dtyunxi.yundt.module.customer.api.enums.SrcTypeEnum;
import com.dtyunxi.yundt.module.customer.api.exception.CustomerModuleExceptionCode;
import com.dtyunxi.yundt.module.customer.api.user.IAuthentication;
import com.dtyunxi.yundt.module.customer.api.user.dto.response.CurrentPartner;
import com.dtyunxi.yundt.module.customer.api.user.dto.response.H5LoginDtoResp;
import com.dtyunxi.yundt.module.customer.api.user.dto.response.HttpResponseDto;
import com.dtyunxi.yundt.module.customer.biz.util.HttpExtUtil;
import com.dtyunxi.yundt.module.customer.bo.LoginInfo;
import com.dtyunxi.yundt.module.customer.bo.TokenInfo;
import com.dtyunxi.yundt.module.domain.util.ConvertUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import com.github.pagehelper.PageInfo;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 认证服务实现
 *
 * @author wu.sheng
 * @time 2019年7月12日 上午10:09:58
 */
@Component
public class AuthenticationImpl implements IAuthentication {

    private static final Logger logger = LoggerFactory.getLogger(AuthenticationImpl.class);

    private static final String h5Pwd = "ZJJK123456";
    @Resource
    private ITokenApi tokenApi;

    @Resource
    private IContext context;
    @Resource
    IVerifyCodeApi verifyCodeApi;

    @Resource
    private ISecurityApi securityApi;

    @Resource
    private IUserQueryApi userQueryApi;

    @Resource
    private IAuthorizeApi authorizeApi;

    @Resource
    private ICacheService cacheService;

    @Resource
    private TenantGuideDas tenantGuideDas;

    @Resource
    private IOrganizationQueryApi organizationQueryApi;
    @Resource
    private IOrganizationQueryExtApi organizationQueryExtApi;
    @Resource
    private HttpExtUtil httpExtUtil;

    @Resource
    private IPostAssignmentQueryApi postAssignmentQueryApi;

    @Value("${marketing.cloud.h5.login.url:https://nyxyapp.by-health.com/micro-csp/simpleLogin}")
    private String h5LoginUrl;

    @Value("${marketing.cloud.h5.login:false}")
    private Boolean isCloudH5Login;
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;
    @Resource
    private ICustomerSalesmanQueryApi customerSalesmanQueryApi;
    @Resource
    private IEmployeeCustomerQueryApi employeeCustomerQueryApi;

    @Value("${icommerceb.post.postCode}")
    private String sysPostCode;


    //是否开启主数据相关配置 true 开启，默认关闭
    @Value("${comm.master.data.onoff:false}")
    private Boolean onoffFlag;

    public AuthenticationImpl() {
    }


    /**
     * 登录
     */
    @Override
    public TokenInfo login(LoginInfo loginInfo) {

        if (loginInfo.getType() != 1){
            // 是否使用营销云登陆
            if (isCloudH5Login){
                return newLogin(loginInfo);
            }
        }

        UserLoginReqDto userLoginReqDto = convert2UserLoginReqDto(loginInfo);
        userLoginReqDto.setInstanceId(context.instanceId());
        userLoginReqDto.setTenantId(context.tenantId());


        Long instanceId = context.instanceId();
        logger.info("登录instanceId={}",instanceId);
        String applicationKey = ServiceContext.getContext().getAttachment("Application-Key");
        logger.info("登录applicationKey={}",applicationKey);

        logger.info("登录参数userLoginReqDto={}", ObjectHelper.bean2Json(userLoginReqDto));
        RestResponse<TokenRespDto> restResponse = tokenApi.createToken(userLoginReqDto);
        TokenRespDto tokenRespDto = RestResponseHelper.extractData(restResponse);


        if (null == tokenRespDto) {
            throw new BizException(CustomerModuleExceptionCode.LOGIN_FAIL.getCode(),
                    CustomerModuleExceptionCode.LOGIN_FAIL.getMsg());
        }

        //判断如果是业务员小程序端，则需要校验该用户的岗位信息为业务员
        if (SrcTypeEnum.SALESMAN.getCode().equals(loginInfo.getSrcType())) {
            //TCBJ项目业务员逻辑简单化，只校验当前登录人作为业务员绑定了客户即可
            //todo start 2022-03-17 注释掉客户人员关联查询，改为查询当前登录人绑定的有效客户
            if(onoffFlag){
                CustomerSearchExtReqDto customerSearchDto = new CustomerSearchExtReqDto();
                customerSearchDto.setSalesmanId(tokenRespDto.getUserId());
                PageInfo<CustomerRespDto> customerRespDtoPageInfo = RestResponseHelper.extractData(employeeCustomerQueryApi.queryValidCustomerPage(customerSearchDto));
                if (CollectionUtils.isEmpty(customerRespDtoPageInfo.getList())) {
                    throw new BizException(CustomerModuleExceptionCode.SALESMAN_LOGIN_FAIL.getCode(),
                            CustomerModuleExceptionCode.SALESMAN_LOGIN_FAIL.getMsg());
                }
            }else{
                RestResponse<List<RCustomerSalesmanRespDto>> listRestResp = customerSalesmanQueryApi.queryByUserId(tokenRespDto.getUserId());
                List<RCustomerSalesmanRespDto> customerRespDtos = RestResponseHelper.extractData(listRestResp);
                if (CollectionUtils.isEmpty(customerRespDtos)) {
                    throw new BizException(CustomerModuleExceptionCode.SALESMAN_LOGIN_FAIL.getCode(),
                            CustomerModuleExceptionCode.SALESMAN_LOGIN_FAIL.getMsg());
                }
            }
            //2022-03-17 end

//            RestResponse<List<EmployeeDto>> listRestResp = organizationQueryApi.queryEmployeeByUserId(tokenRespDto.getUserId(), "{}");
//            List<EmployeeDto> employeeDtoList = RestResponseHelper.extractData(listRestResp);
//            if (CollectionUtils.isEmpty(employeeDtoList)){
//                throw new BizException(CustomerModuleExceptionCode.SALESMAN_LOGIN_FAIL.getCode(),
//                        CustomerModuleExceptionCode.SALESMAN_LOGIN_FAIL.getMsg());
//            }
//            EmployeeDto employeeDto = employeeDtoList.get(0);
//            RestResponse<List<PostPagerRespDto>> postPagerRestResp = postAssignmentQueryApi.postList(employeeDto.getEmployeeNo());
//            List<PostPagerRespDto> postPagerRespList = RestResponseHelper.extractData(postPagerRestResp);
//            if (CollectionUtils.isEmpty(postPagerRespList)){
//                throw new BizException(CustomerModuleExceptionCode.SALESMAN_LOGIN_FAIL.getCode(),
//                        CustomerModuleExceptionCode.SALESMAN_LOGIN_FAIL.getMsg());
//            }
//            Boolean flag = false;
//            for (PostPagerRespDto postPagerRespDto : postPagerRespList) {
//                if (postPagerRespDto.getCode().equals(sysPostCode)){
//                    flag = true;
//                }
//            }
//            if (!flag){
//                throw new BizException(CustomerModuleExceptionCode.SALESMAN_LOGIN_FAIL.getCode(),
//                        CustomerModuleExceptionCode.SALESMAN_LOGIN_FAIL.getMsg());
//            }
        }

        TokenInfo tokenInfo = ConvertUtil.convert(restResponse.getData(), TokenInfo.class);
        UserDto userDto = userQueryApi.queryById(restResponse.getData().getUserId(), null).getData();
        tokenInfo.setUserType(userDto.getUserType());
        tokenInfo.setPhone(userDto.getPhone());
        tokenInfo.setInstanceId(userLoginReqDto.getInstanceId());
        tokenInfo.setTenantId(userLoginReqDto.getTenantId());
        // 非邀请注册的才需要查询组织
        if (loginInfo.getType() != 1){
            //获取登录人绑定的组织
            RestResponse<Long> longRestResp = customerExtQueryApi.queryOrgIdByUserId(tokenInfo.getUserId());
            Long orgId = RestResponseHelper.extractData(longRestResp);
            tokenInfo.setOrgInfoId(orgId);
        }

//        //获取首次登录标识
//        String firstLoginFlag = this.getFirstLoginFlag(tokenInfo.getUserId().toString());
//        if ("1".equals(firstLoginFlag)){
//            tokenInfo.setIsFirstLogin(0);
//        } else {
//            tokenInfo.setIsFirstLogin(1);
//        }
        tokenInfo.setIsFirstLogin(0);
        return tokenInfo;
    }

    /**
     * LoginInfo转UserLoginReqDto
     *
     * @param loginInfo
     * @return
     * @author wu.sheng
     * @time 2019年8月1日 下午4:40:06
     * @version
     */
    private UserLoginReqDto convert2UserLoginReqDto(LoginInfo loginInfo) {
        UserLoginReqDto userLoginReqDto = new UserLoginReqDto();
        userLoginReqDto.setLoginType(loginInfo.getLoginType());
        userLoginReqDto.setIdCode(loginInfo.getLoginName());
        userLoginReqDto.setCode(loginInfo.getCaptcha());
        userLoginReqDto.setUniqueId(loginInfo.getCaptchaId());
        userLoginReqDto.setCheckCode(loginInfo.getCaptcha());
        userLoginReqDto.setCheckCodeUniqueId(loginInfo.getCaptchaId());
        userLoginReqDto.setPhone(loginInfo.getLoginName());
        userLoginReqDto.setUserName(loginInfo.getLoginName());
        userLoginReqDto.setPassword(loginInfo.getPassword());
        userLoginReqDto.setEmail(loginInfo.getLoginName());

        if (null != loginInfo.getKeepDays()) {
            // token有效时间天转秒
            Integer tokenValidTime = loginInfo.getKeepDays() * 24 * 3600;
            userLoginReqDto.setTokenValidTime(tokenValidTime);
        }

        return userLoginReqDto;
    }

    /**
     * 注销
     */
    @Override
    public void logout(Long userId) {
        RestResponse<Void> restResponse = tokenApi.deleteToken(String.valueOf(userId));
        RestResponseHelper.checkOrThrow(restResponse);
    }

    /**
     * 修改密码
     */
    @Override
    public void modifyPassword(String userName, String password, String newPassword) {
        UserModifyPasswordDto userModifyPasswordDto = new UserModifyPasswordDto();
        userModifyPasswordDto.setInstanceId(context.instanceId());
        userModifyPasswordDto.setNewPassword(newPassword);
        userModifyPasswordDto.setPassword(password);
        userModifyPasswordDto.setUserName(userName);
        RestResponse<Void> voidRestResponse = securityApi.modifyPassword(userModifyPasswordDto);
        RestResponseHelper.checkOrThrow(voidRestResponse);

    }

    /**
     * 根据手机或邮箱验证码重置用户密码
     */
    @Override
    public void resetPassword(ResetPasswordReqDto resetPasswordReqDto) {
        if (resetPasswordReqDto.getType() == null) {
            throw new BizException("验证码类型错误");
        }
        // 发送类型： 1 短信 2 邮箱
        // 中台校验类型:1图像验证码，2手机验证码，3邮箱验证码
        // 保持一直进行转换
        switch (resetPasswordReqDto.getType()) {
            case 1:
                resetPasswordReqDto.setType(2);
                break;
            default:
                throw new BizException("验证码类型错误");
        }
        RequestDto requestDto = new RequestDto();
        requestDto.setInstanceId(context.instanceId());
        requestDto.setTenantId(context.tenantId());

        if (!resetPasswordReqDto.getCaptchaId().contains(resetPasswordReqDto.getTarget())) {
            throw new BizException("修改验证码和手机不一致");
        }
        RestResponse<Boolean> restResponse1 = verifyCodeApi.checkVerifyCode(resetPasswordReqDto.getCaptcha(), resetPasswordReqDto.getCaptchaId(), resetPasswordReqDto.getType());
        Boolean isCheck = RestResponseHelper.extractData(restResponse1);
        if (!isCheck) {
            throw new BizException("验证码错误");
        }
        RestResponse<UserDto> userDtoRestResponse = userQueryApi.queryByPhone(resetPasswordReqDto.getTarget(), JSON.toJSONString(requestDto));
        UserDto userDto = RestResponseHelper.extractData(userDtoRestResponse);
        if (userDto == null) {
            throw new BizException("手机号无法到查询用户信息");
        }
        RestResponse<Void> restResponse = securityApi.resetPasswordByAdmin(userDto.getId(), resetPasswordReqDto.getNewPassword());
        RestResponseHelper.checkOrThrow(restResponse);
    }

    @Override
    public void resetPassword(Long userId, String newPassword) {
        RestResponse<Void> restResponse = securityApi.resetPasswordByAdmin(userId, newPassword);
        RestResponseHelper.checkOrThrow(restResponse);
        //设置首次登录标识
        Boolean flag = this.setFirstLoginFlag(userId.toString());

    }

    /**
     * 手机号码绑定
     *
     * @param userId 用户id
     * @param phone  手机号码
     */
    @Override
    public void bindPhone(Long userId, String phone) {

        RestResponse<Long> restResponse = authorizeApi.bindPhone(context.instanceId(), userId, phone);

        RestResponseHelper.extractData(restResponse);
    }

    /**
     * 手机号码解绑
     *
     * @param userId 用户id
     * @param phone  手机号码
     */
    @Override
    public void unbindPhone(Long userId, String phone) {
        RestResponse<Long> restResponse = authorizeApi.unbindPhone(context.instanceId(), userId, phone);

        RestResponseHelper.extractData(restResponse);
    }

    @Override
    public TenantGuideRespDto tenantGuide(Long tenantId) {

        TenantGuideRespDto guideRespDto = new TenantGuideRespDto();

        TenantGuideEo selectGuide = new TenantGuideEo();
        selectGuide.setTenantId(tenantId);
        List<TenantGuideEo> guideEos = tenantGuideDas.select(selectGuide);
        if (CollectionUtils.isNotEmpty(guideEos)) {
            BeanUtils.copyProperties(guideEos.get(0), guideRespDto);
        }

        return guideRespDto;
    }

    @Override
    public TokenInfo newLogin(LoginInfo loginInfo) {

         // 1.调用营销云的接口校验登陆信息是否正确
        List<H5LoginDtoResp> list = postImarketingServiceLogin(loginInfo);


        UserLoginReqDto userLoginReqDto = convert2UserLoginReqDto(loginInfo);
        userLoginReqDto.setInstanceId(context.instanceId());
        userLoginReqDto.setTenantId(context.tenantId());

        userLoginReqDto.setPassword(Base64.encodeString(h5Pwd).replaceAll("=",""));
        logger.info("登录参数userLoginReqDto={}", ObjectHelper.bean2Json(userLoginReqDto));
        RestResponse<TokenRespDto> restResponse = tokenApi.createToken(userLoginReqDto);
        logger.info("登录返回的结果={}", restResponse.getData());
        TokenRespDto tokenRespDto = RestResponseHelper.extractData(restResponse);


        if (null == tokenRespDto) {
            throw new BizException(CustomerModuleExceptionCode.LOGIN_FAIL.getCode(),
                    CustomerModuleExceptionCode.LOGIN_FAIL.getMsg());
        }
        TokenInfo tokenInfo = ConvertUtil.convert(restResponse.getData(), TokenInfo.class);
        CurrentPartner currentPartner = list.get(0).getCurrentPartner();
        // 如果是true就是租户，如果是false就是业务员
        if (currentPartner != null && StringUtils.equals("true", currentPartner.getOrg())) {
           // todo 如果是组织，需要通过营销云id的查询中台的组织id(营销云的id对应中台的编码)
            List<String> orgCodes = list.stream().map(H5LoginDtoResp::getId).collect(Collectors.toList());
            List<OrganizationDto> organizationDtoList = organizationQueryApi.queryListByOrgCode(-1L, orgCodes).getData();
            if (CollectionUtils.isNotEmpty(organizationDtoList)){
                // todo 暂时取第一个,后续再跟进这个问题
                tokenInfo.setOrgInfoId(organizationDtoList.get(0).getId());
            }
        }

        tokenInfo.setIsFirstLogin(0);
        return tokenInfo;
    }

    private List<H5LoginDtoResp> postImarketingServiceLogin(LoginInfo loginInfo) {
        Map<String, Object> mapParam = new HashMap<>();
        mapParam.put("password", Base64.decodeString(loginInfo.getPassword().getBytes(StandardCharsets.UTF_8)));
        mapParam.put("account", loginInfo.getLoginName());
        HttpResponseDto httpResponseDto = httpExtUtil.httpPost(h5LoginUrl, mapParam, HttpResponseDto.class);
        logger.info("调用营销云H5登陆返回的结果为:{}", JacksonUtil.toJson(httpResponseDto));
        Assert.isTrue(httpResponseDto != null, "1000001", "用户名或者密码报错");
        String errorCode = httpResponseDto.getErrorCode();
        Assert.isTrue("0000".equals(errorCode), "100000", "用户名或者密码报错");
        Object returnObject = httpResponseDto.getReturnObject();
        return  JacksonUtil.readValue(JacksonUtil.toJson(returnObject), new TypeReference<List<H5LoginDtoResp>>() {});
    }

    /**
     * 获取首次登录标记缓存key
     *
     * @param userId
     * @return
     */
    private String getFirstLoginCacheKey(String userId) {
        StringBuffer sb = new StringBuffer();
        sb.append("FIRST_LOGIN").append(":").append(userId);
        return sb.toString();
    }

    /**
     * 获取用户首次登录标记
     *
     * @param userId
     * @return
     */
    public String getFirstLoginFlag(String userId) {
        return cacheService.getCache(getFirstLoginCacheKey(userId), String.class);
    }

    /**
     * 设置用户首次登录标记
     *
     * @param userId
     * @return
     */
    public Boolean setFirstLoginFlag(String userId) {
        String cacheKey = getFirstLoginCacheKey(userId);
        Long result = cacheService.setnx(cacheKey, "1");
        return result == 1;
    }


}
