package com.dtyunxi.yundt.module.customer.biz.service;

import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.ImportEventReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.*;
import com.dtyunxi.yundt.cube.center.user.api.dto.UserDto;

import java.util.List;
import java.util.function.Predicate;

/**
 * 客户导入记录
 * @author sumo on 2020/10/13 0013
 */
public interface ICustomerImportLogService {


    /**
     * 对Excel批量导入的信息进行校验
     *
     * @param importEventReqDto
     * @param customerTypeEos           有效的客户类型
     * @param customerStatusRespDtoList 获取所有客户状态
     * @param regionNameList      获取所有区域
     * @param userDtoList               业务员
     */
    CustomerImportDataValidateRespDto importDataVerify(ImportEventReqDto importEventReqDto, List<CustomerTypeRespDto> customerTypeEos, List<CustomerStatusRespDto> customerStatusRespDtoList,
                                                       List<String> regionNameList, List<UserDto> userDtoList,List<CustomerRespDto> customerRespList,List<CustomerLevelRespDto> levelList);

    /**
     * 导入
     *
     * @param importEventReqDto         导入的信息
     * @param dataValidateResultHandler 导入的数据格式校验结果处理
     */
    void importCustomer(ImportEventReqDto importEventReqDto, Predicate<CustomerImportDataValidateRespDto> dataValidateResultHandler);
}
