package com.dtyunxi.yundt.module.customer.biz.service.impl;

import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.biz.commons.utils.Assert;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.mj.biz.commons.utils.EasyPoiExportUtil;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.center.openapi.api.IMapApi;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.company.CompanyVerifyReqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.MapTextRespDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.company.CompanyVerifyRespDto;
import com.dtyunxi.tcbj.module.settlement.biz.service.SettlementAccountRegisterRelationService;
import com.dtyunxi.yundt.cube.center.customer.api.IImportRecordApi;
import com.dtyunxi.yundt.cube.center.customer.api.constants.BizImportEnum;
import com.dtyunxi.yundt.cube.center.customer.api.constants.IsCustomerEnum;
import com.dtyunxi.yundt.cube.center.customer.api.constants.StoreDataOriginEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.constants.CustomerTypeEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.constants.StoreDataOriginEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.enmus.ImportStatusEnum;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.ImportRecordReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.StoreAreaRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.query.IStoreAreaQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.customer.api.ICustomerExtService;
import com.dtyunxi.yundt.module.customer.api.enums.BizChannelEnum;
import com.dtyunxi.yundt.module.customer.api.enums.CompanyVerifyEnum;
import com.dtyunxi.yundt.module.customer.api.enums.DefaultSettingEnum;
import com.dtyunxi.yundt.module.customer.biz.constant.StoreConstant;
import com.dtyunxi.yundt.module.customer.biz.service.IStoreService;
import com.dtyunxi.yundt.module.customer.biz.util.BeanPropertyNullUtil;
import com.dtyunxi.yundt.module.customer.biz.vo.StoreExportVo;
import com.google.common.collect.Lists;
import com.yx.tcbj.center.customer.api.ICustomerSyncCreditApi;
import com.yx.tcbj.center.customer.api.IStoreApi;
import com.yx.tcbj.center.customer.api.dto.request.FindCustomerByCreditReqDto;
import com.yx.tcbj.center.customer.api.dto.request.store.StoreReqDto;
import com.yx.tcbj.center.customer.api.dto.response.store.StoreRespDto;
import com.yx.tcbj.center.customer.api.query.IStoreQueryApi;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import java.util.*;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

@Service
public class StoreServiceImpl implements IStoreService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Resource
    private IStoreApi storeApi;

    @Resource
    private ICustomerSyncCreditApi customerSyncCreditApi;

    @Resource
    private IStoreQueryApi storeQueryApi;

    @Resource
    private IStoreAreaQueryApi storeAreaQueryApi;

    @Resource
    private IMapApi mapApi;

    @Resource
    private IContext context;

    @Resource
    private IImportRecordApi importRecordApi;

    @Resource
    private ApplicationContext applicationContext;
    @Resource
    private SettlementAccountRegisterRelationService settlementAccountRegisterRelationService;

    AtomicInteger counter = new AtomicInteger(1);

    /**
     * 处理药店数据导入
     */
    private final ThreadPoolExecutor importExecutor = new ThreadPoolExecutor(
            Runtime.getRuntime().availableProcessors(),
            Runtime.getRuntime().availableProcessors() * 4,
            60 * 2,
            TimeUnit.SECONDS,
            new ArrayBlockingQueue<>(3, true),
            (r) -> new Thread(r, "Thread-import[" + counter.addAndGet(1) + "]"),
            new ThreadPoolExecutor.CallerRunsPolicy()
    );

    @Override
    @Transactional(rollbackFor = Exception.class)
    public RestResponse<Void> saveOrUpdateStore(StoreReqDto reqDto) {
        //校验当前门店类型与上级门店是否大客户类型
        if (StringUtils.isNotBlank(reqDto.getParentSocialCreditNum())) {
            RestResponse<StoreRespDto> storeRespDtoRestResponse = storeQueryApi.queryStoreRespDtoByCreditNum(reqDto.getParentSocialCreditNum());
            StoreRespDto storeRespDto = RestResponseHelper.extractData(storeRespDtoRestResponse);
            Assert.isTrue(!ObjectUtils.isEmpty(storeRespDto), "0001", "当前上级门店不存在！！！");
            logger.info("当前门店{}上级门店详细信息：{}", StringUtils.defaultString(reqDto.getStoreName(), ""), JSON.toJSONString(storeRespDto));
            if (StoreConstant.IS_CUSTOMER.equals(storeRespDto.getIsCustomer())) {
                Assert.isTrue(storeRespDto.getIsCustomer().equals(reqDto.getIsCustomer()), "0002", "与当前上级是否大客户类型不一致，无法变更当前门店是否大客户类型");
            }
        }

        // 同步store修改的state、oldSocialCreditNum信息到customer
        applicationContext.getBean(IStoreService.class).syncStoreState2Customer(reqDto);//异步提升效率
        this.syncStoreInfo2Customer(reqDto);//需同步校验新统一社会信用代码对旧小b是否可用，不能异步

        //处理药店经纬度
        StoreExportVo storeExportVo = new StoreExportVo();
        CubeBeanUtils.copyProperties(storeExportVo, reqDto);
        this.extractedAddress(storeExportVo);
        reqDto.setLog(storeExportVo.getLog());
        reqDto.setLat(storeExportVo.getLat());

        //是否业务处理标识(默认:空 , 0:否  1:是  )
        if(ObjectUtils.isNotEmpty(reqDto.getIsReplenish())){
            reqDto.setIsReplenish(reqDto.getIsReplenish());
        }
        //默认全部转大写 一级剔除空格
        reqDto.setSocialCreditNum(reqDto.getSocialCreditNum().trim().toUpperCase(Locale.ROOT));
        if (!ObjectUtils.isEmpty(reqDto.getId())) {
            RestResponse<Void> voidRestResponse = storeApi.updateStoreBatch(Lists.newArrayList(reqDto));
            RestResponseHelper.extractData(voidRestResponse);
        } else {
            RestResponse<StoreRespDto> storeRespDtoResp = storeQueryApi.queryStoreRespDtoByCreditNum(reqDto.getSocialCreditNum());
            StoreRespDto respDto = RestResponseHelper.extractData(storeRespDtoResp);
            Assert.isTrue(!reqDto.getSocialCreditNum().equals(respDto.getSocialCreditNum()), "0003", "已存在相同信用代码药店！！！");

            RestResponse<Void> voidRestResponse = storeApi.addStore(reqDto);
            RestResponseHelper.extractData(voidRestResponse);
        }

        //获取所有上级门店
        List<StoreRespDto> storeRespDtos = RestResponseHelper.extractData(storeQueryApi.querySocialCreditNums(Lists.newArrayList(reqDto.getParentSocialCreditNum())));
        storeRespDtos.forEach(c -> {
            StoreReqDto storeReqDto = new StoreReqDto();
            storeReqDto.setParentSocialCreditNum(c.getSocialCreditNum());
            storeReqDto.setCustomerSystem(c.getCustomerSystem());
            storeReqDto.setBusinessPattern(c.getBusinessPattern());
            storeReqDto.setBizChannel(c.getBizChannel());
            // 是否业务处理标识(默认:空 , 0:否  1:是  )===> 此处默认为 1
            storeReqDto.setIsReplenish(DefaultSettingEnum.YES.getCode());
            storeApi.updateStore(storeReqDto);
        });

        //大客户类型随上级门店变动而变动
        StoreReqDto storeReq = new StoreReqDto();
        storeReq.setParentSocialCreditNum(reqDto.getSocialCreditNum());
        storeReq.setIsCustomer(reqDto.getIsCustomer());
        storeReq.setCustomerSystem(reqDto.getCustomerSystem());
        storeReq.setBusinessPattern(reqDto.getBusinessPattern());
        storeReq.setBizChannel(reqDto.getBizChannel());
        storeReq.setUpdatePerson(context.userName());
        RestResponseHelper.extractData(storeApi.updateStore(storeReq));

        return RestResponse.VOID;
    }

    private void syncStoreInfo2Customer(StoreReqDto reqDto) {
        if(ObjectUtils.isEmpty(reqDto.getId()) || StringUtils.isEmpty(reqDto.getOldSocialCreditNum())){
            return;
        }
        //校验一: 校验新药店的三要素
        CompanyVerifyReqDto CompanyVerifyReqDto = new CompanyVerifyReqDto();
        CompanyVerifyReqDto.setCode(reqDto.getSocialCreditNum());
        CompanyVerifyReqDto.setName(reqDto.getStoreName());
        CompanyVerifyReqDto.setLegalPersonName(reqDto.getLegalPersonName());
        //ICustomerExtService、IStoreService会循环依赖
        CompanyVerifyRespDto companyVerifyRespDto = applicationContext.getBean(ICustomerExtService.class).verifyCompany(CompanyVerifyReqDto);
        if(!Objects.equals(companyVerifyRespDto.getResult(), CompanyVerifyEnum.SUCCESS.getCode())){
            throw new BizException(companyVerifyRespDto.getRemark());
        }

        //校验二: 客商中心修改保存前调取查验是否存在进件账户，在进件的情况下社会信用代码不允许修改
        checkCreditCodeChangeByCredit(reqDto.getOldSocialCreditNum());

        //校验三: 见customerSyncCreditApi.syncStoreNewCredit2Customer
        // - 校验同一商户是否已存在零售商。
        // - 名称50%匹配校验

        //关联旧信用代码时 查询旧信用代码对应的小b
        // - 同步新信用代码及其他字段到该小b
        // - 同步新药店的状态(转换后的状态)到小b(小b需为启用、注销状态)
        if(reqDto.getOldSocialCreditNum().equals(reqDto.getSocialCreditNum())){
            throw new BizException("关联旧信用代码不能与当前信用代码相同");
        }
        logger.info("关联旧信用代码时 查询旧信用代码对应的小b reqDto={}", reqDto);
        RestResponseHelper.extractData(customerSyncCreditApi.syncStoreNewCredit2Customer(reqDto));
    }

    private void checkCreditCodeChangeByCredit(String oldSocialCreditNum) {
        List<CustomerRespDto> CustomerRespDtos = RestResponseHelper.extractData(customerSyncCreditApi.findCustomerByCredit(FindCustomerByCreditReqDto.builder()
                .socialCreditNum(oldSocialCreditNum)
                .customerType(CustomerTypeEnum.RETAILER.getCode())
                .build()));

        if(CustomerRespDtos == null || CustomerRespDtos.isEmpty()){
            logger.info("check 同步全量库药店状态(转换后)到小b零售商 CustomerRespDtos == null. end");
            return;
        }
        for (CustomerRespDto customerRespDto : CustomerRespDtos) {
            // 客商中心修改保存前调取查验是否存在进件账户，在进件的情况下社会信用代码不允许修改
            // 原校验接口 settlementAccountRegisterRelation/checkCreditCodeChage  这个change就是原来打错了，就这样用吧。
            //  warn: customerDto.getId() 能拿到customer表的id，但customerDto.getCustomerId()就是空的
            settlementAccountRegisterRelationService.checkCreditCodeChage(customerRespDto.getId(),null,oldSocialCreditNum);
        }
    }

    @Async
    @Override
    public void syncStoreState2Customer(StoreReqDto reqDto){
        //药店状态有更改时，同步转换后的状态到小b(小b需为启用、注销状态)
        logger.info("药店状态有更改时，同步转换后的状态到小b(小b需为启用、注销状态) reqDto={}", reqDto);
        RestResponseHelper.extractData(customerSyncCreditApi.syncStoreState2Customer(reqDto));
    }

    /**
     * 解析药店地址经纬度
     *
     * @param reqDto
     */
    private void extractedAddress(StoreExportVo reqDto) {
        StringBuffer storeParesAddress = new StringBuffer(StringUtils.defaultString(reqDto.getProvince(), ""));
        storeParesAddress.append(StringUtils.defaultString(reqDto.getCity(), ""))
                .append(StringUtils.defaultString(reqDto.getDistrict(), ""))
                .append(StringUtils.defaultString(reqDto.getStoreAddr(), ""));
        RestResponse<MapTextRespDto> mapRespDtoRestResponse = mapApi.parserText(storeParesAddress.toString());
        MapTextRespDto mapTextRespDto = RestResponseHelper.extractData(mapRespDtoRestResponse);
        if (ObjectUtils.isNotEmpty(mapTextRespDto)) {
            logger.info("【高德地图】获取门店详细地址经纬度 response : {}", JSON.toJSONString(mapTextRespDto));
            if (CollectionUtils.isNotEmpty(mapTextRespDto.getPois())) {
                MapTextRespDto.Pois pois = mapTextRespDto.getPois().stream().findFirst().get();
                //地址经纬度
                List<String> location = Arrays.asList(pois.getLocation().split(","));
                reqDto.setLog(location.stream().findFirst().get());
                reqDto.setLat(location.stream().skip(location.size() - 1).findFirst().get());
            }
        }
    }

    /**
     * 处理药店区域数据
     *
     * @param reqDto
     * @param storeAreaRespDtos
     */
    private void extractedArea(StoreExportVo reqDto, List<StoreAreaRespDto> storeAreaRespDtos) {
        StoreAreaRespDto province = !StringUtils.isNotBlank(reqDto.getProvince()) ? null : this.getStoreAreaRespDtos(reqDto.getProvince(), storeAreaRespDtos);

        StoreAreaRespDto city = !StringUtils.isNotBlank(reqDto.getCity()) ? null : this.getStoreAreaRespDtos(reqDto.getCity(),
                ObjectUtils.isEmpty(province) ? Lists.newArrayList() : province.getChildren());

        StoreAreaRespDto district = !StringUtils.isNotBlank(reqDto.getDistrict()) ? null : this.getStoreAreaRespDtos(reqDto.getDistrict(),
                ObjectUtils.isEmpty(city) ? Lists.newArrayList() : city.getChildren());

        //设置区域信息
        reqDto.setProvinceCode(ObjectUtils.isEmpty(province) ? "" : province.getCode());
        reqDto.setProvince(ObjectUtils.isEmpty(province) ? reqDto.getProvince() : province.getName());

        reqDto.setCityCode(ObjectUtils.isEmpty(city) ? "" : city.getCode());
        reqDto.setCity(ObjectUtils.isEmpty(city) ? reqDto.getCity() : city.getName());

        //特殊处理当区域信息不存在区域信息
        if (!ObjectUtils.isEmpty(city) && CollectionUtils.isEmpty(city.getChildren())) {
            reqDto.setDistrictCode("-");
            reqDto.setDistrict("-");
        } else {
            reqDto.setDistrictCode(ObjectUtils.isEmpty(district) ? "" : district.getCode());
            reqDto.setDistrict(ObjectUtils.isEmpty(district) ? reqDto.getDistrict() : district.getName());
        }
    }

    private StoreAreaRespDto getStoreAreaRespDtos(String name, List<StoreAreaRespDto> storeAreaRespDtos) {
        if (CollectionUtils.isNotEmpty(storeAreaRespDtos)) {
            List<StoreAreaRespDto> collect = storeAreaRespDtos.stream().filter(c -> name.indexOf(c.getName()) != -1).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(collect)) {
                return collect.stream().findFirst().get();
            }
        }
        return null;
    }


    /**
     * @param storeExportVos
     * @param parentStoreExportList
     */
    private void getParentStore(List<StoreExportVo> storeExportVos, Map<String, StoreExportVo> parentStoreExportList) {
        if (CollectionUtils.isNotEmpty(storeExportVos)) {
            for (StoreExportVo storeExportVo : storeExportVos) {
                List<StoreExportVo> children = storeExportVo.getChildren();
                StoreExportVo orDefault = parentStoreExportList.getOrDefault(storeExportVo.getSocialCreditNum(), null);
                if (null != orDefault) {
                    parentStoreExportList.remove(storeExportVo.getSocialCreditNum());
                    children.add(orDefault);
                    getParentStore(storeExportVo.getChildren(), parentStoreExportList);
                    storeExportVo.setChildren(children);
                }

            }
        }
    }

    /**
     * 取子集数据
     *
     * @param parentStoreExportVo
     * @param storeExportList
     */
    public void returnStore(List<StoreExportVo> parentStoreExportVo, List<StoreExportVo> storeExportList) {
        if (CollectionUtils.isNotEmpty(parentStoreExportVo)) {
            for (StoreExportVo storeExportVo : parentStoreExportVo) {
                storeExportList.addAll(storeExportVo.getChildren());
                returnStore(storeExportVo.getChildren(), storeExportList);
            }
        }
    }

    @Override
    public RestResponse<Void> saveOrUpdateStoreByExcel(MultipartFile file) {
        ImportRecordReqDto importRecordReqDto = new ImportRecordReqDto();
        importRecordReqDto.setCode(BizImportEnum.STORE_IMPORT.getCode());
        importRecordReqDto.setName(BizImportEnum.STORE_IMPORT.getImportName());
        importRecordReqDto.setStatus(ImportStatusEnum.LOADING.getCode());
        Long recordId = RestResponseHelper.extractData(importRecordApi.addImportRecord(importRecordReqDto));

        CompletableFuture.runAsync(() -> {
            ImportParams importParams = new ImportParams();
            importParams.setHeadRows(1);
            importParams.setTitleRows(0);
            importRecordReqDto.setId(recordId);
            try {
                ExcelImportResult<StoreExportVo> result = ExcelImportUtil.importExcelMore(file.getInputStream(), StoreExportVo.class, importParams);
                List<StoreExportVo> list = BeanPropertyNullUtil.getAllFieldNullList(result.getList());
                if (!CollectionUtils.isNotEmpty(list)) {
                    importRecordReqDto.setStatus(ImportStatusEnum.EMPTY.getCode());
                } else {
                    List<StoreExportVo> notLegalList = Lists.newArrayList();
                    if (CollectionUtils.isNotEmpty(list)) {
                        //去重
                        Map<String, StoreExportVo> storeExportMap = list.stream().collect(Collectors.toMap(StoreExportVo::getSocialCreditNum, val -> val, (v1, v2) -> v1));

                        //校验处理数据
                        List<StoreExportVo> storeExportVoResult = verifyStoreExport(Lists.newArrayList(storeExportMap.values()));
                        List<StoreExportVo> legalList = storeExportVoResult.stream().filter(storeExportVo -> !StringUtils.isNotBlank(storeExportVo.getReason())).collect(Collectors.toList());
                        notLegalList.addAll(storeExportVoResult.stream().filter(storeExportVo -> StringUtils.isNotBlank(storeExportVo.getReason())).collect(Collectors.toList()));
                        //校验并处理药店信息以及区分新增修改数据
                        getStoreRespDtos(legalList, context.userName());
                    }
                    importRecordReqDto.setStatus(!ObjectUtils.isEmpty(notLegalList) ? ImportStatusEnum.ERROR.getCode() : ImportStatusEnum.SUCCESS.getCode());
                    importRecordReqDto.setImportDesc(String.format(BizImportEnum.STORE_IMPORT.getDescModel(), file.getOriginalFilename(), list.size(), notLegalList.size(), list.size() - notLegalList.size()));
                    if (!ObjectUtils.isEmpty(notLegalList)) {
                        String excelName = "cube/" + "导入药店数据失败文件_" + DateUtil.getDateFormat(new Date(), "yyyyMMddHHmmss");
                        importRecordReqDto.setErrorUrl(EasyPoiExportUtil.getExportUrl(notLegalList, StoreExportVo.class, (String) null, excelName, "xls"));
                    }
                }
            } catch (Exception e) {
                e.printStackTrace();
                importRecordReqDto.setStatus(ImportStatusEnum.ERROR.getCode());
            }
            RestResponseHelper.extractData(importRecordApi.modifyImportRecord(importRecordReqDto));
        }, importExecutor);
        return RestResponse.SUCCESS;
    }

    /**
     * 处理导入药店数据补充信息
     *
     * @param list
     * @param userName 触发人
     */
    private void getStoreRespDtos(List<StoreExportVo> list, String userName) {
        logger.info("【{}】触发分批处理药店数据导入 count:{},content:{}", userName, list.size(), JSON.toJSONString(list));
        //校验导入数据

        List<StoreReqDto> storeReqDtoList = list.stream().map(c -> {
            StoreReqDto storeReqDto = new StoreReqDto();
            CubeBeanUtils.copyProperties(storeReqDto, c);
            return storeReqDto;
        }).collect(Collectors.toList());

        Map<String, StoreReqDto> storeExportMap = storeReqDtoList.stream().collect(Collectors.toMap(StoreReqDto::getSocialCreditNum, c -> c, (k1, k2) -> k1));

        //查询导入药店数据区分药店数据
        List<String> creditNumLists = Lists.newArrayList(storeExportMap.keySet());
        RestResponse<List<StoreRespDto>> listRestResponse = storeQueryApi.querySocialCreditNums(creditNumLists);
        List<StoreRespDto> storeRespDtoList = RestResponseHelper.extractData(listRestResponse);

        Map<String, StoreRespDto> storeRespDtoMap = storeRespDtoList.stream().collect(Collectors.toMap(k -> k.getSocialCreditNum().toUpperCase(Locale.ROOT), val -> val, (k1, k2) -> k2));

        //过滤新增数据
        List<String> creditNumExit = storeRespDtoList.stream().map(c -> c.getSocialCreditNum()).collect(Collectors.toList());
        creditNumLists.removeAll(creditNumExit);
        logger.info("分批导入药店新增药店信用代码：{}", JSON.toJSONString(creditNumLists));



        if(CollectionUtils.isNotEmpty(creditNumLists)){
            List<StoreReqDto> notExitList = creditNumLists.stream().map(c -> {
                StoreReqDto storeReqDto = storeExportMap.get(c);
                storeReqDto.setCreatePerson(userName);
                //默认变更大写
                storeReqDto.setSocialCreditNum(storeReqDto.getSocialCreditNum().toUpperCase(Locale.ROOT));

                // 是否业务处理标识(默认:空 , 0:否  1:是  )===> 此处默认为 1
                storeReqDto.setIsReplenish(DefaultSettingEnum.YES.getCode());

                //药店表数据来源: 手动录入（包含导入）
                storeReqDto.setDataOrigin(StoreDataOriginEnum.MANUALLY_ENTER.getCode());

                return storeReqDto;
            }).collect(Collectors.toList());

            logger.info("门店新增数据：{}",JSON.toJSONString(notExitList));
            if (CollectionUtils.isNotEmpty(notExitList)) {
                storeApi.addStoreBatch(notExitList);
            }
        }

        if(CollectionUtils.isNotEmpty(creditNumExit)){
            List<StoreReqDto> isExitList = creditNumExit.stream().map(c -> {
                StoreReqDto storeReqDto = storeExportMap.get(c);
                storeReqDto.setUpdatePerson(userName);
                //默认变更大写
                String socialCreditNum = storeReqDto.getSocialCreditNum().toUpperCase(Locale.ROOT);
                storeReqDto.setSocialCreditNum(socialCreditNum);
                StoreRespDto orDefault = storeRespDtoMap.getOrDefault(socialCreditNum, null);
                storeReqDto.setStoreId(ObjectUtils.isNotEmpty(orDefault) ? orDefault.getStoreId() : "");

                // 是否业务处理标识(默认:空 , 0:否  1:是  )===> 此处默认为 1
                storeReqDto.setIsReplenish(DefaultSettingEnum.YES.getCode());
                return storeReqDto;
            }).collect(Collectors.toList());

            logger.info("门店更新数据：{}",JSON.toJSONString(isExitList));
            if (CollectionUtils.isNotEmpty(isExitList)) {
                storeApi.updateStoreBatch(isExitList);
            }
        }

        //直接按照导入的数据为大客户的更新
        List<StoreReqDto> collect = storeReqDtoList.stream().filter(c ->
                StoreConstant.IS_CUSTOMER.equals(c.getIsCustomer())).collect(Collectors.toList());
        collect.forEach(c -> {
            StoreReqDto storeReq = new StoreReqDto();
            storeReq.setParentSocialCreditNum(c.getSocialCreditNum());
            storeReq.setIsCustomer(StoreConstant.IS_CUSTOMER);
            storeReq.setUpdatePerson(userName);
            // 是否业务处理标识(默认:空 , 0:否  1:是  )===> 此处默认为 1
            storeReq.setIsReplenish(DefaultSettingEnum.YES.getCode());
            storeApi.updateStore(storeReq);
        });

        //获取所有上级门店
        List<String> parentSocialCreditNumList = storeReqDtoList.stream()
                .map(c -> c.getParentSocialCreditNum())
                .filter(c -> StringUtils.isNotBlank(c))
                .distinct()
                .collect(Collectors.toList());

        List<StoreRespDto> storeRespDtos = RestResponseHelper.extractData(storeQueryApi.querySocialCreditNums(parentSocialCreditNumList));
        storeRespDtos.forEach(c -> {
            StoreReqDto storeReq = new StoreReqDto();
            storeReq.setParentSocialCreditNum(c.getSocialCreditNum());
            storeReq.setCustomerSystem(c.getCustomerSystem());
            storeReq.setBusinessPattern(c.getBusinessPattern());
            storeReq.setBizChannel(c.getBizChannel());
            storeReq.setUpdatePerson(userName);
            // 是否业务处理标识(默认:空 , 0:否  1:是  )===> 此处默认为 1
            storeReq.setIsReplenish(DefaultSettingEnum.YES.getCode());
            storeApi.updateStore(storeReq);
        });


        //客户系统类型以及经营模式跟随上级变更
        storeReqDtoList.forEach(c -> {
            StoreReqDto storeReq = new StoreReqDto();
            storeReq.setParentSocialCreditNum(c.getSocialCreditNum());
            storeReq.setCustomerSystem(c.getCustomerSystem());
            storeReq.setBusinessPattern(c.getBusinessPattern());
            storeReq.setBizChannel(c.getBizChannel());
            storeReq.setUpdatePerson(userName);
            // 是否业务处理标识(默认:空 , 0:否  1:是  )===> 此处默认为 1
            storeReq.setIsReplenish(DefaultSettingEnum.YES.getCode());
            storeApi.updateStore(storeReq);
        });
    }

    /**
     * 校验导入数据并解析
     *
     * @param list
     * @return
     */
    private List<StoreExportVo> verifyStoreExport(List<StoreExportVo> list) {
        Map<String, StoreExportVo> collect = list.stream().collect(Collectors.toMap(StoreExportVo::getSocialCreditNum, c -> c, (key1, key2) -> key2));
        for (StoreExportVo c : list) {
            //校验当前门店类型与上级门店是否大客户类型
            if (StringUtils.isNotBlank(c.getParentSocialCreditNum())) {
                StoreExportVo orDefault = collect.getOrDefault(c.getParentSocialCreditNum(), null);
                if (null == orDefault) {
                    RestResponse<StoreRespDto> storeRespDtoRestResponse = storeQueryApi.queryStoreRespDtoByCreditNum(c.getParentSocialCreditNum());
                    StoreRespDto storeRespDto = RestResponseHelper.extractData(storeRespDtoRestResponse);
                    logger.info("当前父级门店信息：{}", JSON.toJSONString(storeRespDto));
                    if (BeanPropertyNullUtil.isAllFieldNull(storeRespDto)) {
                        c.setReason("不存在当前上级门店");
                        continue;
                    }
                }
            }

            //标识当前导入填写了 解析省市区
            if (StringUtils.isNotBlank(c.getProvince()) || StringUtils.isNotBlank(c.getDistrict()) || StringUtils.isNotBlank(c.getCity())) {
                //区域信息
                List<StoreAreaRespDto> storeAreaRespDtos = RestResponseHelper.extractData(storeAreaQueryApi.queryTree());
                this.extractedArea(c, storeAreaRespDtos);
                if (!StringUtils.isNotBlank(c.getProvinceCode()) || !StringUtils.isNotBlank(c.getDistrictCode()) || !StringUtils.isNotBlank(c.getCityCode())) {
                    c.setReason("省市区解析异常");
                    continue;
                }
            }

            //解析地址
            /** 20230110 当导入经纬度已填写时，无需自动解析获取经纬度 **/
            if (StringUtils.isNotBlank(c.getStoreAddr()) && StringUtils.isAllBlank(c.getLog()) && StringUtils.isAllBlank(c.getLat())) {
                this.extractedAddress(c);
                if (!StringUtils.isNotBlank(c.getLog()) || !StringUtils.isNotBlank(c.getLat())) {
                    c.setReason("经纬度解析异常");
                    continue;
                }
            }

            //excel导入解析   客户为大客户并且屏蔽业务线不为空时，则解析
            if (StringUtils.isNotBlank(c.getBizChannel()) && c.getIsCustomer().equals(IsCustomerEnum.IS_CUSTOMER.getCode())) {
                //处理业务线转化
                List<String> bizChannel = Arrays.asList(c.getBizChannel().split("\\+"));
                if (ObjectUtils.isNotEmpty(bizChannel)) {
                    List<String> bizChannelCodes = bizChannel.stream().map(biz -> BizChannelEnum.fromName(biz).getCode()).collect(Collectors.toList());
                    c.setBizChannel(StringUtils.join(bizChannelCodes,","));
                }
            }

            //导入字段非空校验
            if (StringUtils.isBlank(c.getStoreType())) {
                c.setReason("机构类型不能为空");
                continue;
            }

        }
        return list;
    }
}
