/*
 * *
 *  @(#)MqUtils.java 1.0 19-7-13 下午5:08
 *
 *  Copyright (c) 2016, YUNXI. All rights reserved.
 *  YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * /
 */

package com.dtyunxi.yundt.module.customer.biz.mq.producer;

import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerImportSaveReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.enmus.ImportTypeEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.exception.CustomerBusinessRuntimeException;
import com.dtyunxi.yundt.cube.center.customer.api.customer.exception.CustomerExceptionCode;
import com.dtyunxi.yundt.module.customer.biz.mq.constants.MessageTag;
import com.dtyunxi.yundt.module.customer.biz.mq.constants.MessageTopic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;


/**
 * 客商导入通用消息发送/生产
 * @author sumo on 2020/10/13 0013
 */
@Component
public class CustomerImportProducer {
    private static Logger logger = LoggerFactory.getLogger(CustomerImportProducer.class);
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private Environment environment;


    /**
     * 批量导入客户信息
     */
    public void sendCustomerImportMq(CustomerImportSaveReqDto customerImportSaveReqDto) {
        logger.info("Mq发送计算批量导入客户信息事件:{},类型[{}]", customerImportSaveReqDto.getId(), ImportTypeEnum.toName(customerImportSaveReqDto.getImportType()));
        if(ImportTypeEnum.toName(customerImportSaveReqDto.getImportType())==null){
            throw new CustomerBusinessRuntimeException(CustomerExceptionCode.CUSTOMER_CODE_EXISTS,customerImportSaveReqDto.getImportType());
        }
        if (customerImportSaveReqDto.getId() == null) {
            logger.info("Mq发送计算批量导入客户信息事件失败原因:id[{}]为空", customerImportSaveReqDto.getId());
             throw new CustomerBusinessRuntimeException(CustomerExceptionCode.SYS_OBJ_NOT_FOUND, "导入任务不存在");

        }
        if (ImportTypeEnum.fromCode(customerImportSaveReqDto.getImportType()) == ImportTypeEnum.CUSTOMER) {
            commonsMqService.sendSingleMessage(environment.resolvePlaceholders(MessageTopic.CUSTOMER_INFO_IMPORT_TOPIC),MessageTag.CUSTOMER_INFO_IMPORT_TAG, customerImportSaveReqDto);

        } else if (ImportTypeEnum.fromCode(customerImportSaveReqDto.getImportType()) == ImportTypeEnum.SUPPLIER) {
            commonsMqService.sendSingleMessage(environment.resolvePlaceholders(MessageTopic.SUPPLIER_INFO_IMPORT_TOPIC),MessageTag.SUPPLIER_INFO_IMPORT_TAG, customerImportSaveReqDto);

        }

    }

}
