/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.customer.biz.impl.user;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CustomerSearchExtReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.query.ICustomerQueryV3Api;
import com.dtyunxi.yundt.cube.center.user.api.IEmployeeRoleApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.RoleDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.EmployeeRoleReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.RoleReqDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IRoleQueryApi;
import com.dtyunxi.yundt.module.customer.api.dto.request.user.RoleQueryReqDto;
import com.dtyunxi.yundt.module.customer.api.dto.response.user.IEmployeeRoleService;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class EmployeeRoleServiceImpl
implements IEmployeeRoleService {
    private static final Logger log = LoggerFactory.getLogger(EmployeeRoleServiceImpl.class);
    @Resource
    private IEmployeeRoleApi employeeRoleApi;
    @Resource
    private ICustomerQueryV3Api customerQueryV3Api;
    @Resource
    private IRoleQueryApi roleQueryApi;
    @Resource
    private HttpServletRequest request;

    public RestResponse<Long> addEmployeeRole(Long instanceId, EmployeeRoleReqDto reqDto) {
        log.info("\u65b0\u589e\u4eba\u5458\u89d2\u8272\u4fe1\u606f\u5165\u53c2\uff1areqDto={}", (Object)JSON.toJSONString((Object)reqDto));
        return this.employeeRoleApi.addEmployeeRole(instanceId, reqDto);
    }

    public RestResponse<Void> modifyEmployeeRole(Long instanceId, EmployeeRoleReqDto reqDto) {
        log.info("\u4fee\u6539\u4eba\u5458\u89d2\u8272\u4fe1\u606f\u5165\u53c2\uff1areqDto={}", (Object)JSON.toJSONString((Object)reqDto));
        return this.employeeRoleApi.modifyEmployeeRole(instanceId, reqDto);
    }

    public RestResponse<Long> setSuperAdmin(Long instanceId, EmployeeRoleReqDto reqDto) {
        log.info("\u8bbe\u7f6e\u8d85\u7ea7\u7ba1\u7406\u5458\u5165\u53c2\uff1areqDto={}", (Object)JSON.toJSONString((Object)reqDto));
        return this.employeeRoleApi.setSuperAdmin(instanceId, reqDto);
    }

    public RestResponse<PageInfo<RoleDto>> queryPageRoleInfo(RoleQueryReqDto reqDto) {
        log.info("\u5206\u9875\u67e5\u8be2\u89d2\u8272\u5217\u8868\u5165\u53c2\uff1areqDto={}", (Object)JSON.toJSONString((Object)reqDto));
        RoleReqDto roleReqDto = new RoleReqDto();
        if (StringUtils.isNotBlank((CharSequence)reqDto.getCode())) {
            roleReqDto.setCode(reqDto.getCode());
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getName())) {
            roleReqDto.setName(reqDto.getName());
        }
        ArrayList<Object> orgIds = new ArrayList<Object>();
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getOrgIds())) {
            orgIds.addAll(reqDto.getOrgIds());
        } else {
            Long userOrgId = null;
            String orgIdObj = this.headerOrgId();
            if (orgIdObj != null) {
                userOrgId = Long.valueOf(orgIdObj.toString());
            }
            if (userOrgId != null) {
                List customerRespDtos = Optional.ofNullable(this.getCustomerRespDtos(userOrgId)).orElse(new ArrayList(0));
                List customerOrgIds = customerRespDtos.stream().map(CustomerRespDto::getOrgInfoId).distinct().collect(Collectors.toList());
                orgIds.addAll(customerOrgIds);
                orgIds.add(userOrgId);
            }
        }
        roleReqDto.setOrgIdList(orgIds);
        roleReqDto.setPageNum(reqDto.getPageNum());
        roleReqDto.setPageSize(reqDto.getPageSize());
        if (reqDto.getCountRelationUserAndGroupNum() != null && reqDto.getCountRelationUserAndGroupNum().booleanValue()) {
            roleReqDto.setUserGroupRelationNum(Integer.valueOf(1));
        }
        log.info("\u8c03\u7528\u89d2\u8272\u67e5\u8be2API\u53c2\u6570\uff1aroleReqDto={}", (Object)JSON.toJSONString((Object)roleReqDto));
        ServiceContext.getContext().setAttachment("yes-req-cus-b2b-organizationId", this.headerOrgId());
        RestResponse response = this.roleQueryApi.queryPageRoleInfoPost(roleReqDto, reqDto.getPageNum(), reqDto.getPageSize());
        RestResponseHelper.checkOrThrow((RestResponse)response);
        return response;
    }

    public String headerOrgId() {
        String organizationId = this.request.getHeader("yes-req-cus-b2b-organizationId");
        log.info("\u83b7\u53d6\u8bf7\u6c42\u5934\u7ec4\u7ec7ID\uff1a{}", (Object)organizationId);
        return organizationId;
    }

    @Nullable
    private List<CustomerRespDto> getCustomerRespDtos(Long orgId) {
        CustomerSearchExtReqDto customerExtQuery = new CustomerSearchExtReqDto();
        customerExtQuery.setMerchantId(orgId);
        return (List)RestResponseHelper.extractData((RestResponse)this.customerQueryV3Api.queryCustomerByExtDtoList(customerExtQuery));
    }
}

