package com.dtyunxi.yundt.module.customer.biz.impl.user;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CustomerSearchExtReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.query.ICustomerQueryV3Api;
import com.dtyunxi.yundt.cube.center.user.api.IEmployeeRoleApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.RoleDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.EmployeeRoleReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.RoleReqDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IRoleQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.customer.api.dto.request.user.RoleQueryReqDto;
import com.dtyunxi.yundt.module.customer.api.dto.response.user.IEmployeeRoleService;
import com.github.pagehelper.PageInfo;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author liangfa
 * @Description 人员角色信息接口
 * @date 2022-01-14 17:38
 * @since 1.0.0
 */
@Service
public class EmployeeRoleServiceImpl implements IEmployeeRoleService {

    private static final Logger log = LoggerFactory.getLogger(EmployeeRoleServiceImpl.class);

    @Resource
    private IEmployeeRoleApi employeeRoleApi;


    @Resource
    private ICustomerQueryV3Api customerQueryV3Api;
    @Resource
    private IRoleQueryApi roleQueryApi;


    @Resource
    private HttpServletRequest request;

    @Override
    public RestResponse<Long> addEmployeeRole(Long instanceId, EmployeeRoleReqDto reqDto) {
        log.info("新增人员角色信息入参：reqDto={}", JSON.toJSONString(reqDto));
        return employeeRoleApi.addEmployeeRole(instanceId, reqDto);
    }

    @Override
    public RestResponse<Void> modifyEmployeeRole(Long instanceId, EmployeeRoleReqDto reqDto) {
        log.info("修改人员角色信息入参：reqDto={}", JSON.toJSONString(reqDto));
        return employeeRoleApi.modifyEmployeeRole(instanceId, reqDto);
    }

    @Override
    public RestResponse<Long> setSuperAdmin(Long instanceId, EmployeeRoleReqDto reqDto) {
        log.info("设置超级管理员入参：reqDto={}", JSON.toJSONString(reqDto));
        return employeeRoleApi.setSuperAdmin(instanceId, reqDto);
    }

    @Override
    public RestResponse<PageInfo<RoleDto>> queryPageRoleInfo(RoleQueryReqDto reqDto) {
        log.info("分页查询角色列表入参：reqDto={}", JSON.toJSONString(reqDto));
        
        // 构建RoleReqDto对象
        RoleReqDto roleReqDto = new RoleReqDto();
        
        // 添加角色代码和名称过滤
        if (StringUtils.isNotBlank(reqDto.getCode())) {
            roleReqDto.setCode(reqDto.getCode());
        }
        if (StringUtils.isNotBlank(reqDto.getName())) {
            roleReqDto.setName(reqDto.getName());
        }
        roleReqDto.setStatus(reqDto.getStatus());
        
        // 添加组织ID
        List<Long> orgIds = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(reqDto.getOrgIds())) {
            orgIds.addAll(reqDto.getOrgIds());
        } else {
            // 获取当前用户所属组织ID
            Long userOrgId = null;
            
            Object orgIdObj = headerOrgId();
            if (orgIdObj != null) {
                userOrgId = Long.valueOf(orgIdObj.toString());
            }

            if (userOrgId != null) {
                List<CustomerRespDto> customerRespDtos = Optional.ofNullable(getCustomerRespDtos(userOrgId)).orElse(new ArrayList<>(0));
                List<Long> customerOrgIds = customerRespDtos.stream().map(CustomerRespDto::getOrgInfoId).distinct().collect(Collectors.toList());
                orgIds.addAll(customerOrgIds);
                orgIds.add(userOrgId);
            }
        }
        
        // 设置组织ID列表
        roleReqDto.setOrgIdList(orgIds);
        
        // 设置分页参数
        roleReqDto.setPageNum(reqDto.getPageNum());
        roleReqDto.setPageSize(reqDto.getPageSize());
        
        // 是否计算关联数量
        if (reqDto.getCountRelationUserAndGroupNum() != null && reqDto.getCountRelationUserAndGroupNum()) {
            roleReqDto.setUserGroupRelationNum(1); // 设置非零值表示需要计算关联数量
        }
        
        log.info("调用角色查询API参数：roleReqDto={}", JSON.toJSONString(roleReqDto));
        ServiceContext.getContext().setAttachment("yes-req-cus-b2b-organizationId", headerOrgId());
        // 调用角色查询API的Post方法
        RestResponse<PageInfo<RoleDto>> response = roleQueryApi.queryPageRoleInfoPost(roleReqDto, 
                reqDto.getPageNum(), reqDto.getPageSize());
        RestResponseHelper.checkOrThrow(response);
        return response;
    }

    public String headerOrgId() {
        String organizationId = request.getHeader("yes-req-cus-b2b-organizationId");
        log.info("获取请求头组织ID：{}", organizationId);
        return organizationId;
    }

    @Nullable
    private List<CustomerRespDto> getCustomerRespDtos(Long orgId) {
        //客户人员查询
        CustomerSearchExtReqDto customerExtQuery = new CustomerSearchExtReqDto();
        customerExtQuery.setMerchantId(orgId);

        return RestResponseHelper.extractData(customerQueryV3Api.queryCustomerByExtDtoList(customerExtQuery));
    }
}
