package com.dtyunxi.yundt.module.customer.biz.util;

import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.lang.reflect.Field;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 判断对象属性为空工具类
 * @Author: xiuji
 * @Date: 2022/3/23 3:39 PM
 */
public class BeanPropertyNullUtil {
    private static final Logger logger = LoggerFactory.getLogger(BeanPropertyNullUtil.class);

    /**
     * 判断对象属性是否为null
     * @param obj 对象
     * @param <T>
     * @return TRUE 对象属性全为null；FALSE 对象属性存在一个不为null
     */
    public static <T> boolean isAllFieldNull(T obj) {
        if(null == obj){
            return true;
        }
        Class stuCla = (Class) obj.getClass();// 得到类对象
        Field[] fs = stuCla.getDeclaredFields();//得到属性集合
        boolean flag = true;
        for (Field f : fs) {//遍历属性
            f.setAccessible(true); // 设置属性是可以访问的(私有的也可以)
            Object val = null;
            try {
                val = f.get(obj);// 得到此属性的值
            }catch (Exception e){
                e.printStackTrace();
                logger.info("获取对象属性值异常:{}",e.getMessage());
            }

            if(val!=null) {//只要有1个属性不为空,那么就不是所有的属性值都为空
                flag = false;
                break;
            }
        }
        return flag;
    }


    /**
     * 判断集合对象属性是否为null
     * @param list
     * @param <T>
     * @return 返回对象属性全部不为空的集合
     */
    public static <T> List<T> getAllFieldNullList(List<T> list){
        if (CollectionUtils.isEmpty(list)) {
            list = Lists.newArrayList();
        }
        list = list.stream().filter(dto -> !isAllFieldNull(dto)).collect(Collectors.toList());
        return list;
    }
}
