package com.dtyunxi.yundt.module.customer.biz.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.CustomerExtReqDto;
import com.dtyunxi.tcbj.api.query.ICustomerDistributorsQueryApi;
import com.dtyunxi.tcbj.api.query.ISaleOrderReportQueryApi;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.company.CompanyVerifyReqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.company.CompanyResultDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.company.CompanyResultInfoDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.company.CompanyVerifyRespDto;
import com.dtyunxi.tcbj.center.openapi.api.query.ICompanyQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.IStoreSellerGovernApi;
import com.dtyunxi.yundt.cube.center.customer.api.constants.*;
import com.dtyunxi.yundt.cube.center.customer.api.customer.constants.CustomerTypeEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.constants.SettleStatusEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.CompanyInfoDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.CustomerAddResultDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerExtDetailRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerStatusRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerStatusQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CustomerCheckPatternReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CustomerReqExtDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.StoreQueryProvinceReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.StoreSellerGovernReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.CustomerCheckPatternRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.StoreAreaRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.query.ICustomerCheckPatternQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.query.IStoreAreaQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.warehouse.ICsLogicWarehouseQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.WarehouseSupplyRelReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.WarehouseSupplyRelRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.query.IWarehouseSupplyRelQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsLogicWarehouseQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsLogicSupplyWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsLogicWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsWarehouseTypeEnum;
import com.dtyunxi.yundt.cube.center.shop.api.ISellerExtApi;
import com.dtyunxi.yundt.cube.center.shop.api.IShopExtApi;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.*;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.SellerRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.ShopBaseDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.ISellerExtQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.query.ISellerQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopExtQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.constants.YesNoEnum;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.ModifyOrganizationReqDto;
import com.dtyunxi.yundt.cube.center.user.api.IOrganizationThreeApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.customer.api.ICustomerExtService;
import com.dtyunxi.yundt.module.customer.api.dto.MerchantDetailRespDto;
import com.dtyunxi.yundt.module.customer.api.dto.request.MerchantSearchReqDto;
import com.dtyunxi.yundt.module.customer.api.dto.response.MerchantListRespDto;
import com.dtyunxi.yundt.module.customer.api.enums.CompanyVerifyEnum;
import com.dtyunxi.yundt.module.customer.biz.constant.TianyanchaProvinceEnum;
import com.dtyunxi.yundt.module.customer.biz.service.IStoreService;
import com.dtyunxi.yundt.module.customer.biz.util.BeanPropertyNullUtil;
import com.dtyunxi.yundt.cube.center.customer.api.constants.CustomerStatusEnum;
import com.dtyunxi.yundt.module.customer.api.enums.SellerStatusEnum;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yx.tcbj.center.customer.api.ICustomerExtThreeApi;
import com.yx.tcbj.center.customer.api.dto.request.ComputeCustomerNameRateReqDto;
import com.yx.tcbj.center.customer.api.dto.request.CustomerBatchUpReqDto;
import com.yx.tcbj.center.customer.api.dto.request.DrCustomersReqDto;
import com.yx.tcbj.center.customer.api.dto.request.store.StoreReqDto;
import com.yx.tcbj.center.customer.api.dto.response.CustomerExtRespDto;
import com.yx.tcbj.center.customer.api.dto.response.CustomerExtV2DetailRespDto;
import com.yx.tcbj.center.customer.api.dto.response.store.StoreRespDto;
import com.yx.tcbj.center.customer.api.query.ICustomerExtThreeQueryApi;
import com.yx.tcbj.center.customer.api.query.ICustomerQueryApi;
import com.yx.tcbj.center.customer.api.query.IStoreQueryApi;
import com.yx.tcbj.center.shop.api.query.IShopExtQueryV3Api;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.dtyunxi.cube.biz.commons.utils.Assert;

import javax.annotation.Resource;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 客户服务实现
 *
 * @author: xuhuaqiang
 */
@Slf4j
@Service("customerExtService")
public class CustomerExtServiceImpl implements ICustomerExtService {

    private static Logger logger = LoggerFactory.getLogger(CustomerExtServiceImpl.class);

    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;

    @Resource
    private ISellerQueryApi sellerQueryApi;

    @Resource
    private IContext context;

    @Resource
    private ISellerExtQueryApi sellerExtQueryApi;

    @Resource
    private ICustomerExtThreeApi customerExtThreeApi;

    @Resource
    private ICustomerStatusQueryApi customerStatusQueryApi;
    @Resource
    private ISellerExtApi sellerExtApi;

    @Resource
    private IStoreQueryApi storeQueryApi;

    @Resource
    private ICompanyQueryApi companyQueryApi;

    @Resource
    private ICustomerDistributorsQueryApi customerDistributorsQueryApi;
    @Resource
    private ICustomerExtThreeQueryApi customerExtThreeQueryApi;
    @Resource
    private ISaleOrderReportQueryApi saleOrderReportQueryApi;

    @Resource
    private ICustomerQueryApi customerQueryApi;

    @Resource
    private IStoreAreaQueryApi storeAreaQueryApi;

    @Resource
    private IStoreService storeService;

    @Resource
    private ICustomerCheckPatternQueryApi customerCheckPatternQueryApi;
    @Resource
    private IOrganizationThreeApi organizationThreeApi;
    @Resource
    private IShopExtApi shopExtApi;
    @Resource
    private IShopExtQueryApi shopExtQueryApi;
    @Resource
    private IShopExtQueryV3Api shopExtQueryV3Api;
    @Resource
    private IStoreSellerGovernApi storeSellerGovernApi;

    @Resource
    private IWarehouseSupplyRelQueryApi warehouseSupplyRelQueryApi;
    @Autowired
    private ICsLogicWarehouseQueryApi csLogicWarehouseQueryApi;

    @Override
    public CustomerExtV2DetailRespDto queryById(Long id) {
        // 调用客商中心，查询客户基础信息
        RestResponse<CustomerExtDetailRespDto> customerRestResp = customerExtQueryApi.queryById(id);
        CustomerExtDetailRespDto customerExtDetailRespDto = RestResponseHelper.extractData(customerRestResp);

        CustomerExtV2DetailRespDto customerRespDto = new CustomerExtV2DetailRespDto();
        CubeBeanUtils.copyProperties(customerRespDto, customerExtDetailRespDto);

        // 补充仓库配置信息
        List<CustomerExtRespDto> customerExtRespDtos = RestResponseHelper.extractData(
                customerExtThreeQueryApi.queryByOrgIdList(Lists.newArrayList(customerExtDetailRespDto.getOrgInfoId())));
        CustomerExtRespDto customerExtRespDto = customerExtRespDtos.stream().findFirst().get();
        customerRespDto.setIsWarehouseEnable(customerExtRespDto.getIsWarehouseEnable());

        // RestResponse<CustomerExtV3DetailRespDto> restResponse =
        // customerExtThreeQueryApi.queryById(id);
        // CustomerExtV3DetailRespDto customerExtV3DetailRespDto =
        // RestResponseHelper.extractData(restResponse);
        if (CustomerTypeEnum.RETAILER.getCode().equals(customerRespDto.getType())) {
            // 如果是零售商，需要展示所属商家名称
            // todo 根据merchantId作为orgId调用店铺中心查询商家信息
            SellerQueryReqDto sellerQueryReqDto = new SellerQueryReqDto();
            sellerQueryReqDto.setOrganizationId(customerRespDto.getMerchantId());
            RestResponse<List<SellerRespDto>> listRestResponse = sellerQueryApi.queryList(sellerQueryReqDto);
            List<SellerRespDto> sellerRespDtos = RestResponseHelper.extractData(listRestResponse);
            if (CollectionUtils.isNotEmpty(sellerRespDtos)) {
                customerRespDto.setMerchantName(sellerRespDtos.get(0).getName());
            }
        }

        return customerRespDto;
    }

    @Override
    public PageInfo<MerchantListRespDto> queryMerchantByPage(String filter, Integer pageNum, Integer pageSize) {
        MerchantSearchReqDto searchReqDto = new MerchantSearchReqDto();
        logger.info("queryMerchantByPage params:{}", filter);
        if (StringUtils.isNotBlank(filter)) {
            searchReqDto = JSONObject.parseObject(filter, MerchantSearchReqDto.class);
        }

        boolean merchantSearchFlag = false;
        Map<Long, SellerRespDto> sellerMap = new HashMap<>();
        if (StringUtils.isNotEmpty(searchReqDto.getMerchantCode())
                || StringUtils.isNotEmpty(searchReqDto.getMerchantName())) {
            merchantSearchFlag = true;
            // 根据商家编码和商家名称查询符合条件的商家集合
            SellerQueryReqDto sellerQueryReqDto = new SellerQueryReqDto();
            sellerQueryReqDto.setCode(searchReqDto.getMerchantCode());
            sellerQueryReqDto.setName(searchReqDto.getMerchantName());
            sellerQueryReqDto.setTenantId(context.tenantId());
            sellerQueryReqDto.setInstanceId(context.instanceId());
            RestResponse<List<SellerRespDto>> listRestResponse = sellerQueryApi.queryList(sellerQueryReqDto);
            List<SellerRespDto> sellerRespDtos = RestResponseHelper.extractData(listRestResponse);
            if (CollectionUtils.isEmpty(sellerRespDtos)) {
                return new PageInfo<>();
            } else {
                List<Long> orgIds = sellerRespDtos.stream().map(SellerRespDto::getOrganizationId)
                        .collect(Collectors.toList());
                searchReqDto.setOrgInfoIds(orgIds);
                sellerMap = sellerRespDtos.stream()
                        .collect(Collectors.toMap(SellerRespDto::getOrganizationId, o -> o, (v1, v2) -> v2));
            }
        }
        if (Objects.isNull(searchReqDto.getSettleStatus())) {
            searchReqDto.setSettleStatusList(
                    Arrays.asList(SettleStatusEnum.SETTLED.getCode(), SettleStatusEnum.DISABLED.getCode()));
        }

        // searchReqDto.setType(CustomerTypeEnum.DEALER.getCode());
        // 客户管理的客户类型为零售商、零售商管理的客户类型为大B(经销商) --liangfa 2022-02-18
        searchReqDto.setType(
                Objects.isNull(searchReqDto.getType()) ? CustomerTypeEnum.DEALER.getCode() : searchReqDto.getType());

        searchReqDto.setChannel(CustomerTypeEnum.BRAND.getCode());
        RestResponse<PageInfo<CustomerRespDto>> pageInfoRestResponse = customerExtQueryApi
                .queryByPage(JSON.toJSONString(searchReqDto), pageNum, pageSize);
        PageInfo<CustomerRespDto> pageInfo = RestResponseHelper.extractData(pageInfoRestResponse);

        PageInfo<MerchantListRespDto> listRespDtoPageInfo = new PageInfo<>();
        CubeBeanUtils.copyProperties(listRespDtoPageInfo, pageInfo, "list", "navigatepageNums");
        List<MerchantListRespDto> listRespDtoList = Lists.newArrayList();

        if (CollectionUtils.isNotEmpty(pageInfo.getList())) {
            if (!merchantSearchFlag) {
                // 根据组织ID集合查询符合条件的商家集合
                List<Long> orgIds = pageInfo.getList().stream().map(CustomerRespDto::getOrgInfoId)
                        .collect(Collectors.toList());
                SellerQueryReqDto sellerQueryReqDto = new SellerQueryReqDto();
                sellerQueryReqDto.setOrganizationIds(orgIds);
                sellerQueryReqDto.setTenantId(context.tenantId());
                sellerQueryReqDto.setInstanceId(context.instanceId());
                RestResponse<List<SellerRespDto>> listRestResponse = sellerQueryApi.queryListOnPost(sellerQueryReqDto);
                List<SellerRespDto> sellerRespDtos = RestResponseHelper.extractData(listRestResponse);
                if (CollectionUtils.isNotEmpty(sellerRespDtos)) {
                    sellerMap = sellerRespDtos.stream()
                            .collect(Collectors.toMap(SellerRespDto::getOrganizationId, o -> o, (v1, v2) -> v2));
                }

            }
            MerchantListRespDto merchantListRespDto;
            for (CustomerRespDto customerRespDto : pageInfo.getList()) {
                merchantListRespDto = new MerchantListRespDto();
                SellerRespDto sellerRespDto = sellerMap.get(customerRespDto.getOrgInfoId());
                if (Objects.nonNull(sellerRespDto)) {
                    merchantListRespDto.setMerchantCode(sellerRespDto.getCode());
                    merchantListRespDto.setMerchantName(sellerRespDto.getName());
                    merchantListRespDto.setMerchantId(sellerRespDto.getId());
                }
                merchantListRespDto.setOrgInfoId(customerRespDto.getOrgInfoId());
                merchantListRespDto.setSettleStatus(customerRespDto.getSettleStatus());
                // todo 设置公司名称
                merchantListRespDto.setCompanyName(customerRespDto.getOrgName());
                listRespDtoList.add(merchantListRespDto);
            }
        }

        listRespDtoPageInfo.setList(listRespDtoList);
        return listRespDtoPageInfo;
    }

    @Override
    public PageInfo<CustomerExtRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        // lsw-20220908-因为找回了家客户编码的缘故，故在这里更换方法。
        // RestResponse<PageInfo<CustomerRespDto>> pageInfoRestResponse =
        // customerExtQueryApi.queryByPage(filter, pageNum, pageSize);
        RestResponse<PageInfo<CustomerExtRespDto>> pageInfoRestResponse = this.customerExtThreeQueryApi
                .queryByPage(filter, pageNum, pageSize);
        PageInfo<CustomerExtRespDto> pageInfo = RestResponseHelper.extractData(pageInfoRestResponse);
        if (CollectionUtils.isNotEmpty(pageInfo.getList())) {
            // 根据组织ID集合查询符合条件的商家集合
            Map<Long, SellerRespDto> sellerMap = new HashMap<>();
            Set<Long> orgIds = pageInfo.getList().stream().map(CustomerExtRespDto::getMerchantId)
                    .collect(Collectors.toSet());
            SellerQueryReqDto sellerQueryReqDto = new SellerQueryReqDto();
            sellerQueryReqDto.setOrganizationIds(Lists.newArrayList(orgIds));
            sellerQueryReqDto.setTenantId(context.tenantId());
            sellerQueryReqDto.setInstanceId(context.instanceId());
            RestResponse<List<SellerRespDto>> listRestResponse = sellerQueryApi.queryList(sellerQueryReqDto);
            List<SellerRespDto> sellerRespDtos = RestResponseHelper.extractData(listRestResponse);
            if (CollectionUtils.isNotEmpty(sellerRespDtos)) {
                sellerMap = sellerRespDtos.stream()
                        .collect(Collectors.toMap(SellerRespDto::getOrganizationId, o -> o, (v1, v2) -> v2));
            }

            // 组装考核数据信息
            List<String> customerCodes = pageInfo.getList().stream().map(c -> c.getCode()).collect(Collectors.toList());
            CustomerCheckPatternReqDto customerCheckPatternReqDto = new CustomerCheckPatternReqDto();
            customerCheckPatternReqDto.setCustomerCodes(customerCodes);
            List<CustomerCheckPatternRespDto> customerCheckPatternRespDtos = RestResponseHelper.extractData(
                    customerCheckPatternQueryApi.selectCustomerCheckPatternByCode(customerCheckPatternReqDto));
            Map<String, List<CustomerCheckPatternRespDto>> customerCodeGroupByMap = customerCheckPatternRespDtos
                    .stream().collect(Collectors.groupingBy(key -> key.getCustomerCode()));
            Map<String, List<CustomerCheckPatternRespDto>> mergeCustomerCodeGroupByMap = customerCheckPatternRespDtos
                    .stream()
                    .filter(c -> StringUtils.isNotBlank(c.getMergeCustomerCode()))
                    .collect(Collectors.groupingBy(val -> val.getMergeCustomerCode()));

            // -- 分仓配置查询：用orgId，查询对应的默认仓库
            Map<String, List<WarehouseSupplyRelRespDto>> defaultWarehouse = this.getWarehouseDefaultMap(orgIds);
            // -- 分仓配置查询：用客户id列表，查询对应的分仓配置
            Map<String, List<WarehouseSupplyRelRespDto>> warehouseSupplyMap = this.getWarehouseSupplyMap(pageInfo);

            for (CustomerExtRespDto customerExtRespDto : pageInfo.getList()) {
                SellerRespDto sellerRespDto = sellerMap.get(customerExtRespDto.getMerchantId());
                if (Objects.nonNull(sellerRespDto)) {
                    customerExtRespDto.setMerchantName(sellerRespDto.getName());
                }
                Integer ifWholeCasePurchase = customerExtRespDto.getIfWholeCasePurchase() == null ? 0
                        : customerExtRespDto.getIfWholeCasePurchase();
                customerExtRespDto.setIfWholeCasePurchase(ifWholeCasePurchase);

                // -- 分仓配置赋值：设置客户列表中的分仓信息
                this.setWarehouseSupplyDetail(customerExtRespDto, warehouseSupplyMap, defaultWarehouse);

                List<CustomerCheckPatternRespDto> customerCheckPatternRespDtoList = Lists.newArrayList();
                customerCheckPatternRespDtoList.addAll(
                        customerCodeGroupByMap.getOrDefault(customerExtRespDto.getCode(), Lists.newArrayList()));
                customerCheckPatternRespDtoList.addAll(
                        mergeCustomerCodeGroupByMap.getOrDefault(customerExtRespDto.getCode(), Lists.newArrayList()));

                if (CollectionUtils.isNotEmpty(customerCheckPatternRespDtoList)) {
                    CustomerCheckPatternRespDto customerCheckPatternRespDto = customerCheckPatternRespDtoList.stream()
                            .findFirst().get();
                    customerExtRespDto.setPatternType(customerCheckPatternRespDto.getPatternType());
                    List<CustomerCheckPatternRespDto> customerNames = Lists.newArrayList();
                    customerNames.addAll(customerCheckPatternRespDtoList);
                    customerNames.addAll(customerCheckPatternRespDtoList.stream()
                            .filter(c -> StringUtils.isNotBlank(c.getMergeCustomerName()))
                            .map(c -> {
                                CustomerCheckPatternRespDto checkPatternRespDto = new CustomerCheckPatternRespDto();
                                checkPatternRespDto.setCustomerCode(c.getMergeCustomerCode());
                                checkPatternRespDto.setCustomerName(c.getMergeCustomerName());
                                return checkPatternRespDto;
                            }).collect(Collectors.toList()));
                    // List<String> result = customerNames.stream().filter(c ->
                    // !customerExtRespDto.getName().equals(c)).collect(Collectors.toList());
                    Map<String, CustomerCheckPatternRespDto> collect = customerNames.stream()
                            .collect(Collectors.toMap(key -> key.getCustomerCode(), val -> val, (k1, k2) -> k1));
                    if (CollectionUtils.isNotEmpty(collect.values())) {
                        customerExtRespDto.setCustomerCheckList(collect.values().stream()
                                .filter(c -> !customerExtRespDto.getCode().equals(c.getCustomerCode()))
                                .collect(Collectors.toList()));
                    }
                }
            }
        }
        return pageInfo;
    }

    private void setWarehouseSupplyDetail(CustomerExtRespDto customerExtRespDto,
            Map<String, List<WarehouseSupplyRelRespDto>> warehouseSupplyMap,
            Map<String, List<WarehouseSupplyRelRespDto>> defaultWarehouse) {

        log.info("分仓配置信息 setWarehouseSupplyDetail start. customerExtRespDto={}", JSON.toJSONString(customerExtRespDto));

        // 给所有客户设置默认主仓
        List<WarehouseSupplyRelRespDto> defaultWarehouses = defaultWarehouse.get("0");
        log.info("产品默认仓 defaultWarehouse={}", JSONObject.toJSONString(defaultWarehouses));
        customerExtRespDto.setDeliveryWarehouses(defaultWarehouses);//

        List<WarehouseSupplyRelRespDto> defaultReturnWarehouses = defaultWarehouse.get("1");
        log.info("退货默认仓 defaultReturnWarehouses={}", JSONObject.toJSONString(defaultReturnWarehouses));
        customerExtRespDto.setDeliveryReturnWarehouses(defaultReturnWarehouses);

        // 如果租户打开分仓开关，则设置的查询到的分仓
        if (!this.isWarehouseEnable(customerExtRespDto.getMerchantId())) {
            return;
        } else {
            log.info("产品仓 商家开启分仓功能，经销商客户ID：{}", customerExtRespDto.getMerchantId());
        }

        List<WarehouseSupplyRelRespDto> splitWarehouses = warehouseSupplyMap.get(customerExtRespDto.getId() + "-0");
        log.info("产品分仓 splitWarehouses={}", JSONObject.toJSONString(splitWarehouses));
        if (splitWarehouses != null && !splitWarehouses.isEmpty()) {
            customerExtRespDto.setDeliveryWarehouses(splitWarehouses);
        }

        List<WarehouseSupplyRelRespDto> splitReturnWarehouses = warehouseSupplyMap
                .get(customerExtRespDto.getId() + "-1");
        log.info("退货分仓 splitReturnWarehouses={}", JSONObject.toJSONString(splitReturnWarehouses));
        if (splitReturnWarehouses != null && !splitReturnWarehouses.isEmpty()) {
            customerExtRespDto.setDeliveryReturnWarehouses(splitReturnWarehouses);
        }

        log.info("分仓配置信息 setWarehouseSupplyDetail end. customerExtRespDto={}", JSON.toJSONString(customerExtRespDto));
    }

    private Map<String, List<WarehouseSupplyRelRespDto>> getWarehouseDefaultMap(Set<Long> orgIds) {

        log.info("主仓配置信息 查询默认产品主仓 orgIds={}", JSON.toJSONString(orgIds));

        CsLogicWarehouseQueryDto csLogicWarehouseQueryDto = new CsLogicWarehouseQueryDto();
        csLogicWarehouseQueryDto.setOrganizationId(orgIds.stream().findFirst().get());
        csLogicWarehouseQueryDto.setMainWarehouse(1);// 主仓
        csLogicWarehouseQueryDto.setPageNum(1);
        csLogicWarehouseQueryDto.setPageSize(Integer.MAX_VALUE);
        List<CsLogicSupplyWarehouseRespDto> csLogicWarehouseRespDto = csLogicWarehouseQueryApi
                .querySupplyByPage(csLogicWarehouseQueryDto).getData().getList();
        log.info("主仓配置信息 csLogicWarehouseRespDto={}", JSON.toJSONString(csLogicWarehouseRespDto));

        List<WarehouseSupplyRelRespDto> warehouseSupplyRelRespDtoList = new ArrayList<>();
        for (CsLogicSupplyWarehouseRespDto logicWarehouseRespDto : csLogicWarehouseRespDto) {
            WarehouseSupplyRelRespDto warehouseSupplyRelRespDto = new WarehouseSupplyRelRespDto();
            BeanUtil.copyProperties(logicWarehouseRespDto, warehouseSupplyRelRespDto);

            warehouseSupplyRelRespDtoList.add(warehouseSupplyRelRespDto);
        }

        Map<String, List<WarehouseSupplyRelRespDto>> warehouseSupplyMap = warehouseSupplyRelRespDtoList.stream()
                .collect(Collectors.groupingBy(
                        WarehouseSupplyRelRespDto::getWarehouseType));

        log.info("主仓配置信息 warehouseSupplyMap={}", JSON.toJSONString(warehouseSupplyMap));

        return warehouseSupplyMap;
    }

    private Map<String, List<WarehouseSupplyRelRespDto>> getWarehouseSupplyMap(PageInfo<CustomerExtRespDto> pageInfo) {
        List<Long> customerIds = pageInfo.getList().stream().map(c -> c.getId()).collect(Collectors.toList());
        WarehouseSupplyRelReqDto warehouseSupplyRelReqDto = new WarehouseSupplyRelReqDto();
        warehouseSupplyRelReqDto.setCustomerIds(customerIds);

        List<WarehouseSupplyRelRespDto> warehouseSupplyDetails = RestResponseHelper.extractData(
                warehouseSupplyRelQueryApi.queryByPage(JSON.toJSONString(warehouseSupplyRelReqDto), 1,
                        Integer.MAX_VALUE))
                .getList();

        Map<String, List<WarehouseSupplyRelRespDto>> warehouseSupplyMap = warehouseSupplyDetails.stream()
                .collect(Collectors.groupingBy(
                        e -> e.getCustomerId() + "-" + e.getWarehouseType()));

        log.info("分仓配置信息 warehouseSupplyMap={}", JSON.toJSONString(warehouseSupplyMap));

        return warehouseSupplyMap;
    }

    private boolean isWarehouseEnable(Long merchantId) {
        log.info("查询经销商客户是否开启分仓功能，经销商客户ID： {}", merchantId);
        List<CustomerExtRespDto> customerLssList = customerExtThreeQueryApi
                .queryByOrgIdList(Collections.singletonList(merchantId)).getData();
        log.info("经销商客户信息： {}", JSON.toJSONString(customerLssList));
        if (customerLssList == null || customerLssList.size() != 1) {
            throw new BizException("0001", "查询经销商客户信息异常 customerLssList=" + JSON.toJSONString(customerLssList));
        }
        CustomerExtRespDto customerLss = customerLssList.get(0);
        return ObjectUtils.isNotEmpty(customerLss) && customerLss.getIsWarehouseEnable() == 1;
    }

    @Override
    public MerchantDetailRespDto queryMerchantByCurrentUser() {

        RestResponse<CompanyInfoDto> restResponse = customerExtQueryApi.queryCompanyByCurrentUser();
        CompanyInfoDto companyInfoDto = RestResponseHelper.extractData(restResponse);

        if (Objects.isNull(companyInfoDto)) {
            return null;
        }

        RestResponse<SellerRespDto> sellerRestResp = sellerExtQueryApi
                .querySellerByOrganizationId(companyInfoDto.getOrgInfoId());
        SellerRespDto sellerRespDto = RestResponseHelper.extractData(sellerRestResp);
        if (Objects.isNull(sellerRespDto)) {
            return null;
        }
        MerchantDetailRespDto merchantDetailRespDto = new MerchantDetailRespDto();
        CubeBeanUtils.copyProperties(merchantDetailRespDto, sellerRespDto);
        merchantDetailRespDto.setCompanyInfoDto(companyInfoDto);
        return merchantDetailRespDto;
    }

    /**
     * 注销状态拦截
     */
    private static final List<String> VERIFY_STATE = Lists.newArrayList("注销", "吊销", "撤销", "歇业", "停业", "吊销，未注销办理吊销转注销",
            "吊销，已注销办理吊销转注销", "吊销，未注销", "吊销，已注销");

    @Override
    public StoreRespDto queryCompanyByCreditCode(String creditCode, String customerCode) {


        if (StringUtils.isNotBlank(creditCode)){
            //  处理默认的信用代码
            List<StoreRespDto> storeRespDtoList = getStoreLcalRespDtos();

            if ("TCBJ20220701000001".equals(creditCode) || "TCBJ20220701000002".equals(creditCode)){
                return storeRespDtoList.stream().filter(e -> e.getSocialCreditNum().equals(creditCode)).findFirst().get();
            }

            // 根据信用代码查询得到组织编码，组织编码是cs_customer表的third_party_id字段，查询客户表
            CustomerRespDto cusData = RestResponseHelper
                    .extractData(customerDistributorsQueryApi.queryCustomerBySocialCreditNum(creditCode));
            Assert.isTrue(
                    ObjectUtils.isEmpty(cusData),
                    "0001",
                    "当前信用代码为一级经销商!!!");
        }

        RestResponse<CustomerRespDto> customer = customerQueryApi.queryCustomerByCode(customerCode);
        CustomerRespDto customerRespDto = RestResponseHelper.extractData(customer);
        logger.info("当前校验客户信息：{}", JSON.toJSONString(customerRespDto));



        RestResponse<StoreRespDto> storeRespDtoRestResponse = storeQueryApi.queryStoreRespDtoByCreditNum(creditCode);
        StoreRespDto storeRespDto = RestResponseHelper.extractData(storeRespDtoRestResponse);
        logger.info("药店【{}】详细信息：{}", creditCode, JSON.toJSONString(storeRespDto));

        // 当校验客户类型为零售商时，校验当前商家是否存在相同信用代码注册用户
        if (CustomerTypeEnum.RETAILER.getCode().equals(customerRespDto.getType())) {
            // 先校验信用代码是否未已经经销商
            if (!BeanPropertyNullUtil.isAllFieldNull(storeRespDto)) {
                Assert.isTrue(
                        // 不允许为大客户
                        storeRespDto.getIsCustomer().equals(IsCustomerEnum.NOT_CUSTOMER.getCode()),
                        "0001",
                        "当前信用代码为大客户!!!");
                Assert.isTrue(
                        !VERIFY_STATE.contains(storeRespDto.getState()),
                        "0001",
                        "当前信用代码已注销!!!");

            }

            CustomerExtReqDto customerExtReqDto = new CustomerExtReqDto();
            customerExtReqDto.setCreditCode(creditCode);
            customerExtReqDto.setMerchantId(customerRespDto.getMerchantId());
            List<CustomerRespDto> customerRespDtoList = RestResponseHelper
                    .extractData(customerDistributorsQueryApi.queryCustomerList(customerExtReqDto));
            List<String> customerCodes = customerRespDtoList.stream()
                    .filter(c -> c.getType().equals(CustomerTypeEnum.RETAILER.getCode()))
                    .filter(c -> !c.getCode().equals(customerCode))
                    .map(c -> c.getCode()).collect(Collectors.toList());
            logger.info("校验信用代码查询客户结果集：{}", JSON.toJSONString(customerCodes));
            Assert.isTrue(
                    CollectionUtils.isEmpty(customerCodes),
                    "0001",
                    "商家已存在该零售商客户[" + StringUtils.join(customerCodes, " | ") + "],请检查统一信用代码");
        }

        if (BeanPropertyNullUtil.isAllFieldNull(storeRespDto)) {
            RestResponse<CompanyResultDto> companyResultDtoRestResponse = companyQueryApi
                    .queryCompanyByDesc(creditCode);
            CompanyResultDto companyResultDto = RestResponseHelper.extractData(companyResultDtoRestResponse);
            logger.info("【天眼查】企业基本信息查询结果：{}", JSON.toJSONString(companyResultDto));
            Assert.notNull(companyResultDto, "0001", "查询企业基础信息无数据");
            CompanyResultInfoDto result = companyResultDto.getResult();
            Assert.notNull(result, "0001", "查询企业基础信息无数据");
            Assert.notNull(!StringUtils.equals(result.getRegStatus(), "注销"), "0001", "该企业已经注销，不能注册");
            // 获取省份信息
            TianyanchaProvinceEnum tianyanchaProvince = TianyanchaProvinceEnum.find(result.getBase());
            String provinceName = tianyanchaProvince != null ? tianyanchaProvince.getProvinceName() : null;

            // -- dto省市区code转换
            String provinceCode = getStoreAreaCodeByName(provinceName, "CN",
                    String.valueOf(StoreAreaLevelEnum.PROVINCE.getCode()));

            String cityCode = getStoreAreaCodeByName(result.getCity(), provinceCode,
                    String.valueOf(StoreAreaLevelEnum.CITY.getCode()));
            String districtCode = getStoreAreaCodeByName(result.getDistrict(), cityCode,
                    String.valueOf(StoreAreaLevelEnum.DISTRICT.getCode()));

            StoreRespDto respDto = new StoreRespDto(
                    result.getName(),
                    result.getHistoryNames(),
                    result.getCreditCode(),
                    provinceName,
                    result.getCity(),
                    result.getDistrict(),
                    result.getRegLocation(),
                    result.getRegStatus(),
                    result.getLegalPersonName());

            // 显式设置省市区编码
            respDto.setProvinceCode(provinceCode);
            respDto.setCityCode(cityCode);
            respDto.setDistrictCode(districtCode);

            Assert.isTrue(!BeanPropertyNullUtil.isAllFieldNull(respDto), "0001", "查询企业基础信息无数据");
            return respDto;
        }
        return storeRespDto;
    }

    private static  List<StoreRespDto> getStoreLcalRespDtos() {

        //            公司名称：汤臣倍健内购账户
//            信用代码：TCBJ20220701000001
//            标准省市区：广东省-广州市-天河区
//            法人：汤臣倍健内购账户
//
//            公司名称：汤臣倍健促销账户
//            信用代码：TCBJ20220701000002
//            标准省市区：广东省-广州市-黄埔区
//            法人：汤臣倍健促销账户
        List<StoreRespDto> storeRespDtoList = Lists.newArrayList();
        StoreRespDto storeRespDto = new StoreRespDto();
        storeRespDto.setSocialCreditNum("TCBJ20220701000001");
        storeRespDto.setStoreName("汤臣倍健内购账户");
        storeRespDto.setLegalPersonName("汤臣倍健内购账户");
        storeRespDto.setProvince("广东省");
        storeRespDto.setCity("广州市");
        storeRespDto.setDistrict("天河区");
        storeRespDto.setProvinceCode("440000");
        storeRespDto.setCityCode("440100");
        storeRespDto.setDistrictCode("440106");

        storeRespDtoList.add(storeRespDto);

        storeRespDto = new StoreRespDto();
        storeRespDto.setSocialCreditNum("TCBJ20220701000002");
        storeRespDto.setStoreName("汤臣倍健促销账户");
        storeRespDto.setLegalPersonName("汤臣倍健促销账户");
        storeRespDto.setProvince("广东省");
        storeRespDto.setProvinceCode("440000");
        storeRespDto.setCityCode("440100");
        storeRespDto.setDistrictCode("65900969");

        storeRespDto.setCity("广州市");
        storeRespDto.setDistrict("黄埔区");
        storeRespDtoList.add(storeRespDto);
        return storeRespDtoList;
    }

    @Override
    public CompanyVerifyRespDto verifyCompany(CompanyVerifyReqDto verifyCompanyReqDto) {
        log.info("企业三要素认证开始 verifyCompanyReqDto={}", JSON.toJSONString(verifyCompanyReqDto));

        Assert.notNull(verifyCompanyReqDto.getCode(), "0001", "信用代码不允许为空");
        Assert.notNull(verifyCompanyReqDto.getName(), "0001", "企业名称不允许为空");
        Assert.notNull(verifyCompanyReqDto.getLegalPersonName(), "0001", "法人不允许为空");

        CompanyVerifyRespDto companyVerifyRespDto = null;
        RestResponse<StoreRespDto> storeRespDtoRestResponse = storeQueryApi
                .queryStoreRespDtoByCreditNum(verifyCompanyReqDto.getCode());
        StoreRespDto storeRespDto = RestResponseHelper.extractData(storeRespDtoRestResponse);
        StoreReqDto storeReqDto = null;// 天眼查结果 转换过后的实体类 若全量表有数据，则该变量为null

        if (BeanPropertyNullUtil.isAllFieldNull(storeRespDto) || storeRespDto.getId() == null) {// storeRespDto里面的list是空数组，isAllFieldNull判断会失效
            RestResponse<CompanyVerifyRespDto> companyVerifyRespDtoRestResponse = companyQueryApi
                    .queryCompanyVerify(verifyCompanyReqDto);
            companyVerifyRespDto = RestResponseHelper.extractData(companyVerifyRespDtoRestResponse);
            Assert.notNull(companyVerifyRespDto, "0001", "天眼查三要素校验异常");

            if (companyVerifyRespDto.getResult() != 1) {
                throw new BizException("100000",
                        "天眼查-企业三要素验证异常：验证结果" + CompanyVerifyEnum.fromCode(companyVerifyRespDto.getResult()).getName()
                                + " 描述：" + companyVerifyRespDto.getRemark());
            }

            // 查询门店信息入库 根据信用代码查询
            CompanyResultDto companyResultDto = RestResponseHelper
                    .extractData(companyQueryApi.queryCompanyByDesc(verifyCompanyReqDto.getCode()));
            if (companyResultDto.getError_code() != 0) {
                throw new BizException("100000", "天眼查-企业基本信息异常：错误代码 " + companyResultDto.getError_code());
            }
            logger.info("根据信用代码获取门店详细信息 => {} ", JSON.toJSONString(companyResultDto));

            // 查询门店信息至门店全量表
            storeReqDto = companyResultDtoToStoreRespDto(companyResultDto);
            storeService.saveOrUpdateStore(storeReqDto);

        } else {
            companyVerifyRespDto = new CompanyVerifyRespDto();
            CompanyVerifyEnum companyVerifyEnum = getVerifyEnumFromStore(verifyCompanyReqDto, storeRespDto);

            companyVerifyRespDto.setResult(companyVerifyEnum.getCode());
            companyVerifyRespDto.setRemark(companyVerifyEnum.getName());
        }

        // 在校验三要素的前提下 再校验省市
        if (companyVerifyRespDto.getResult() == 1) {
            if (storeReqDto != null) {// 天眼查数据来校验
                this.verifyProvinceAndName(verifyCompanyReqDto, storeReqDto);
            } else {// 全量表数据来校验
                StoreReqDto param = new StoreReqDto();
                BeanUtil.copyProperties(storeRespDto, param);
                this.verifyProvinceAndName(verifyCompanyReqDto, param);
            }
        }

        log.info("企业三要素认证结束");
        return companyVerifyRespDto;
    }

    // customer中心也有一份白名单 CustomerExtThreeServiceImpl 其他地方的修改功能会调用，改的话要同步改
    private final static List<String> verifyWhiteList = Lists.newArrayList("TCBJ20220701000001", "TCBJ20220701000002");

    private void verifyProvinceAndName(CompanyVerifyReqDto verifyCompanyReqDto, StoreReqDto companyResultDto) {
        log.info("三要素校验 额外省市校验 verifyCompanyReqDto={}, companyResultDto={}", JSON.toJSONString(verifyCompanyReqDto),
                JSON.toJSONString(companyResultDto));
        if (verifyCompanyReqDto.getProvinceCode() == null || verifyCompanyReqDto.getCityCode() == null) {
            // 没传省市 则跳过校验
            log.info("没传省市 则跳过校验");
            return;
        }
        if (companyResultDto.getProvinceCode() == null || companyResultDto.getCityCode() == null) {
            // 天眼查省市映射没有值 则跳过校验
            log.info("天眼查省市映射没有值 则跳过校验");
            return;
        }

        if (verifyWhiteList.contains(verifyCompanyReqDto.getCode())) {
            log.info("信用代码为校验白名单，跳过校验 code={}", verifyCompanyReqDto.getCode());
            return;
        }

        // 1 公司信息入参与全量表校验
        if (!verifyCompanyReqDto.getProvinceCode().equals(companyResultDto.getProvinceCode()) ||
                !verifyCompanyReqDto.getCityCode().equals(companyResultDto.getCityCode())) {
            throw new BizException("100000", "企业省市验证异常：企业所属地址与实际不符");
        }
        // 2 公司信息入参与数据库查询的客户信息校验
        if (verifyCompanyReqDto.getCustomerId() == null) {
            log.info("getCustomerId == null 则跳过校验");
            return;
        }
        CustomerExtRespDto customer = queryCustomerByCusId(verifyCompanyReqDto.getCustomerId());
//        if (!verifyCompanyReqDto.getProvince().equals(customer.getProvince()) ||
//                !verifyCompanyReqDto.getCity().equals(customer.getCity())) {
//            throw new BizException("100000", "企业省市验证异常：门店所属地区与营销云不一致，请核对后再提交！");
//        }

        // 校验客户名称与公司名称匹配度
        RestResponseHelper
                .extractData(customerExtThreeApi.computeCustomerNameRate(ComputeCustomerNameRateReqDto.builder()
                        .orgName(verifyCompanyReqDto.getName())
                        .cusName(customer.getName())
                        .creditCode(verifyCompanyReqDto.getCode())
                        .build()));
    }

    private CustomerExtRespDto queryCustomerByCusId(String cusId) {
        CustomerExtRespDto customerExtRespDto = RestResponseHelper
                .extractData(customerExtThreeQueryApi.queryById(cusId));
        if (customerExtRespDto != null) {
            return customerExtRespDto;
        }
        throw new BizException("100000", "企业省市验证异常：客户id查询不到对应数据 cusId=" + cusId);
    }

    private CompanyVerifyEnum getVerifyEnumFromStore(CompanyVerifyReqDto verifyCompanyReqDto,
            StoreRespDto storeRespDto) {
        log.info("三要素校验 查询全量表对比 verifyCompanyReqDto={}, storeRespDto={}", JSONObject.toJSONString(verifyCompanyReqDto),
                JSONObject.toJSONString(storeRespDto));
        boolean companyNameValid = verifyCompanyReqDto.getName()
                .equals(StringUtils.defaultString(storeRespDto.getStoreName(), ""));
        boolean legalPersonValid = verifyCompanyReqDto.getLegalPersonName()
                .equals(StringUtils.defaultString(storeRespDto.getLegalPersonName(), ""));
        CompanyVerifyEnum companyVerifyEnum = null;
        if (!companyNameValid) {
            companyVerifyEnum = CompanyVerifyEnum.FAIL_NAME;
            return companyVerifyEnum;
        }
        if (!legalPersonValid) {
            companyVerifyEnum = CompanyVerifyEnum.FAIL_LEGALPERSONNAME;
            return companyVerifyEnum;
        }
        companyVerifyEnum = CompanyVerifyEnum.SUCCESS;
        log.info("三要素校验 查询全量表对比结束 companyVerifyEnum={}", JSONObject.toJSONString(companyVerifyEnum));
        return companyVerifyEnum;
    }

    /**
     * 解析天眼查门店信息入库
     * 
     * @param companyResultDto
     */
    private StoreReqDto companyResultDtoToStoreRespDto(CompanyResultDto companyResultDto) {
        CompanyResultInfoDto result = companyResultDto.getResult();
        StoreReqDto storeReqDto = StoreReqDto.builder()
                .storeName(result.getName())
                .storeAlias(result.getHistoryNames())
                .socialCreditNum(result.getCreditCode())
                .province(result.getBase())
                .city(result.getCity())
                .district(result.getDistrict())
                .storeAddr(result.getRegLocation())
                .storeRegisterAddr(result.getRegLocation())
                .state(result.getRegStatus())
                .legalPersonName(result.getLegalPersonName())
                .isReplenish(IsDealEnum.NOT_DEAL.getCode())
                .dataOrigin(StoreDataOriginEnum.SKY_EYE_QUERY.getCode())
                // .storeType(StoreTypeEnum.IT.getName())
                .storeType("其他")
                .build();

        // 天眼查省份拼音转换匹配 cs_store_area
        // 获取省name
        TianyanchaProvinceEnum tianyanchaProvince = TianyanchaProvinceEnum.find(result.getBase());
        log.info("天眼查省份信息映射 ==> 天眼查结果: {}; 映射结果 {}", result.getBase(),
                tianyanchaProvince == null ? null : tianyanchaProvince.getProvinceName());
        if (tianyanchaProvince != null) {
            storeReqDto.setProvince(tianyanchaProvince.getProvinceName());
            storeReqDto.setProvinceCode(tianyanchaProvince.getProvinceCode());

            // 直辖市的level_1(省)名为"北京"，level_2(市)名为"北京市" (天眼查返回的数据为'市辖区')
            if (TianyanchaProvinceEnum.BIG_CITY.contains(tianyanchaProvince.getProvinceName())
                    && "市辖区".equals(result.getCity())) {
                String bigCityName = tianyanchaProvince.getProvinceName() + "市";
                log.info("天眼查直辖市映射 ==> 天眼查结果: {}; 映射结果 {}", result.getCity(), bigCityName);
                result.setCity(bigCityName);// 覆盖请求参数
                storeReqDto.setCity(bigCityName);// 覆盖返回参数
            }

            // 获取市code
            String cityCode = getStoreAreaCodeByName(result.getCity(), tianyanchaProvince.getProvinceCode(),
                    String.valueOf(StoreAreaLevelEnum.CITY.getCode()));
            storeReqDto.setCityCode(cityCode);
            if (cityCode != null) {
                // 获取区code
                String districtCode = getStoreAreaCodeByName(result.getDistrict(), cityCode,
                        String.valueOf(StoreAreaLevelEnum.DISTRICT.getCode()));
                storeReqDto.setDistrictCode(districtCode);
            }
        }

        return storeReqDto;
    }

    private String getStoreAreaCodeByName(String name, String parentCode, String level) {
        log.info("根据区域名称获取区域code参数 ==> 区域名称: {}; 区域parentCode {}; level {}", name, parentCode, level);
        if (parentCode == null) {
            return null;
        }
        StoreAreaRespDto storeAreaRespDto = RestResponseHelper
                .extractData(storeAreaQueryApi.queryByProvince(StoreQueryProvinceReqDto.builder()
                        .parentCode(parentCode)
                        .level(level)
                        .name(name)
                        .build()));
        log.info("根据区域名称获取区域code结果 ==> 区域code: {}", storeAreaRespDto.getCode());
        return storeAreaRespDto.getCode();
    }

    @Override
    public Void updateCustomerStatus(Long id, Long statusId) {
        this.updateCusAndSellerstatus(id, statusId, null);
        return null;
    }

    private Void updateCusAndSellerstatus(Long id, Long statusId, String flag) {
        // 查询客户对应的组织id
        RestResponse<CustomerExtDetailRespDto> cusResp = customerExtQueryApi.queryById(id);
        CustomerExtDetailRespDto respDto = RestResponseHelper.extractData(cusResp);
        if (ObjectUtils.isEmpty(respDto) || ObjectUtils.isEmpty(respDto.getOrgInfoId())) {
            throw new BizException("100000", "商家组织信息为空");
        }
        if (ObjectUtils.isEmpty(respDto.getStatusId())) {
            // 状态id为空或者状态id一致的情况下就没必要重复去设置
            logger.info("客户id为:{},其状态ID为空,不更新客户状态和商家状态", id);
            return null;
        }

        // 禁用客户表客户，ALL情况表示已经前面更新过了，没必要更新，非All才需要单独更新
        if (!"ALL".equals(flag)) {
            RestResponse<Void> resp = this.customerExtThreeApi.updateCustomerStatus(id, statusId);
            RestResponseHelper.extractData(resp);
        }
        // 查询客户组织对应的店铺信息
        RestResponse<SellerRespDto> sellerResp = sellerExtQueryApi.querySellerByOrganizationId(respDto.getOrgInfoId());
        SellerRespDto sellerRespDto = RestResponseHelper.extractData(sellerResp);
        // 店铺信息非空的情况下要进行根据客户状态进行店铺的启用和停用
        if (ObjectUtils.isNotEmpty(sellerRespDto) && ObjectUtils.isNotEmpty(sellerRespDto.getId())) {
            StatusReqDto statusReqDto = new StatusReqDto();
            statusReqDto.setId(sellerRespDto.getId());
            RestResponse<CustomerStatusRespDto> statusResp = customerStatusQueryApi.queryById(statusId);
            CustomerStatusRespDto statusRespDto = RestResponseHelper.extractData(statusResp);
            if (CustomerStatusEnum.ENABLED.getCode().equals(statusRespDto.getCode())
                    // 按业务需要：小b状态改为【注销】时，三要素校验暂不失效，暂不限制退货下单。shizy 20231010
                    || CustomerStatusEnum.CANCEL.getCode().equals(statusRespDto.getCode())) {
                statusReqDto.setStatus(SellerStatusEnum.NORMAL.getCode());
            } else {
                statusReqDto.setStatus(SellerStatusEnum.BANNED.getCode());
            }
            RestResponse<Void> changeResp = sellerExtApi.changeStatus(statusReqDto);
            RestResponseHelper.extractData(changeResp);
        }
        return null;
    }

    @Override
    public void update(CustomerReqExtDto reqDto) {
        RestResponse<Void> updateResp = this.customerExtThreeApi.update(reqDto);
        RestResponseHelper.extractData(updateResp);
        this.updateCusAndSellerstatus(reqDto.getId(), reqDto.getStatusId(), "ALL");
        this.updateCusNameForDealer(reqDto);
    }

    /**
     * 修改经销商名称后，同步修改其他关联表的公司名称
     */
    private void updateCusNameForDealer(CustomerReqExtDto reqDto) {
        // 只处理经销商
        if (!CustomerTypeEnum.DEALER.getCode().equals(reqDto.getType())) {
            return;
        }
        // 用 organizationId 修改公司 name
        if (reqDto.getOrgInfoId() == null || StringUtils.isEmpty(reqDto.getName())) {
            return;
        }

        logger.info("同步修改关联表公司名称 start. organizationId={}, name={}", reqDto.getOrgInfoId(), reqDto.getName());
        // 1 update yx_ppe_user.us_organization
        Integer updateOrganizationResult = RestResponseHelper
                .extractData(organizationThreeApi.modify(ModifyOrganizationReqDto.builder()
                        .id(reqDto.getOrgInfoId())
                        .name(reqDto.getName())
                        .build()));
        logger.info("同步修改关联表公司名称 修改 us_organization 表成功 result={}; id={}", updateOrganizationResult,
                reqDto.getOrgInfoId());

        // 2 update yx_ppe_shop.sc_seller。删除缓存SellerEo
        SellerRespDto sellerRespDto = RestResponseHelper
                .extractData(sellerExtQueryApi.querySellerByOrganizationId(reqDto.getOrgInfoId()));
        if (sellerRespDto != null && sellerRespDto.getId() != null) {
            SellerToBReqDto sellerToBReqDto = new SellerToBReqDto();
            sellerToBReqDto.setSellerId(sellerRespDto.getId());
            sellerToBReqDto.setName(reqDto.getName());
            sellerToBReqDto.setOrganizationName(reqDto.getName());
            RestResponseHelper.extractData(sellerExtApi.modifySeller(sellerToBReqDto));
            logger.info("同步修改关联表公司名称 修改 sc_seller 表成功 id={}", sellerRespDto.getId());
        }

        // 3 update yx_ppe_shop.sc_shop。删除缓存ShopEo、shop_detail
        List<ShopBaseDto> shopBaseDtos = RestResponseHelper
                .extractData(shopExtQueryApi.queryShopListBySellerOrgId(reqDto.getOrgInfoId()));
        for (ShopBaseDto shopBaseDto : shopBaseDtos) {
            ShopToBDto shopToBDto = new ShopToBDto();
            shopToBDto.setId(shopBaseDto.getId());
            if (shopBaseDtos.size() > 1) {
                shopToBDto.setName(reqDto.getName() + "-" + shopBaseDto.getCode());// 避免重名报错
            } else {
                shopToBDto.setName(reqDto.getName());
            }
            shopToBDto.setOrganizationName(reqDto.getName());

            // shop-center的缓存删除不完全，会查到旧数据。这里主动删一遍
            ShopToBQueryReqDto shopToBQueryReqDto = new ShopToBQueryReqDto();
            shopToBQueryReqDto.setSellerId(shopBaseDto.getId());
            shopExtQueryV3Api.deleteCache(shopToBQueryReqDto);
            // updateShop
            RestResponseHelper.extractData(shopExtApi.updateShop(shopToBDto));
            logger.info("同步修改关联表公司名称 修改 sc_shop 表成功 id={}", shopBaseDto.getId());
        }

        // 4 update yx_ppe_customer.cs_store_seller_govern
        StoreSellerGovernReqDto StoreSellerGovernReqDto = new StoreSellerGovernReqDto();
        StoreSellerGovernReqDto.setCompanyName(reqDto.getName());
        StoreSellerGovernReqDto.setSellerName(reqDto.getName());
        StoreSellerGovernReqDto.setOrganizationId(reqDto.getOrgInfoId());
        Integer updateStoreSellerGovernResult = RestResponseHelper
                .extractData(storeSellerGovernApi.updateByOrganizationId(StoreSellerGovernReqDto));
        logger.info("同步修改关联表公司名称 修改 cs_store_seller_govern 表成功 result={}", updateStoreSellerGovernResult);

        logger.info("同步修改关联表公司名称 end. ");
    }

    @Override
    public RestResponse<CustomerAddResultDto> add(CustomerReqExtDto reqDto) {
        return this.customerExtThreeApi.add(reqDto);
    }

    @Override
    public RestResponse<List<String>> batchUpCusIfWholePurchase(CustomerBatchUpReqDto reqDto) {
        if (CollectionUtils.isNotEmpty(reqDto.getCustomerIds()) && reqDto.getDr() != null && reqDto.getDr().equals(1)) {
            List<DrCustomersReqDto> drCustomerLists = new ArrayList<>();
            for (Long id : reqDto.getCustomerIds()) {
                drCustomerLists.add(new DrCustomersReqDto(id, RestResponseHelper
                        .extractData(this.saleOrderReportQueryApi.queryCountByCustomerId(id.toString()))));
            }
            reqDto.setDrCustomerLists(drCustomerLists);
            reqDto.setCustomerIds(null);
        }
        return this.customerExtThreeApi.batchUpCusIfWholePurchase(reqDto);
    }
}
