package com.dtyunxi.yundt.module.customer.biz.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.biz.commons.utils.ExecutorUtils;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.oss.api.IObjectStorageService;
import com.dtyunxi.huieryun.oss.vo.OssRegistryVo;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.module.export.biz.constant.ExportTypeEnum;
import com.dtyunxi.tcbj.module.export.biz.impl.BaseExportService;
import com.dtyunxi.tcbj.module.export.biz.impl.ExportService;
import com.dtyunxi.yundt.cube.center.credit.api.credit.ICreditEntityApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.ICustomerApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.constants.CustomerExportType;
import com.dtyunxi.yundt.cube.center.customer.api.customer.constants.CustomerTypeEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerAreaListReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerSearchReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.ExportRecordReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerAreaRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerNameSimpleRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerTypeRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerAreaQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerTypeQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.query.IEmployeeCustomerQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.response.ItemAuthRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.query.IOrderQueryTobApi;
import com.dtyunxi.yundt.cube.center.user.api.ICustomerOrgInfoApi;
import com.dtyunxi.yundt.cube.center.user.api.ICustomerUserApi;
import com.dtyunxi.yundt.cube.center.user.api.IUserApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.*;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgAndOrgInfoRespDto;
import com.dtyunxi.yundt.cube.center.user.api.query.*;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.customer.api.ICustomerExtService;
import com.dtyunxi.yundt.module.customer.api.ICustomerService;
import com.dtyunxi.yundt.module.customer.api.IFileService;
import com.dtyunxi.yundt.module.customer.api.dto.request.CustomerDetailReqDto;
import com.dtyunxi.yundt.module.customer.api.dto.request.CustomerSearchExtReqDto;
import com.dtyunxi.yundt.module.customer.api.dto.request.UserAccountReqDto;
import com.dtyunxi.yundt.module.customer.api.dto.response.CustomerDetailAddRespDto;
import com.dtyunxi.yundt.module.customer.api.dto.response.CustomerDetailRespDto;
import com.dtyunxi.yundt.module.customer.api.dto.response.CustomerListRespDto;
import com.dtyunxi.yundt.module.customer.api.enums.SrcTypeEnum;
import com.dtyunxi.yundt.module.customer.api.exception.CustomerModuleExceptionCode;
import com.dtyunxi.yundt.module.customer.biz.mq.producer.CustomerChangeProducer;
import com.dtyunxi.yundt.module.customer.biz.vo.CustomerExportExtVo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.response.CustomerAuthItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.query.ICustomerAuthItemQueryExtApi;
import com.dtyunxi.yundt.module.customer.api.dto.response.CustomerSkuAuthCountRespDto;
import com.dtyunxi.yundt.module.customer.api.dto.response.CustomerSkuAuthBatchCountRespDto;
import com.yx.tcbj.center.customer.api.dto.response.CustomerExtRespDto;
import com.yx.tcbj.center.customer.api.query.ICustomerExtThreeQueryApi;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.io.ByteArrayInputStream;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 客户服务实现
 *
 * @author: xuhuaqiang
 */
@Service("customerService")
public class CustomerServiceImpl implements ICustomerService {

    private static Logger logger = LoggerFactory.getLogger(CustomerServiceImpl.class);

    @Resource
    private ICacheService cacheService;

    @Resource
    private ICustomerOrgInfoApi customerOrgInfoApi;

    @Resource
    private ICustomerApi customerApi;

    @Autowired
    private IUserApi userApi;

    @Resource
    private IUserQueryApi userQueryApi;

    @Resource
    private IEmployeeExpandQueryApi employeeExpandQueryApi;

    @Resource
    private IOrganizationQueryExtApi organizationQueryExtApi;

    @Resource
    private IBizOrganizationQueryApi bizOrganizationQueryApi;

    @Resource
    private ICustomerQueryApi customerQueryApi;

    @Resource
    private ICustomerExtThreeQueryApi customerExtThreeQueryApi;


    @Resource
    private ICustomerAreaQueryApi customerAreaQueryApi;

    @Resource
    private ICustomerUserQueryApi customerUserQueryApi;

    @Resource
    private ICustomerUserApi customerUserApi;

    @Resource
    private ICustomerOrgInfoQueryApi customerOrgInfoQueryApi;

    @Resource
    private ICustomerTypeQueryApi customerTypeQueryApi;

    @Resource
    private IContext context;

    @Resource
    private IObjectStorageService objectStorageService;
    @Resource
    private OssRegistryVo ossRegistryVo;
    @Resource
    private ICommonsMqService commonsMqService;

    @Resource
    private IOrderQueryTobApi orderQueryTobApi;

    @Resource
    private CustomerChangeProducer customerChangeProducer;

    @Resource
    private ICreditEntityApi iCreditEntityApi;
    @Resource
    private IEmployeeCustomerQueryApi employeeCustomerQueryApi;

    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;

    @Resource
    private IOrganizationQueryApi organizationQueryApi;
    @Resource
    private HttpServletRequest request;
    @Resource
    private ICustomerExtService customerExtService;
    @Resource
    private ExportService exportService;
    
    @Resource
    private com.dtyunxi.yundt.cube.center.item.api.b2b.query.IItemAuthQueryApi itemAuthQueryApi;

    @Resource
    private ICustomerAuthItemQueryExtApi customerAuthItemQueryExtApi;

    /**
     * 获取请求头的组织ID
     *
     * @return 组织ID
     */
    public String getHeaderOrgId() {
        String organizationId = request.getHeader("yes-req-cus-b2b-organizationId");
        logger.info("获取请求头组织ID：{}", organizationId);
        return organizationId;
    }

    /**
     * 检查区域编码是否有效
     * @author  惜笔
     * @date  2021-08-27 14:01
     * @param reqDto
     * @return void
     */
    private void checkCustomerArea(CustomerDetailReqDto reqDto){
        List<String> regionCodeList = reqDto.getRegionCodeList();
        if (CollUtil.isEmpty(regionCodeList)){
            return;
        }
        reqDto.setRegionCodeList(new HashSet<>(regionCodeList).stream().collect(Collectors.toList()));
        CustomerAreaListReqDto customerAreaListReqDto = new CustomerAreaListReqDto();
        customerAreaListReqDto.setCodes(regionCodeList);
        customerAreaListReqDto.setOrgInfoId(reqDto.getOrgInfoId());
        RestResponse<List<CustomerAreaRespDto>> listRestResponse = customerAreaQueryApi.queryForList(customerAreaListReqDto);
        List<CustomerAreaRespDto> customerAreaRespDtos = RestResponseHelper.extractData(listRestResponse);
        // 如果查询不到或者返回的数量不一致，则代表有区域缺失
        if (CollUtil.isEmpty(customerAreaRespDtos) || customerAreaRespDtos.size() != regionCodeList.size()){
            throw new BizException(CustomerModuleExceptionCode.REGION_NO_EXISTS.getCode(),
                    CustomerModuleExceptionCode.REGION_NO_EXISTS.getMsg());
        }
        reqDto.setRegionNameList(customerAreaRespDtos.stream().map(CustomerAreaRespDto::getName).collect(Collectors.toList()));
    }

    @Override
    public CustomerDetailAddRespDto add(CustomerDetailReqDto reqDto) {
        logger.info("开始创建客户信息,CustomerDetailReqDto:{}", JSON.toJSONString(reqDto));
        Long instanceId = context.instanceId();
        Long tenantId = context.tenantId();
        reqDto.setInstanceId(instanceId);
        reqDto.setTenantId(tenantId);

        //调用客商中心，校验客户类型是否存在
        if (Objects.nonNull(reqDto.getCustomerTypeId())) {
            String cacheKey_customerType = "customerTypeById_" + reqDto.getCustomerTypeId().toString();
            CustomerTypeRespDto customerTypeRespDto = cacheService.getCache(cacheKey_customerType, CustomerTypeRespDto.class);
            if (Objects.isNull(customerTypeRespDto)) {
                RestResponse<CustomerTypeRespDto> restResponse = customerTypeQueryApi.queryById(reqDto.getCustomerTypeId());
                customerTypeRespDto = RestResponseHelper.extractData(restResponse);
                //校验客户类型是否存在
                if (Objects.isNull(customerTypeRespDto)) {
                    throw new BizException(CustomerModuleExceptionCode.CUSTOMER_TYPE_NO_EXISTS.getCode(),
                            CustomerModuleExceptionCode.CUSTOMER_TYPE_NO_EXISTS.getMsg());
                }
                else {
                    //加10秒的缓存，压测时减少查询
                    cacheService.add(cacheKey_customerType, customerTypeRespDto, 10);
                }
            }
        }
        //校验客户区域是否存在
        this.checkCustomerArea(reqDto);

        //调用客商中心，新增客户信息
        RestResponse<Long> restResponse = customerApi.add(reqDto);
        Long customerId = RestResponseHelper.extractData(restResponse);

        //构建客户组织对象
        CustomerOrgInfoDto orgInfoDto = createCustomerOrgInfo(reqDto);
        orgInfoDto.setId(customerId);
        reqDto.setId(customerId);
        orgInfoDto.setExtension("");
        logger.info("新增客户组织信息...，入参CustomerOrgInfoDto：{}", JSON.toJSONString(orgInfoDto));
        //向用户中心发送mq
//        commonsMqService.sendSingleMessage(MessageTag.MQ_QUEUE_ORGANIZATION_INFO, JSON.toJSONString(orgInfoDto));
        customerChangeProducer.sendCustomerChangeMq(orgInfoDto);

        CustomerDetailAddRespDto respDto = new CustomerDetailAddRespDto();
        respDto.setId(customerId);
        respDto.setOrgInfoId(customerId);
        return respDto;
    }

    @Override
    public CustomerDetailAddRespDto saveAll(CustomerDetailReqDto reqDto) {
        logger.info("开始保存全部客户相关信息,CustomerDetailReqDto:{}", JSON.toJSONString(reqDto));
        Long instanceId = context.instanceId();
        Long tenantId = context.tenantId();
        //校验登录账号的用户名是否已被注册
        if (Objects.nonNull(reqDto.getUserAccountReqDto())) {
            List<SqlFilter> userFilters = Lists.newArrayList();
            userFilters.add(SqlFilter.eq("userName", reqDto.getUserAccountReqDto().getUserName()));
            Map<String, Object> filterMap = Maps.newHashMap();
            filterMap.put("filters", userFilters);
            filterMap.put("instanceId", instanceId);
            String queryFilter = JSONObject.toJSONString(filterMap);
            RestResponse<PageInfo<UserDto>> pageInfoRestResponse = userQueryApi.queryByPage(queryFilter, 1, 1);
            PageInfo<UserDto> userDtoPageInfo = RestResponseHelper.extractData(pageInfoRestResponse);
            if (Objects.nonNull(userDtoPageInfo)) {
                if (reqDto.getUserAccountReqDto().getUserId() == null && CollectionUtils.isNotEmpty(userDtoPageInfo.getList())) {

                    throw new BizException(CustomerModuleExceptionCode.USER_NAME_EXISTS.getCode(),
                            CustomerModuleExceptionCode.USER_NAME_EXISTS.getMsg());

                } else if (reqDto.getUserAccountReqDto().getUserId() != null && CollectionUtils.isNotEmpty(userDtoPageInfo.getList()) &&
                        !userDtoPageInfo.getList().get(0).getId().equals(reqDto.getUserAccountReqDto().getUserId())) {

                    throw new BizException(CustomerModuleExceptionCode.USER_NAME_EXISTS.getCode(),
                            CustomerModuleExceptionCode.USER_NAME_EXISTS.getMsg());
                }
            }
        }
        if (Objects.isNull(reqDto.getId())) {
            //新增客户信息
            CustomerDetailAddRespDto addRespDto = this.add(reqDto);
            //调用用户中心新增登录账号信息
            UserAccountReqDto userAccountReqDto = reqDto.getUserAccountReqDto();
            if (Objects.nonNull(userAccountReqDto)) {
                userAccountReqDto.setOrgInfoId(addRespDto.getOrgInfoId());
                this.addCustomerAccount(userAccountReqDto);
            }
            //新增联系人信息集合
            List<ContactsInfoDto> contactsInfoDtos = reqDto.getContactsInfoList();
            if (CollectionUtils.isNotEmpty(contactsInfoDtos)){
                for (ContactsInfoDto contactsInfoDto : contactsInfoDtos) {
                    contactsInfoDto.setOrgInfoId(addRespDto.getOrgInfoId());
                    contactsInfoDto.setInstanceId(instanceId);
                    contactsInfoDto.setTenantId(tenantId);
                    RestResponse<Long> addContactsRestResp = customerUserApi.addCustomerContactsInfo(contactsInfoDto);
                    RestResponseHelper.extractData(addContactsRestResp);
                }
            }
            //新增财务信息集合
            List<BillInfoDto> billInfoDtos = reqDto.getBillInfoList();
            if (CollectionUtils.isNotEmpty(billInfoDtos)){
                for (BillInfoDto billInfoDto : billInfoDtos) {
                    billInfoDto.setOrgInfoId(addRespDto.getOrgInfoId());
                    billInfoDto.setInstanceId(instanceId);
                    billInfoDto.setTenantId(tenantId);
                    RestResponse<Long> addBillInfoRestResp = customerUserApi.addCustomerBillInfo(billInfoDto);
                    RestResponseHelper.extractData(addBillInfoRestResp);
                }
            }
            //新增地址信息
            AddressDto addressDto = reqDto.getAddressDto();
            if (Objects.nonNull(addressDto)) {
                addressDto.setOrgInfoId(addRespDto.getOrgInfoId());
                addressDto.setInstanceId(instanceId);
                addressDto.setTenantId(tenantId);
                RestResponse<Long> addAddressRestResp = customerUserApi.addCustomerAddress(addressDto);
                RestResponseHelper.extractData(addAddressRestResp);
            }
            return addRespDto;
        } else {
            CustomerDetailAddRespDto updateRespDto = new CustomerDetailAddRespDto();
            updateRespDto.setOrgInfoId(reqDto.getOrgInfoId());
            updateRespDto.setId(reqDto.getId());
            //更新客户信息
            this.update(reqDto);
            //调用用户中心新增/更新登录账号信息
            UserAccountReqDto userAccountReqDto = reqDto.getUserAccountReqDto();
            if (Objects.nonNull(userAccountReqDto)) {
                userAccountReqDto.setOrgInfoId(updateRespDto.getOrgInfoId());
                if (Objects.isNull(userAccountReqDto.getUserId())) {
                    this.addCustomerAccount(userAccountReqDto);
                } else {
                    this.updateCustomerAccount(userAccountReqDto);
                }

            }
            //新增/更新联系人信息集合
            List<ContactsInfoDto> contactsInfoDtos = reqDto.getContactsInfoList();
            if (CollectionUtils.isNotEmpty(contactsInfoDtos)){
                for (ContactsInfoDto contactsInfoDto : contactsInfoDtos) {
                    contactsInfoDto.setOrgInfoId(updateRespDto.getOrgInfoId());
                    contactsInfoDto.setInstanceId(instanceId);
                    contactsInfoDto.setTenantId(tenantId);
                    if (Objects.isNull(contactsInfoDto.getId())) {
                        RestResponse<Long> addContactsRestResp = customerUserApi.addCustomerContactsInfo(contactsInfoDto);
                        RestResponseHelper.extractData(addContactsRestResp);
                    } else {
                        RestResponse<Void> updateContactsRestResp = customerUserApi.updateCustomerContactsInfo(contactsInfoDto);
                        RestResponseHelper.extractData(updateContactsRestResp);
                    }
                }
            }
            //新增/更新财务信息集合
            List<BillInfoDto> billInfoDtos = reqDto.getBillInfoList();
            if (CollectionUtils.isNotEmpty(billInfoDtos)){
                for (BillInfoDto billInfoDto : billInfoDtos) {
                    billInfoDto.setOrgInfoId(updateRespDto.getOrgInfoId());
                    billInfoDto.setInstanceId(instanceId);
                    billInfoDto.setTenantId(tenantId);
                    if (Objects.isNull(billInfoDto.getId())) {
                        RestResponse<Long> addBillInfoRestResp = customerUserApi.addCustomerBillInfo(billInfoDto);
                        RestResponseHelper.extractData(addBillInfoRestResp);
                    } else {
                        RestResponse<Void> updateBillInfoRestResp = customerUserApi.updateCustomerBillInfo(billInfoDto);
                        RestResponseHelper.extractData(updateBillInfoRestResp);
                    }
                }
            }
            //新增/更新地址信息
            AddressDto addressDto = reqDto.getAddressDto();
            if (Objects.nonNull(addressDto)) {
                addressDto.setOrgInfoId(updateRespDto.getOrgInfoId());
                addressDto.setInstanceId(instanceId);
                addressDto.setTenantId(tenantId);
                if (Objects.isNull(addressDto.getId())) {
                    RestResponse<Long> addAddressRestResp = customerUserApi.addCustomerAddress(addressDto);
                    RestResponseHelper.extractData(addAddressRestResp);
                } else {
                    RestResponse<Void> updateAddressRestResp = customerUserApi.updateCustomerAddress(addressDto);
                    RestResponseHelper.extractData(updateAddressRestResp);
                }
            }

            return updateRespDto;
        }
    }


    @Override
    public void update(CustomerDetailReqDto reqDto) {
        logger.info("开始修改客户信息,CustomerDetailReqDto:{}", JSON.toJSONString(reqDto));
        Long instanceId = context.instanceId();
        Long tenantId = context.tenantId();
        reqDto.setInstanceId(instanceId);
        reqDto.setTenantId(tenantId);
        //调用客商中心，校验客户类型是否存在
        if (Objects.nonNull(reqDto.getCustomerTypeId())) {
            RestResponse<CustomerTypeRespDto> restResponse = customerTypeQueryApi.queryById(reqDto.getCustomerTypeId());
            CustomerTypeRespDto customerTypeRespDto = RestResponseHelper.extractData(restResponse);
        }
        //校验所属区域是否存在
        this.checkCustomerArea(reqDto);
//        if (StringUtils.isNotEmpty(reqDto.getRegionCode())) {
//            RestResponse<AreaGroupDetailRespDto> areaGroupRestResponse = areaGroupQueryApi.queryByCode(reqDto.getRegionCode());
//            AreaGroupDetailRespDto groupDetailRespDto = RestResponseHelper.extractData(areaGroupRestResponse);
//            if (Objects.isNull(groupDetailRespDto)) {
//                throw new BizException(CustomerModuleExceptionCode.RECORD_NOT_EXIST.getCode(),
//                        CustomerModuleExceptionCode.RECORD_NOT_EXIST.getMsg());
//            }
//        }
        //创建客户组织信息
        CustomerOrgInfoDto orgInfoDto = createCustomerOrgInfo(reqDto);
        //todo orgInfoId为空时需要去客商中心获取该客户的orgInfoId
        if (Objects.isNull(reqDto.getOrgInfoId())) {
            RestResponse<CustomerRespDto> customerRestResp = customerQueryApi.queryById(reqDto.getId());
            CustomerRespDto customerRespDto = RestResponseHelper.extractData(customerRestResp);
            reqDto.setOrgInfoId(customerRespDto.getOrgInfoId());
        }
        orgInfoDto.setId(reqDto.getOrgInfoId());
        //调用用户中心，更新客户组织信息
        orgInfoDto.setExtension("");
        logger.info("更新客户组织信息...，入参CustomerOrgInfoDto：{}", JSON.toJSONString(orgInfoDto));
//        RestResponse<Void> updateResponse = customerOrgInfoApi.updateCustomerOrgInfo(orgInfoDto);
//        RestResponseHelper.extractData(updateResponse);
        //调用客商中心，更新客户信息
        RestResponse<Void> restResponse = customerApi.update(reqDto);
        RestResponseHelper.extractData(restResponse);
        //向用户中心发送mq
//        commonsMqService.sendSingleMessage(MessageTag.MQ_QUEUE_ORGANIZATION_INFO, JSON.toJSONString(orgInfoDto));
        customerChangeProducer.sendCustomerChangeMq(orgInfoDto);
    }

    @Override
    public void addCustomerAccount(UserAccountReqDto userAccountReqDto) {
        logger.info("开始创建客户账号信息,CustomerDetailReqDto:{}", JSON.toJSONString(userAccountReqDto));
        UserDto userDto = new UserDto();
        BeanUtils.copyProperties(userAccountReqDto, userDto);
        Long instanceId = context.instanceId();
        Long tenantId = context.tenantId();
        userDto.setTenantId(tenantId);
        userDto.setInstanceId(instanceId);
        RestResponse<Long> longRestResponse = userApi.addUser(instanceId, userDto);
        Long userId = RestResponseHelper.extractData(longRestResponse);
        CustomerReqDto customerReqDto = new CustomerReqDto();
        BeanUtils.copyProperties(userAccountReqDto, customerReqDto);
        customerReqDto.setUserId(userId);
        customerReqDto.setOrgInfoId(userAccountReqDto.getOrgInfoId());
        customerApi.updateAccountStatus(customerReqDto);
    }

    @Override
    public void updateCustomerAccount(UserAccountReqDto userAccountReqDto) {
        logger.info("开始编辑客户账号信息,CustomerDetailReqDto:{}", JSON.toJSONString(userAccountReqDto));
        UserDto userDto = new UserDto();
        BeanUtils.copyProperties(userAccountReqDto, userDto);
        Long instanceId = context.instanceId();
        Long tenantId = context.tenantId();
        userDto.setTenantId(tenantId);
        userDto.setInstanceId(instanceId);

        RestResponse<Void> restResponse = userApi.updatePasswordPermitted(userAccountReqDto.getUserId(), userDto);
        RestResponseHelper.checkOrThrow(restResponse);


        CustomerReqDto customerReqDto = new CustomerReqDto();
        BeanUtils.copyProperties(userAccountReqDto, customerReqDto);
        customerReqDto.setUserId(null);
        customerReqDto.setOrgInfoId(userAccountReqDto.getOrgInfoId());
        customerApi.updateAccountStatus(customerReqDto);
    }

    /**
     * 分页查询客户信息列表
     */
    @Override
    public PageInfo<CustomerListRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        // 使用module层的CustomerSearchExtReqDto而不是cube层的
        com.dtyunxi.yundt.module.customer.api.dto.request.CustomerSearchExtReqDto searchReqDto = 
            new com.dtyunxi.yundt.module.customer.api.dto.request.CustomerSearchExtReqDto();
        logger.info("queryByPage params:{}",filter);
        if (StringUtils.isNotBlank(filter)) {
            searchReqDto = JSONObject.parseObject(filter, com.dtyunxi.yundt.module.customer.api.dto.request.CustomerSearchExtReqDto.class);
        }
//        searchReqDto.setInstanceId(context.instanceId());
        searchReqDto.setTenantId(context.tenantId());
        this.settingUserIdsForSearch(searchReqDto);
        if (Objects.nonNull(searchReqDto.getUserFlag()) && !searchReqDto.getUserFlag()) {
            return new PageInfo<>();
        }
        //默认查询审核通过的客户
        searchReqDto.setListFlag(true);
        //判断是否是来源于业务员小程序端，是的话需要设置业务员id
        if (SrcTypeEnum.SALESMAN.getCode().equals(searchReqDto.getSrcType())){
            searchReqDto.setSalesmanUserId(context.userId());
            //如果是业务员小程序端，分页时需要特殊处理
            // 1.客户搜索支持：客户名称和联系人模糊搜索
            //2.客户列表排序规则：a、按客户最后下单时间倒序排列；b、下单时间 相同时，按客户新增时间倒序排列
//            RestResponse<PageInfo<CustomerRespDto>> pageInfoRestResponse = customerQueryApi.queryByPage(JSON.toJSONString(searchReqDto), pageNum, pageSize);
//            PageInfo<CustomerRespDto> pageInfo = RestResponseHelper.extractData(pageInfoRestResponse);

            //改成customerExtThreeQueryApi的查询
            /*CustomerSearchExtThreeReqDto customerSearchExtThreeReqDto = new CustomerSearchExtThreeReqDto();
            CubeBeanUtils.copyProperties(customerSearchExtThreeReqDto,searchReqDto);
            RestResponse<PageInfo<CustomerRespDto>> pageInfoRestResponse = customerExtThreeQueryApi.queryByPage(customerSearchExtThreeReqDto, pageNum, pageSize);
            PageInfo<CustomerRespDto> pageInfo = RestResponseHelper.extractData(pageInfoRestResponse);
            */
            // 转换为cube层的DTO进行查询
            com.dtyunxi.yundt.cube.center.customer.api.dto.request.CustomerSearchExtReqDto searchExtReqDto = 
                new com.dtyunxi.yundt.cube.center.customer.api.dto.request.CustomerSearchExtReqDto();
            CubeBeanUtils.copyProperties(searchExtReqDto,searchReqDto);
            searchExtReqDto.setOrgInfoId(searchReqDto.getMerchantId());
            searchExtReqDto.setSalesmanId(context.userId());
            searchExtReqDto.setPageNum(pageNum);
            searchExtReqDto.setPageSize(pageSize);
            RestResponse<PageInfo<CustomerRespDto>> pageInfoRestResponse = employeeCustomerQueryApi.queryValidCustomerPage(searchExtReqDto);
            PageInfo<CustomerRespDto> pageInfo = RestResponseHelper.extractData(pageInfoRestResponse);
            //如果是业务员端，需要根据客户名称模糊搜索，有结果就直接返回，没结果则需要根据联系人模糊搜索
            //todo 新版业务员端只需根据客户名称/编号模糊搜索，不再根据联系人模糊搜索，所以注释掉以下代码
//            List<Long> customerIds = this.getCustomerIdsBySalesmanId(context.userId());
//            if (StringUtils.isNotEmpty(searchReqDto.getKeyword()) && pageInfo.getTotal() == 0){
//                List<Long> newCustomerIds = Lists.newArrayList();
//                if (CollectionUtils.isNotEmpty(customerIds)){
//                    RestResponse<List<ContactsInfoDto>> listRestResponse = customerUserQueryApi.queryContactsInfoListByOrgInfoIdList(customerIds);
//                    List<ContactsInfoDto> contactsInfoDtos = RestResponseHelper.extractData(listRestResponse);
//                    for (ContactsInfoDto contactsInfoDto : contactsInfoDtos) {
//                        String linkName = contactsInfoDto.getLinkName();
//                        if (StringUtils.isNotEmpty(linkName) && linkName.contains(searchReqDto.getKeyword())){
//                            newCustomerIds.add(contactsInfoDto.getOrgInfoId());
//                        }
//                    }
//                }
//                if (CollectionUtils.isNotEmpty(newCustomerIds)){
//                    CustomerSearchReqDto reqDto = new CustomerSearchReqDto();
//                    reqDto.setSalesmanId(context.userId());
//                    reqDto.setTenantId(context.tenantId());
//                    reqDto.setIdList(newCustomerIds);
//                    RestResponse<PageInfo<CustomerRespDto>> newPageInfoRestResp = customerQueryApi.queryByPage(JSON.toJSONString(reqDto), 1, Integer.MAX_VALUE);
//                    pageInfo = RestResponseHelper.extractData(newPageInfoRestResp);
//                }
//
//            }
            //查询客户最后下单时间
//            Map<String, Date> timeMap = new HashMap<>();
            //查询客户订单量
            //todo 有性能问题，暂时去掉
//            Map<String, Integer> numMap = new HashMap<>();
//            if (CollectionUtils.isNotEmpty(pageInfo.getList())){
//                OrderStatisticsReqDto orderStatisticsReqDto = new OrderStatisticsReqDto();
//                orderStatisticsReqDto.setCustomerIds(pageInfo.getList().stream().map(e -> String.valueOf(e.getId())).collect(Collectors.toList()));
//                orderStatisticsReqDto.setSalesmanId(context.userId().toString());
//                orderStatisticsReqDto.setInstanceId(context.instanceId());
//                orderStatisticsReqDto.setTenantId(context.tenantId());
//                orderStatisticsReqDto.setType("1");
//                orderStatisticsReqDto.setPageNum(1);
//                orderStatisticsReqDto.setPageSize(Integer.MAX_VALUE);
//                orderStatisticsReqDto.setSortFiled("1");
//                //设置开始时间和结束时间
//                Calendar c = Calendar.getInstance();//获得一个日历的实例
//                c.setTime(new Date());
//                c.add(Calendar.MONTH,-6);
//                orderStatisticsReqDto.setStartTime(c.getTime());
//                orderStatisticsReqDto.setEndTime(new Date());
//                //根据客户ids统计订单信息以获取最后下单时间
//                //todo 根据客户ids统计订单信息以获取每个客户的订单数
//                RestResponse<PageInfo<OrderStatisticsRespDto>> orderPageInfoRestResp = orderQueryTobApi.statisticsOrder(orderStatisticsReqDto);
//                PageInfo<OrderStatisticsRespDto> orderPageInfo = RestResponseHelper.extractData(orderPageInfoRestResp);
//                if (Objects.nonNull(orderPageInfo) && CollectionUtils.isNotEmpty(orderPageInfo.getList())){
////                    timeMap = orderPageInfo.getList().stream()
////                            .collect(Collectors.toMap(OrderStatisticsRespDto::getCustomerId, OrderStatisticsRespDto::getLastOrderTime, (e1, e2) -> e1));
//                    numMap = orderPageInfo.getList().stream()
//                            .collect(Collectors.toMap(OrderStatisticsRespDto::getCustomerId, OrderStatisticsRespDto::getNum, (e1, e2) -> e1));
//                }
//            }

            List<CustomerListRespDto> listRespDtoList = Lists.newArrayList();
            if (CollectionUtils.isNotEmpty(pageInfo.getList())) {
                // 获取所属商家
                List<Long> customerIds = customerExtQueryApi.queryCustomerIdByOrgId(pageInfo.getList().stream().map(CustomerRespDto::getMerchantId).distinct().collect(Collectors.toList())).getData();
                List<CustomerRespDto> customerList = Lists.newArrayList();
                if (CollectionUtils.isNotEmpty(customerIds)) {
                    customerList = customerExtQueryApi.queryListByCustomerIds(customerIds).getData();
                }
                logger.info("获取所属商家 customerIds = {}, customerList = {}", JSONObject.toJSONString(customerIds), JSONObject.toJSONString(customerList));

                //获取所有orgId
                List<Long> orgInfoIds = pageInfo.getList().stream().map(CustomerRespDto::getOrgInfoId).distinct().collect(Collectors.toList());
                List<OrgAndOrgInfoRespDto> orgAndOrgInfoByIds = RestResponseHelper.extractData(organizationQueryApi.queryOrgAndOrgInfoByIds(orgInfoIds));
                logger.info("获取所属orgInfo orgInfoIds = {}, orgAndOrgInfoList = {}", JSONObject.toJSONString(orgInfoIds), JSONObject.toJSONString(orgAndOrgInfoByIds));
                //增加一行备注打包用，忽略
                CustomerListRespDto listRespDto;
                for (CustomerRespDto customerRespDto : pageInfo.getList()) {
                    listRespDto = new CustomerListRespDto();
                    CubeBeanUtils.copyProperties(listRespDto, customerRespDto);
                    if (CollectionUtils.isNotEmpty(customerList)) {
                        for (CustomerRespDto customer : customerList) {
                            if (Objects.equals(customerRespDto.getMerchantId(), customer.getOrgInfoId())) {
                                //拷贝属性到CustomerListRespDto
                                listRespDto.setMerchantName(customer.getName());
                                break;
                            }
                        }
                    }
                    if (CollectionUtils.isNotEmpty(orgAndOrgInfoByIds)){
                        for (OrgAndOrgInfoRespDto orgAndOrgInfoRespDto : orgAndOrgInfoByIds) {
                            if (Objects.equals(customerRespDto.getOrgInfoId(), orgAndOrgInfoRespDto.getOrganizationDto().getId())) {
                                //拷贝属性到CustomerListRespDto
                                listRespDto.setOrgName(orgAndOrgInfoRespDto.getOrganizationInfoDto().getOrgName());
                                break;
                            }
                        }
                    }
                    listRespDtoList.add(listRespDto);
                }

//                //上游卖家组织id_name关系map
//                Map<Long, String> marchantOrgMap = RestResponseHelper.extractData(bizOrganizationQueryApi.getOrganizationsByIds(pageInfo.getList().stream()
//                        .map(CustomerRespDto::getMerchantId).distinct().collect(Collectors.toList())))
//                        .stream().collect(Collectors.toMap(OrganizationDto::getId, OrganizationDto::getName));
//                CustomerListRespDto listRespDto;
//                for (CustomerRespDto customerRespDto : pageInfo.getList()) {
//                    listRespDto = new CustomerListRespDto();
//                    //拷贝属性到CustomerListRespDto
//                    CubeBeanUtils.copyProperties(listRespDto, customerRespDto);
//                    listRespDto.setMerchantName(marchantOrgMap.get(listRespDto.getMerchantId()));
//                    //设置最后下单时间
////                    Date lastOrderTime = timeMap.get(customerRespDto.getId().toString());
////                    if (Objects.nonNull(lastOrderTime)){
////                        listRespDto.setLastOrderTime(lastOrderTime);
////                    }
//                    //设置每个客户的订单数
////                    Integer num = numMap.get(customerRespDto.getId().toString());
////                    listRespDto.setNum(num);
//                    listRespDtoList.add(listRespDto);
//                }
            }

            logger.info("业务员端listRespDtoList>>>>{}",JSON.toJSONString(listRespDtoList));

            PageInfo<CustomerListRespDto> listRespDtoPageInfo = new PageInfo<>();
            CubeBeanUtils.copyProperties(listRespDtoPageInfo, pageInfo, "list", "navigatepageNums");
            listRespDtoPageInfo.setList(listRespDtoList);
            return listRespDtoPageInfo;

            //客户列表排序规则：a、按客户最后下单时间倒序排列；b、下单时间相同时，按客户新增时间倒序排列
//            List<CustomerListRespDto> newListRespDtoList = listRespDtoList.stream().
//                    sorted(Comparator.comparing(CustomerListRespDto::getLastOrderTime,Comparator.nullsFirst(Date::compareTo)).
//                            thenComparing(CustomerListRespDto::getCreateTime).reversed()).
//                    collect(Collectors.toList());
            //todo 客户列表排序规则改为：a、按客户订单量倒序排列；b、订单量相同时，按客户新增时间倒序排列
            //todo 有性能问题，暂时去掉
//            List<CustomerListRespDto> newListRespDtoList = listRespDtoList.stream().
//                    sorted(Comparator.comparing(CustomerListRespDto::getNum,Comparator.nullsFirst(Integer::compareTo)).
//                            thenComparing(CustomerListRespDto::getCreateTime).reversed()).
//                    collect(Collectors.toList());
//
//            //分页返回
//            int startPage = (pageNum - 1) * pageSize + 1;
//            List<CustomerListRespDto> respDtoList = new ArrayList<>(pageSize);
//            for (int i = startPage; i <= pageNum * pageSize; i++) {
//                if (newListRespDtoList.size() >= i && (i - 1) >= 0) {
//                    respDtoList.add(newListRespDtoList.get(i - 1));
//                }
//            }
//            PageInfo<CustomerListRespDto> listPageInfo = new PageInfo();
//            listPageInfo.setList(respDtoList);
//            listPageInfo.setTotal(newListRespDtoList.size());
//            listPageInfo.setPageSize(pageSize);
//            listPageInfo.setPageNum(pageNum);
//            return listPageInfo;

        }


        if("Y".equalsIgnoreCase(searchReqDto.getIsHaveCreditAccount())){
            //查询已加入信用的账号
            RestResponse<List<Long>> enableCustomerIds = iCreditEntityApi.getEnableCustomerIds("3");
            searchReqDto.setIdList(enableCustomerIds.getData());
        }
        List<CustomerAuthItemRespDto> authItems = new ArrayList<>();
        String headerOrgId = getHeaderOrgId();
        // 根据SKU授权状态筛选客户
        if (searchReqDto.getSkuId() != null && searchReqDto.getIsAuthorized() != null) {
            try {
                logger.info("根据SKU授权状态筛选客户: skuId={}, isAuthorized={}", 
                        searchReqDto.getSkuId(), searchReqDto.getIsAuthorized());
                
                // 获取当前组织ID

                if (StringUtils.isBlank(headerOrgId)) {
                    logger.warn("无法获取当前组织ID，跳过SKU授权筛选");
                    if (searchReqDto.getIsAuthorized()) {
                        // 如果要求已授权客户但无法获取组织ID，返回空结果
                        return new PageInfo<>();
                    }
                } else {
                    RestResponse<List<CustomerAuthItemRespDto>> authResponse = getListRestResponse(headerOrgId, searchReqDto);

                    if (authResponse != null && authResponse.getData() != null) {
                        authItems = authResponse.getData();
                        Set<Long> authorizedCustomerIds = authItems.stream()
                                .map(CustomerAuthItemRespDto::getCustomerId)
                                .collect(Collectors.toSet());
                        
                        logger.info("查询到已授权客户数量: {}", authorizedCustomerIds.size());
                        
                        if (searchReqDto.getIsAuthorized()) {
                            // 查询已授权客户，使用IN筛选
                            if (authorizedCustomerIds.isEmpty()) {
                                // 没有已授权客户，返回空结果
                                logger.info("没有找到已授权的客户，返回空结果");
                                return new PageInfo<>();
                            }
                            List<Long> existingIdList = searchReqDto.getIdList();
                            if (existingIdList != null && !existingIdList.isEmpty()) {
                                // 与现有筛选条件取交集
                                authorizedCustomerIds.retainAll(existingIdList);
                                if (authorizedCustomerIds.isEmpty()) {
                                    logger.info("已授权客户与现有筛选条件无交集，返回空结果");
                                    return new PageInfo<>();
                                }
                            }
                            searchReqDto.setIdList(new ArrayList<>(authorizedCustomerIds));
                        } else {
                            // 查询未授权客户，使用NOT IN筛选
                            List<Long> existingIdList = searchReqDto.getIdList();
                            if (existingIdList != null && !existingIdList.isEmpty()) {
                                // 从现有筛选条件中排除已授权客户
                                existingIdList.removeAll(authorizedCustomerIds);
                                if (existingIdList.isEmpty()) {
                                    // 所有客户都已授权，返回空结果
                                    logger.info("现有筛选条件中的客户都已授权，返回空结果");
                                    return new PageInfo<>();
                                }
                                searchReqDto.setIdList(existingIdList);
                            } else {
                                // 需要查询所有客户，然后排除已授权的
                                // 设置NOT IN条件
                                if (!authorizedCustomerIds.isEmpty()) {
                                    searchReqDto.setIdNotInList(new ArrayList<>(authorizedCustomerIds));
                                }
                            }
                        }
                    } else {
                        logger.warn("查询客户授权商品失败或返回数据为空");
                        if (searchReqDto.getIsAuthorized()) {
                            // 如果查询失败且要求已授权客户，返回空结果
                            return new PageInfo<>();
                        }
                    }
                }
            } catch (Exception e) {
                logger.error("根据SKU授权状态筛选客户时发生异常: skuId={}, isAuthorized={}", 
                        searchReqDto.getSkuId(), searchReqDto.getIsAuthorized(), e);
                // 异常情况下，如果要求已授权客户，返回空结果；否则继续正常查询
                if (searchReqDto.getIsAuthorized()) {
                    return new PageInfo<>();
                }
            }
        }

        // 修改BUG#fmcg-2165-ideb-2267:过滤已授信准入的客户，不会显示在选择列表里
        if (Objects.equals(searchReqDto.getIsFilterCreditEntity(), "Y")){
            RestResponse<List<Long>> enableCustomerIds = iCreditEntityApi.getEnableCustomerIds("3");
            searchReqDto.setIdNotInList(enableCustomerIds.getData());
            logger.info("[客商客户] >>> 过滤掉已信用准入的客户id:{}", searchReqDto.getIdNotInList());
        }

        searchReqDto.setIsFilterDownstreamCustomersByCurrentUser(true);
        // 转换为cube层的DTO进行最终查询
        com.yx.tcbj.center.customer.api.dto.request.CustomerSearchExtThreeReqDto customerSearchExtThreeReqDto = 
            new com.yx.tcbj.center.customer.api.dto.request.CustomerSearchExtThreeReqDto();
        CubeBeanUtils.copyProperties(customerSearchExtThreeReqDto,searchReqDto);
        
        // 传递SKU授权相关参数
        if (searchReqDto.getSkuId() != null) {
            // 将SKU ID和授权状态信息传递给查询DTO
            // 注意：这里需要根据实际的CustomerSearchExtThreeReqDto结构来设置参数
            // 如果该DTO不支持这些字段，可能需要通过其他方式传递
        }
        
        // 如果是大b查询请求则需要从头获取组织id
        if (searchReqDto.getType() != null && searchReqDto.getType() == 2) {
            if (StringUtils.isNotBlank(headerOrgId)) {
                customerSearchExtThreeReqDto.setMerchantIds(Collections.singletonList(Long.valueOf(headerOrgId)));
            }
        }
        String sellerorgid = ServiceContext.getContext().getAttachment("yes.req.cus.b2b.sellerorgid");
        if (StringUtils.isNotEmpty(sellerorgid) && StringUtils.isNumeric(sellerorgid)){
            customerSearchExtThreeReqDto.setOrganizationId(Long.valueOf(sellerorgid));
        }
        logger.info("客户列表查询 入参 {}", JSON.toJSONString(customerSearchExtThreeReqDto));
        RestResponse<PageInfo<CustomerRespDto>> pageInfoRestResponse = customerExtThreeQueryApi.queryByPage(customerSearchExtThreeReqDto, pageNum, pageSize);
        PageInfo<CustomerRespDto> pageInfo = RestResponseHelper.extractData(pageInfoRestResponse);


        PageInfo<CustomerListRespDto> listRespDtoPageInfo = new PageInfo<>();
        CubeBeanUtils.copyProperties(listRespDtoPageInfo, pageInfo, "list", "navigatepageNums");
        List<CustomerListRespDto> listRespDtoList = Lists.newArrayList();
        //根据区域id和userId查询用户中心返回登录账号和所属区域
        if (CollectionUtils.isNotEmpty(pageInfo.getList())) {
            //获取userId集合和regionCode集合
//            Set<Long> userIdList = Sets.newHashSet();
//            Set<String> regionCodeList = Sets.newHashSet();

            CustomerListRespDto listRespDto;
            for (CustomerRespDto customerRespDto : pageInfo.getList()) {
                listRespDto = new CustomerListRespDto();
                //拷贝属性到CustomerListRespDto
                CubeBeanUtils.copyProperties(listRespDto, customerRespDto);

                listRespDtoList.add(listRespDto);

//                if (Objects.nonNull(customerRespDto.getUserId())) {
//                    userIdList.add(customerRespDto.getUserId());
//                }
            }
            
            // 检查是否需要验证商品授权状态
            Long skuId = null;
            if (StringUtils.isNotBlank(filter)) {
                JSONObject filterJson = JSONObject.parseObject(filter);
                if (filterJson.containsKey("skuId")) {
                    skuId = filterJson.getLong("skuId");
                }
            }
            
            // 如果提供了skuId，则查询授权状态
            if (Objects.nonNull(skuId)) {
                logger.info("检查客户对SKU[{}]的授权状态", skuId);
                // 获取所有客户组织ID
                List<Long> orgInfoIds = listRespDtoList.stream()
                    .map(CustomerListRespDto::getId)
                    .distinct()
                    .collect(Collectors.toList());
                
                if (CollectionUtils.isNotEmpty(orgInfoIds)) {
                    // 构建查询参数
                    com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request.ItemAuthReqDto itemAuthReqDto = 
                        new com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request.ItemAuthReqDto();
                    itemAuthReqDto.setTargetType(1); // 客户授权类型
                    itemAuthReqDto.setTargetIdList(orgInfoIds);
                    itemAuthReqDto.setBusinessType("SKU");
                    itemAuthReqDto.setBusinessIdList(Lists.newArrayList(skuId));
                    itemAuthReqDto.setStatus(1); // 启用状态
                    if (CollectionUtils.isEmpty(authItems)){
                        authItems = getListRestResponse(headerOrgId, searchReqDto).getData();
                    }
                    // 查询授权信息
                    RestResponse<List<com.dtyunxi.yundt.cube.center.item.api.b2b.dto.response.ItemAuthRespDto>> authResponse = 
                        itemAuthQueryApi.list(itemAuthReqDto);
                    List<com.dtyunxi.yundt.cube.center.item.api.b2b.dto.response.ItemAuthRespDto> authList = 
                        RestResponseHelper.extractData(authResponse);
                    if (CollectionUtils.isNotEmpty(authList)) {
                        // 获取已授权的组织ID集合
                        Set<Long> customerIds = authItems.stream().map(CustomerAuthItemRespDto::getCustomerId).collect(Collectors.toSet());
                        Set<Long> authorizedInventoryIds = authList.stream()
                                .filter(r->Objects.nonNull(r.getProhibiteStatus()) && Objects.equals(r.getProhibiteStatus(), 2))
                                .map(ItemAuthRespDto::getTargetId)
                                .collect(Collectors.toSet());

                        logger.info("已授权的客户ID: {}", customerIds);
                        
                        // 设置授权状态
                        for (CustomerListRespDto customer : listRespDtoList) {
                            customer.setIsAuthorized(customerIds.contains(customer.getId()));
                            customer.setEnableInventory(!authorizedInventoryIds.contains(customer.getId()));
                        }
                    } else {
                        // 如果没有授权记录，则所有客户均未授权
                        listRespDtoList.forEach(customer -> customer.setIsAuthorized(false));
                        listRespDtoList.forEach(customer -> customer.setEnableInventory(true));
                    }
                }
            }
            
            //查询登录账号信息
//            Map<Long, String> userNameMap = new HashMap<>();
//            if (CollectionUtils.isNotEmpty(userIdList)) {
//                RestResponse<List<UserDto>> salesmanRestResp = userQueryApi.queryByIdList(StringUtils.join(userIdList, ","), "{}");
//                List<UserDto> userList = RestResponseHelper.extractData(salesmanRestResp);
//                userNameMap = userList.stream().collect(Collectors.toMap(UserDto::getId, UserDto::getUserName));
//            }
//
//            for (CustomerListRespDto respDto : listRespDtoList) {
//                //设置登录账号名称
//                if (Objects.nonNull(respDto.getUserId())) {
//                    respDto.setUserName(userNameMap.get(respDto.getUserId()));
//                }
//            }


        }
//        CubeBeanUtils.copyCollection(listRespDtoList,pageInfo.getList(),CustomerListRespDto.class);
        listRespDtoPageInfo.setList(listRespDtoList);
        return listRespDtoPageInfo;
    }

    private RestResponse<List<CustomerAuthItemRespDto>> getListRestResponse(String headerOrgId, CustomerSearchExtReqDto searchReqDto) {
        Long currentOrgId = Long.valueOf(headerOrgId);

        // 调用客户授权商品查询API
        List<Long> skuIds = Arrays.asList(searchReqDto.getSkuId());
        return customerAuthItemQueryExtApi.queryAuthItemBySkuIds(skuIds, currentOrgId);
    }

    private String getRegionName(List<String> regionCodeList, Long orgId){
        CustomerAreaListReqDto customerAreaListReqDto = new CustomerAreaListReqDto();
        customerAreaListReqDto.setCodes(regionCodeList);
        customerAreaListReqDto.setOrgInfoId(orgId);
        return RestResponseHelper.extractData(customerAreaQueryApi.queryForList(customerAreaListReqDto)).stream().map(CustomerAreaRespDto::getName).collect(Collectors.joining(","));
    }

    /**
     * 根据业务员登录的userId查询客户ids
     *
     * @param salesmanId
     * @return
     */
    public List<Long> getCustomerIdsBySalesmanId(Long salesmanId) {

        List<Long> customerIds = Lists.newArrayList();
        //查询客户信息
        CustomerSearchReqDto searchReqDto = new CustomerSearchReqDto();
        searchReqDto.setSalesmanId(salesmanId);
        searchReqDto.setTenantId(context.tenantId());
        RestResponse<List<CustomerRespDto>> listRestResp = customerQueryApi.queryByList(JSON.toJSONString(searchReqDto));
        List<CustomerRespDto> customerRespDtos = RestResponseHelper.extractData(listRestResp);
        if (CollectionUtils.isNotEmpty(customerRespDtos)){
            customerIds = customerRespDtos.stream().map(CustomerRespDto::getId).collect(Collectors.toList());
        }

        return customerIds;
    }

    private void settingUserIdsForSearch(CustomerSearchReqDto searchReqDto) {
        if (StringUtils.isNotEmpty(searchReqDto.getUserName())) {
            //请求用户中心根据userName模糊搜索
            List<SqlFilter> userFilters = Lists.newArrayList();
            userFilters.add(SqlFilter.like("userName", "%" + searchReqDto.getUserName() + "%"));
            Map<String, Object> filterMap = Maps.newHashMap();
            filterMap.put("filters", userFilters);
            filterMap.put("tenantId", searchReqDto.getTenantId());
            filterMap.put("instanceId", searchReqDto.getInstanceId());
            String queryFilter = JSONObject.toJSONString(filterMap);
            RestResponse<PageInfo<UserDto>> pageInfoRestResponse = userQueryApi.queryByPage(queryFilter, 1, Integer.MAX_VALUE);
            PageInfo<UserDto> userDtoPageInfo = RestResponseHelper.extractData(pageInfoRestResponse);
            List<Long> userIdList = Lists.newArrayList();
            if (Objects.nonNull(userDtoPageInfo) && CollectionUtils.isNotEmpty(userDtoPageInfo.getList())) {
                for (UserDto userDto : userDtoPageInfo.getList()) {
                    userIdList.add(userDto.getId());
                }
            }
            if (CollectionUtils.isEmpty(userIdList)) {
                searchReqDto.setUserFlag(false);
            }
            searchReqDto.setUserIds(userIdList);
        }
    }

    @Override
    public CustomerDetailRespDto queryById(Long id) {
        CustomerDetailRespDto customerDetailRespDto = new CustomerDetailRespDto();
        //调用客商中心，查询客户基础信息
        RestResponse<CustomerRespDto> customerRestResp = customerQueryApi.queryById(id);
        CustomerRespDto customerRespDto = RestResponseHelper.extractData(customerRestResp);
        BeanUtils.copyProperties(customerRespDto, customerDetailRespDto);
        //调用客商中心，查询客户组织信息
        RestResponse<CustomerOrgInfoDto> orgInfoRestResp = customerOrgInfoQueryApi.queryById(customerRespDto.getOrgInfoId());
        CustomerOrgInfoDto orgInfoDto = RestResponseHelper.extractData(orgInfoRestResp);
        if (orgInfoDto != null) {
            customerDetailRespDto.setBussinessLicenseUrl(orgInfoDto.getBussinessLicenseUrl());
        }
        //调用用户中心查询业务员信息和登录账号信息
        if (Objects.nonNull(customerRespDto.getSalesmanId())) {
            RestResponse<UserDto> salesmanRestResp = userQueryApi.queryById(customerRespDto.getSalesmanId(), "{}");
            UserDto salesman = RestResponseHelper.extractData(salesmanRestResp);
            if (Objects.nonNull(salesman)) {
                customerDetailRespDto.setSalesmanName(salesman.getNickName());
            }
        }
        if (Objects.nonNull(customerRespDto.getUserId())) {
            RestResponse<UserDto> userRestResp = userQueryApi.queryById(customerRespDto.getUserId(), "{}");
            UserDto userDto = RestResponseHelper.extractData(userRestResp);
            if (Objects.nonNull(userDto)) {
                customerDetailRespDto.setUserName(userDto.getUserName());
            }
        }
        //查询所属区域信息
        Map<String, String> regionNameMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(customerRespDto.getRegionCodeList())) {
            customerDetailRespDto.setRegionNameList(Arrays.asList(this.getRegionName(customerRespDto.getRegionCodeList(), customerRespDto.getOrgInfoId()).split(",")));
        }
        //查询联系人信息
        RestResponse<List<ContactsInfoDto>> contactsInfoRestResp =
                customerUserQueryApi.queryContactsInfoListByOrgInfoId(customerRespDto.getOrgInfoId());
        List<ContactsInfoDto> contactsInfoDtos = RestResponseHelper.extractData(contactsInfoRestResp);
        if (CollectionUtils.isNotEmpty(contactsInfoDtos)) {
            customerDetailRespDto.setContactsInfoList(contactsInfoDtos);
        }

        //查询财务信息
        RestResponse<List<BillInfoDto>> billInfoRestResp =
                customerUserQueryApi.queryBillInfoListByOrgInfoId(customerRespDto.getOrgInfoId());
        List<BillInfoDto> billInfoDtos = RestResponseHelper.extractData(billInfoRestResp);
        if (CollectionUtils.isNotEmpty(billInfoDtos)) {
            customerDetailRespDto.setBillInfoList(billInfoDtos);
        }
        //查询地址信息列表
        RestResponse<List<AddressDto>> addressRestResp =
                customerUserQueryApi.queryAddressListByOrgInfoId(customerRespDto.getOrgInfoId());
        List<AddressDto> addressDtos = RestResponseHelper.extractData(addressRestResp);
        customerDetailRespDto.setAddressDtoList(addressDtos);

        return customerDetailRespDto;
    }

    @Override
    public CustomerDetailRespDto queryByCode(String code) {
        CustomerDetailRespDto customerDetailRespDto = new CustomerDetailRespDto();

        RestResponse<CustomerRespDto> customerRespDtoRestResponse = customerQueryApi.queryByCode(code);
        CustomerRespDto customerRespDto = RestResponseHelper.extractData(customerRespDtoRestResponse);
        BeanUtils.copyProperties(customerRespDto, customerDetailRespDto);
        return customerDetailRespDto;
    }

    /***
     * 校验该区域下是否存在客户 true:是;false:否
     * @param regionCode
     * @return
     */
    @Override
    public Boolean isExistByRegionCode(String regionCode) {
        //根据regionCode分页查询客户信息列表
        CustomerSearchReqDto searchReqDto = new CustomerSearchReqDto();
        List<String> regionCodes = Lists.newArrayList(regionCode);
        searchReqDto.setRegionCodes(regionCodes);
//        searchReqDto.setInstanceId(context.instanceId());
        searchReqDto.setTenantId(context.tenantId());
        RestResponse<PageInfo<CustomerRespDto>> pageInfoRestResponse = customerQueryApi.queryByPage(JSON.toJSONString(searchReqDto), 1, 10);
        PageInfo<CustomerRespDto> pageInfo = RestResponseHelper.extractData(pageInfoRestResponse);
        return Objects.nonNull(pageInfo) && CollectionUtils.isNotEmpty(pageInfo.getList());
    }

    @Override
    public void moveCustomerToRegion(String sourceRegionCode, String targetRegionCode) {
        RestResponse<Void> restResponse = customerApi.moveCustomerToRegion(sourceRegionCode, targetRegionCode);
        RestResponseHelper.extractData(restResponse);
    }

    @Override
    public String exportCustomer(CustomerSearchReqDto customerSearchReqDto) {
        String operator = context.userName();
        Long instanceId = context.instanceId();
        Long tenantId = context.tenantId();
        customerSearchReqDto.setTenantId(tenantId);
        String fileName = "客户数据_" + DateUtil.getDateFormat(new Date(), "yyyyMMddHHmmss") + new Random().nextInt(100) + ".xls";
        //异步上传，直接把链接返回给前端
        ExecutorUtils.execute(() -> {
            this.settingUserIdsForSearch(customerSearchReqDto);
            //查询客户基本信息列表
            List<CustomerRespDto> list;
            if (Objects.nonNull(customerSearchReqDto.getUserFlag()) && !customerSearchReqDto.getUserFlag()) {
                list = new ArrayList<>();
            } else {
                list = this.queryByList(JSON.toJSONString(customerSearchReqDto));
            }
            //查询客户详细信息列表
            List<CustomerDetailRespDto> detailList = this.queryCustomerDetailByList(tenantId, instanceId, list);
            long startTime1 = new Date().getTime();
            //导出数量
            int exportNum = list.size();

            String data = new String(new byte[]{(byte) 0xEF, (byte) 0xBB, (byte) 0xBF}) + processData(detailList);
            ByteArrayInputStream inputStream = new ByteArrayInputStream(data.getBytes());
            //上传到oss
            logger.info("Excel文件：{}开始上传到oss服务器...", ossRegistryVo.getEndpoint() + "/" + fileName);
            try {
                objectStorageService.put(ossRegistryVo.getBucketName(), fileName, inputStream);
            } catch (Exception e) {
                logger.error("导出客户上传oss出现异常：", e);
                throw new BizException(CustomerModuleExceptionCode.CUSTOMER_UPLOAD_OSS_ERROR.getCode(),
                        CustomerModuleExceptionCode.CUSTOMER_UPLOAD_OSS_ERROR.getMsg());
            } finally {
                try {
                    long startTime2 = new Date().getTime();
                    logger.info("Excel文件进行整理完毕,花费[{}]豪秒", (startTime2 - startTime1));
                    inputStream.close();
                } catch (Exception e) {
                    logger.error("关闭流出现异常");
                }
            }
            logger.info("Excel上传到oss服务器完毕,下载链接：{},导出入参：{}", ossRegistryVo.getEndpoint() + "/" + fileName, JSON.toJSONString(customerSearchReqDto));

            //保存导出日志
            saveExportRecord(operator, CustomerExportType.CUSTOMER_LIST, fileName, exportNum, ossRegistryVo.getEndpoint() + "/" + fileName);
        });
        //拼接下载链接
        String downloadUrl = objectStorageService.getFileUrl(fileName);
        return downloadUrl;
    }

    @Override
    public String exportCustomerExt(String filter) {
        logger.info("客户导出EXT：{}",JSON.toJSONString(filter));
        String name = "客户数据_" + DateUtil.getDateFormat(new Date(), "yyyyMMddHHmmss") + new Random().nextInt(100);
        BaseExportService baseExportService = new BaseExportService(name, ExportTypeEnum.CUSTOMER);

        // 执行异步Excel处理
        baseExportService.executor(req -> {
            // 查询数据
            PageInfo<CustomerExtRespDto> pageInfo = customerExtService.queryByPage(req, 1, 100000);
            if (ObjectUtil.isNotEmpty(pageInfo) && CollectionUtils.isNotEmpty(pageInfo.getList())){

                List<CustomerExportExtVo> exportExtVoList = new ArrayList<>();
                pageInfo.getList().forEach(info->{
                    CustomerExportExtVo exportExtVo = BeanUtil.copyProperties(info, CustomerExportExtVo.class);
                    exportExtVoList.add(exportExtVo);
                });

                baseExportService.exportUrl(exportExtVoList,CustomerExportExtVo.class);// 执行导出Excel
            }else {
                exportService.fail(baseExportService.getId(),"导出" + name + "列表,数据为空");
            }
            return null;
        },filter);

        return "导出"+name+"成功";
    }

    private void saveExportRecord(String operator, CustomerExportType type, String fileName, int num, String downloadUrl) {
        ExportRecordReqDto exportRecordReqDto = new ExportRecordReqDto();
        exportRecordReqDto.setNum(num);
        exportRecordReqDto.setFileName(fileName);
        exportRecordReqDto.setUrl(downloadUrl);
        exportRecordReqDto.setType(type.getCode());
        exportRecordReqDto.setCreatePerson(operator);
        customerApi.saveCustomerExportRecord(exportRecordReqDto);
    }

    private List<CustomerDetailRespDto> queryCustomerDetailByList(Long tenantId, Long instanceId, List<CustomerRespDto> customerRespList) {
        List<CustomerDetailRespDto> detailRespList = Lists.newArrayList();
        if (CollectionUtils.isEmpty(customerRespList)) {
            return detailRespList;
        }
        //获取 组织信息ID集合，userIds,regionCodes,salesmanIds
        List<Long> orgInfoIdList = Lists.newArrayList();
        Set<Long> userIds = Sets.newHashSet();
        Set<String> regionCodes = Sets.newHashSet();
        Set<Long> parentCustomerIds = Sets.newHashSet();
//        Set<Long> salesmanIds = Sets.newHashSet();
        for (CustomerRespDto customerRespDto : customerRespList) {
            orgInfoIdList.add(customerRespDto.getOrgInfoId());
            if (Objects.nonNull(customerRespDto.getUserId())) {
                userIds.add(customerRespDto.getUserId());
            }
            if (StringUtils.isNotEmpty(customerRespDto.getRegionCodes())){
                List<String> regionList = Arrays.asList(customerRespDto.getRegionCodes().split(","));
                regionCodes.addAll(regionList);
            }
            if (Objects.nonNull(customerRespDto.getSalesmanId())) {
                userIds.add(customerRespDto.getSalesmanId());
            }
            if (Objects.nonNull(customerRespDto.getParentCustomerId())) {
                parentCustomerIds.add(customerRespDto.getParentCustomerId());
            }
        }
//        List<Long> orgInfoIdList = list.stream().map(CustomerRespDto::getOrgInfoId).collect(Collectors.toList());
        //调用客商中心，查询客户组织信息列表
//        Map<Long, CustomerOrgInfoDto> orgInfoMap = null;
//        CustomerOrgInfoQueryReqDto orgInfoQueryReqDto = new CustomerOrgInfoQueryReqDto();
//        orgInfoQueryReqDto.setIdList(orgInfoIdList);
//        RestResponse<PageInfo<CustomerOrgInfoDto>> orgInfoRestResp = customerOrgInfoQueryApi.queryPage(orgInfoQueryReqDto,1,Integer.MAX_VALUE);
//        PageInfo<CustomerOrgInfoDto> pageInfo = RestResponseHelper.extractData(orgInfoRestResp);
//        if (Objects.nonNull(pageInfo)){
//            List<CustomerOrgInfoDto> orgInfoDtos = pageInfo.getList();
//            orgInfoMap = orgInfoDtos.stream().collect(Collectors.toMap(CustomerOrgInfoDto::getId, e -> e));
//        }
        //调用用户中心查询业务员信息和登录账号信息
        Map<Long, UserDto> userMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(userIds)) {
            RestResponse<List<UserDto>> salesmanRestResp = employeeExpandQueryApi.queryByIdList(new ArrayList<>(userIds));
            List<UserDto> userList = RestResponseHelper.extractData(salesmanRestResp);
            userMap = userList.stream().collect(Collectors.toMap(UserDto::getId, e -> e));
        }
        //查询所属区域
        Map<String, String> regionNameMap = new HashMap<>();
        List<String> newRegionCodes = new ArrayList<>(regionCodes);
        List<String> newRegionCodes2 = new ArrayList<>();
        newRegionCodes2.add(newRegionCodes.get(1));
        newRegionCodes2.add(newRegionCodes.get(0));
//        if (CollectionUtils.isNotEmpty(regionCodes)) {
//            List<SqlFilter> sqlFilterList = Lists.newArrayList();
//            sqlFilterList.add(SqlFilter.in("code", StringUtils.join(newRegionCodes2, ",")));
//            Map<String, Object> filterMap = new HashMap<>();
//            filterMap.put("sqlFilters", sqlFilterList);
//            filterMap.put("tenantId", tenantId);
//            filterMap.put("instanceId", instanceId);
//            RestResponse<PageInfo<AreaGroupRespDto>> areaGroupRestResp =
//                    areaGroupQueryApi.queryByPage(JSONObject.toJSONString(filterMap), 1, Integer.MAX_VALUE);
//            PageInfo<AreaGroupRespDto> areaGroupPageInfo = RestResponseHelper.extractData(areaGroupRestResp);
//            if (Objects.nonNull(areaGroupPageInfo)) {
//                regionNameMap = areaGroupPageInfo.getList().stream().collect(Collectors.toMap(AreaGroupRespDto::getCode, AreaGroupRespDto::getName));
//            }
//
//            customerDetailRespDto.setRegion(sb.toString());
//
//        }
        //调用客商中心查询父客户信息
        Map<Long, String> parentCustomerMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(parentCustomerIds)) {
            RestResponse<List<CustomerNameSimpleRespDto>> listRestResponse = customerQueryApi.queryListByIds(Lists.newArrayList(parentCustomerIds));
            List<CustomerNameSimpleRespDto> nameList = RestResponseHelper.extractData(listRestResponse);
            parentCustomerMap = nameList.stream().collect(Collectors.toMap(CustomerNameSimpleRespDto::getId, CustomerNameSimpleRespDto::getName));
        }
//        if (CollectionUtils.isNotEmpty(regionCodes)){
//            for (String regionCode : regionCodes) {
//                RestResponse<AreaGroupDetailRespDto> areaGroupRestResponse = areaGroupQueryApi.queryByCode(regionCode);
//                AreaGroupDetailRespDto groupDetailRespDto = RestResponseHelper.extractData(areaGroupRestResponse);
//                if (Objects.nonNull(groupDetailRespDto)){
//                    regionNameMap.put(regionCode,groupDetailRespDto.getName());
//                }
//            }
//        }
        //查询联系人信息
        RestResponse<List<ContactsInfoDto>> contactsInfoRestResp =
                customerUserQueryApi.queryContactsInfoListByOrgInfoIdList(orgInfoIdList);
        List<ContactsInfoDto> contactsInfoDtos = RestResponseHelper.extractData(contactsInfoRestResp);
        Map<Long, List<ContactsInfoDto>> contactsInfoMap = contactsInfoDtos.stream().collect(Collectors.groupingBy(ContactsInfoDto::getOrgInfoId));
//        Map<Long, ContactsInfoDto> contactsInfoMap = contactsInfoDtos.stream().collect(Collectors.toMap(ContactsInfoDto::getOrgInfoId, e -> e));
        //查询财务信息
        RestResponse<List<BillInfoDto>> billInfoRestResp =
                customerUserQueryApi.queryBillInfoListByOrgInfoIdList(orgInfoIdList);
        List<BillInfoDto> billInfoDtos = RestResponseHelper.extractData(billInfoRestResp);
        Map<Long, List<BillInfoDto>> billInfoMap = billInfoDtos.stream().collect(Collectors.groupingBy(BillInfoDto::getOrgInfoId));
//        Map<Long, BillInfoDto> billInfoMap = billInfoDtos.stream().collect(Collectors.toMap(BillInfoDto::getOrgInfoId, e -> e));

        //循环customerRespList组装detailRespList
        CustomerDetailRespDto customerDetailRespDto;
        CustomerDetailRespDto newCustomerDetailDto;
        for (CustomerRespDto customerRespDto : customerRespList) {
            customerDetailRespDto = new CustomerDetailRespDto();
            //拷贝属性
            BeanUtils.copyProperties(customerRespDto, customerDetailRespDto);
            //设置营业执照URL
//            CustomerOrgInfoDto orgInfoDto = orgInfoMap.get(customerRespDto.getOrgInfoId());
//            customerDetailRespDto.setBussinessLicenseUrl(orgInfoDto.getBussinessLicenseUrl());
            //设置业务员信息和登录账号信息
            if (Objects.nonNull(customerRespDto.getSalesmanId())) {
                UserDto salesman = userMap.get(customerRespDto.getSalesmanId());
                if (Objects.nonNull(salesman)) {
                    customerDetailRespDto.setSalesmanName(salesman.getNickName());
                }
            }
            if (Objects.nonNull(customerRespDto.getUserId())) {
                UserDto userDto = userMap.get(customerRespDto.getUserId());
                if (Objects.nonNull(userDto)) {
                    customerDetailRespDto.setUserName(userDto.getUserName());
                }
            }
            //设置客户区域名称
            if (StringUtils.isNotEmpty(customerRespDto.getRegionCodes())) {
                customerDetailRespDto.setRegion(this.getRegionName(customerRespDto.getRegionCodeList(), customerRespDto.getOrgInfoId()));
            }
            //设置所属上级
            if (Objects.nonNull(customerRespDto.getParentCustomerId())) {
                String customerName = parentCustomerMap.get(customerRespDto.getParentCustomerId());
                customerDetailRespDto.setParentCustomerName(customerName);
            }
            //设置联系人信息和财务信息
            //支持导出多个联系人、财务信息：
            //1）举例：联系人有3个，财务信息有5个；
            //2）按照确定最大行数的原则，确定该客户导出数据至少有5行；即展示5行不同的财务信息；
            //3）然后在5行内，填入3行联系人信息，填不满的2行处理方式（2种都行）：a）置空，b）按照最后一条联系人信息，继续填充；(选择a)
            //4）表格中其余的行和列，采用客户信息填充满；
            List<ContactsInfoDto> contactsInfoList = contactsInfoMap.get(customerRespDto.getOrgInfoId());
            List<BillInfoDto> billInfoList = billInfoMap.get(customerRespDto.getOrgInfoId());
            if (CollectionUtils.isEmpty(contactsInfoList) && CollectionUtils.isEmpty(billInfoList)){
                detailRespList.add(customerDetailRespDto);
                continue;
            }
            if (CollectionUtils.isNotEmpty(contactsInfoList)){
                if (CollectionUtils.isNotEmpty(billInfoList)){
                    if (contactsInfoList.size() > billInfoList.size()){
                        for (int i = 0; i < contactsInfoList.size(); i++) {
                            newCustomerDetailDto = new CustomerDetailRespDto();
                            //拷贝属性
                            BeanUtils.copyProperties(customerDetailRespDto, newCustomerDetailDto);
                            newCustomerDetailDto.setContactsInfoDto(contactsInfoList.get(i));
                            if (i < billInfoList.size()){
                                newCustomerDetailDto.setBillInfoDto(billInfoList.get(i));
                            }
                            detailRespList.add(newCustomerDetailDto);
                        }
                    } else {
                        for (int i = 0; i < billInfoList.size(); i++) {
                            newCustomerDetailDto = new CustomerDetailRespDto();
                            //拷贝属性
                            BeanUtils.copyProperties(customerDetailRespDto, newCustomerDetailDto);
                            newCustomerDetailDto.setBillInfoDto(billInfoList.get(i));
                            if (i < contactsInfoList.size()){
                                newCustomerDetailDto.setContactsInfoDto(contactsInfoList.get(i));
                            }
                            detailRespList.add(newCustomerDetailDto);
                        }
                    }
                } else {
                    for (int i = 0; i < contactsInfoList.size(); i++) {
                        newCustomerDetailDto = new CustomerDetailRespDto();
                        //拷贝属性
                        BeanUtils.copyProperties(customerDetailRespDto, newCustomerDetailDto);
                        newCustomerDetailDto.setContactsInfoDto(contactsInfoList.get(i));
                        detailRespList.add(newCustomerDetailDto);
                    }
                }
            } else {
                for (int i = 0; i < billInfoList.size(); i++) {
                    newCustomerDetailDto = new CustomerDetailRespDto();
                    //拷贝属性
                    BeanUtils.copyProperties(customerDetailRespDto, newCustomerDetailDto);
                    newCustomerDetailDto.setBillInfoDto(billInfoList.get(i));
                    detailRespList.add(newCustomerDetailDto);
                }
            }
        }
        return detailRespList;

    }

    @Override
    public List<CustomerRespDto> queryByList(String filter) {
        CustomerSearchReqDto searchReqDto = new CustomerSearchReqDto();
        if (StringUtils.isNotBlank(filter)) {
            searchReqDto = JSONObject.parseObject(filter, CustomerSearchReqDto.class);
        }
//        if (Objects.isNull(searchReqDto.getInstanceId())){
//            searchReqDto.setInstanceId(context.instanceId());
//        }
        if (Objects.isNull(searchReqDto.getTenantId())) {
            searchReqDto.setTenantId(context.tenantId());
        }
        RestResponse<List<CustomerRespDto>> listRestResponse = customerQueryApi.queryByList(JSON.toJSONString(searchReqDto));
        List<CustomerRespDto> customerRespList = RestResponseHelper.extractData(listRestResponse);
        return customerRespList;
    }

    @Override
    public Boolean checkExportCustomer(String fileName) {
        boolean exists = objectStorageService.exists(ossRegistryVo.getBucketName(), fileName);
        return exists;
    }

    @Override
    public PageInfo<AddressDto> queryAddressByPage(String keyword, String addressType, Long customerId, Integer pageNum, Integer pageSize) {
        if (StringUtils.isEmpty(addressType)) {
            addressType = "1";
        }
        //调用客商中心，查询客户基础信息
        RestResponse<CustomerRespDto> customerRestResp = customerQueryApi.queryById(customerId);
        CustomerRespDto customerRespDto = RestResponseHelper.extractData(customerRestResp);
        if (Objects.isNull(customerRespDto)) {
            return new PageInfo<>(Lists.newArrayList());
        }
        //根据客户的orgInfoId查询该客户的地址信息列表
        RestResponse<List<AddressDto>> listRestResponse = customerUserQueryApi.queryAddressListByOrgInfoId(customerRespDto.getOrgInfoId());
        List<AddressDto> addressDtos = RestResponseHelper.extractData(listRestResponse);
        if (CollectionUtils.isEmpty(addressDtos)) {
            return new PageInfo<>(Lists.newArrayList());
        }
        String finalAddressType = addressType;
        List<AddressDto> addressDtosTemp = addressDtos.stream().filter(address -> address.getAddressType().equals(finalAddressType)).collect(Collectors.toList());
        List<AddressDto> newAddressDtos = new ArrayList<>();
        if (StringUtils.isEmpty(keyword)) {
            newAddressDtos.addAll(addressDtosTemp);
        } else {
            for (AddressDto addressDto : addressDtosTemp) {
                String contact = addressDto.getContact();
                String phone = addressDto.getPhone();
                if (contact.contains(keyword) || phone.contains(keyword)) {
                    newAddressDtos.add(addressDto);
                }
            }
        }
        //分页返回
        int startPage = (pageNum - 1) * pageSize + 1;
        List<AddressDto> respDtoList = new ArrayList<>(pageSize);
        for (int i = startPage; i <= pageNum * pageSize; i++) {
            if (newAddressDtos.size() >= i && (i - 1) >= 0) {
                respDtoList.add(newAddressDtos.get(i - 1));
            }
        }
        PageInfo<AddressDto> pageInfo = new PageInfo();
        pageInfo.setList(respDtoList);
        pageInfo.setTotal(newAddressDtos.size());
        pageInfo.setPageSize(pageSize);
        pageInfo.setPageNum(pageNum);
        return pageInfo;
    }

    @Override
    public AddressDto queryDefaultAddress(String addressType, Long customerId) {
        if (StringUtils.isEmpty(addressType)) {
            addressType = "1";
        }
        //调用客商中心，查询客户基础信息
        RestResponse<CustomerRespDto> customerRestResp = customerQueryApi.queryById(customerId);
        CustomerRespDto customerRespDto = RestResponseHelper.extractData(customerRestResp);
        if (Objects.isNull(customerRespDto)) {
            return null;
        }
        //根据客户的orgInfoId查询该客户的地址信息列表
        RestResponse<List<AddressDto>> listRestResponse = customerUserQueryApi.queryAddressListByOrgInfoId(customerRespDto.getOrgInfoId());
        List<AddressDto> addressDtos = RestResponseHelper.extractData(listRestResponse);
        if (CollectionUtils.isEmpty(addressDtos)) {
            return null;
        }
        for (AddressDto addressDto : addressDtos) {
            if (addressType.equals(addressDto.getAddressType()) && addressDto.getStatus() == 1) {
                return addressDto;
            }
        }
        return null;

    }

    /**
     * 处理数据拼接为string
     *
     * @param list
     * @return
     */
    private String processData(List<CustomerDetailRespDto> list) {
        StringBuilder sb = new StringBuilder();
        //表头设置
        sb.append("客户名称,客户类型,客户编号,客户区域,客户级别,所属上级,所属省,所属市,所属区,详细地址,所属业务员,备注,联系人,职位,手机,电话,邮箱,预留手机,登录账号,登录密码,账号状态,开户名称,开户银行,银行账号,纳税人识别号,开票抬头,发票内容,支付宝号,微信号\n");
        Iterator<CustomerDetailRespDto> iterator = list.iterator();
        while (iterator.hasNext()) {
            CustomerDetailRespDto customerDetailRespDto = iterator.next();
            //客户名称
            String name = StringUtils.isNotBlank(customerDetailRespDto.getName()) ? customerDetailRespDto.getName() : "";
            //客户类型
            String customerTypeName = StringUtils.isNotBlank(customerDetailRespDto.getCustomerTypeName()) ? customerDetailRespDto.getCustomerTypeName() : "";
            //客户编号
            String code = StringUtils.isNotBlank(customerDetailRespDto.getCode()) ? customerDetailRespDto.getCode() : "";
            //归属区域
            String region = StringUtils.isNotBlank(customerDetailRespDto.getRegion()) ? customerDetailRespDto.getRegion() : "";
            //客户级别
            String levelName = StringUtils.isNotBlank(customerDetailRespDto.getLevelName()) ? customerDetailRespDto.getLevelName() : "";
            //所属上级
            String parentCustomerName = StringUtils.isNotBlank(customerDetailRespDto.getParentCustomerName()) ? customerDetailRespDto.getParentCustomerName() : "";
            //所属省
            String province = StringUtils.isNotBlank(customerDetailRespDto.getProvince()) ? customerDetailRespDto.getProvince() : "";
            //所属市
            String city = StringUtils.isNotBlank(customerDetailRespDto.getCity()) ? customerDetailRespDto.getCity() : "";
            //所属区
            String county = StringUtils.isNotBlank(customerDetailRespDto.getCounty()) ? customerDetailRespDto.getCounty() : "";
            //详细地址
            String address = StringUtils.isNotBlank(customerDetailRespDto.getAddress()) ? customerDetailRespDto.getAddress() : "";
            //所属业务员
            String salesmanName = StringUtils.isNotBlank(customerDetailRespDto.getSalesmanName()) ? customerDetailRespDto.getSalesmanName() : "";
            //备注
            String remark = StringUtils.isNotBlank(customerDetailRespDto.getRemark()) ? customerDetailRespDto.getRemark() : "";
            ContactsInfoDto contactsInfoDto = customerDetailRespDto.getContactsInfoDto();
            String linkName = "";
            String position = "";
            String phoneNum = "";
            String tel = "";
            String postcode = "";
            String reserveMobile = "";
            if (Objects.nonNull(contactsInfoDto)) {
                //联系人
                linkName = StringUtils.isNotBlank(contactsInfoDto.getLinkName()) ? contactsInfoDto.getLinkName() : "";
                //职位
                position = StringUtils.isNotBlank(contactsInfoDto.getPosition()) ? contactsInfoDto.getPosition() : "";
                //手机
                phoneNum = StringUtils.isNotBlank(contactsInfoDto.getPhoneNum()) ? contactsInfoDto.getPhoneNum() : "";
                //电话
                tel = StringUtils.isNotBlank(contactsInfoDto.getTel()) ? contactsInfoDto.getTel() : "";
                //邮箱
                postcode = StringUtils.isNotBlank(contactsInfoDto.getPostcode()) ? contactsInfoDto.getPostcode() : "";
                //预留手机
                reserveMobile = StringUtils.isNotBlank(contactsInfoDto.getReserveMobile()) ? contactsInfoDto.getReserveMobile() : "";
            }
            //登录账号
            String userName = StringUtils.isNotBlank(customerDetailRespDto.getUserName()) ? customerDetailRespDto.getUserName() : "";
            //登录密码
            String password = "";
            //账号状态
            String statusName = StringUtils.isNotBlank(customerDetailRespDto.getStatusName()) ? customerDetailRespDto.getStatusName() : "";
            BillInfoDto billInfoDto = customerDetailRespDto.getBillInfoDto();
            String companyName = "";
            String depositBank = "";
            String bankAccount = "";
            String dutyNum = "";
            String invoiceTitle = "";
            String invoiceContent = "";
            String alipayNumber = "";
            String wechatNumber = "";
            if (Objects.nonNull(billInfoDto)) {
                //开户名称
                companyName = StringUtils.isNotBlank(billInfoDto.getCompanyName()) ? billInfoDto.getCompanyName() : "";
                //开户银行
                depositBank = StringUtils.isNotBlank(billInfoDto.getDepositBank()) ? billInfoDto.getDepositBank() : "";
                //银行账号
                bankAccount = StringUtils.isNotBlank(billInfoDto.getBankAccount()) ? billInfoDto.getBankAccount() : "";
                //纳税人识别号
                dutyNum = StringUtils.isNotBlank(billInfoDto.getDutyNum()) ? billInfoDto.getDutyNum() : "";
                //开票抬头
                invoiceTitle = StringUtils.isNotBlank(billInfoDto.getInvoiceTitle()) ? billInfoDto.getInvoiceTitle() : "";
                //发票内容
                invoiceContent = StringUtils.isNotBlank(billInfoDto.getInvoiceContent()) ? billInfoDto.getInvoiceContent() : "";
                //支付宝号
                alipayNumber = StringUtils.isNotBlank(billInfoDto.getAlipayNumber()) ? billInfoDto.getAlipayNumber() : "";
                //微信号
                wechatNumber = StringUtils.isNotBlank(billInfoDto.getWechatNumber()) ? billInfoDto.getWechatNumber() : "";
            }


            //客户名称,客户类型,客户编号,客户区域,客户级别,所属上级,所属省,所属市,所属区,详细地址,所属业务员,备注,联系人,职位,手机,电话,邮箱
            //预留手机,登录账号,登录密码,账号状态,开户名称,开户银行,银行账号,纳税人识别号,开票抬头,发票内容,支付宝号,微信号
            sb.append("\t").append(name).append(",");
            sb.append("\t").append(customerTypeName).append(",");
            sb.append("\t").append(code).append(",");
            sb.append("\t").append(region).append(",");
            sb.append("\t").append(levelName).append(",");
            sb.append("\t").append(parentCustomerName).append(",");
            sb.append("\t").append(province).append(",");
            sb.append("\t").append(city).append(",");
            sb.append("\t").append(county).append(",");
            sb.append("\t").append(address).append(",");
            sb.append("\t").append(salesmanName).append(",");
            sb.append("\t").append(remark).append(",");

            sb.append("\t").append(linkName).append(",");
            sb.append("\t").append(position).append(",");
            sb.append("\t").append(phoneNum).append(",");
            sb.append("\t").append(tel).append(",");
            sb.append("\t").append(postcode).append(",");
            sb.append("\t").append(reserveMobile).append(",");

            sb.append("\t").append(userName).append(",");
            sb.append("\t").append(password).append(",");
            sb.append("\t").append(statusName).append(",");

            sb.append("\t").append(companyName).append(",");
            sb.append("\t").append(depositBank).append(",");
            sb.append("\t").append(bankAccount).append(",");
            sb.append("\t").append(dutyNum).append(",");
            sb.append("\t").append(invoiceTitle).append(",");
            sb.append("\t").append(invoiceContent).append(",");
            sb.append("\t").append(alipayNumber).append(",");
            sb.append("\t").append(wechatNumber).append("\r\n");


            iterator.remove();
        }
        return sb.toString();
    }

    private CustomerOrgInfoDto createCustomerOrgInfo(CustomerDetailReqDto reqDto) {
        CustomerOrgInfoDto orgInfoDto = new CustomerOrgInfoDto();
        CubeBeanUtils.copyProperties(orgInfoDto, reqDto, "id");
        orgInfoDto.setOrgCode(reqDto.getCode());
        orgInfoDto.setOrgName(reqDto.getName());
        return orgInfoDto;
    }

    /**
     * 根据SKU ID查询已授权和未授权客户数量
     *
     * @param skuId SKU ID
     * @return 客户SKU授权数量统计响应DTO
     */
    public CustomerSkuAuthCountRespDto queryCustomerCountBySkuAuth(Long skuId) {
        logger.info("查询SKU[{}]的客户授权数量统计", skuId);
        
        CustomerSkuAuthCountRespDto result = new CustomerSkuAuthCountRespDto();
        result.setSkuId(skuId);
        result.setAuthorizedCount(0L);
        result.setUnauthorizedCount(0L);
        result.setTotalCount(0L);
        
        if (skuId == null) {
            logger.warn("SKU ID为空，返回默认统计结果");
            return result;
        }
        
        try {
            // 获取当前组织ID
            String headerOrgId = getHeaderOrgId();
            if (StringUtils.isBlank(headerOrgId)) {
                logger.warn("无法获取当前组织ID，返回默认统计结果");
                return result;
            }
            
            Long currentOrgId = Long.valueOf(headerOrgId);
            
            // 调用客户授权商品查询API获取已授权客户

                // 查询授权客户数量
                com.dtyunxi.yundt.module.customer.api.dto.request.CustomerSearchExtReqDto searchReqDto =
                        new com.dtyunxi.yundt.module.customer.api.dto.request.CustomerSearchExtReqDto();
                searchReqDto.setTenantId(context.tenantId());
                searchReqDto.setListFlag(true); // 只查询审核通过的客户
                searchReqDto.setIsAuthorized(true); // 只查询审核通过的客户
                searchReqDto.setSkuId(skuId); // 只查询审核通过的客户

                // 查询总客户数量（这里需要调用查询方法获取总数）
                PageInfo<CustomerListRespDto> authPageInfo = queryByPage(JSON.toJSONString(searchReqDto), 1, 1);

                long authorizedCount = authPageInfo.getTotal();
                result.setAuthorizedCount(authorizedCount);
                
                // 查询总客户数量
                com.dtyunxi.yundt.module.customer.api.dto.request.CustomerSearchExtReqDto searchReqDto2 =
                    new com.dtyunxi.yundt.module.customer.api.dto.request.CustomerSearchExtReqDto();
                searchReqDto2.setTenantId(context.tenantId());
                searchReqDto2.setListFlag(true); // 只查询审核通过的客户
                
                // 查询总客户数量（这里需要调用查询方法获取总数）
                PageInfo<CustomerListRespDto> totalPageInfo2 = queryByPage(JSON.toJSONString(searchReqDto2), 1, 1);
                long totalCount = totalPageInfo2 != null ? totalPageInfo2.getTotal() : 0;
                
                long unauthorizedCount = Math.max(0, totalCount - authorizedCount);
                result.setUnauthorizedCount(unauthorizedCount);
                result.setTotalCount(totalCount);
                
                logger.info("SKU[{}]客户授权统计完成: 已授权={}, 未授权={}, 总数={}", 
                        skuId, authorizedCount, unauthorizedCount, totalCount);
        } catch (Exception e) {
            logger.error("查询SKU[{}]的客户授权数量统计时发生异常", skuId, e);
        }
        
        return result;
    }

    /**
     * 根据多个SKU ID批量查询客户授权数量统计
     *
     * @param skuIds SKU ID列表
     * @return 客户SKU授权批量数量统计响应DTO
     */
    public CustomerSkuAuthBatchCountRespDto batchQueryCustomerCountBySkuAuth(List<Long> skuIds) {
        logger.info("批量查询SKU客户授权数量统计: {}", skuIds);
        
        List<CustomerSkuAuthCountRespDto> skuAuthCounts = new ArrayList<>();
        
        if (CollectionUtils.isEmpty(skuIds)) {
            logger.warn("SKU ID列表为空，返回空结果");
            return new CustomerSkuAuthBatchCountRespDto(skuAuthCounts);
        }
        
        // 为每个SKU ID初始化结果
        for (Long skuId : skuIds) {
            CustomerSkuAuthCountRespDto skuResult = new CustomerSkuAuthCountRespDto();
            skuResult.setSkuId(skuId);
            skuResult.setAuthorizedCount(0L);
            skuResult.setUnauthorizedCount(0L);
            skuResult.setTotalCount(0L);
            skuAuthCounts.add(skuResult);
        }
        
        try {
            // 获取当前组织ID
            String headerOrgId = getHeaderOrgId();
            if (StringUtils.isBlank(headerOrgId)) {
                logger.warn("无法获取当前组织ID，返回默认统计结果");
                return new CustomerSkuAuthBatchCountRespDto(skuAuthCounts);
            }
            
            Long currentOrgId = Long.valueOf(headerOrgId);
            
            // 批量调用客户授权商品查询API
            RestResponse<List<CustomerAuthItemRespDto>> authResponse = 
                    customerAuthItemQueryExtApi.queryAuthItemBySkuIds(skuIds, currentOrgId);
            
            if (authResponse != null && authResponse.getData() != null) {
                List<CustomerAuthItemRespDto> authItems = authResponse.getData();
                
                // 按SKU ID分组统计已授权客户数量
                Map<Long, Set<Long>> skuAuthorizedCustomers = new HashMap<>();
                for (CustomerAuthItemRespDto authItem : authItems) {
                    Long skuId = authItem.getSkuId();
                    Long customerId = authItem.getCustomerId();
                    
                    skuAuthorizedCustomers.computeIfAbsent(skuId, k -> new HashSet<>()).add(customerId);
                }
                
                // 查询总客户数量
                com.dtyunxi.yundt.module.customer.api.dto.request.CustomerSearchExtReqDto searchReqDto = 
                    new com.dtyunxi.yundt.module.customer.api.dto.request.CustomerSearchExtReqDto();
                searchReqDto.setTenantId(context.tenantId());
                searchReqDto.setListFlag(true);
                
                PageInfo<CustomerListRespDto> totalPageInfo = queryByPage(JSON.toJSONString(searchReqDto), 1, 1);
                long totalCount = totalPageInfo != null ? totalPageInfo.getTotal() : 0;
                
                // 更新每个SKU的统计结果
                for (CustomerSkuAuthCountRespDto skuResult : skuAuthCounts) {
                    Long skuId = skuResult.getSkuId();
                    Set<Long> authorizedCustomers = skuAuthorizedCustomers.getOrDefault(skuId, new HashSet<>());
                    long authorizedCount = authorizedCustomers.size();
                    long unauthorizedCount = Math.max(0, totalCount - authorizedCount);
                    
                    skuResult.setAuthorizedCount(authorizedCount);
                    skuResult.setUnauthorizedCount(unauthorizedCount);
                    skuResult.setTotalCount(totalCount);
                    
                    logger.info("SKU[{}]客户授权统计: 已授权={}, 未授权={}", 
                            skuId, authorizedCount, unauthorizedCount);
                }
                
                logger.info("批量查询SKU客户授权统计完成，总客户数={}", totalCount);
            } else {
                logger.warn("批量查询SKU客户授权信息失败或返回数据为空");
            }
        } catch (Exception e) {
            logger.error("批量查询SKU客户授权数量统计时发生异常", e);
        }
        
        return new CustomerSkuAuthBatchCountRespDto(skuAuthCounts);
    }

}
