package com.dtyunxi.yundt.module.customer.rest; /**
 * @(#)CustomerGroupRest.java 1.0 2021-05-08 15:00:35
 *
 * Copyright (c) 2021, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerGroupAddReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerGroupModifyReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerGroupQueryReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerGroupRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerGroupTreeRespDto;
import com.dtyunxi.yundt.module.customer.api.ICustomerGroupService;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

/**
* 客户分组Rest类
*
* @author liuji
* @Date : 2021-05-08 15:00:35
*/
@Api(tags = {"客商组件：客户分组服务"})
@RestController
@RequestMapping("/v1/customer/group")
public class CustomerGroupRest{

    @Resource
    private ICustomerGroupService customerGroupService;

    @PostMapping("")
    @ApiOperation(value = "新增客户分组", notes = "新增客户分组")
    public RestResponse<Long> add(@RequestBody CustomerGroupAddReqDto addReqDto) {
        return new RestResponse<>(customerGroupService.add(addReqDto));
    }

    @PutMapping("")
    @ApiOperation(value = "修改客户分组", notes = "修改客户分组")
    public RestResponse<Void> modify(@RequestBody CustomerGroupModifyReqDto modifyReqDto) {
        customerGroupService.modify(modifyReqDto);
        return new RestResponse<>();
    }

    @DeleteMapping("/{id}")
    @ApiOperation(value = "删除客户分组", notes = "删除客户分组")
    public RestResponse<Void> remove(@PathVariable("id") Long id) {
        customerGroupService.remove(id);
        return new RestResponse<>();
    }

    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询客户分组", notes = "根据id查询客户分组")
    public RestResponse<CustomerGroupRespDto> queryById(@PathVariable("id") Long id) {
        return new RestResponse<>(customerGroupService.queryById(id));
    }

    @GetMapping("")
    @ApiOperation(value = "客户分组分页数据", notes = "根据filter查询条件查询客户分组数据")
    public RestResponse<PageInfo<CustomerGroupRespDto>> queryByPage(@RequestParam(name = "filter", required = false) String filter,
                                                           @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                           @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize) {
        return new RestResponse<>(customerGroupService.queryByPage(filter, pageNum, pageSize));
    }

    @GetMapping("/tree")
    @ApiOperation(value = "客户分组tree", notes = "查询客户分组tree")
    RestResponse<List<CustomerGroupTreeRespDto>> queryForTree(){
        return new RestResponse<>(customerGroupService.queryForTree());
    }
}