package com.dtyunxi.yundt.module.customer.rest;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.StoreSellerGovernExcelRespDto;
import com.dtyunxi.yundt.module.customer.api.ICustomerV4Service;
import com.dtyunxi.yundt.module.customer.api.dto.request.VerifyCustomerByOrgIdReqDto;
import com.dtyunxi.yundt.module.customer.api.dto.response.CustomerListRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

/**
 * 客户信息
 * @author xuhuaqiang
 * @version 1.0.0
 * @description
 * @date 2020/9/29 18:06
 */
@Api(tags = {"客商组件：客户信息服务"})
@RestController
@RequestMapping("/v4/customer")
public class CustomerV4Rest {

    private static final Logger logger = LoggerFactory.getLogger(CustomerV4Rest.class);

    @Autowired
    private ICustomerV4Service customerV4Service;


    @GetMapping(value = "", produces = "application/json")
    @ApiOperation(value = "客户信息分页查询", notes = "客户信息分页查询")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "filter", value = "过滤条件, tenantId, instanceId通过filter传递", dataType = "string", paramType = "query"),
            @ApiImplicitParam(name = "pageNum", value = "起始页", dataType = "int", paramType = "query", required = true),
            @ApiImplicitParam(name = "pageSize", value = "每一页的记录数", dataType = "int", paramType = "query", required = true)})
    RestResponse<PageInfo<CustomerListRespDto>> queryByPage(@RequestParam(name = "filter", required = false) String filter,
                                                            @RequestParam("pageNum") Integer pageNum, @RequestParam("pageSize") Integer pageSize){
        return new RestResponse<>(customerV4Service.queryByPage(filter, pageNum, pageSize));
    }

    @PostMapping(value = "/VerifyCustomerByExcel", produces = "application/json")
    @ApiOperation(value = "批量校验三要素ByExcel", notes = "批量校验三要素ByExcel")
    public RestResponse<StoreSellerGovernExcelRespDto> excel(@RequestParam("file") MultipartFile file) {
        return new RestResponse<>(customerV4Service.verifyCustomerByExcel(file));
    }

    @PostMapping("/verifyCustomerByTable")
    @ApiOperation(value = "批量校验三要素ByTable", notes = "批量校验三要素ByByTable")
    RestResponse<Void> verifyCustomerByTable(){
        return new RestResponse<>(customerV4Service.verifyCustomerByTable());
    }

}
