package com.dtyunxi.yundt.module.customer.rest.user;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.user.api.IEmployeeRoleApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.EmployeeRoleReqDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IEmployeeRoleQueryApi;
import com.dtyunxi.yundt.module.customer.api.dto.response.user.IEmployeeRoleService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;

/**
 * @author liangfa
 * @Description 人员角色信息
 * @date 2022-01-14 17:42
 * @since 1.0.0
 */
@Api(tags = {"用户组件：人员角色信息"})
@RestController
@RequestMapping("/v2/ext/employeeRole")
public class EmployeeRoleRest{

    @Resource
    private IEmployeeRoleService employeeRoleService;


    /**
     * 新增人员角色信息
     *
     * @param reqDto 请求参数DTO
     * @return 数据ID
     */
    @PostMapping({"/addEmployeeRole/{instanceId}"})
    @ApiOperation(value = "新增人员角色信息", notes = "新增人员角色信息")
    public RestResponse<Long> addEmployeeRole(@PathVariable("instanceId") Long instanceId,
                                              @RequestBody EmployeeRoleReqDto reqDto) {
        return employeeRoleService.addEmployeeRole(instanceId, reqDto);
    }

    /**
     * 修改人员角色信息
     *
     * @param reqDto 请求参数DTO
     * @return
     */
    @PostMapping({"/modifyEmployeeRole/{instanceId}"})
    @ApiOperation(value = "修改人员角色信息", notes = "修改人员角色信息")
    public RestResponse<Void> modifyEmployeeRole(@PathVariable("instanceId") Long instanceId,
                                                 @RequestBody EmployeeRoleReqDto reqDto) {
        return employeeRoleService.modifyEmployeeRole(instanceId, reqDto);
    }

    /**
     * 设置超级管理员
     * @param instanceId 实例ID
     * @param reqDto 请求参数
     * @return 结果
     */
    @PostMapping({"/setSuperAdmin/{instanceId}"})
    @ApiOperation(value = "设置超级管理员", notes = "设置超级管理员")
    public RestResponse<Long> setSuperAdmin(@PathVariable("instanceId") Long instanceId,
                                            @RequestBody EmployeeRoleReqDto reqDto) {
        return employeeRoleService.setSuperAdmin(instanceId,reqDto);
    }
}
