package com.dtyunxi.yundt.module.customer.rest;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.EmployeeCustomerBlacklistQueryReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.EmployeeCustomerImportReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.EmployeeCustomerQueryReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.EmployeeCustomerBlacklistRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.EmployeeCustomerImportRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.EmployeeCustomerRespDto;
import com.dtyunxi.yundt.module.customer.api.IEmployeeCustomerService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @Author: xiuji
 * @Date: 2022/1/20 10:07 AM
 */
@Api(tags = {"客商组件：人员关联客户服务"})
@RestController
@RequestMapping("/v1/employeeCustomer")
public class EmployeeCustomerRest {

    @Autowired
    private IEmployeeCustomerService employeeCustomerService;

    /**
     * 人员关联-客户导
     * @param importReqDto
     * @return
     */
    @PostMapping("/customerImport")
    @ApiOperation(value = "人员关联-客户导入", notes = "人员关联-客户导入")
    RestResponse<EmployeeCustomerImportRespDto> customerImport(@RequestBody EmployeeCustomerImportReqDto importReqDto){
        return employeeCustomerService.customerImport(importReqDto);
    }


    @PostMapping("/list")
    @ApiOperation(value = "查询人员关联客户集合", notes = "查询人员关联客户集合")
    RestResponse<List<EmployeeCustomerRespDto>> queryEmployeeCustomerList(@RequestBody EmployeeCustomerQueryReqDto queryReqDto){
        return employeeCustomerService.queryEmployeeCustomerList(queryReqDto);
    }



    @PostMapping("/blacklist")
    @ApiOperation(value = "人员关联客户黑名单集合", notes = "人员关联客户黑名单集合")
    RestResponse<List<EmployeeCustomerBlacklistRespDto>> queryEmployeeCustomerBlackList(@RequestBody EmployeeCustomerBlacklistQueryReqDto queryReqDto){
        return employeeCustomerService.queryEmployeeCustomerBlackList(queryReqDto);
    }



}
