package com.dtyunxi.yundt.module.customer.rest;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.customer.api.customer.ICustomerAreaApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.*;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerAreaRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerAreaTreeRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerAreaQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.util.RestUtil;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.customer.api.ICustomerAreaExtService;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

/**
 * 客户区域服务(迁移原来的功能，兼容原来的接口，所以接口 uri 保持不变)
 * @author  惜笔
 * @date  2021-08-27 16:57
 * @version 1.0.0
 */
@Api(tags = {"客商组件：客户区域服务"})
@RestController
@RequestMapping("/v1/basedata/area-group")
public class CustomerAreaRest {

    @Resource
    private IContext context;

    @Resource
    private ICustomerAreaApi customerAreaApi;

    @Resource
    private ICustomerAreaQueryApi customerAreaQueryApi;
    @Resource
    private ICustomerAreaExtService customerAreaExtService;

    @PostMapping(value = "", produces = "application/json")
    @ApiOperation(
            value = "新增区域分组",
            notes = "新增区域分组"
    )
    RestResponse<Long> saveAreaGroup(@Validated @RequestBody CustomerAreaReqDto customerAreaReqDto){
        customerAreaReqDto.setInstanceId(context.instanceId());
        customerAreaReqDto.setTenantId(context.tenantId());
        return new RestResponse<>(customerAreaExtService.saveAreaGroup(customerAreaReqDto));
    }

    @DeleteMapping(value = "/{code}", produces = "application/json")
    @ApiOperation(
            value = "删除区域分组",
            notes = "根据区域分组ID删除数据"
    )
    @ApiImplicitParams({@ApiImplicitParam(
            name = "code",
            value = "区域分组CODE",
            dataType = "String",
            paramType = "path",
            required = true
    )})
    RestResponse<Void> removeByCode(@PathVariable("code") String code){
        CustomerAreaInfoReqDto customerAreaInfoReqDto = new CustomerAreaInfoReqDto();
        customerAreaInfoReqDto.setCode(code);
        RestUtil.checkRestResponse(customerAreaApi.removeByCondition(customerAreaInfoReqDto));
        return RestResponse.VOID;
    }

    @PutMapping(value = "/{id}", produces = "application/json")
    @ApiOperation(
            value = "修改区域分组",
            notes = "修改区域分组"
    )
    @ApiImplicitParams({@ApiImplicitParam(
            name = "id",
            value = "区域分组ID",
            dataType = "Long",
            paramType = "path",
            required = true
    )})
    RestResponse<Void> modifyAreaGroup(@PathVariable("id") Long id, @Validated @RequestBody CustomerAreaReqDto customerAreaReqDto){
        customerAreaReqDto.setInstanceId(context.instanceId());
        customerAreaReqDto.setTenantId(context.tenantId());
        RestUtil.checkRestResponse(customerAreaApi.modifyCustomerArea(id, customerAreaReqDto));
        return RestResponse.VOID;
    }

    @GetMapping(value = "/page", produces = "application/json")
    @ApiOperation(
            value = "分页查询区域分组",
            notes = "分页查询区域分组"
    )
    RestResponse<PageInfo<CustomerAreaRespDto>> queryByPage(@RequestParam("filter") String filter, @RequestParam(name = "pageNum",required = false,defaultValue = "1") Integer pageNum, @RequestParam(name = "pageSize",required = false,defaultValue = "10") Integer pageSize){
        RestResponse<PageInfo<CustomerAreaRespDto>> pageInfo = customerAreaQueryApi.queryByPage(filter, pageNum, pageSize);
        return pageInfo;
    }

    @GetMapping(value = "/code/{code}", produces = "application/json")
    @ApiOperation(
            value = "根据区域分组编码查询区域分组",
            notes = "根据区域分组编码查询区域分组"
    )
    @ApiImplicitParams({@ApiImplicitParam(
            name = "code",
            value = "区域分组编码",
            dataType = "String",
            paramType = "path",
            required = true
    )})
    RestResponse<CustomerAreaTreeRespDto> queryByCode(@PathVariable("code") String code){
        CustomerAreaSubTreeReqDto customerAreaSubTreeReqDto = new CustomerAreaSubTreeReqDto();
        customerAreaSubTreeReqDto.setCode(code);
        RestResponse<CustomerAreaTreeRespDto> customerAreaTreeRespDtoRestResponse = customerAreaQueryApi.queryForSubTree(customerAreaSubTreeReqDto);
        return customerAreaTreeRespDtoRestResponse;
    }

    @GetMapping(value = "/parent-code/{parentCode}", produces = "application/json")
    @ApiOperation(
            value = "根据区域分组父编码查询区域分组",
            notes = "根据区域分组父编码查询区域分组"
    )
    @ApiImplicitParams({@ApiImplicitParam(
            name = "parentCode",
            value = "区域分组父编码",
            dataType = "String",
            paramType = "path",
            required = true
    )})
    RestResponse<List<CustomerAreaRespDto>> queryByParentCode(@PathVariable("parentCode") String parentCode){
        CustomerAreaListReqDto customerAreaListReqDto = new CustomerAreaListReqDto();
        customerAreaListReqDto.setParentCode(parentCode);
        RestResponse<List<CustomerAreaRespDto>> listRestResponse = customerAreaQueryApi.queryForList(customerAreaListReqDto);
        return listRestResponse;
    }


    @GetMapping(value = "/tree", produces = "application/json")
    @ApiOperation(
            value = "查询区域分组树",
            notes = "查询区域分组树"
    )
    RestResponse<List<CustomerAreaTreeRespDto>> queryForTree(@RequestParam(required = false) Long orgInfoId){
        CustomerAreaTreeReqDto customerAreaTreeReqDto = new CustomerAreaTreeReqDto();
        customerAreaTreeReqDto.setOrgInfoId(orgInfoId);
        RestResponse<List<CustomerAreaTreeRespDto>> listRestResponse = customerAreaQueryApi.queryForTree(customerAreaTreeReqDto);
        return listRestResponse;
    }

    @GetMapping(value = "/list/level/{level}", produces = "application/json")
    @ApiOperation(
            value = "按层级查询区域分组",
            notes = "按层级查询区域分组"
    )
    @ApiImplicitParams({@ApiImplicitParam(
            name = "level",
            value = "查询层级",
            dataType = "Long",
            paramType = "path",
            required = true
    )})
    RestResponse<List<CustomerAreaRespDto>> queryByLevel(@PathVariable("level") Integer level){
        // 查询第几级的数据
        CustomerAreaListReqDto customerAreaListReqDto = new CustomerAreaListReqDto();
        customerAreaListReqDto.setLevel(level);
        RestResponse<List<CustomerAreaRespDto>> listRestResponse = customerAreaQueryApi.queryForList(customerAreaListReqDto);
        return listRestResponse;
    }
}
