/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.item.biz.service.impl;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.omnichannel.IItemPackageApi;
import com.dtyunxi.yundt.cube.center.item.api.omnichannel.dto.request.PackageOnOrOffSalesReqDto;
import com.dtyunxi.yundt.cube.center.item.api.omnichannel.dto.request.PackageReqDto;
import com.dtyunxi.yundt.cube.center.item.api.omnichannel.dto.request.PackageShelfQueryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.omnichannel.dto.response.PackageInfoRespDto;
import com.dtyunxi.yundt.cube.center.item.api.omnichannel.dto.response.PackageItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.omnichannel.dto.response.PackageRespDto;
import com.dtyunxi.yundt.cube.center.item.api.omnichannel.dto.response.PackageShelfCountRespDto;
import com.dtyunxi.yundt.cube.center.item.api.omnichannel.query.IItemPackageQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.dtyunxi.yundt.module.item.biz.service.IItemPackageService;
import com.github.pagehelper.PageInfo;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

@Service
public class ItemPackageServiceImpl
implements IItemPackageService {
    @Resource
    private IItemPackageApi itemPackageApi;
    @Resource
    private IItemPackageQueryApi packageQueryApi;
    @Resource
    private IShopQueryApi shopQueryApi;

    @Override
    public RestResponse<Long> addPackage(PackageReqDto addReqDto) {
        return this.itemPackageApi.addPackage(addReqDto);
    }

    @Override
    public RestResponse<Void> modifyPackage(PackageReqDto modifyReqDto) {
        return this.itemPackageApi.modifyPackage(modifyReqDto);
    }

    @Override
    public RestResponse<Void> removePackage(String ids) {
        return this.itemPackageApi.removePackage(ids);
    }

    @Override
    public RestResponse<PackageRespDto> queryById(Long id, String searchType) {
        RestResponse packageRespDtoRestResponse = this.packageQueryApi.queryById(id, searchType);
        PackageRespDto packageRespDto = (PackageRespDto)RestResponseHelper.extractData((RestResponse)packageRespDtoRestResponse);
        HashSet<Long> set = new HashSet<Long>(1);
        set.add(packageRespDto.getShopId());
        RestResponse response = this.shopQueryApi.queryByIds(set);
        List shopDto = (List)RestResponseHelper.extractData((RestResponse)response);
        if (CollectionUtils.isEmpty((Collection)shopDto)) {
            throw new BizException("\u5e97\u94fa\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        packageRespDto.setShopName(((ShopDto)shopDto.get(0)).getName());
        return new RestResponse((Object)packageRespDto);
    }

    @Override
    public RestResponse<PackageInfoRespDto> queryByPage(PackageReqDto packageReqDto, Integer pageNum, Integer pageSize) {
        PackageInfoRespDto packageInfoRespDto = new PackageInfoRespDto();
        PackageShelfCountRespDto countRespDto = (PackageShelfCountRespDto)this.packageQueryApi.queryCounts(packageReqDto).getData();
        packageInfoRespDto.setOnShelfNum(countRespDto.getOnShelfNum());
        packageInfoRespDto.setOffShelfNum(countRespDto.getOffShelfNum());
        PageInfo dtoPageInfo = (PageInfo)this.packageQueryApi.queryByPage(packageReqDto, pageNum, pageSize).getData();
        if (CollectionUtils.isEmpty((Collection)dtoPageInfo.getList())) {
            return new RestResponse((Object)packageInfoRespDto);
        }
        packageInfoRespDto.setDtoPageInfo(dtoPageInfo);
        Set shopIds = dtoPageInfo.getList().stream().map(PackageRespDto::getShopId).collect(Collectors.toSet());
        List dtos = (List)this.shopQueryApi.queryByIds(shopIds).getData();
        Map<Long, ShopDto> shopDtoMap = dtos.stream().collect(Collectors.toMap(ShopDto::getId, a -> a, (k1, k2) -> k1));
        for (PackageRespDto packageRespDto : dtoPageInfo.getList()) {
            ShopDto dto = shopDtoMap.get(packageRespDto.getShopId());
            if (dto == null) continue;
            packageRespDto.setShopName(dto.getName());
        }
        return new RestResponse((Object)packageInfoRespDto);
    }

    @Override
    public RestResponse<Void> onSalesOrNot(PackageOnOrOffSalesReqDto packageOnOrOffSalesReqDto) {
        return this.itemPackageApi.onSalesOrNot(packageOnOrOffSalesReqDto);
    }

    @Override
    public RestResponse<PackageRespDto> queryDetail(Long itemId, Long shopId) {
        return this.packageQueryApi.queryDetail(itemId, shopId);
    }

    @Override
    public RestResponse<List<PackageItemRespDto>> getPackageItemList(String shelfIds) {
        return this.packageQueryApi.getPackageItemList(shelfIds);
    }

    @Override
    public RestResponse<PageInfo<PackageItemRespDto>> queryShelfPage(PackageShelfQueryReqDto packageShelfQueryReqDto, Integer pageNum, Integer pageSize) {
        return this.packageQueryApi.queryShelfPage(packageShelfQueryReqDto, pageNum, pageSize);
    }
}

