/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.item.rest;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.IItemInfoApi;
import com.dtyunxi.tcbj.api.dto.request.QueryItemByBrandAndOrgReqDto;
import com.dtyunxi.tcbj.api.dto.response.QueryItemByBrandAndOrgRespDto;
import com.dtyunxi.yundt.module.item.api.dto.request.ItemOffShelfReqDto;
import com.dtyunxi.yundt.module.item.rest.ItemServiceRest;
import com.yx.tcbj.center.api.ItemBrandAuthApi;
import com.yx.tcbj.center.api.dto.request.ItemBrandAuthAddReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5546\u54c1\u7ec4\u4ef6\uff1a\u5546\u54c1\u7ba1\u7406\u670d\u52a1 \u540e\u53f0\u7ef4\u62a4\u63a5\u53e3"})
@RestController
@RequestMapping(value={"/v2/item"})
public class ItemServiceRestV2 {
    private static final Logger log = LogManager.getLogger(ItemServiceRestV2.class);
    @Resource
    private ItemServiceRest itemServiceRest;
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private IItemInfoApi itemInfoApi;
    @Resource
    private ItemBrandAuthApi itemBrandAuthApi;

    @PostMapping(value={"/offShelfByBrand"}, produces={"application/json"})
    @ApiOperation(value="\u6279\u91cf\u4e0b\u67b6\u5546\u54c1by\u54c1\u724ccode+\u54c1\u724c\u65b9orgId")
    RestResponse<Void> offShelfByBrand(@RequestBody QueryItemByBrandAndOrgReqDto reqDto) {
        log.info("\u6309\u54c1\u724c\u6279\u91cf\u4e0b\u67b6\u5546\u54c1,\u8bf7\u6c42\u53c2\u6570 reqDto={}", (Object)JSONObject.toJSONString((Object)reqDto));
        List queryItemByBrandAndOrgRespDto = (List)this.itemInfoApi.queryItemByBrandAndOrg(reqDto).getData();
        log.info("\u6309\u54c1\u724c\u6279\u91cf\u4e0b\u67b6\u5546\u54c1,\u67e5\u8be2\u54c1\u724c\u65b9\u4e0b\u9762\u5bf9\u5e94\u54c1\u724c\u7684\u5546\u54c1\u4fe1\u606f queryItemByBrandAndOrgRespDto={}", (Object)JSONObject.toJSONString((Object)queryItemByBrandAndOrgRespDto));
        List<ItemOffShelfReqDto> itemOffShelfReqDtos = this.convertOffShelfParam(queryItemByBrandAndOrgRespDto);
        log.info("\u5f00\u59cb\u8c03\u7528\u4e0b\u67b6\u5546\u54c1\u7684\u4ee3\u7801 itemOffShelfReqDtos={}", (Object)JSONObject.toJSONString(itemOffShelfReqDtos));
        this.itemServiceRest.offShelf(itemOffShelfReqDtos);
        log.info("\u7ed3\u675f\u8c03\u7528\u4e0b\u67b6\u5546\u54c1\u7684\u4ee3\u7801");
        return new RestResponse();
    }

    private List<ItemOffShelfReqDto> convertOffShelfParam(List<QueryItemByBrandAndOrgRespDto> queryItemByBrandAndOrgRespDto) {
        ArrayList<ItemOffShelfReqDto> itemOffShelfReqDtos = new ArrayList<ItemOffShelfReqDto>();
        for (QueryItemByBrandAndOrgRespDto itemByBrandAndOrgRespDto : queryItemByBrandAndOrgRespDto) {
            ItemOffShelfReqDto itemOffShelfReqDto = new ItemOffShelfReqDto();
            BeanUtil.copyProperties((Object)itemByBrandAndOrgRespDto, (Object)itemOffShelfReqDto, (String[])new String[0]);
            itemOffShelfReqDtos.add(itemOffShelfReqDto);
        }
        return itemOffShelfReqDtos;
    }

    @ApiOperation(value="\u6279\u91cf\u4e0a\u67b6\u5546\u54c1by\u54c1\u724ccode+\u54c1\u724c\u65b9orgId")
    @PutMapping(value={"/onSaleByBrand"})
    RestResponse<Void> onShelfByBrand(@RequestBody QueryItemByBrandAndOrgReqDto reqDto) {
        log.info("\u6309\u54c1\u724c\u6279\u91cf\u4e0a\u67b6\u5546\u54c1,\u8bf7\u6c42\u53c2\u6570 reqDto={}", (Object)JSONObject.toJSONString((Object)reqDto));
        List queryItemByBrandAndOrgRespDto = (List)this.itemInfoApi.queryItemByBrandAndOrg(reqDto).getData();
        log.info("\u6309\u54c1\u724c\u6279\u91cf\u4e0a\u67b6\u5546\u54c1,\u67e5\u8be2\u54c1\u724c\u65b9\u4e0b\u9762\u5bf9\u5e94\u54c1\u724c\u7684\u5546\u54c1\u4fe1\u606f queryItemByBrandAndOrgRespDto={}", (Object)JSONObject.toJSONString((Object)queryItemByBrandAndOrgRespDto));
        Map onShelfShopMap = queryItemByBrandAndOrgRespDto.stream().collect(Collectors.groupingBy(QueryItemByBrandAndOrgRespDto::getShopId, Collectors.mapping(QueryItemByBrandAndOrgRespDto::getItemId, Collectors.toList())));
        log.info("\u5f00\u59cb\u8c03\u7528\u4e0b\u67b6\u5546\u54c1\u7684\u4ee3\u7801 onShelfShopMap={}", (Object)JSONObject.toJSONString(onShelfShopMap));
        this.commonsMqService.sendSingleMessageAsync("ITEM-SYNC-ONSHELF", onShelfShopMap);
        log.info("\u7ed3\u675f\u8c03\u7528\u4e0b\u67b6\u5546\u54c1\u7684\u4ee3\u7801");
        return new RestResponse();
    }

    @PostMapping(value={"/offShelfByBrandWithConfig"}, produces={"application/json"})
    @ApiOperation(value="\u6279\u91cf\u4e0b\u67b6\u5546\u54c1by\u54c1\u724ccode+\u54c1\u724c\u65b9orgId \u5e76\u4e14\u6dfb\u52a0\u5230\u7981\u552e\u914d\u7f6e\u8868")
    RestResponse<Void> offShelfByBrandWithConfig(@RequestBody QueryItemByBrandAndOrgReqDto reqDto) {
        log.info("\u6309\u54c1\u724c\u6279\u91cf\u4e0b\u67b6\u5546\u54c1\u5e76\u6dfb\u52a0\u914d\u7f6e,\u8bf7\u6c42\u53c2\u6570 reqDto={}", (Object)JSONObject.toJSONString((Object)reqDto));
        log.info("1 \u8c03\u7528\u5546\u54c1\u6279\u91cf\u4e0b\u67b6");
        this.offShelfByBrand(reqDto);
        log.info("2 \u8c03\u7528\u7981\u552e\u914d\u7f6e\u65b0\u589e\u63a5\u53e3");
        this.itemBrandAuthApi.add(ItemBrandAuthAddReqDto.builder().authType("1").ppfOrgId(reqDto.getPpfOrgId()).brandId(reqDto.getBrandId()).shopId(reqDto.getShopId()).itemId(reqDto.getItemId()).build());
        return new RestResponse();
    }
}

