package com.dtyunxi.tcbj.api.dto.request;

import java.util.Date;
import com.dtyunxi.dto.RequestDto;
import com.dtyunxi.tcbj.api.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;

/**
* 渠道仓库存表Eo对象
*
* @author wude
* @since 2022-03-09
*/
@ApiModel(value = "ChannelInventoryReqDto", description = "渠道仓库存表Eo对象")
public class ChannelInventoryReqDto extends BaseDto {
    /**
     *  仓库编码
     */
    @ApiModelProperty(name = "warehouseCode", value = "仓库编码")
    private String warehouseCode;
    /**
     *  仓库名称
     */
    @ApiModelProperty(name = "warehouseName", value = "仓库名称")
    private String warehouseName;
    /**
     *  商品长编码
     */
    @ApiModelProperty(name = "itemLongCode", value = "商品长编码")
    private String itemLongCode;
    /**
     *  商品名称
     */
    @ApiModelProperty(name = "itemName", value = "商品名称")
    private String itemName;
    /**
     *  实际库存大于0
     */
    @ApiModelProperty(name = "positiveBalance", value = "实际库存大于0 0否 1是")
    private Integer positiveBalance;

    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }

    public String getWarehouseName() {
        return warehouseName;
    }

    public void setWarehouseName(String warehouseName) {
        this.warehouseName = warehouseName;
    }

    public String getItemLongCode() {
        return itemLongCode;
    }

    public void setItemLongCode(String itemLongCode) {
        this.itemLongCode = itemLongCode;
    }

    public String getItemName() {
        return itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public Integer getPositiveBalance() {
        return positiveBalance;
    }

    public void setPositiveBalance(Integer positiveBalance) {
        this.positiveBalance = positiveBalance;
    }
}
