package com.dtyunxi.tcbj.api.dto.request;

import java.util.Date;
import com.dtyunxi.dto.RequestDto;
import com.dtyunxi.tcbj.api.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
* 逻辑仓库存查询请求dto
*
* @author wude
* @since 2022-03-07
*/
@Data
@ApiModel(value = "LogicInventoryReqDto", description = "逻辑仓库存查询请求dto")
public class LogicInventoryReqDto extends BaseDto {
    /**
    *  仓库编码
    */
    @ApiModelProperty(name = "warehouseCode", value = "仓库编码")
    private String warehouseCode;
    /**
    *  仓库名称
    */
    @ApiModelProperty(name = "warehouseName", value = "仓库名称")
    private String warehouseName;
    /**
     *  仓库类型
     */
    @ApiModelProperty(name = "warehouseType", value = "仓库类型")
    private String warehouseType;
    /**
    *  商品长编码
    */
    @ApiModelProperty(name = "itemLongCode", value = "商品长编码")
    private String itemLongCode;
    /**
     *  商品名称
     */
    @ApiModelProperty(name = "itemName", value = "商品名称")
    private String itemName;
    /**
    *  批次
    */
    @ApiModelProperty(name = "batch", value = "批次")
    private String batch;
    /**
    *  批次类型 common-正常,defective-残次品,其他类型待定
    */
    @ApiModelProperty(name = "batchType", value = "批次类型 common-正常,defective-残次品,其他类型待定")
    private String batchType;
    /**
     *  实际库存大于0
     */
    @ApiModelProperty(name = "positiveBalance", value = "实际库存大于0 0否 1是")
    private Integer positiveBalance;
    /**
     *  是否过期
     */
    @ApiModelProperty(name = "expired", value = "是否过期 0否 1是")
    private Integer expired;

    /**
     *  过期开始时间
     */
    @ApiModelProperty(name = "expireBeginTime", value = "过期开始时间")
    private Date expireBeginTime;

    /**
     *  过期结束时间
     */
    @ApiModelProperty(name = "expireEndTime", value = "过期结束时间")
    private Date expireEndTime;
    /**
     *  仓库属性
     */
    @ApiModelProperty(name = "warehouseProperty", value = "仓库属性")
    private String warehouseProperty;
    /**
     *  所属物理仓
     */
    @ApiModelProperty(name = "physicsWarehouseId", value = "所属物理仓")
    private String physicsWarehouseId;
    /**
     *  仓库质量
     */
    @ApiModelProperty(name = "warehouseQuality", value = "仓库质量")
    private String warehouseQuality;
    /**
     *  所属物理仓
     */
    private String physicsWarehouseName;
}
