package com.dtyunxi.tcbj.api.dto.request;

import java.util.Date;
import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;

/**
* 逻辑仓Eo对象
*
* @author wude
* @since 2022-03-07
*/
@ApiModel(value = "LogicWarehouseReqDto", description = "逻辑仓Eo对象")
public class LogicWarehouseReqDto extends RequestDto{
    /**
    *  主键id
    */
    @ApiModelProperty(name = "id", value = "主键id")
    private Long id;
    /**
    *  仓库编码
    */
    @ApiModelProperty(name = "warehouseCode", value = "仓库编码")
    private String warehouseCode;
    /**
    *  仓库名称
    */
    @ApiModelProperty(name = "warehouseName", value = "仓库名称")
    private String warehouseName;
    /**
    *  仓库类型,待定
    */
    @ApiModelProperty(name = "warehouseType", value = "仓库类型,待定")
    private String warehouseType;
    /**
    *  仓库状态 initial-初始,enable-启用,disable-停用
    */
    @ApiModelProperty(name = "warehouseStatus", value = "仓库状态 initial-初始,enable-启用,disable-停用")
    private String warehouseStatus;
    /**
    *  spa工厂
    */
    @ApiModelProperty(name = "sapFactory", value = "spa工厂")
    private String sapFactory;
    /**
    *  sap库位
    */
    @ApiModelProperty(name = "sapStorageLocation", value = "sap库位")
    private String sapStorageLocation;
    /**
    *  是否允许负库存 0-不允许 1-允许
    */
    @ApiModelProperty(name = "negativeFlag", value = "是否允许负库存 0-不允许 1-允许")
    private Integer negativeFlag;
    /**
    *  渠道类型
    */
    @ApiModelProperty(name = "channelType", value = "渠道类型")
    private String channelType;
    /**
    *  联系人
    */
    @ApiModelProperty(name = "contact", value = "联系人")
    private String contact;
    /**
    *  联系电话
    */
    @ApiModelProperty(name = "phone", value = "联系电话")
    private String phone;
    /**
    *  备注
    */
    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;
    /**
    *  组织ID
    */
    @ApiModelProperty(name = "organizationId", value = "组织ID")
    private Long organizationId;
    /**
    *  组织code
    */
    @ApiModelProperty(name = "organizationCode", value = "组织code")
    private String organizationCode;
    /**
    *  所属组织名称
    */
    @ApiModelProperty(name = "organizationName", value = "所属组织名称")
    private String organizationName;
    /**
    *  是否主仓：0否1是
    */
    @ApiModelProperty(name = "mainWarehouse", value = "是否主仓：0否1是")
    private Integer mainWarehouse;

    public void setId(Long id){
    this.id = id;
    }
    public Long getId(){
    return this.id;
    }
    public void setWarehouseCode(String warehouseCode){
    this.warehouseCode = warehouseCode;
    }
    public String getWarehouseCode(){
    return this.warehouseCode;
    }
    public void setWarehouseName(String warehouseName){
    this.warehouseName = warehouseName;
    }
    public String getWarehouseName(){
    return this.warehouseName;
    }
    public void setWarehouseType(String warehouseType){
    this.warehouseType = warehouseType;
    }
    public String getWarehouseType(){
    return this.warehouseType;
    }
    public void setWarehouseStatus(String warehouseStatus){
    this.warehouseStatus = warehouseStatus;
    }
    public String getWarehouseStatus(){
    return this.warehouseStatus;
    }
    public void setSapFactory(String sapFactory){
    this.sapFactory = sapFactory;
    }
    public String getSapFactory(){
    return this.sapFactory;
    }
    public void setSapStorageLocation(String sapStorageLocation){
    this.sapStorageLocation = sapStorageLocation;
    }
    public String getSapStorageLocation(){
    return this.sapStorageLocation;
    }
    public void setNegativeFlag(Integer negativeFlag){
    this.negativeFlag = negativeFlag;
    }
    public Integer getNegativeFlag(){
    return this.negativeFlag;
    }
    public void setChannelType(String channelType){
    this.channelType = channelType;
    }
    public String getChannelType(){
    return this.channelType;
    }
    public void setContact(String contact){
    this.contact = contact;
    }
    public String getContact(){
    return this.contact;
    }
    public void setPhone(String phone){
    this.phone = phone;
    }
    public String getPhone(){
    return this.phone;
    }
    public void setRemark(String remark){
    this.remark = remark;
    }
    public String getRemark(){
    return this.remark;
    }
    public void setOrganizationId(Long organizationId){
    this.organizationId = organizationId;
    }
    public Long getOrganizationId(){
    return this.organizationId;
    }
    public void setOrganizationCode(String organizationCode){
    this.organizationCode = organizationCode;
    }
    public String getOrganizationCode(){
    return this.organizationCode;
    }
    public void setOrganizationName(String organizationName){
    this.organizationName = organizationName;
    }
    public String getOrganizationName(){
    return this.organizationName;
    }
    public void setMainWarehouse(Integer mainWarehouse){
    this.mainWarehouse = mainWarehouse;
    }
    public Integer getMainWarehouse(){
    return this.mainWarehouse;
    }
}
