package com.dtyunxi.tcbj.api.dto.request;

import java.util.Date;
import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;

/**
* 客户状态Eo对象
*
* @author yuangui
* @since 2022-03-19
*/
@ApiModel(value = "CustomerStatusReqDto", description = "客户状态Eo对象")
public class PCPCustomerStatusReqDto extends RequestDto{
    /**
    *  主键
    */
    @ApiModelProperty(name = "id", value = "主键")
    private Long id;
    /**
    *  名称
    */
    @ApiModelProperty(name = "name", value = "名称")
    private String name;
    /**
    *  编号
    */
    @ApiModelProperty(name = "code", value = "编号")
    private String code;
    /**
    *  客户账号状态（0.禁用，1.启用）
    */
    @ApiModelProperty(name = "accountStatus", value = "客户账号状态（0.禁用，1.启用）")
    private Integer accountStatus;
    /**
    *  备注
    */
    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;
    /**
    *  记录状态（0.停用，1.启用）
    */
    @ApiModelProperty(name = "recordStatus", value = "记录状态（0.停用，1.启用）")
    private Integer recordStatus;

    public void setId(Long id){
    this.id = id;
    }
    public Long getId(){
    return this.id;
    }
    public void setName(String name){
    this.name = name;
    }
    public String getName(){
    return this.name;
    }
    public void setCode(String code){
    this.code = code;
    }
    public String getCode(){
    return this.code;
    }
    public void setAccountStatus(Integer accountStatus){
    this.accountStatus = accountStatus;
    }
    public Integer getAccountStatus(){
    return this.accountStatus;
    }
    public void setRemark(String remark){
    this.remark = remark;
    }
    public String getRemark(){
    return this.remark;
    }
    public void setRecordStatus(Integer recordStatus){
    this.recordStatus = recordStatus;
    }
    public Integer getRecordStatus(){
    return this.recordStatus;
    }
}
