/**
 * @(#) OrderChannelVO.java 1.0 2022/1/5/005
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.tcbj.api.dto.response;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 订单渠道详情实体
 */
@Data
@ApiModel(value = "OrderChannelRespDto", description = "订单渠道详情实体")
public class OrderChannelRespDto {


  @ApiModelProperty(name="createTime", value = "创建时间")
  @JsonProperty("createTime")
  private String createTime = null;


  @ApiModelProperty(name="updateTime", value = "更新时间")
  @JsonProperty("updateTime")
  private String updateTime = null;


  @ApiModelProperty(name="createPerson", value = "创建人")
  @JsonProperty("createPerson")
  private String createPerson = null;


  @ApiModelProperty(name="updatePerson", value = "更新人")
  @JsonProperty("updatePerson")
  private String updatePerson = null;


  @ApiModelProperty(name="id", value = "唯一id")
  @JsonProperty("id")
  private Long id = null;



  @ApiModelProperty(name="ruleId", value = "ruleId")
  @JsonProperty("ruleId")
  private Long ruleId = null;

  @ApiModelProperty(name="orderChannelStatus", value = "订单渠道状态")
  @JsonProperty("orderChannelStatus")
  private String orderChannelStatus;


  @ApiModelProperty(name="orderChannelName", value = "订单渠道名称")
  @JsonProperty("orderChannelName")
  private String orderChannelName;


  @ApiModelProperty(name="orderChannelCode", value = "订单渠道编码")
  @JsonProperty("orderChannelCode")
  private String orderChannelCode = null;


  @ApiModelProperty(name="orderChannelRemark", value = "订单渠道备注")
  @JsonProperty("orderChannelRemark")
  private String orderChannelRemark = null;


  @ApiModelProperty(name="orderChannelId", value = "订单渠道ID")
  @JsonProperty("orderChannelId")
  private String orderChannelId = null;
  
}

