package com.dtyunxi.tcbj.api.dto.response;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 平台订单统计dto
 *
 * @author haoxiao
 * @since 2022-03-10
 */
@Data
@ApiModel(value = "PlatformOrderCountRespDto", description = "平台订单统计dto")
public class PlatformOrderCountRespDto {
    /**
     * 实际库存
     */
    @ApiModelProperty(name = "allCount", value = "全部订单数量")
    private BigDecimal allCount;
    /**
     * 正常订单的数量
     */
    @ApiModelProperty(name = "normalCount", value = "正常订单的数量")
    private BigDecimal normalCount;
    /**
     * 异常订单的数量
     */
    @ApiModelProperty(name = "abnormalCount", value = "异常订单的数量")
    private BigDecimal abnormalCount;

    /**
     * 作废订单的数量
     */
    @ApiModelProperty(name = "invalidCount", value = "作废订单的数量")
    private BigDecimal invalidCount;

}
