package com.dtyunxi.tcbj.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.OutResultOrderReqDto;
import com.dtyunxi.tcbj.api.dto.response.OutResultOrderRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import com.github.pagehelper.PageInfo;

/**
* 出库结果单服务接口
*
* @author wude
* @since 2022-03-10
*/
@Api(tags = {"出库结果单服务"})
@FeignClient(name = "${tcbj.center.report.name:tcbj-center-report}", path = "/v1/outResultOrder", url = "${tcbj.center.report.api:}")
public interface IOutResultOrderQueryApi {

    /**
    * 根据id查询出库结果单
    *
    * @param id 出库结果单id
    * @return   出库结果单数据
    */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询出库结果单", notes = "根据id查询出库结果单")
    RestResponse<OutResultOrderRespDto> queryById(@PathVariable("id") Long id);

    /**
    * 出库结果单分页数据
    *
    * @param filter   出库结果单查询条件
    * @return 出库结果单分页数据
    */
    @PostMapping("/page")
    @ApiOperation(value = "出库结果单分页数据", notes = "根据filter查询条件查询出库结果单数据，filter=OutResultOrderReqDto")
    RestResponse<PageInfo<OutResultOrderRespDto>> queryByPage(@RequestBody OutResultOrderReqDto filter);

}
