package com.dtyunxi.tcbj.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.CustomerQueryByUserIdReqDto;
import com.dtyunxi.tcbj.api.dto.response.CustomerIdsRespDto;
import com.dtyunxi.tcbj.api.dto.response.PCPCustomerSalesmanRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import com.github.pagehelper.PageInfo;

/**
* 业务员表服务接口
*
* @author yuangui
* @since 2022-03-19
*/
@Api(tags = {"客户中心:PCP业务员表服务"})
@FeignClient(
    contextId = "com-dtyunxi-tcbj-api-query-ICustomerSalesmanQueryApi",
    name = "${tcbj.center.report.api.name:tcbj-center-report}",
    path = "/v2/customer-salesman",
    url = "${tcbj.center.report.api:}"
)
public interface IPCPCustomerSalesmanQueryApi {

    /**
    * 根据id查询业务员表
    *
    * @param id 业务员表id
    * @return   业务员表数据
    */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询业务员表", notes = "根据id查询业务员表")
    RestResponse<PCPCustomerSalesmanRespDto> queryById(@PathVariable("id") Long id);

    /**
    * 业务员表分页数据
    *
    * @param filter   业务员表查询条件
    * @param pageNum  当前页
    * @param pageSize 页大小
    * @return 业务员表分页数据
    */
    @GetMapping("/page")
    @ApiOperation(value = "业务员表分页数据", notes = "根据filter查询条件查询业务员表数据，filter=CustomerSalesmanReqDto")
    RestResponse<PageInfo<PCPCustomerSalesmanRespDto>> queryByPage(@RequestParam("filter") String filter,
                                                                   @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                                   @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

    /**
     * 根据userId查询客户ID列表
     *
     * @param userId 用户ID
     * @return 客户ID列表
     */
    @GetMapping("/customer-ids/by-user/{userId}")
    @ApiOperation(value = "根据userId查询客户ID列表", notes = "根据userId查询客户ID列表")
    RestResponse<CustomerIdsRespDto> queryCustomerIdsByUserId(@PathVariable("userId") Long userId);
    
    /**
     * 根据用户ID和关键词查询客户列表
     *
     * @param reqDto 查询条件（用户ID和关键词）
     * @return 客户ID和名称列表
     */
    @PostMapping("/customers/by-user")
    @ApiOperation(value = "根据用户ID和关键词查询客户列表", notes = "根据用户ID和关键词查询客户列表")
    RestResponse<CustomerIdsRespDto> queryCustomersByUserId(@RequestBody CustomerQueryByUserIdReqDto reqDto);
}
