package com.dtyunxi.tcbj.api.biz.customer;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.biz.customer.dto.QueryCustomerFullAreaReq;
import com.dtyunxi.tcbj.api.biz.customer.dto.QueryCustomerFullAreaResp;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

// ----------------------------
// Controller 实现 + Feign 实现
@RestController
@RequestMapping("/v1/customer/export")
public class CustomerExportController implements ICustomerExportApi {

    @Resource
    private CustomerExportService customerExportService;

    @Override
    public RestResponse<QueryCustomerFullAreaResp> queryCustomerFullArea(@RequestBody QueryCustomerFullAreaReq queryDto) {
        QueryCustomerFullAreaResp queryCustomerFullAreaResp = customerExportService.queryCustomerFullArea(queryDto);
        return new RestResponse<>(queryCustomerFullAreaResp);
    }
}
