package com.dtyunxi.tcbj.api.biz.customer;

import com.dtyunxi.tcbj.api.biz.customer.dto.CustomerFullAreaDto;
import com.dtyunxi.tcbj.api.biz.customer.dto.QueryCustomerFullAreaReq;
import com.dtyunxi.tcbj.api.biz.customer.dto.QueryCustomerFullAreaResp;
import lombok.extern.log4j.Log4j2;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Collections;
import java.util.List;

@Service
@Log4j2
public class CustomerExportService {

    @Resource
    private CustomerExportMapper customerExportMapper;

    public QueryCustomerFullAreaResp queryCustomerFullArea(QueryCustomerFullAreaReq req) {
        log.info("查询客户完整区域信息，请求参数：{}", req);

        List<Long> customerIds = req.getCustomerIds();
        // 处理空列表情况
        if (customerIds == null || customerIds.isEmpty()) {
            return QueryCustomerFullAreaResp.builder()
                    .customerFullAreaList(Collections.emptyList())
                    .build();
        }

        log.info("查询的客户ID列表：{}", customerIds);

        // 调用Mapper查询
        List<CustomerFullAreaDto> customerFullAreaList =
            customerExportMapper.queryByCustomerIds(customerIds);

        log.info("查询完成，返回结果数量：{}", customerFullAreaList.size());

        return QueryCustomerFullAreaResp.builder()
                .customerFullAreaList(customerFullAreaList)
                .build();
    }

}