package com.dtyunxi.tcbj.api.dto.request;

import java.util.Date;
import com.dtyunxi.dto.RequestDto;
import com.dtyunxi.tcbj.api.dto.BaseDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;

/**
* 发货通知单请求dto
*
* @author wude
* @since 2022-03-08
*/
@ApiModel(value = "DeliveryNoticeOrderReqDto", description = "发货通知单请求dto")
public class DeliveryNoticeOrderReqDto extends BaseDto {
    /**
    *  单号
    */
    @ApiModelProperty(name = "documentNo", value = "单号")
    private String orderNo;
    /**
    *  业务类型
    */
    @ApiModelProperty(name = "businessType", value = "业务类型")
    private Integer businessType;
    /**
    *  单据状态,待定
    */
    @ApiModelProperty(name = "orderStatus", value = "单据状态,待定")
    private String orderStatus;

    /**
    *  发货仓库编码
    */
    @ApiModelProperty(name = "warehouseCode", value = "发货仓库编码")
    private String warehouseCode;
    /**
    *  发货仓库名称
    */
    @ApiModelProperty(name = "warehouseName", value = "发货仓库名称")
    private String warehouseName;
    /**
     *  收货仓库名称
     */
    @ApiModelProperty(name = "receiveWarehouseName", value = "收货仓库名称")
    private String receiveWarehouseName;
    /**
    *  发货总数量
    */
    @ApiModelProperty(name = "totalQuantity", value = "发货总数量")
    private BigDecimal totalQuantity;
    /**
     * 创建开始时间
     */
    @ApiModelProperty(
            name = "createBeginTime",
            value = "创建开始时间"
    )
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss"
    )
    private Date createBeginTime;
    /**
     * 创建结束时间
     */
    @ApiModelProperty(
            name = "createEndTime",
            value = "创建结束时间"
    )
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss"
    )
    private Date createEndTime;

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public Integer getBusinessType() {
        return businessType;
    }

    public void setBusinessType(Integer businessType) {
        this.businessType = businessType;
    }

    public String getOrderStatus() {
        return orderStatus;
    }

    public void setOrderStatus(String orderStatus) {
        this.orderStatus = orderStatus;
    }

    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }

    public String getWarehouseName() {
        return warehouseName;
    }

    public void setWarehouseName(String warehouseName) {
        this.warehouseName = warehouseName;
    }

    public BigDecimal getTotalQuantity() {
        return totalQuantity;
    }

    public void setTotalQuantity(BigDecimal totalQuantity) {
        this.totalQuantity = totalQuantity;
    }

    public String getReceiveWarehouseName() {
        return receiveWarehouseName;
    }

    public void setReceiveWarehouseName(String receiveWarehouseName) {
        this.receiveWarehouseName = receiveWarehouseName;
    }

    public Date getCreateBeginTime() {
        return createBeginTime;
    }

    public void setCreateBeginTime(Date createBeginTime) {
        this.createBeginTime = createBeginTime;
    }

    public Date getCreateEndTime() {
        return createEndTime;
    }

    public void setCreateEndTime(Date createEndTime) {
        this.createEndTime = createEndTime;
    }
}
