package com.dtyunxi.tcbj.api.dto.constant.enums;

import java.util.Arrays;
import java.util.Optional;

/**
 * @author ghosn
 * @create 2023/5/31 18:08
 */
public enum StoreReqTypeEnum {

    STORE(1, "门店本身是客户并且为启用"),
    DISTRIBUTION(2, "分销商是客户并且为启用"),
    PARENT_STORE(3, "上级门店是客户并且为启用");

    private Integer code;

    private String value;

    StoreReqTypeEnum(Integer code, String value) {
        this.code = code;
        this.value = value;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public static StoreReqTypeEnum enumOfCode(Integer code) {
        return Optional.of(Arrays.stream(StoreReqTypeEnum.values()).filter(c->c.getCode().equals(code)).findFirst()).orElse(null).get();
    }
}
