package com.dtyunxi.tcbj.api.dto.response;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
 * @author minyue
 * @description: 售后单明细统计
 * @since 2022-01-18 10:40
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "ReturnDetailStatisticsRespDto", description = "售后单明细统计")
public class ReturnDetailStatisticsRespDto extends OrderDetailBaseRespDto {

    @ApiModelProperty(name = "returnNo", value = "退订单号")
    private String returnNo;

    @ApiModelProperty(name = "orderNo", value = "原订货单号")
    private String orderNo;

    @ApiModelProperty(name = "returnItemNum", value = "退货数量")
    private Integer returnItemNum;
    private Integer itemNum;

    @ApiModelProperty(name = "returnItemPrice", value = "应退单价")
    private BigDecimal returnItemPrice;

    @ApiModelProperty(name = "returnItemOrigAmount", value = "应退小计")
    private BigDecimal returnItemOrigAmount;

    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;

    @ApiModelProperty(name = "unit", value = "单位")
    private String unit;
}
